/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.k3webservice;

import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceContext;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.AisInfo;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.ArrayOfCurrency;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.Currency;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.CurrencyServiceSoapStub;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.K3LoginServiceSoapStub;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.PublicServiceSoapStub;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.WebServiceException;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.holders.ArrayOfAisInfoHolder;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.holders.ArrayOfCurrencyHolder;
import com.kingdee.eas.rptclient.gr.rptclient.K3Currency;
import com.kingdee.eas.rptclient.gr.tools.k3.K3Helper;
import com.kingdee.util.StringUtils;
import javax.xml.rpc.Service;
import javax.xml.rpc.holders.StringHolder;
import org.apache.log4j.Logger;

public class K3WebServiceFacade {
    private static final Logger logger = Logger.getLogger(K3WebServiceFacade.class);

    public static String login(String userName, String passwd, long acctid) throws Exception {
        K3LoginServiceSoapStub login = new K3LoginServiceSoapStub(K3WebServiceContext.getInstance().getLoginEndPoint(), (Service)new org.apache.axis.client.Service());
        String result = login.login(userName, passwd, acctid);
        if (StringUtils.isEmpty((String)result) || result.length() < 8) {
            ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
            throw new WebServiceException(resHelper.getString("UserOrPassword_error"));
        }
        result = result.substring(8);
        result = Base64.decodeToString((String)result);
        K3WebServiceContext.getInstance().setUserName(userName);
        K3WebServiceContext.getInstance().setPassword(passwd);
        K3WebServiceContext.getInstance().setAISID(acctid);
        return result;
    }

    public static AisInfo[] queryAisInfo() throws Exception {
        PublicServiceSoapStub svs = new PublicServiceSoapStub(K3WebServiceContext.getInstance().getAISQueryEndPoint(), (Service)new org.apache.axis.client.Service());
        ArrayOfAisInfoHolder holder = new ArrayOfAisInfoHolder();
        StringHolder str = new StringHolder();
        svs.aisQuery(holder, str);
        if (str.value != null && str.value.trim().length() > 0) {
            throw new WebServiceException(str.value);
        }
        return holder.value.getAisInfo();
    }

    public static K3Currency[] queryK3Currencies() throws Exception {
        ArrayOfCurrency cc = K3WebServiceFacade.queryCurrency();
        if (cc == null) {
            return null;
        }
        K3Currency[] k3c = new K3Currency[cc.getCurrency().length];
        for (int i = 0; i < cc.getCurrency().length; ++i) {
            k3c[i] = new K3Currency();
            K3Currency currency = k3c[i];
            Currency currency2 = cc.getCurrency(i);
            currency.setK3CurrencyName(currency2.getName());
            currency.setK3CurrencyNumber(currency2.getNumber());
            currency.setK3id(currency2.getUUID());
            currency.setScale(currency2.getScale());
        }
        return k3c;
    }

    private static ArrayOfCurrency queryCurrency() throws Exception {
        CurrencyServiceSoapStub svs = new CurrencyServiceSoapStub(K3WebServiceContext.getInstance().getCurrencyQueryEndPoint(), (Service)new org.apache.axis.client.Service());
        ArrayOfCurrencyHolder holder = new ArrayOfCurrencyHolder();
        StringHolder strTimestamp = new StringHolder();
        StringHolder str = new StringHolder();
        StringHolder strErr = new StringHolder();
        K3Helper k3helper = new K3Helper();
        k3helper.initK3Info();
        svs.query(k3helper.getDcId(), k3helper.getUsername(), k3helper.getPassword(), Integer.MAX_VALUE, null, strTimestamp, holder, str, strErr);
        if (strErr.value != null && strErr.value.trim().length() > 0) {
            logger.error((Object)(" queryCurrency() --- " + strErr.value));
            logger.info((Object)(" dcID == " + k3helper.getDcId()));
            logger.info((Object)(" strTimestamp == " + strTimestamp.toString()));
            logger.info((Object)(" holder == " + holder.toString()));
            logger.info((Object)(" str == " + str.toString()));
            logger.info((Object)(" strErr == " + strErr.toString()));
            throw new WebServiceException(str.value.concat("\r\n").concat(strErr.value));
        }
        return holder.value;
    }

    public static void main(String[] args) {
        try {
            AisInfo[] infos;
            try {
                infos = K3WebServiceFacade.queryAisInfo();
                System.out.println(infos);
                String sdsn = K3WebServiceFacade.login("administrator", "", 2L);
                System.out.println(sdsn);
                ArrayOfCurrency currency = K3WebServiceFacade.queryCurrency();
                System.out.println(currency);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            infos = K3WebServiceFacade.queryAisInfo();
            for (int i = 0; i < infos.length; ++i) {
                System.out.println(infos[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

