/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.gr.rptclient.CompanySelectUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.CslConstant;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;

public class ChangePasswordUI
extends AbstractPanel {
    protected SimpleDateFormat fmtDate = null;
    protected ResourceBundleHelper resHelper = null;
    protected KDLabelContainer lblOldPwd;
    protected KDLabelContainer lblNewPwd;
    protected KDLabelContainer lblComfPwd;
    protected KDButton btnOK;
    protected KDButton btnCancel;
    protected KDPasswordField txtOldPwd;
    protected KDPasswordField txtNewPwd;
    protected KDPasswordField txtComfPwd;
    protected KDSeparator kDSeparator2;
    protected KDLabelContainer lblCompany;
    protected KDTextField txtCompany;
    protected KDButton btnSelectCompany;
    protected ResourceBundleHelper resHelperNew = null;

    public ChangePasswordUI() throws Exception {
        this.jbInit();
        this.fmtDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.resHelperNew = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.ApplicationResources");
        this.setUITitle(this.resHelper.getString("ChangePasswordUI.title"));
        this.lblOldPwd = new KDLabelContainer();
        this.lblNewPwd = new KDLabelContainer();
        this.lblComfPwd = new KDLabelContainer();
        this.lblCompany = new KDLabelContainer();
        this.lblCompany.setName("lblCompany");
        this.lblCompany.setBoundLabelText(this.resHelperNew.getString("lblCompany.text"));
        this.btnOK = new KDButton();
        this.btnCancel = new KDButton();
        this.txtOldPwd = new KDPasswordField();
        this.txtNewPwd = new KDPasswordField();
        this.txtComfPwd = new KDPasswordField();
        this.kDSeparator2 = new KDSeparator();
        this.txtCompany = new KDTextField();
        this.btnSelectCompany = new KDButton();
        this.btnSelectCompany.setText(this.resHelperNew.getString("companySel"));
        this.lblOldPwd.setName("lblOldPwd");
        this.lblNewPwd.setName("lblNewPwd");
        this.lblComfPwd.setName("lblComfPwd");
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        this.txtOldPwd.setName("txtOldPwd");
        this.txtNewPwd.setName("txtNewPwd");
        this.txtComfPwd.setName("txtComfPwd");
        this.kDSeparator2.setName("kDSeparator2");
        this.txtCompany.setName("txtCompany");
        this.txtCompany.setEnabled(false);
        this.btnSelectCompany.setName("btnSelectCompany");
        this.lblOldPwd.setBoundLabelText(this.resHelper.getString("Password"));
        this.lblOldPwd.setBoundLabelLength(100);
        this.lblNewPwd.setBoundLabelText(this.resHelper.getString("NewPassword"));
        this.lblNewPwd.setBoundLabelLength(100);
        this.lblComfPwd.setBoundLabelText(this.resHelper.getString("ConfirmPassword"));
        this.lblComfPwd.setBoundLabelLength(100);
        this.lblCompany.setBoundLabelLength(100);
        this.btnOK.setText(this.resHelper.getString("OK"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ChangePasswordUI.this.btnOK_actionPerformed(e);
                }
                catch (Exception exc) {
                    ChangePasswordUI.this.handUIException(exc);
                }
            }
        });
        this.btnCancel.setText(this.resHelper.getString("Cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ChangePasswordUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    ChangePasswordUI.this.handUIException(exc);
                }
            }
        });
        this.btnSelectCompany.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    ChangePasswordUI.this.btnSelectComanpy_mouseClicked(e);
                }
                catch (Exception exc) {
                    ChangePasswordUI.this.handUIException(exc);
                }
            }
        });
    }

    private void canSelectCompany() {
        Map uiContext = this.getUIContext();
        Boolean canSelect = (Boolean)uiContext.get(CslConstant.SHOW_SELEDT_COMPANY);
        if (canSelect != null && canSelect.booleanValue()) {
            this.btnSelectCompany.setEnabled(canSelect.booleanValue());
            this.btnSelectCompany.setVisible(canSelect.booleanValue());
        } else {
            this.btnSelectCompany.setEnabled(false);
            this.btnSelectCompany.setVisible(false);
        }
        String userCompany = (String)uiContext.get(CslConstant.USER_COMPANY);
        this.txtCompany.setText(userCompany);
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 290, 160));
        this.setLayout(null);
        this.lblOldPwd.setBounds(new Rectangle(10, 10, 270, 19));
        this.lblOldPwd.setBoundLabelUnderline(true);
        this.add((Component)this.lblOldPwd, null);
        this.lblNewPwd.setBounds(new Rectangle(10, 32, 270, 19));
        this.lblNewPwd.setBoundLabelUnderline(true);
        this.add((Component)this.lblNewPwd, null);
        this.lblComfPwd.setBounds(new Rectangle(10, 54, 270, 19));
        this.lblComfPwd.setBoundLabelUnderline(true);
        this.add((Component)this.lblComfPwd, null);
        this.lblCompany.setBounds(new Rectangle(10, 76, 270, 19));
        this.lblCompany.setBoundLabelUnderline(true);
        this.add((Component)this.lblCompany, null);
        this.btnOK.setBounds(new Rectangle(127, 128, 73, 21));
        this.add((Component)this.btnOK, null);
        this.btnCancel.setBounds(new Rectangle(203, 128, 73, 21));
        this.add((Component)this.btnCancel, null);
        this.btnSelectCompany.setBounds(new Rectangle(10, 128, 85, 24));
        this.add((Component)this.btnSelectCompany, null);
        this.kDSeparator2.setBounds(new Rectangle(0, 116, 290, 10));
        this.add((Component)this.kDSeparator2, null);
        this.lblOldPwd.setBoundEditor((JComponent)this.txtOldPwd);
        this.lblNewPwd.setBoundEditor((JComponent)this.txtNewPwd);
        this.lblComfPwd.setBoundEditor((JComponent)this.txtComfPwd);
        this.lblCompany.setBoundEditor((JComponent)this.txtCompany);
    }

    private void btnOK(ActionEvent e, Map uiContext) throws EASBizException {
        char[] newPass1 = this.txtNewPwd.getPassword();
        char[] newPass2 = this.txtComfPwd.getPassword();
        char[] oldPass = this.txtOldPwd.getPassword();
        if (!StringUtils.equals((String)newPass1.toString(), (String)newPass2.toString())) {
            Arrays.fill(newPass1, ' ');
            Arrays.fill(newPass2, ' ');
            Arrays.fill(oldPass, ' ');
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("passwordNotEquals")));
        }
        Arrays.fill(newPass2, ' ');
        String userId = (String)uiContext.get(CslConstant.USER_ID);
        String sql = "select FPassword from t_eas_user where FId = ?";
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery(sql, new Object[]{userId});
            if (rowSet.next() && !StringUtils.equals((String)oldPass.toString(), (String)rowSet.getString("FPassword"))) {
                Arrays.fill(oldPass, ' ');
                throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("oldPwdError")));
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("1", ex.getMessage()));
        }
        finally {
            Arrays.fill(oldPass, ' ');
        }
        String userNumber = (String)uiContext.get(CslConstant.USER_NUMBER);
        String operateUser = UIConfig.getLoginUser();
        this.changePassword(userId, newPass1.toString(), operateUser);
        Arrays.fill(newPass1, ' ');
        if (StringUtils.isEmpty((String)userNumber)) {
            return;
        }
        this.removeUesrComany(userNumber);
        String company = this.txtCompany.getText();
        if (StringUtils.isEmpty((String)company)) {
            return;
        }
        this.addUserCompany(userNumber, operateUser);
    }

    private void addUserCompany(String userNumber, String operateUser) throws EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String[] companies = this.txtCompany.getText().split(";");
            String sql = "insert into T_EAS_User_Company values (?, ?, ?, ?, ?)";
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            boolean flag = false;
            Timestamp now = new Timestamp(new Date().getTime());
            for (int i = 0; i < companies.length; ++i) {
                ps.setString(1, Uuid.create().toString());
                ps.setString(2, userNumber);
                ps.setString(3, companies[i].substring(0, companies[i].lastIndexOf("-")));
                ps.setString(4, operateUser);
                ps.setTimestamp(5, now);
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
            ps.clearBatch();
        }
        catch (Exception ex) {
            try {
                throw new EASBizException(new NumericExceptionSubItem("1", ex.getMessage()));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void removeUesrComany(String userNumber) throws EASBizException {
        String sql = "delete from T_EAS_User_Company where FUserNumber = ?";
        try {
            DbUtil.execute(sql, new Object[]{userNumber});
        }
        catch (BOSException ex) {
            throw new EASBizException(new NumericExceptionSubItem("1", ex.getMessage()));
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        uiContext.put(CslConstant.CHANGE_RESULT_KEY, CslConstant.CHANGE_RESULT_VALUE_OK);
        this.btnOK(e, uiContext);
        this.disposeUIWindow();
    }

    protected void btnSelectComanpy_mouseClicked(MouseEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        CompanySelectUI window = (CompanySelectUI)CompanySelectUI.getInstance((Component)((Object)this), null);
        if (window == null) {
            return;
        }
        String companies = this.txtCompany.getText();
        uiContext.put(CslConstant.COMPANIES, (Object)companies);
        window.setUIContext2((Map)uiContext);
        window.showWindow();
        companies = (String)uiContext.get(CslConstant.COMPANIES);
        this.txtCompany.setText(companies);
    }

    private void changePassword(String userId, String newPass, String updateUser) throws EASBizException {
        String sql = "update t_eas_user set FPassword = ?, FLastUpdateUser = ?, FLastUpdateTime = ? where fid = ?";
        try {
            Object[] params = new Object[]{newPass, updateUser, this.fmtDate.format(new Date()), userId};
            DbUtil.execute(sql, params);
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("1", e.getMessage()));
        }
    }

    public void setUIContext2(Map uiContext) {
        super.setUIContext(uiContext);
    }

    @Override
    public void showWindow() {
        this.canSelectCompany();
        super.showWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) {
        this.getUIContext().put(CslConstant.CHANGE_RESULT_KEY, CslConstant.CHANGE_RESULT_VALUE_CANCEL);
        this.disposeUIWindow();
    }
}

