/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.util.CslConstant;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.newrpt.client.designer.BaseCompanyListUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;

public class CompanySelectUI
extends BaseCompanyListUI {
    public CompanySelectUI() throws Exception {
        this.jbInit2();
    }

    public static BaseCompanyListUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            CompanySelectUI ui = (CompanySelectUI)fy.create(parent, CompanySelectUI.class.getName(), ctx);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private void jbInit2() {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.setUITitle(this.resHelper.getString("this.title"));
        this.btnExit.setVisible(false);
        this.btnExit.setEnabled(false);
        this.remove((Component)this.btnExit);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    @Override
    public void initTable() {
        super.initTable();
    }

    @Override
    public void initCompany() throws BOSException, SQLException, EASBizException {
        String sql = "select FId, FNumber, FName from t_eas_company where FIsMtnOrg = 1 order by FNumber";
        IRowSet rs = DbUtil.executeQuery(sql);
        while (rs.next()) {
            String fId = rs.getString("FID");
            String fNumber = rs.getString("Fnumber");
            String fName = rs.getString("Fname");
            IRow row = this.table.addRow();
            row.getCell(0).setValue((Object)Boolean.FALSE);
            row.getCell(1).setValue((Object)fId);
            row.getCell(2).setValue((Object)fNumber);
            row.getCell(3).setValue((Object)fName);
        }
    }

    private void setCompanyNumber() {
        String[] numbers = this.getCompanies();
        if (numbers == null || numbers.length == 0) {
            return;
        }
        String companyOnTable = null;
        int count = this.table.getRowCount();
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < count; ++j) {
                companyOnTable = (String)this.table.getCell(j, "number").getValue();
                if (!companyOnTable.equals(numbers[i])) continue;
                this.table.getCell(j, "select").setValue((Object)Boolean.TRUE);
            }
        }
    }

    private String[] getCompanies() {
        String companies = (String)this.getUIContext().get(CslConstant.COMPANIES);
        if (StringUtils.isEmpty((String)companies)) {
            return null;
        }
        String[] strs = companies.split(";");
        String[] numbers = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            numbers[i] = strs[i].substring(0, strs[i].lastIndexOf("-"));
        }
        return numbers;
    }

    private void getSelectedCompanies() {
        StringBuffer sb = new StringBuffer();
        Boolean isSelect = null;
        String number = null;
        String name = null;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            isSelect = (Boolean)this.table.getCell(i, "select").getValue();
            if (!isSelect.booleanValue()) continue;
            number = (String)this.table.getCell(i, "number").getValue();
            name = (String)this.table.getCell(i, "name").getValue();
            sb.append(number);
            sb.append("-");
            sb.append(name);
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            this.getUIContext().put(CslConstant.COMPANIES, sb.toString());
        } else {
            this.getUIContext().put(CslConstant.COMPANIES, "");
        }
    }

    @Override
    public void showWindow() {
        this.setCompanyNumber();
        super.showWindow();
    }

    public void setUIContext2(Map map) {
        this.setUIContext(map);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectedCompanies();
        this.disposeUIWindow();
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        this.setCompanyNumber();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setCompanyNumber();
    }
}

