/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceFacade;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.AisInfo;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.WebServiceException;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.tools.k3.K3Helper;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.axis.AxisFault;

public class DBSettingUI
extends AbstractPanel {
    protected KDLabelContainer lblUserName = new KDLabelContainer();
    protected KDLabelContainer lblPassword = new KDLabelContainer();
    protected KDLabelContainer lblShareFileUrl = new KDLabelContainer();
    protected KDButton btnOK = new KDButton();
    protected KDButton btnCancel = new KDButton();
    protected KDTextField txtUserName = new KDTextField();
    protected KDPasswordField txtPassword = new KDPasswordField();
    protected KDTextField txtShareFileUrl = new KDTextField();
    protected KDSeparator kDSeparator2 = new KDSeparator();
    private AisInfo[] aisList;
    private Locale locale = null;
    private KDLabelContainer lbcDataCenter = new KDLabelContainer();
    private KDComboBox ddlDataCenter = new KDComboBox();
    private KDLabelContainer lbcServer = new KDLabelContainer();
    private KDTextField txtServer = new KDTextField();
    private KDCheckBox cbxSelectK3 = new KDCheckBox();
    private KDPanel k3Panel = new KDPanel();
    private K3Helper k3helper;

    public DBSettingUI() throws Exception {
        this.jbInit();
        this.initData();
        this.initK3Helper();
    }

    private void initK3Helper() throws Exception {
        this.initLocale();
        try {
            this.k3helper = new K3Helper(this.locale);
            this.k3helper.initK3Info();
            this.loadK3Info();
        }
        catch (Exception e) {
            this.txtServer.setText("");
            this.txtUserName.setText("");
            this.txtPassword.setText("");
        }
    }

    private void jbInit() throws Exception {
        this.k3Panel.setName("k3Panel");
        this.lbcServer.setName("lbcServer");
        this.lbcDataCenter.setName("lbcDataCenter");
        this.lblUserName.setName("lblUserName");
        this.lblPassword.setName("lblPassword");
        this.lblShareFileUrl.setName("lblShareFileUrl");
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        this.txtServer.setName("txtServer");
        this.ddlDataCenter.setName("ddlDataCenter");
        this.txtUserName.setName("txtUserName");
        this.txtPassword.setName("txtPassword");
        this.txtShareFileUrl.setName("txtShareFileUrl");
        this.txtShareFileUrl.setEnabled(false);
        this.kDSeparator2.setName("kDSeparator2");
        this.cbxSelectK3.setName("cbxSelectK3");
        this.lbcServer.setBoundLabelUnderline(true);
        this.lbcServer.setBoundLabelLength(89);
        this.lbcDataCenter.setBoundLabelUnderline(true);
        this.lbcDataCenter.setBoundLabelLength(89);
        this.lblUserName.setBoundLabelUnderline(true);
        this.lblUserName.setBoundLabelLength(89);
        this.lblPassword.setBoundLabelUnderline(true);
        this.lblPassword.setBoundLabelLength(89);
        this.lblShareFileUrl.setBoundLabelUnderline(true);
        this.lblShareFileUrl.setBoundLabelLength(89);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DBSettingUI.this.btnOK_actionPerformed(e);
                }
                catch (Exception exc) {
                    DBSettingUI.this.handUIException(exc);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBSettingUI.this.btnCancel_actionPerformed(e);
            }
        });
        this.txtServer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    DBSettingUI.this.txtServer_focusLost(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.cbxSelectK3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBSettingUI.this.cbxSelectK3_actionPerformed(e);
            }
        });
    }

    private void initData() throws Exception {
        if (!StringUtils.isEmpty((String)UIConfig.getShareFileUrl())) {
            this.txtShareFileUrl.setText(UIConfig.getShareFileUrl());
        } else {
            this.txtShareFileUrl.setText(".\\sharefile");
        }
    }

    private void loadK3Info() throws Exception {
        this.ddlDataCenter.removeAllItems();
        this.txtServer.setText(this.k3helper.getServer());
        this.txtUserName.setText(this.k3helper.getUsername());
        this.txtPassword.setText(this.k3helper.getPassword());
        if (!StringUtils.isEmpty((String)this.k3helper.getServer())) {
            this.cbxSelectK3.setSelected(true);
        }
    }

    private void initLocale() {
        if (this.locale == null) {
            Map uiContext = this.getUIContext();
            this.locale = uiContext.containsKey("selectedLocale") ? (Locale)uiContext.get("selectedLocale") : new Locale("L2");
        }
    }

    @Override
    public void initUIContentLayout() {
        this.initLocale();
        this.setUITitle(this.getResx("ServerSettingUI.title"));
        this.setBounds(new Rectangle(10, 10, 290, 215));
        this.setLayout(null);
        this.lblShareFileUrl.setBoundLabelText(this.getResx("lblShareFileUrl.text"));
        this.lblShareFileUrl.setBounds(new Rectangle(10, 10, 270, 19));
        this.lblShareFileUrl.setBoundEditor((JComponent)this.txtShareFileUrl);
        this.add((Component)this.lblShareFileUrl, null);
        this.cbxSelectK3.setText(this.getResx("cbxSelectK3.text"));
        this.cbxSelectK3_actionPerformed(null);
        this.cbxSelectK3.setBounds(new Rectangle(8, 33, 200, 19));
        this.add((Component)this.cbxSelectK3, null);
        this.k3Panel.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 1), this.getResx("k3Panel.title")));
        this.k3Panel.setBounds(new Rectangle(10, 54, 270, 115));
        this.k3Panel.setLayout(null);
        this.add((Component)this.k3Panel, null);
        this.lbcServer.setBoundLabelText(this.getResx("lbcServer.text"));
        this.lbcServer.setBounds(new Rectangle(10, 17, 250, 19));
        this.lbcServer.setBoundEditor((JComponent)this.txtServer);
        this.k3Panel.add((Component)this.lbcServer, null);
        this.lbcDataCenter.setBoundLabelText(this.getResx("lblDataCenter.text"));
        this.lbcDataCenter.setBounds(new Rectangle(10, 39, 250, 19));
        this.lbcDataCenter.setBoundEditor((JComponent)this.ddlDataCenter);
        this.k3Panel.add((Component)this.lbcDataCenter, null);
        this.lblUserName.setBoundLabelText(this.getResx("lblUserName.text"));
        this.lblUserName.setBounds(new Rectangle(10, 61, 250, 19));
        this.lblUserName.setBoundEditor((JComponent)this.txtUserName);
        this.k3Panel.add((Component)this.lblUserName, null);
        this.lblPassword.setBoundLabelText(this.getResx("lblPassword.text"));
        this.lblPassword.setBounds(new Rectangle(10, 83, 250, 19));
        this.lblPassword.setBoundEditor((JComponent)this.txtPassword);
        this.k3Panel.add((Component)this.lblPassword, null);
        this.kDSeparator2.setBounds(new Rectangle(0, 178, 290, 10));
        this.add((Component)this.kDSeparator2, null);
        this.btnOK.setText(this.getResx("OK"));
        this.btnOK.setBounds(new Rectangle(127, 185, 73, 21));
        this.add((Component)this.btnOK, null);
        this.btnCancel.setText(this.getResx("Cancel"));
        this.btnCancel.setBounds(new Rectangle(203, 185, 73, 21));
        this.add((Component)this.btnCancel, null);
        String shareFile = UIConfig.getShareFileUrl();
        if (!StringUtils.isEmpty((String)shareFile)) {
            this.txtShareFileUrl.setText(shareFile);
        } else {
            this.txtShareFileUrl.setText(".\\sharefile");
        }
    }

    private void cbxSelectK3_actionPerformed(ActionEvent e) {
        boolean b = this.cbxSelectK3.isSelected();
        this.k3Panel.setEnabled(b);
        this.txtServer.setEnabled(b);
        this.ddlDataCenter.setEnabled(b);
        this.txtUserName.setEnabled(b);
        this.txtPassword.setEnabled(b);
        if (b && !StringUtils.isEmpty((String)this.txtServer.getText())) {
            try {
                this.txtServer_focusLost(null);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)this), ex.getMessage(), ex);
            }
        }
    }

    protected void txtServer_focusLost(FocusEvent e) throws Exception {
        String server = this.txtServer.getText();
        if (StringUtils.isEmpty((String)server)) {
            return;
        }
        UIConfig.setK3Ip(server);
        this.initDataCenter();
        this.onloadK3Account();
    }

    private void onloadK3Account() throws EASBizException, BOSException, SQLException {
        String sql = "select FK3Name from T_EAS_K3Setting where FCompanyNumber = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
        if (rowSet.next()) {
            String k3Account = rowSet.getString("FK3Name");
            if (!StringUtils.isEmpty((String)k3Account)) {
                // empty if block
            }
            for (int i = 0; i < this.ddlDataCenter.getItemCount(); ++i) {
                if (!k3Account.equals(this.ddlDataCenter.getItemAt(i).toString())) continue;
                this.ddlDataCenter.setSelectedItem((Object)k3Account);
            }
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String shareFile = this.txtShareFileUrl.getText();
        if (StringUtils.isEmpty((String)shareFile)) {
            MsgBox.showInfo(this.getResx("ShareFileIsNull"));
            return;
        }
        UIConfig.setShareFileUrl(shareFile);
        if (this.cbxSelectK3.isSelected()) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.k3Login();
                this.createOrUpdateK3Info();
            }
            catch (Exception exc) {
                throw new EASBizException(new NumericExceptionSubItem("1", exc.getMessage()));
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            UIConfig.storeConfig();
        }
        this.disposeUIWindow();
    }

    private void createK3Info() throws Exception {
        String sql = "insert into T_EAS_K3Setting values(?, ?, ?, ?, ?, ?, 1, ?, ?, ?)";
        Object[] param = new Object[]{Uuid.create().toString(), this.k3helper.getServer(), this.k3helper.getK3Account(), this.k3helper.getUsername(), this.k3helper.getPassword(), UIConfig.getCurCompanyNumber(), new Integer(this.k3helper.getDcIndex()), new Integer(this.k3helper.getDcId()), this.k3helper.getK3Url()};
        DbUtil.execute(sql, param);
    }

    private void updateK3Info(String fid) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EAS_K3Setting set ");
        sql.append("  FK3Server = ?, ");
        sql.append("  FK3Name = ?, ");
        sql.append("  FUserName = ?, ");
        sql.append("  FPassword = ?, ");
        sql.append("  FState = 1, ");
        sql.append("  FDcIndex = ?, ");
        sql.append("  FDcId = ?, ");
        sql.append("  Fk3Url = ? ");
        sql.append("     where FId = '").append(fid).append("'");
        Object[] param = new Object[]{this.k3helper.getServer(), this.k3helper.getK3Account(), this.k3helper.getUsername(), this.k3helper.getPassword(), new Integer(this.k3helper.getDcIndex()), new Integer(this.k3helper.getDcId()), this.k3helper.getK3Url()};
        DbUtil.execute(sql.toString(), param);
    }

    private void createOrUpdateK3Info() throws Exception {
        String sql = "SELECT FID from T_EAS_K3Setting where FCompanyNumber = ?";
        IRowSet rs = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
        if (rs.next()) {
            this.updateK3Info(rs.getString("FID"));
        } else {
            this.createK3Info();
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) {
        this.disposeUIWindow();
    }

    private void initDataCenter() {
        try {
            this.aisList = K3WebServiceFacade.queryAisInfo();
        }
        catch (ConnectException e) {
            MsgBox.showError((Component)((Object)this), this.getResx("connectTimeout"));
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (AxisFault e) {
            MsgBox.showError((Component)((Object)this), this.getResx("connectTimeout"));
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (WebServiceException e) {
            MsgBox.showError((Component)((Object)this), e.getMessage());
            this.ddlDataCenter.removeAllItems();
            return;
        }
        catch (Exception e) {
            this.ddlDataCenter.removeAllItems();
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return;
        }
        if (this.aisList == null || this.aisList.length == 0) {
            MsgBox.showError((Component)((Object)this), this.getResx("this.msgdcerror"));
            return;
        }
        this.fillDataCenter();
    }

    private void fillDataCenter() {
        int index = this.ddlDataCenter.getSelectedIndex();
        this.ddlDataCenter.removeAllItems();
        for (int i = 0; i < this.aisList.length; ++i) {
            this.ddlDataCenter.addItem((Object)this.aisList[i].getAisName());
        }
        this.ddlDataCenter.setSelectedIndex(index);
    }

    private void k3Login() throws Exception {
        String server = this.txtServer.getText();
        if (StringUtils.isEmpty((String)server)) {
            throw new BOSException(CslRptClientResourceHelper.getString("7_DBSettingUI"));
        }
        int aisInfoIndex = this.ddlDataCenter.getSelectedIndex();
        if (aisInfoIndex < 0) {
            throw new BOSException(this.getResx("selectDatacenter"));
        }
        char[] password = this.txtPassword.getPassword();
        AisInfo aisInfo = this.aisList[aisInfoIndex];
        String loginString = K3WebServiceFacade.login(this.txtUserName.getText(), password.toString(), aisInfo.getAisID());
        Arrays.fill(password, ' ');
        if (StringUtils.isEmpty((String)loginString)) {
            throw new BOSException(this.getResx("LoginString_isnull"));
        }
        this.parseLoginString(loginString);
        UIConfig.setK3Url(loginString);
        UIConfig.setK3Ip(this.txtServer.getText());
        this.k3helper.setServer(this.txtServer.getText());
        this.k3helper.setK3Account(this.ddlDataCenter.getSelectedItem().toString());
        this.k3helper.setUsername(this.txtUserName.getText());
        char[] pwd = this.txtPassword.getPassword();
        this.k3helper.setPassword(pwd.toString());
        Arrays.fill(pwd, ' ');
        this.k3helper.setDcIndex(this.ddlDataCenter.getSelectedIndex());
        this.k3helper.setDcId(aisInfo.getAisID());
        this.k3helper.setK3Url(loginString);
    }

    private String parseLoginString(String loginString) throws BOSException {
        String dataSource;
        int end;
        if (!loginString.startsWith("ConnectString")) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        int begin = loginString.indexOf("{");
        String tmpStr = loginString.substring(begin + 1, end = loginString.indexOf("}"));
        if (StringUtils.isEmpty((String)tmpStr)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        String[] param = tmpStr.split("\\;");
        if (param.length == 0) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        HashMap<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < param.length; ++i) {
            String[] strs = param[i].split("=");
            if (strs.length == 2) {
                context.put(strs[0], strs[1]);
                continue;
            }
            if (strs.length == 1) {
                context.put(strs[0], "");
                continue;
            }
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        StringBuffer connectString = new StringBuffer();
        String provider = (String)context.get("Provider");
        if (StringUtils.isEmpty((String)provider)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        if (provider.startsWith("SQLOLEDB")) {
            connectString.append("jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:trace=off:file=null:Optimize=1:");
        }
        if (StringUtils.isEmpty((String)(dataSource = (String)context.get("Data Source")))) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("jdbc:microsoft:sqlserver://").append(dataSource).append(":1433;");
        String dbname = (String)context.get("Initial Catalog");
        if (StringUtils.isEmpty((String)dbname)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("DataBaseName=").append(dbname);
        String userName = (String)context.get("User ID");
        if (StringUtils.isEmpty((String)userName)) {
            throw new BOSException(this.getResx("UserIsNull"));
        }
        String password = (String)context.get("Password");
        return connectString.toString();
    }

    private String getResx(String resxItemName) {
        String resxName = "com.kingdee.eas.rptclient.gr.rptclient.resource.LoginFrameResource";
        if (this.locale == null) {
            this.locale = new Locale("L2");
        }
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)this.locale);
    }
}

