/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.client.DynaRangeUI;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import java.awt.Point;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DynaRangeProvider {
    public Map getRangeProp(int sourceType, Book book, ReportDesigner currentUI) throws Exception {
        Sheet activeSheet = book.getActiveSheet();
        Cell cell = activeSheet.getActiveCell();
        HashMap map = null;
        if (sourceType == 10 || sourceType == 11 || sourceType == 12) {
            map = this.getDynaRange(activeSheet, cell);
        }
        return map;
    }

    private HashMap getDynaRange(Sheet sheet, Cell cell) throws BOSException, SQLException, EASBizException {
        ArrayList pointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNotBasePoint = true;
        for (int i = 0; i < pointList.size(); ++i) {
            Point point;
            Point basePoint = (Point)pointList.get(i);
            int x = basePoint.y;
            int y = basePoint.x;
            if (cell == null || x != cell.getRow() || y != cell.getCol()) continue;
            isNotBasePoint = false;
            DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
            int colSize = param.getDefaultCounter();
            map.put("basePoint", basePoint);
            if (param.getDynaItemSource() == 0) {
                map.put("dynaSource", DynaItemTypeEnum.ManualImport);
            } else {
                map.put("dynaSource", DynaItemTypeEnum.Other);
            }
            if (param.getSpreadStyle() == 0) {
                int x1 = param.isIncludeSum() ? x + colSize + 1 : x + colSize;
                int y1 = this.getColCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeRow", point);
            } else if (param.getSpreadStyle() == 1) {
                int y1 = param.isIncludeSum() ? y + colSize + 1 : y + colSize;
                int x1 = this.getRowCount(sheet, x, y);
                point = new Point(x1, y1);
                map.put("dynaRangeCol", point);
            }
            boolean isGrade = param.isGrade();
            map.put("isGrade", new Boolean(isGrade));
            if (param.isIncludeSum()) {
                map.put("isHaveSumItem", new Boolean(true));
                if (param.getPosition() == 1) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + 1, 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + 1));
                    }
                } else if (param.getPosition() == 2) {
                    if (param.getSpreadStyle() == 0) {
                        map.put("sumItemRow", new Point(x + colSize + 1, 0));
                    }
                    if (param.getSpreadStyle() == 1) {
                        map.put("sumItemCol", new Point(0, y + colSize + 1));
                    }
                }
            } else {
                map.put("isHaveSumItem", null);
            }
            if (param.getOrderBy().getValue() == 1) {
                map.put("orderBy", OrderByEnum.NONE);
                continue;
            }
            map.put("orderBy", param.getOrderBy());
            if (param.getSpreadStyle() == 0) {
                String row = Location.getCellName((int)0, (int)(y + param.getOrderRow()));
                map.put("orderRow", row);
                continue;
            }
            if (param.getSpreadStyle() != 1) continue;
            map.put("orderCol", new Integer(x + param.getOrderRow()));
        }
        return map;
    }

    private int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private void setResult(HashMap map, ReportDesigner currentUI) throws Exception {
        UIContext uiContext = new UIContext((Object)currentUI);
        if (map == null || map.size() == 0) {
            MsgBox.showError(CslRptClientResourceHelper.getString("12_DynaRangeProvider"));
        } else {
            uiContext.put((Object)"map", (Object)map);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DynaRangeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
    }
}

