/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uiframe.ProjectFaceUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.DBSettingUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.RptClientMainFrame;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DataBaseConstructor;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReceiveTemplate;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.tools.k3.K3Helper;
import com.kingdee.eas.rptclient.gr.update.FtpConfigService;
import com.kingdee.eas.rptclient.gr.update.ui.UpdateProgressBarUI;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoginFrame
extends KDFrame {
    private static Logger logger = Logger.getLogger(LoginFrame.class);
    public static Image TITLE_ICON;
    private static final String LFCLASSNAME = "com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel";
    private KDLabelContainer lbcLanguage = new KDLabelContainer();
    private KDLabelContainer lbcUserName = new KDLabelContainer();
    private KDLabel kdlLogo = new KDLabel();
    private KDLabel kdlProject = new KDLabel();
    private KDLabelContainer lbcPassword = new KDLabelContainer();
    private KDLabelContainer lbcCompany = new KDLabelContainer();
    private KDComboBox cboCompany = new KDComboBox();
    private KDComboBox ddlLanguage = new KDComboBox();
    private KDTextField txtUserName = new KDTextField();
    private KDPasswordField txtPassword = new KDPasswordField();
    private KDButton btnLogin = new KDButton();
    private KDButton btnCancel = new KDButton();
    private KDWorkButton btnSetting = new KDWorkButton();
    private boolean isInLogin = false;
    private boolean isSetK3 = false;
    ResourceBundleHelper resHelper = null;

    public LoginFrame() {
        this.jbInit();
        this.initCompany();
    }

    private void jbInit() {
        this.initLanguage();
        this.initIcon();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setPreferredSize(new Dimension(634, 418));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginFrame.this.this_windowClosing(e);
            }
        });
        this.lbcLanguage.getBoundLabel().setForeground(Color.WHITE);
        this.lbcLanguage.setBounds(new Rectangle(256, 154, 279, 19));
        this.lbcLanguage.setBoundLabelUnderline(true);
        this.lbcLanguage.setBoundLabelLength(89);
        ((KDLabel)this.lbcLanguage.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcCompany.getBoundLabel().setForeground(Color.WHITE);
        this.lbcCompany.setBounds(new Rectangle(256, 177, 279, 19));
        this.lbcCompany.setBoundLabelUnderline(true);
        this.lbcCompany.setBoundLabelLength(89);
        this.lbcCompany.setBoundEditor((JComponent)this.cboCompany);
        ((KDLabel)this.lbcCompany.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcUserName.getBoundLabel().setForeground(Color.WHITE);
        this.lbcUserName.setBounds(new Rectangle(256, 200, 279, 19));
        this.lbcUserName.setBoundLabelUnderline(true);
        this.lbcUserName.setBoundLabelLength(89);
        ((KDLabel)this.lbcUserName.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.lbcPassword.getBoundLabel().setForeground(Color.WHITE);
        this.lbcPassword.setBounds(new Rectangle(256, 223, 279, 19));
        this.lbcPassword.setBoundLabelUnderline(true);
        this.lbcPassword.setBoundLabelLength(89);
        ((KDLabel)this.lbcPassword.getBoundLabel()).setUnderlineColor(Color.WHITE);
        this.ddlLanguage.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcLanguage.setBoundEditor((JComponent)this.ddlLanguage);
        this.ddlLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginFrame.this.changeLang();
            }
        });
        this.txtUserName.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.lbcUserName.setBoundEditor((JComponent)this.txtUserName);
        this.initUserName();
        this.txtPassword.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.txtPassword.setEchoChar('*');
        this.lbcPassword.setBoundEditor((JComponent)this.txtPassword);
        class ActionLogin
        extends AbstractAction {
            ActionLogin() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoginFrame.this.isInLogin) {
                    return;
                }
                LoginFrame.this.isInLogin = true;
                Thread workThread = new Thread(){

                    @Override
                    public void run() {
                        LoginFrame.this.preLogin();
                        LoginFrame.this.isInLogin = false;
                        LoginFrame.this.loginMain();
                    }
                };
                workThread.start();
            }
        }
        ActionLogin actionLogin = new ActionLogin();
        this.txtPassword.setAction((Action)actionLogin);
        this.btnSetting.setBounds(new Rectangle(256, 252, 77, 19));
        this.btnSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoginFrame.this.btnSetting_actionPerformed(e);
                }
                catch (Exception e1) {
                    MsgBox.showInfo(e1.getMessage());
                }
            }
        });
        this.btnLogin.setBounds(new Rectangle(373, 252, 77, 21));
        this.btnLogin.setAction((Action)actionLogin);
        this.btnCancel.setBounds(new Rectangle(458, 252, 77, 21));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginFrame.this.btnCancel_actionPerformed(e);
            }
        });
        this.initResources();
        this.getContentPane().add((Component)this.lbcLanguage);
        this.getContentPane().add((Component)this.lbcCompany);
        this.getContentPane().add((Component)this.lbcUserName);
        this.getContentPane().add((Component)this.lbcPassword);
        this.getContentPane().add((Component)this.btnSetting);
        this.getContentPane().add((Component)this.btnLogin);
        this.getContentPane().add((Component)this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(null);
        CtrlSwingUtilities.resetAppDefaultFocusTraversalKeys();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtPassword, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.getRootPane().setDefaultButton((JButton)this.btnLogin);
        this.ddlLanguage.requestFocus();
    }

    private void this_windowClosing(WindowEvent e) {
        this.setDefaultCloseOperation(3);
    }

    private void preLogin() {
        this.lbcLanguage.setEnabled(false);
        this.lbcPassword.setEnabled(false);
        this.lbcUserName.setEnabled(false);
        this.btnSetting.setEnabled(false);
        this.btnLogin.setEnabled(false);
        this.btnCancel.setEnabled(false);
    }

    private void enableAll() {
        this.lbcLanguage.setEnabled(true);
        this.lbcPassword.setEnabled(true);
        this.lbcUserName.setEnabled(true);
        this.btnSetting.setEnabled(true);
        this.btnLogin.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void loginMain() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.login();
        }
        catch (Exception exc) {
            MsgBox.showInfo((Component)((Object)this), exc.getMessage());
            this.enableAll();
            this.txtPassword.requestFocus();
            this.txtPassword.selectAll();
            return;
        }
        try {
            if (UIConfig.getUserType() == 0) {
                this.upgradeClient();
                this.k3Login();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        long startMainFrame = System.currentTimeMillis();
        try {
            RptClientMainFrame frame = new RptClientMainFrame();
            this.dispose();
            frame.show();
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
        }
        long costMainFrame = System.currentTimeMillis() - startMainFrame;
        logger.info((Object)(" show main frame:" + costMainFrame + " ms."));
    }

    private void k3Login() throws Exception {
        try {
            Locale locale = new Locale(((LanguageInfo)this.ddlLanguage.getSelectedItem()).getLocale());
            K3Helper k3helper = new K3Helper(locale);
            k3helper.initK3Info();
            UIConfig.setK3Ip(k3helper.getServer());
            UIConfig.setK3Url(k3helper.getK3Url());
            k3helper.k3login();
            MsgBox.showInfo((Component)((Object)this), CslRptClientResourceHelper.getString("29_LoginFrame"));
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), CslRptClientResourceHelper.getString("30_LoginFrame") + e.getMessage());
            throw e;
        }
    }

    private void upgradeClient() throws Exception {
        DNFFile file;
        if (StringUtils.isEmpty((String)UIConfig.getCurCompanyNumber())) {
            return;
        }
        this.loadFTPInfo(UIConfig.getCurCompanyNumber());
        String ip = UIConfig.getFTPIP();
        String username = UIConfig.getFTPUser();
        String password = UIConfig.getFTPPassword();
        String downPath = UIConfig.getFTPDownPath();
        String companyNumber = UIConfig.getCurCompanyNumber();
        String curPath = UIConfig.getShareFileUrl();
        String filename = companyNumber + ".dnf";
        int userType = UIConfig.getUserType();
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)downPath) || StringUtils.isEmpty((String)companyNumber)) {
            MsgBox.showWarning((Component)((Object)this), CommonUtil.getResource("ftpConfigIncomplete"));
            return;
        }
        logger.debug((Object)"step 1:connectin ftp server and download file");
        FTPUpDown ftp = null;
        try {
            ftp = new FTPUpDown(ip, "21", username, password);
        }
        catch (Exception ex) {
            if (userType == 0) {
                MsgBox.showInfo((Component)((Object)this), CommonUtil.getResource("ftpConnectFail") + "," + ex.getMessage());
            }
            return;
        }
        logger.debug((Object)"step 2:Update Application Program");
        logger.debug((Object)"step 3:update template and basedata(currency and company)");
        try {
            ftp.resetPath();
            boolean existDataPath = ftp.checkFolderIsExist(downPath);
            if (existDataPath) {
                if (1 != userType) {
                    ftp.downFile(downPath, filename, curPath);
                }
            } else {
                String msg = MessageFormat.format(CommonUtil.getResource("downPathNotExists"), downPath);
                MsgBox.showInfo((Component)((Object)this), msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)("download DNFFile(" + filename + ") error"), (Throwable)e);
        }
        logger.debug((Object)"step 3.2:parse DNFFile");
        File dnnFile = new File(curPath + File.separator + filename);
        if (dnnFile.exists() && (file = new DNFFile(dnnFile.getPath(), DNFFile.getDNF_PASSWORD())).getEASVersion() != null) {
            int confirm;
            String easVersion = null;
            try {
                easVersion = ClientVersionUtil.getCommonLibVersion();
                logger.info((Object)(" EAS vsersion == " + easVersion));
                logger.info((Object)(" DNFfile version == " + file.getEASVersion()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (easVersion.compareTo(file.getEASVersion()) < 0 && (confirm = MsgBox.showConfirm2((Component)((Object)this), CslRptClientResourceHelper.getString("31_LoginFrame"))) == 0) {
                System.exit(0);
            }
            if (file.getUpdateTime() != null && file.getUpdateTime().compareTo(this.updateTemplateTime()) > 0 && (confirm = MsgBox.showConfirm2((Component)((Object)this), CommonUtil.getResource("hasNewTemplates"))) == 0) {
                try {
                    logger.debug((Object)"step 3.3~3.5: Receive basedata");
                    ReceiveTemplate.receiveTemplates(file.getTemplateCollection());
                    ReceiveTemplate.receiveCurrency(file.getCurrencyCollection());
                    ReceiveTemplate.receiveCompany(file.getOrgUnitCollection());
                    ReceiveTemplate.writeUpdateTime(file.getUpdateTime());
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)((Object)this), e.getMessage());
                }
            }
        }
        System.gc();
        dnnFile.delete();
    }

    private String updateTemplateTime() {
        String sql = "select FUpdateTemplateTime from t_eas_company where fnumber = ?";
        String updateTemplateTime = "2001-10-10 10:10:10";
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
            if (rowSet.next()) {
                SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                updateTemplateTime = dateFmt.format(rowSet.getDate("FUpdateTemplateTime"));
            }
        }
        catch (Exception e1) {
            MsgBox.showError((Component)((Object)this), CslRptClientResourceHelper.getString("32_LoginFrame"));
        }
        return updateTemplateTime;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void btnSetting_actionPerformed(ActionEvent e) throws EASBizException, BOSException, SQLException {
        int userType = 0;
        String company = null;
        String companyName = null;
        String companyNumber = null;
        IRowSet rowSet = DbUtil.executeQuery("select FPassword, FUserType from t_eas_user where lcase(FNumber) = ?", new Object[]{this.txtUserName.getText().toLowerCase()});
        if (!rowSet.next()) {
            throw new BOSException(this.getResx("this.msgpwderror"));
        }
        String secret = rowSet.getString("FPassword");
        char[] password = this.txtPassword.getPassword();
        if (!password.toString().equals(secret == null ? "" : secret)) {
            Arrays.fill(password, ' ');
            throw new BOSException(this.getResx("this.msgpwderror"));
        }
        Arrays.fill(password, ' ');
        userType = rowSet.getInt("FUserType");
        if (userType == 1) {
            if (this.cboCompany.getItemCount() <= 0) {
                MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("no_company"));
                return;
            }
            company = this.cboCompany.getSelectedItem().toString();
            companyName = company.substring(company.lastIndexOf("-"));
            companyNumber = company.substring(0, company.lastIndexOf("-"));
        } else {
            if (this.cboCompany.getItemCount() < 1) {
                MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("fristUse"));
                return;
            }
            company = this.cboCompany.getSelectedItem().toString();
            companyName = company.substring(company.lastIndexOf("-"));
            companyNumber = company.substring(0, company.lastIndexOf("-"));
            IRowSet rs = DbUtil.executeQuery("select FID from T_EAS_User_Company where FCompanyNumber = ? and FUserNumber = ?", new Object[]{companyNumber, this.txtUserName.getText()});
            if (!rs.next()) {
                throw new BOSException(this.getResx("noLogin"));
            }
        }
        UIConfig.setCurCompany(companyNumber, companyName);
        DBSettingUI ui = (DBSettingUI)this.getWindow();
        ui.showWindow();
    }

    private AbstractPanel getWindow() {
        HashMap returnMap = new HashMap();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)"returnMap", returnMap);
        Locale locale = new Locale(((LanguageInfo)this.ddlLanguage.getSelectedItem()).getLocale());
        uiContext.put((Object)"selectedLocale", (Object)locale);
        uiContext.put((Object)"isSetK3", (Object)new Boolean(this.isSetK3));
        DBSettingUI ui = null;
        try {
            ui = (DBSettingUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)this), DBSettingUI.class.getName(), (Map)uiContext);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        return ui;
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private void login() throws Exception {
        int userType = 0;
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        if (currentLangInfo == null) {
            throw new BOSException(this.getResx("selectLoginLanguage"));
        }
        Locale locale = new Locale(((LanguageInfo)this.ddlLanguage.getSelectedItem()).getLocale());
        char[] password = this.txtPassword.getPassword();
        IRowSet rowSet = DbUtil.executeQuery("select FPassword, FUserType from t_eas_user where lcase(FNumber) = ?", new Object[]{this.txtUserName.getText().toLowerCase()});
        if (rowSet.next()) {
            String secret = rowSet.getString(1);
            if (!password.equals(secret == null ? "" : secret)) {
                Arrays.fill(password, ' ');
                throw new BOSException(this.getResx("this.msgpwderror"));
            }
            Arrays.fill(password, ' ');
            userType = rowSet.getInt("FUserType");
            IRowSet rs = null;
            if (userType == 0) {
                String company = (String)this.cboCompany.getSelectedItem();
                company = company.substring(0, company.lastIndexOf("-"));
                String sql = "SELECT c.fid from t_eas_user_company c inner join t_eas_user u on u.fnumber = c.fUserNumber where u.fnumber = ? and c.fcompanynumber = ?";
                rs = DbUtil.executeQuery(sql, new Object[]{this.txtUserName.getText().toLowerCase(), company});
                if (!rs.next()) {
                    throw new BOSException(this.getResx("noLogin"));
                }
            }
        } else {
            throw new BOSException(this.getResx("this.msgpwderror"));
        }
        LocaleUtils.setDefaultLocale((Locale)locale);
        UIConfig.setLangIndex(this.ddlLanguage.getSelectedIndex());
        UIConfig.setUserName(this.txtUserName.getText());
        UIConfig.setLoginUser(this.txtUserName.getText());
        UIConfig.setUserType(userType);
        if (this.cboCompany.getItemCount() > 0) {
            String[] company = ((String)this.cboCompany.getSelectedItem()).split("-");
            UIConfig.setCurCompany(company[0], company[1]);
        }
        UIConfig.storeConfig();
    }

    private void loadFTPInfo(String companyNum) throws Exception {
        String update;
        String down;
        String upload;
        String pass;
        String uname;
        String ip;
        IRowSet rowSet = DbUtil.executeQuery("select FServerPath, FUsername, FPassword, FUploadPath, FDownloadPath, FUpdatePath from T_EAS_FTP where FCompanyNumber = ?", new Object[]{companyNum});
        if (rowSet.next()) {
            ip = rowSet.getString("FServerPath");
            uname = rowSet.getString("FUsername");
            pass = rowSet.getString("FPassword");
            upload = rowSet.getString("FuploadPath");
            down = rowSet.getString("FDownloadPath");
            update = rowSet.getString("FUpdatePath");
            if (StringUtils.isEmpty((String)ip)) {
                throw new BOSException(this.getResx("ftpHost.text"));
            }
            if (StringUtils.isEmpty((String)uname)) {
                throw new BOSException(this.getResx("ftpUname.text"));
            }
            if (StringUtils.isEmpty((String)pass)) {
                throw new BOSException(this.getResx("ftpPasswrod.text"));
            }
            if (StringUtils.isEmpty((String)upload)) {
                throw new BOSException(this.getResx("ftpUpload.text"));
            }
            if (StringUtils.isEmpty((String)down)) {
                throw new BOSException(this.getResx("ftpDown.text"));
            }
        } else {
            throw new BOSException(this.getResx("ftp.text"));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Ftp_IP", ip);
        params.put("Ftp_UserName", uname);
        params.put("Ftp_Password", pass);
        params.put("Ftp_UpPath", upload);
        params.put("Ftp_DownPath", down);
        params.put("Ftp_UpdatePath", update);
        UIConfig.setFTPSetting(params);
    }

    private void initCompany() {
        String sql = "SELECT FID, FNumber, FName from T_EAS_Company where FIsMtnOrg = 1 order by FNumber";
        try {
            IRowSet rs = DbUtil.executeQuery(sql);
            while (rs.next()) {
                this.cboCompany.addItem((Object)(rs.getString(2) + "-" + rs.getString(3)));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            SysUtil.abort();
        }
    }

    private void initResources() {
        this.initBackground();
        this.initProjectLogo();
        this.setTitle(this.getResx("this.title"));
        this.lbcLanguage.setBoundLabelText(this.getResx("lblLanguage.text"));
        this.lbcCompany.setBoundLabelText("\u516c\u53f8");
        this.lbcUserName.setBoundLabelText(this.getResx("lblUserName.text"));
        this.lbcPassword.setBoundLabelText(this.getResx("lblPassword.text"));
        this.btnSetting.setText(this.getResx("btnSetting.text"));
        this.btnSetting.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.btnLogin.setText(this.getResx("btnLogin.text"));
        this.btnCancel.setText(this.getResx("btnCancel.text"));
    }

    private void initProjectLogo() {
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String localDirName = pref.get("easclienthome", null);
        if (localDirName == null) {
            localDirName = "C:/kingdee/eas/client/";
        }
        this.kdlLogo.setBounds(new Rectangle(0, 0, 317, 84));
        this.kdlLogo.setIcon(ProjectFaceUtil.getClientProjectInstance((String)localDirName, (boolean)true).getLoginLogo());
        this.getContentPane().add((Component)this.kdlLogo);
        this.kdlProject.setBounds(454, 338, 180, 80);
        this.kdlProject.setIcon(ProjectFaceUtil.getClientProjectInstance((String)localDirName, (boolean)true).getLoginName());
        this.getContentPane().add((Component)this.kdlProject);
    }

    private String getResx(String resxItemName) {
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        Locale locale = new Locale(currentLangInfo.getLocale());
        String resxName = "com.kingdee.eas.rptclient.gr.rptclient.resource.LoginFrameResource";
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)locale);
    }

    private void initIcon() {
        if (TITLE_ICON == null) {
            TITLE_ICON = EASResource.getImage((String)"imgEas_16");
        }
        this.setIconImage(TITLE_ICON);
    }

    private void initBackground() {
        Icon backgroundImageIcon = EASResource.getIcon((String)"imgPic_login_bg");
        JLabel lblBackground = new JLabel();
        lblBackground.setIcon(backgroundImageIcon);
        lblBackground.setBounds(0, 0, 634, 418);
        this.getLayeredPane().add((Component)lblBackground, JLayeredPane.FRAME_CONTENT_LAYER);
        ((JPanel)this.getContentPane()).setOpaque(false);
    }

    private void initLanguage() {
        Map sortedLangMap = UIConfig.getLanguages();
        Object[] langs = new LanguageInfo[sortedLangMap.size()];
        Iterator iterator = sortedLangMap.entrySet().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String[] locales = key.split("#");
            langs[index] = new LanguageInfo(locales[0], (String)entry.getValue());
            ++index;
        }
        this.ddlLanguage.addItems(langs);
        int langIndex = UIConfig.getLangIndex();
        if (this.ddlLanguage.getItemCount() > langIndex) {
            this.ddlLanguage.setSelectedIndex(langIndex);
        }
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.initDefaultLocale();
    }

    private void initDefaultLocale() {
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        String l = currentLangInfo.getLocale();
        if ("l1".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.US);
            LocaleUtils.setDefaultLocale((Locale)new Locale("l1"));
        } else if ("l2".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.CHINA);
            LocaleUtils.setDefaultLocale((Locale)new Locale("l2"));
        } else if ("l3".equalsIgnoreCase(l)) {
            Locale.setDefault(Locale.TAIWAN);
            LocaleUtils.setDefaultLocale((Locale)new Locale("l3"));
        }
    }

    private void changeLang() {
        LanguageInfo currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        if (currentLangInfo == null) {
            this.ddlLanguage.removeAllItems();
            this.initLanguage();
            currentLangInfo = (LanguageInfo)this.ddlLanguage.getSelectedItem();
        }
        this.initResources();
        this.initDefaultLocale();
    }

    private void initUserName() {
        if (StringUtils.isEmpty((String)UIConfig.getUserName())) {
            this.txtUserName.requestFocus();
        } else {
            this.txtPassword.requestFocus();
        }
        this.txtUserName.setText(UIConfig.getUserName());
    }

    public static void initData() throws Exception {
        long start = System.currentTimeMillis();
        LoginFrame.initLog4jConfig();
        LoginFrame.initExceptionHandler();
        UIManager.setLookAndFeel(LFCLASSNAME);
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" before show Login Frame,init env var : " + cost + " ms!"));
    }

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            LoginFrame.initData();
            DataBaseConstructor.dbModify();
            LoginFrame loginFrame = new LoginFrame();
            loginFrame.show();
            loginFrame.updateClientJarFromFTPSvr();
            long showCost = System.currentTimeMillis() - start;
            logger.info((Object)("finished showing Login Frame,spent:" + showCost + " ms."));
        }
        catch (Exception exc) {
            ExceptionHandler.handle(exc);
        }
    }

    public static void initLog4jConfig() {
        URL url;
        String configItem = "log4j.configuration";
        if (System.getProperty(configItem) == null && (url = LoginFrame.class.getClassLoader().getResource("log4j.properties")) != null) {
            PropertyConfigurator.configure((URL)url);
        }
    }

    public static void initExceptionHandler() {
        String excHandlerKey = "sun.awt.exception.handler";
        String excHandlerValue = ExceptionHandler.class.getName();
        System.setProperty(excHandlerKey, excHandlerValue);
    }

    public void DBUpdate() throws EASBizException, BOSException {
        DataBaseConstructor.initDataBase();
    }

    private void updateClientJarFromFTPSvr() {
        try {
            boolean autoupdate = FtpConfigService.getInstance().isAutoupdate();
            if (!autoupdate) {
                return;
            }
            UpdateProgressBarUI progressBarUI = UpdateProgressBarUI.getInstance((Component)((Object)this), null);
            progressBarUI.setIgnoreCheckedValidParamsStep1(false);
            progressBarUI.run(false);
            progressBarUI.showWindow();
        }
        catch (Exception e) {
            logger.error((Object)(CslRptClientResourceHelper.getString("33_LoginFrame") + e));
            System.out.println(e);
        }
    }

    class LanguageInfo {
        private String locale;
        private String name;

        public LanguageInfo(String locale, String name) {
            this.locale = locale;
            this.name = name;
        }

        public String getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.name;
        }
    }
}

