/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyCfgUI;
import com.kingdee.eas.rptclient.gr.rptclient.CurrencyDAO;
import com.kingdee.eas.rptclient.gr.rptclient.CurrencyVO;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeCurrencyDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeCurrencyVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleLogDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleLogVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeTemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeTemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DataCollectUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReportDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.rptclient.util.UPFFile;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.FunctionProviderImpl;
import com.kingdee.eas.rptclient.newrpt.functionimpl.ICalculateContext;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ReportTimeScheduleTimerTask
extends TimerTask
implements Cloneable {
    private static final Logger logger = Logger.getLogger(ReportTimeScheduleTimerTask.class);
    protected static final int PAUSE_STATE = 0;
    protected static final int RUN_STATE = 1;
    private TimeScheduleVO timeSchedule;
    private java.util.Date firstTime;
    private long delay = 0L;
    private long period = 5000L;
    private int state = 1;
    private String ip = UIConfig.getFTPIP();
    private String userName = UIConfig.getFTPUser();
    private String password = UIConfig.getFTPPassword();
    private String upPath = UIConfig.getFTPUpPath();
    private String downPath = UIConfig.getShareFileUrl();
    private StringBuffer desc = new StringBuffer();
    private int type = 0;
    private int stage = 0;
    private boolean isSuccess = true;

    public ReportTimeScheduleTimerTask() {
    }

    public ReportTimeScheduleTimerTask(TimeScheduleVO timeSchedule, java.util.Date firstTime, long period, int state) {
        this.setTimeSchedule(timeSchedule);
        this.setFirstTime(firstTime);
        this.setPeriod(period);
        this.setState(state);
    }

    public ReportTimeScheduleTimerTask(TimeScheduleVO timeSchedule, long delay, long period, int state) {
        this.setTimeSchedule(timeSchedule);
        this.setDelay(delay);
        this.setPeriod(period);
        this.setState(state);
    }

    public TimeScheduleVO getTimeSchedule() {
        return this.timeSchedule;
    }

    public void setTimeSchedule(TimeScheduleVO timeSchedule) {
        this.timeSchedule = timeSchedule;
    }

    public java.util.Date getFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(java.util.Date firstTime) {
        this.firstTime = firstTime;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getKey() {
        return this.getTimeSchedule().getNumber() + "_" + this.getDelay() + "_" + this.getPeriod();
    }

    public String getIp() {
        return this.ip;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDownPath() {
        return this.downPath;
    }

    public String getUpPath() {
        return this.upPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public void run() {
        try {
            this.stage = 1;
            String[] values = CompanyCfgUI.getCompany();
            if (values[0] == null || values[0].trim().length() == 0) {
                throw new Exception(CslRptClientResourceHelper.getString("37_ReportTimeScheduleTimerTask"));
            }
            if (StringUtils.isEmpty((String)this.ip)) {
                throw new Exception(CslRptClientResourceHelper.getString("38_ReportTimeScheduleTimerTask"));
            }
            this.isSuccess = this.uploadReportFile();
            if (this.isSuccess) {
                this.type = 1;
                this.stage = 5;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            this.desc.append(e.toString());
        }
    }

    private boolean uploadReportFile() throws Exception {
        boolean result = true;
        TimeTemplateVO timeTemplate = null;
        TimeCurrencyVO timeCurrency2 = null;
        TimeTemplateDAO timeTemplateDAO = new TimeTemplateDAO();
        TimeCurrencyDAO timeCurrencyDAO = new TimeCurrencyDAO();
        ArrayList timeTemplateList = timeTemplateDAO.filter(this.getTimeSchedule());
        Iterator timeTemplateIterator = timeTemplateList.iterator();
        ArrayList timeCurrencyList = timeCurrencyDAO.filter(this.getTimeSchedule());
        this.stage = 1;
        if (timeTemplateList.size() == 0) {
            this.desc.append(CslRptClientResourceHelper.getString("39_ReportTimeScheduleTimerTask"));
            this.type = 0;
            this.state = 1;
            return false;
        }
        if (timeCurrencyList.size() == 0) {
            this.desc.append(CslRptClientResourceHelper.getString("40_ReportTimeScheduleTimerTask"));
            this.type = 0;
            this.state = 1;
            return false;
        }
        TemplateVO template = null;
        String templateNumber = "";
        int templateType = 0;
        String currencyNumber = "";
        String templateId = "";
        int periodType = 0;
        int year = 0;
        int period = 0;
        StringBuffer fileName = null;
        DateFormat df = DateFormat.getDateInstance(2, Locale.CHINA);
        String auSuffix = "-ACTUALDATA.xml";
        String bgSuffix = "-BUDGETDATA.xml";
        HashMap outputReport = new HashMap();
        while (timeTemplateIterator.hasNext()) {
            timeTemplate = (TimeTemplateVO)timeTemplateIterator.next();
            templateNumber = timeTemplate.getTemplateNumber();
            templateType = timeTemplate.getTemplateType();
            try {
                template = TemplateDAO.getTemplateVO(templateNumber, templateType);
                if (template == null) {
                    throw new Exception(CslRptClientResourceHelper.getString("41_ReportTimeScheduleTimerTask"));
                }
                if (template.getData() == null) {
                    throw new Exception(CslRptClientResourceHelper.getString("42_ReportTimeScheduleTimerTask"));
                }
            }
            catch (Exception e) {
                this.type = 0;
                this.state = 1;
                logger.error((Object)e);
                e.printStackTrace();
                this.desc.append(CslRptClientResourceHelper.getString("43_ReportTimeScheduleTimerTask")).append(templateNumber).append(CslRptClientResourceHelper.getString("44_ReportTimeScheduleTimerTask"));
                this.desc.append(e.toString());
                TimeScheduleLogVO timeScheduleLog = new TimeScheduleLogVO();
                timeScheduleLog.setScheduleId(this.timeSchedule.getId());
                timeScheduleLog.setScheduleName(this.timeSchedule.getName());
                timeScheduleLog.setStage(this.stage);
                timeScheduleLog.setDesc(this.desc.toString());
                timeScheduleLog.setType(this.type);
                timeScheduleLog.setCompanyNum(UIConfig.getCurCompanyNumber());
                this.saveLog(timeScheduleLog);
                this.desc = new StringBuffer();
                continue;
            }
            templateId = template.getId();
            for (TimeCurrencyVO timeCurrency2 : timeCurrencyList) {
                List<String> list;
                currencyNumber = timeCurrency2.getCurrencyNumber();
                periodType = template.getPeriodType().getValue();
                int[] yearAndPeriod = RPTDateUtil.getPeriod((java.util.Date)new java.util.Date(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                int timePeriod = this.getTimeSchedule().getTimePeriod();
                if (timePeriod == -1) {
                    yearAndPeriod = RPTDateUtil.getRptYearAndPeriod((int)yearAndPeriod[0], (int)yearAndPeriod[1], (int)periodType, (int)0, (int)-1);
                }
                year = yearAndPeriod[0];
                period = yearAndPeriod[1];
                java.util.Date date = RPTDateUtil.getPeriodLastDate((int)yearAndPeriod[0], (int)yearAndPeriod[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                fileName = new StringBuffer();
                fileName.append(UIConfig.getCurCompanyNumber()).append("-");
                fileName.append(templateNumber).append("-").append(currencyNumber).append("-");
                if (templateType == 10) {
                    fileName.append(10);
                } else {
                    fileName.append(1);
                }
                fileName.append("-").append(year).append("-").append(period).append("-").append(periodType);
                StringBuffer fileNameAu = new StringBuffer(fileName.toString());
                fileNameAu.append(auSuffix);
                String[] values = CompanyCfgUI.getCompany();
                values[0] = UIConfig.getCurCompanyNumber();
                String outputFileName = values[0] + "_" + df.format(date) + "_" + template.getPeriodType().getName() + "_" + "ACTUALDATA" + ".UPF";
                String reportId = this.createReport(template, templateId, templateNumber, templateType, currencyNumber, periodType, year, period, "ACTUALDATA", fileNameAu.toString());
                if (reportId != null) {
                    List<String> list2;
                    if (outputReport.containsKey(outputFileName)) {
                        list2 = (List)outputReport.get(outputFileName);
                    } else {
                        list2 = new ArrayList();
                        outputReport.put(outputFileName, list2);
                    }
                    list2.add(reportId);
                }
                if (template.getIsIncludeOtherDC() != 1 || !UIConfig.isSupportUploadBg()) continue;
                StringBuffer fileNameBg = new StringBuffer(fileName.toString());
                fileNameBg.append(bgSuffix);
                outputFileName = UIConfig.getCurCompanyNumber() + "_" + df.format(date) + "_" + template.getPeriodType().getName() + "_" + "BUDGETDATA" + ".UPF";
                reportId = this.createReport(template, templateId, templateNumber, templateType, currencyNumber, periodType, year, period, "BUDGETDATA", fileNameBg.toString());
                if (reportId == null) continue;
                if (outputReport.containsKey(outputFileName)) {
                    list = (List)outputReport.get(outputFileName);
                } else {
                    list = new ArrayList();
                    outputReport.put(outputFileName, list);
                }
                list.add(reportId);
            }
        }
        if (outputReport.isEmpty()) {
            return false;
        }
        for (String outputFileName : outputReport.keySet()) {
            List reportIds = (List)outputReport.get(outputFileName);
            if (reportIds.isEmpty()) continue;
            this.output(outputFileName, reportIds);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createReport(TemplateVO tvo, String templateId, String templateNumber, int templateType, String currencyNumber, int periodType, int year, int period, String dataCollectNumber, String fileName) {
        this.stage = 1;
        String reportId = Uuid.create().toString();
        CurrencyVO currency = null;
        StringBuffer reportDesc = new StringBuffer();
        boolean reportExist = false;
        boolean audited = false;
        try {
            currency = CurrencyDAO.getCurrency(currencyNumber);
            if (currency == null) {
                throw new Exception(CslRptClientResourceHelper.getString("45_ReportTimeScheduleTimerTask") + templateNumber + CslRptClientResourceHelper.getString("46_ReportTimeScheduleTimerTask") + currencyNumber + CslRptClientResourceHelper.getString("47_ReportTimeScheduleTimerTask"));
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select FId, FAuditedStatus from t_eas_report where ");
            sql.append(" FTemplateID = ?");
            sql.append(" and FPeriodType = ?");
            sql.append(" and FYear = ?");
            sql.append(" and FPeriod = ?");
            sql.append(" and FCurrencyID = ?");
            sql.append(" and FTemplateNumber = ?");
            sql.append(" and FDataCollectNumber = ?");
            sql.append(" and FCompanyNum = ?");
            Object[] removeParam = new Object[]{templateId, new Integer(periodType), new Integer(year), new Integer(period), currency.getId(), templateNumber, dataCollectNumber, UIConfig.getCurCompanyNumber()};
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), removeParam);
            if (rowSet.next()) {
                reportId = rowSet.getString("FId");
                reportExist = true;
                boolean bl = audited = rowSet.getInt("FAuditedStatus") == 2;
            }
            if (!reportExist) {
                reportId = this.addNewReport(templateId, tvo, dataCollectNumber, currency, periodType, year, period);
            }
            this.type = 1;
        }
        catch (Exception e) {
            if (currency != null && tvo != null) {
                this.desc.append(CslRptClientResourceHelper.getString("48_ReportTimeScheduleTimerTask")).append(tvo.getName());
                this.desc.append(CslRptClientResourceHelper.getString("49_ReportTimeScheduleTimerTask")).append(currency.getName());
                this.desc.append(CslRptClientResourceHelper.getString("50_ReportTimeScheduleTimerTask")).append(year).append("\u5e74").append(period).append("\u671f").append(RptPeriodTypeEnum.getEnum((int)periodType).getAlias()).append("\r\n");
                this.desc.append(CslRptClientResourceHelper.getString("51_ReportTimeScheduleTimerTask")).append(UIConfig.getCurCompanyNumber());
                this.desc.append(CslRptClientResourceHelper.getString("52_ReportTimeScheduleTimerTask")).append(dataCollectNumber).append("\r\n");
            }
            this.desc.append(e.toString()).append("\r\n");
            String string = null;
            return string;
        }
        finally {
            if (!reportExist || this.type == 0) {
                TimeScheduleLogVO timeScheduleLog = new TimeScheduleLogVO();
                timeScheduleLog.setScheduleId(this.timeSchedule.getId());
                timeScheduleLog.setScheduleName(this.timeSchedule.getName());
                timeScheduleLog.setStage(this.stage);
                timeScheduleLog.setDesc(this.desc.toString());
                timeScheduleLog.setType(this.type);
                timeScheduleLog.setCompanyNum(UIConfig.getCurCompanyNumber());
                this.saveLog(timeScheduleLog);
                this.desc = new StringBuffer();
                this.type = 0;
            }
        }
        if (!audited) {
            this.calAndSave(fileName.toString(), reportId, reportDesc.toString());
        }
        return reportId;
    }

    private String addNewReport(String templateId, TemplateVO tvo, String dataCollectNumber, CurrencyVO currency, int periodType, int year, int period) throws Exception {
        StringBuffer sql = new StringBuffer();
        String reportId = Uuid.create().toString();
        sql.append("insert into t_eas_report");
        sql.append("(FDataCollectNumber, FCompanyNum, FId, FName, FTemplateID, FPeriodType, ");
        sql.append("FYear, FPeriod, FCreatorID,  FCurrencyID, ");
        sql.append("FDescription, FTemplateNumber, FVersionNumber, ");
        sql.append(" FCreateTime, FDynaRpttype, ");
        sql.append("FSourceType, FAuditedStatus, FCheckedStatus) \n");
        sql.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
        sql.append(tvo.getDynaType()).append(", ");
        if (tvo.getTemplateType() <= 0) {
            sql.append("'', ");
        } else if (tvo.getTemplateType() == 10) {
            sql.append(10).append(", ");
        } else {
            sql.append(1).append(", ");
        }
        sql.append(1).append(", ");
        sql.append(1).append(")");
        Object[] param = new Object[]{dataCollectNumber, UIConfig.getCurCompanyNumber(), reportId, tvo.getName(), templateId, new Integer(periodType), new Integer(year), new Integer(period), UIConfig.getUserName(), currency.getId(), tvo.getDescription(), tvo.getNumber(), tvo.getVersionNumber(), new Date(new java.util.Date().getTime())};
        DbUtil.execute(sql.toString(), param);
        byte[] data = tvo.getData();
        Book book = IOHelper.unpackBook((byte[])data);
        DataCollectUtil.fillCellFormulaByDataCollect(book, dataCollectNumber);
        book.setCalculate(false);
        data = IOHelper.packBook((Book)book);
        ReportDAO.saveData(reportId, data);
        return reportId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calAndSave(String fileName, String reportId, String reportDesc) {
        TimeScheduleLogVO timeScheduleLog;
        String fileDir = UIConfig.getShareFileUrl() + "\\" + fileName;
        this.stage = 2;
        Book book = null;
        try {
            book = IOHelper.loadFile((String)fileDir);
            BookProperties bookProperties = BookProperties.loadFromSpread(book);
            ReportCalculateErrorProvider ee = bookProperties.getErrorProvider();
            CalculateContext.getInstance().setErrorProvider((IErrorProvider)ee);
            FunctionProviderImpl functionProviderImpl = new FunctionProviderImpl();
            book.getDeps().getFunctionManager().addFunctionProvider((Object)functionProviderImpl, true);
            final SpreadContext c = new SpreadContext(book);
            functionProviderImpl.setContext(new ICalculateContext(){

                @Override
                public Book getBook() {
                    return c.getBook();
                }
            });
            book.getDeps().getFunctionManager().setErrorProvider(Exception.class, (IErrorProvider)ee);
            bookProperties.restoreToSpread(book);
            ReportVO vo = ReportDAO.getReportVO(reportId);
            CslReportDataProvider dataProvider = new CslReportDataProvider(vo);
            book.setUserObject("CTX", (Object)dataProvider);
            book.setCalculate(true);
            book.calc();
            this.type = 1;
            this.desc.append(reportDesc);
        }
        catch (Exception e) {
            this.desc.append(CslRptClientResourceHelper.getString("53_ReportTimeScheduleTimerTask")).append(e.toString()).append("\r\n");
        }
        finally {
            timeScheduleLog = new TimeScheduleLogVO();
            timeScheduleLog.setScheduleId(this.timeSchedule.getId());
            timeScheduleLog.setScheduleName(this.timeSchedule.getName());
            timeScheduleLog.setStage(this.stage);
            timeScheduleLog.setDesc(this.desc.toString());
            timeScheduleLog.setType(this.type);
            timeScheduleLog.setCompanyNum(UIConfig.getCurCompanyNumber());
            this.saveLog(timeScheduleLog);
            this.desc = new StringBuffer();
            this.type = 0;
        }
        this.stage = 3;
        try {
            IOHelper.saveToFile((Book)book, (String)fileDir);
            this.type = 1;
            this.desc.append(reportDesc);
        }
        catch (Exception e) {
            this.desc.append(CslRptClientResourceHelper.getString("54_ReportTimeScheduleTimerTask")).append(e.toString()).append("\r\n");
        }
        finally {
            timeScheduleLog = new TimeScheduleLogVO();
            timeScheduleLog.setScheduleId(this.timeSchedule.getId());
            timeScheduleLog.setScheduleName(this.timeSchedule.getName());
            timeScheduleLog.setStage(this.stage);
            timeScheduleLog.setDesc(this.desc.toString());
            timeScheduleLog.setType(this.type);
            timeScheduleLog.setCompanyNum(UIConfig.getCurCompanyNumber());
            this.saveLog(timeScheduleLog);
            this.desc = new StringBuffer();
            this.type = 0;
        }
        this.stage = 4;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_eas_report set FAuditedStatus = 2, ");
            sql.append("FAuditorID = ?, FAuditedTime = ?");
            sql.append(" where fid = ?");
            Date d = new Date(new java.util.Date().getTime());
            DbUtil.execute(sql.toString(), new Object[]{UIConfig.getLoginUser(), d, reportId});
            this.type = 1;
            this.desc.append(reportDesc);
        }
        catch (Exception e) {
            this.desc.append(CslRptClientResourceHelper.getString("55_ReportTimeScheduleTimerTask")).append(e.toString()).append("\r\n");
        }
        finally {
            TimeScheduleLogVO timeScheduleLog2 = new TimeScheduleLogVO();
            timeScheduleLog2.setScheduleId(this.timeSchedule.getId());
            timeScheduleLog2.setScheduleName(this.timeSchedule.getName());
            timeScheduleLog2.setStage(this.stage);
            timeScheduleLog2.setDesc(this.desc.toString());
            timeScheduleLog2.setType(this.type);
            timeScheduleLog2.setCompanyNum(UIConfig.getCurCompanyNumber());
            this.saveLog(timeScheduleLog2);
            this.desc = new StringBuffer();
            this.type = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(String outputFileName, List reportIds) {
        this.stage = 5;
        String path = this.getDownPath() + "\\" + outputFileName;
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < reportIds.size(); ++i) {
            if (!isFirst) {
                buf.append(",");
            }
            buf.append("'").append(reportIds.get(i)).append("'");
            isFirst = false;
        }
        CslReportCollection reports = new CslReportCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("report.FID, \n");
        sql.append("report.FName, \n");
        sql.append("report.FCheckedStatus, \n");
        sql.append("report.FSourceType, \n");
        sql.append("report.FDescription, \n");
        sql.append("report.FTemplateID, \n");
        sql.append("report.FPeriodType, \n");
        sql.append("report.FYear, \n");
        sql.append("report.FPeriod, \n");
        sql.append("report.FCreatorID, \n");
        sql.append("report.FCreateTime, \n");
        sql.append(" report.FLastUpdateUserID, \n");
        sql.append("report.FLastUpdateTime, \n");
        sql.append(" report.FAuditorID, \n");
        sql.append("report.FCurrencyID, \n");
        sql.append(" report.FAuditedTime, \n");
        sql.append(" report.FDataCollectNumber, \n");
        sql.append(" c.Fname as FcurrencyName  \n");
        sql.append(" FROM T_EAS_Report report left join T_EAS_Currency c on report.FCurrencyID = c.FID \n");
        sql.append(" WHERE  report.FAuditedStatus = 2  AND report.FId in (" + buf.toString() + ")");
        sql.append(" and report.FCompanyNum = '").append(UIConfig.getCurCompanyNumber()).append("'");
        sql.append(" and c.FCompanyNumber = '").append(UIConfig.getCurCompanyNumber()).append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString());
            while (rowSet.next()) {
                CslReportInfo report = new CslReportInfo();
                report.put("RPT-ID", (Object)rowSet.getObject("FID").toString());
                report.setName(rowSet.getObject("FName") != null ? rowSet.getObject("FName").toString() : "");
                report.setDescription(rowSet.getObject("FDescription") != null ? rowSet.getObject("FDescription").toString() : "");
                report.setData(ReportDAO.getReportVO(rowSet.getString("FID")).getData());
                report.setCheckedStatus(CheckedStatusEnum.getEnum((int)rowSet.getInt("FCheckedStatus")));
                report.setSourceType(RptSrcTypeEnum.getEnum((int)rowSet.getInt("FSourceType")));
                TemplateInfo temp = new TemplateInfo();
                temp.setId(rowSet.getObject("FTemplateID") != null ? BOSUuid.read((String)rowSet.getObject("FTemplateID").toString()) : null);
                report.setTemplate(temp);
                report.setPeriodType(rowSet.getObject("FPeriodType") != null ? RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")) : null);
                report.setYear(rowSet.getInt("FYear"));
                report.setPeriod(rowSet.getShort("FPeriod"));
                report.setDataCollectNumber(rowSet.getString("FDataCollectNumber"));
                CurrencyInfo currency = new CurrencyInfo();
                currency.setName(rowSet.getObject("FcurrencyName") != null ? rowSet.getObject("FcurrencyName").toString() : "");
                currency.setId(rowSet.getObject("FCurrencyId") != null ? BOSUuid.read((String)rowSet.getObject("FCurrencyId").toString()) : null);
                report.setCurrency(currency);
                UserInfo creator = new UserInfo();
                creator.setName(UIConfig.getLoginUser());
                report.setCreator(creator);
                UserInfo auditor = new UserInfo();
                auditor.setName(UIConfig.getLoginUser());
                report.setAuditor(auditor);
                UserInfo lastUpdateUser = new UserInfo();
                lastUpdateUser.setName(UIConfig.getLoginUser());
                report.setLastUpdateUser(lastUpdateUser);
                DataCollectInfo info = report.getDataCollect();
                if (info == null || info.getId() == null) {
                    String dataCollectNumber = report.getDataCollectNumber();
                    if (StringUtils.isEmpty((String)dataCollectNumber)) {
                        dataCollectNumber = "ACTUALDATA";
                        report.setDataCollectNumber(dataCollectNumber);
                    }
                    info = dataCollectNumber.equals("ACTUALDATA") ? DataCollectConstant.getActualDC() : DataCollectConstant.getBudgetDC();
                    report.setDataCollect(info);
                }
                report.setCreateTime(rowSet.getTimestamp("FCreateTime"));
                report.setLastUpdateTime(rowSet.getTimestamp("FLastUpdateTime"));
                report.setAuditTime(rowSet.getTimestamp("FAuditedTime"));
                reports.add(report);
            }
            UPFFile.exportReport(path, reports);
            this.exportReportToFtpByTimer(outputFileName);
            this.type = 1;
        }
        catch (Exception e) {
            this.desc.append(CslRptClientResourceHelper.getString("56_ReportTimeScheduleTimerTask")).append(outputFileName);
            this.desc.append(CslRptClientResourceHelper.getString("57_ReportTimeScheduleTimerTask")).append(e.toString()).append("\r\n");
        }
        finally {
            TimeScheduleLogVO timeScheduleLog = new TimeScheduleLogVO();
            timeScheduleLog.setScheduleId(this.timeSchedule.getId());
            timeScheduleLog.setScheduleName(this.timeSchedule.getName());
            timeScheduleLog.setStage(this.stage);
            timeScheduleLog.setDesc(this.desc.toString());
            timeScheduleLog.setType(this.type);
            timeScheduleLog.setCompanyNum(UIConfig.getCurCompanyNumber());
            this.saveLog(timeScheduleLog);
            this.desc = new StringBuffer();
        }
    }

    private void saveLog(TimeScheduleLogVO timeScheduleLog) {
        TimeScheduleLogDAO timeScheduleLogDao = new TimeScheduleLogDAO();
        timeScheduleLogDao.create(timeScheduleLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportReportToFtpByTimer(String fileName) {
        this.stage = 5;
        String ip = this.getIp();
        String userName = this.getUserName();
        String password = this.getPassword();
        String upPath = this.getUpPath();
        String downPath = this.getDownPath();
        try {
            FTPUpDown ftp = new FTPUpDown(ip, "21", userName, password);
            ftp.uploadFile(downPath + "\\" + fileName, upPath);
            this.desc.append(CslRptClientResourceHelper.getString("58_ReportTimeScheduleTimerTask")).append(fileName).append(CslRptClientResourceHelper.getString("59_ReportTimeScheduleTimerTask"));
        }
        catch (Exception e) {
            this.desc.append(CslRptClientResourceHelper.getString("58_ReportTimeScheduleTimerTask")).append(fileName).append(CslRptClientResourceHelper.getString("60_ReportTimeScheduleTimerTask"));
            this.desc.append(e.toString()).append("\r\n");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReportTimeScheduleTimerTask result = new ReportTimeScheduleTimerTask();
        ReportTimeScheduleTimerTask timerTask = (ReportTimeScheduleTimerTask)super.clone();
        if (timerTask != null) {
            result.setTimeSchedule(timerTask.getTimeSchedule());
            result.setFirstTime(timerTask.getFirstTime());
            result.setDelay(timerTask.getDelay());
            result.setPeriod(timerTask.getPeriod());
            result.setState(timerTask.getState());
        }
        return result;
    }
}

