/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedSpanArray;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslTemplateDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynaItemListener;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.gr.rptclient.util.TableAfterAction;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.rptclient.newrpt.client.designer.MenuManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportActionManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class TemplateDesigner
extends ReportDesigner {
    private static final long serialVersionUID = 5442820641823305065L;
    public static final String MenuName_Save = "File/saveFile";
    private ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.RPTDesignerResource");
    private String id;

    public TemplateDesigner(String id, CoreUIObject uiObj) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void initApplication() throws Exception {
        super.initApplication();
        this.initUITitle();
        this.initBookProtection();
        this.initListener();
        this.initSaveButton();
        this.getSpread().getBook().setCalculate(false);
        this.setMenuStrategy(new TemplateMenuStrategy());
        this.initBudgetFormulaState();
        this.getSpreadManager().setItemFormulasetEnabled(false);
        this.getMenuStrategy().applyMenuState(this.getOperState());
        this.initSpreadStatus();
        this.initPopMenu(this.getActionManager());
    }

    private void initUITitle() {
        String title = "";
        CslTemplateDataProvider provider = (CslTemplateDataProvider)this.getDataProvider();
        title = "ADDNEW".equals(this.getOperState()) ? this.resHelper.getString("addnew") : ("EDIT".equals(this.getOperState()) ? this.resHelper.getString("edit") : this.resHelper.getString("view"));
        title.concat(this.resHelper.getString("template")).concat("--").concat(provider.getTemplateVO().getName());
        this.setTitle(title);
    }

    private void initBookProtection() {
        BookProtection protection = this.getSpread().getBook().getProtection();
        protection.setOperations(3);
        protection.start("defaultpasword");
        if (protection != null && protection.isProtected()) {
            this.getActionManager().getAction("Book_Protection").putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectBook"));
        } else {
            this.getActionManager().getAction("Book_Protection").putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectBook"));
        }
    }

    private void initSaveButton() {
        ActionFileSave actionFileSave = new ActionFileSave();
        actionFileSave.putValue("Name", this.resHelper.getString("actionFileSave"));
        this.setAction(MenuName_Save, actionFileSave, "control S");
        JToolBar toolBar = this.getToolBar("common");
        KDWorkButton saveButton = new KDWorkButton();
        actionFileSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        saveButton.setAction((Action)actionFileSave);
        saveButton.setText("");
        saveButton.setToolTipText(this.resHelper.getString("actionFileSave"));
        toolBar.add((Component)saveButton, 1);
    }

    private void initSpreadStatus() {
        KDSpread spread = this.getSpread();
        spread.getBook().getActiveSheet().getSheetOption().setCellDisplayMode(1);
        spread.repaint();
    }

    private void initBudgetFormulaState() throws BOSException, EASBizException, SQLException {
        KDCheckBoxMenuItem menuItem;
        StringBuffer sql = new StringBuffer();
        sql.append("select FIsIncludeOtherDC from t_eas_template  where FId = ?");
        IRowSet rs = DbUtil.executeQuery(sql.toString(), new Object[]{this.id});
        boolean isIncludeOtherDC = false;
        if (rs.next()) {
            isIncludeOtherDC = rs.getBoolean("FIsIncludeOtherDC");
        }
        if ((menuItem = (KDCheckBoxMenuItem)this.getMenuManager().findMenuUsingPath("View/menuFormulaState/budgetFormula")) != null) {
            menuItem.setEnabled(isIncludeOtherDC);
            menuItem.setVisible(isIncludeOtherDC);
        }
    }

    private void initListener() throws SQLException, BOSException, EASBizException {
        int templateType;
        StringBuffer sql = new StringBuffer();
        sql.append("select FTemplateType, FDynaRpttype from t_eas_template ");
        sql.append(" where FId = ?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{this.id});
        if (rowSet.next() && (templateType = rowSet.getInt("FTemplateType")) == 10) {
            this.getSpread().getBook().addSheetChangeListener((SheetChangeListener)new DynaItemListener());
            SpreadAction action = (SpreadAction)this.getActionManager().getAction("Insert_Row");
            action.setBeforeAction(new NotifyListener(){

                public void doNotify(NotifyEvent evt) {
                    SpreadContext spreadContext = (SpreadContext)evt.getSource();
                    KDSpread spread = spreadContext.getSpread();
                    SortedSpanArray rows = spread.getBook().getActiveSheet().getSheetOption().getSelection().toRowSpans();
                    if (!rows.isEmpty()) {
                        Span span = (Span)rows.getAt(0);
                        int row = span.getStart();
                        DynamicTemplateUtility.beforeAddRow(spread.getBook().getActiveSheet(), row);
                    }
                }
            });
            action = (SpreadAction)this.getActionManager().getAction("Insert_Col");
            action.setBeforeAction(new NotifyListener(){

                public void doNotify(NotifyEvent evt) {
                    SpreadContext spreadContext = (SpreadContext)evt.getSource();
                    KDSpread spread = spreadContext.getSpread();
                    SortedSpanArray cols = spread.getBook().getActiveSheet().getSheetOption().getSelection().toColumnSpans();
                    if (!cols.isEmpty()) {
                        Span span = (Span)cols.getAt(0);
                        int col = span.getStart();
                        DynamicTemplateUtility.beforeAddColumn(spread.getBook().getActiveSheet(), col);
                    }
                }
            });
            action = (SpreadAction)this.getActionManager().getAction("Delete_Row");
            action.setBeforeAction(new NotifyListener(){

                public void doNotify(NotifyEvent evt) {
                    SpreadContext spreadContext = (SpreadContext)evt.getSource();
                    KDSpread spread = spreadContext.getSpread();
                    SortedSpanArray rows = spread.getBook().getActiveSheet().getSheetOption().getSelection().toRowSpans();
                    for (int i = 0; i < rows.size(); ++i) {
                        Span span = (Span)rows.getAt(i);
                        for (int row = span.getStart(); row <= span.getEnd(); ++row) {
                            DynamicTemplateUtility.beforeDeleteRow(spread.getBook().getActiveSheet(), row);
                        }
                    }
                }
            });
            action = (SpreadAction)this.getActionManager().getAction("Delete_Col");
            action.setBeforeAction(new NotifyListener(){

                public void doNotify(NotifyEvent evt) {
                    SpreadContext spreadContext = (SpreadContext)evt.getSource();
                    KDSpread spread = spreadContext.getSpread();
                    SortedSpanArray cols = spread.getBook().getActiveSheet().getSheetOption().getSelection().toColumnSpans();
                    for (int i = 0; i < cols.size(); ++i) {
                        Span span = (Span)cols.getAt(i);
                        for (int col = span.getStart(); col <= span.getEnd(); ++col) {
                            DynamicTemplateUtility.beforeDeleteColumn(spread.getBook().getActiveSheet(), col);
                        }
                    }
                }
            });
            ((SpreadAction)this.getActionManager().getAction("Insert_Row")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Row"));
            ((SpreadAction)this.getActionManager().getAction("Insert_Col")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Col"));
        }
    }

    public void initPopMenu(ReportActionManager manager) {
    }

    public void setAction(String actionName, AbstractAction action, String keystrok) {
        KDMenuItem menuItem = (KDMenuItem)this.getMenuManager().findMenuUsingPath(actionName);
        menuItem.setAction((Action)action);
        if (!StringUtils.isEmpty((String)keystrok)) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystrok));
        }
        menuItem.setVisible(true);
        action.setEnabled(true);
    }

    @Override
    public void actionFileSave_actionPerform(ActionEvent e) {
        Component component;
        Variant.nullVariant.setObject(null);
        CslTemplateDataProvider provider = (CslTemplateDataProvider)this.getDataProvider();
        int type = provider.getTemplateVO().getTemplateType();
        Book book = this.getSpread().getBook();
        if (type == 10 && !DynamicTemplateUtility.checkItem(book)) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("ItemFormulaDup"));
            return;
        }
        String mgs = CslRptClientResourceHelper.getString("6_CslReportDesigner");
        String checkItemResult = DynamicTemplateUtility.checkNumber(this.getSpread().getBook());
        if (checkItemResult != null) {
            MsgBox.showDetailAndOK((Window)((Object)this), mgs, checkItemResult, -1);
            SysUtil.abort();
        }
        if ((component = this.getMenuManager().findMenuUsingPath("View/menuFormulaState/actualFormula")) != null) {
            KDCheckBoxMenuItem menuActualFormula = (KDCheckBoxMenuItem)component;
            if (menuActualFormula.isSelected()) {
                menuActualFormula.doClick();
            } else {
                component = this.getMenuManager().findMenuUsingPath("View/menuFormulaState/budgetFormula");
                if (component != null) {
                    KDCheckBoxMenuItem menuBudgetFormula = (KDCheckBoxMenuItem)component;
                    menuBudgetFormula.doClick();
                }
            }
        }
        try {
            provider.saveBook(book);
            byte[] data = provider.getKDF();
            if (data != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("update t_eas_template set FLastUpdateUserID = ?, ");
                sql.append(" FLastUpdateTime = ? ");
                sql.append(" where FId = ?");
                Date d = new Date(new java.util.Date().getTime());
                DbUtil.execute(sql.toString(), new Object[]{UIConfig.getLoginUser(), d, this.id});
                TemplateDAO.saveData(provider.getTemplateVO());
            }
            super.actionFileSave_actionPerform(e);
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
            return;
        }
        MsgBox.showInfo((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    class ActionFileSave
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionFileSave() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TemplateDesigner.this.actionFileSave_actionPerform(e);
        }
    }

    protected class TemplateMenuStrategy
    implements IMenuStrategy {
        protected TemplateMenuStrategy() {
        }

        @Override
        public void applyMenuState(String state) {
            if (state.equals("ADDNEW")) {
                this.setAddNew();
            } else if (state.equals("EDIT")) {
                this.setEdit();
            } else if (state.equals("VIEW")) {
                this.setView();
            }
            KDCheckBoxMenuItem menuItem = (KDCheckBoxMenuItem)TemplateDesigner.this.getMenuManager().findMenuUsingPath("View/menuFormulaState/actualFormula");
            if (menuItem != null) {
                menuItem.doClick();
            }
        }

        private void setAddNew() {
        }

        private void setView() {
            MenuManager m = TemplateDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            KDMenuItem save = (KDMenuItem)m.findMenuUsingPath(TemplateDesigner.MenuName_Save);
            save.setVisible(false);
            save.getAction().setEnabled(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            m.findMenuUsingPath("File/ImportFile").setVisible(false);
            m.findMenuUsingPath("View/ShowValue").setVisible(false);
            m.findMenuUsingPath("View/ShowFormula").setVisible(false);
            m.findMenuUsingPath("Tool/check/Check_Report").setVisible(false);
            m.findMenuUsingPath("Tool/CompanyFill").setVisible(true);
            m.findMenuUsingPath("calculate").setVisible(false);
            KDCheckBoxMenuItem checkItem = (KDCheckBoxMenuItem)m.findMenuUsingPath("calculate/SetAutoCalc");
            checkItem.getAction().setEnabled(false);
            checkItem = (KDCheckBoxMenuItem)m.findMenuUsingPath("calculate/SetManualCalc");
            checkItem.getAction().setEnabled(false);
            KDMenuItem item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_Book");
            item.getAction().setEnabled(false);
            item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_Sheet");
            item.getAction().setEnabled(false);
            item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_SelectedSheets");
            item.getAction().setEnabled(false);
        }

        private void setEdit() {
            MenuManager m = TemplateDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            m.findMenuUsingPath("File/ImportFile").setVisible(false);
            m.findMenuUsingPath("View/ShowValue").setVisible(false);
            m.findMenuUsingPath("View/ShowFormula").setVisible(false);
            m.findMenuUsingPath("Tool/check/Check_Report").setVisible(false);
            m.findMenuUsingPath("Tool/CompanyFill").setVisible(true);
            m.findMenuUsingPath("calculate").setVisible(false);
            KDCheckBoxMenuItem checkItem = (KDCheckBoxMenuItem)m.findMenuUsingPath("calculate/SetAutoCalc");
            checkItem.getAction().setEnabled(false);
            checkItem = (KDCheckBoxMenuItem)m.findMenuUsingPath("calculate/SetManualCalc");
            checkItem.getAction().setEnabled(false);
            KDMenuItem item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_Book");
            item.getAction().setEnabled(false);
            item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_Sheet");
            item.getAction().setEnabled(false);
            item = (KDMenuItem)m.findMenuUsingPath("calculate/Calc_SelectedSheets");
            item.getAction().setEnabled(false);
        }
    }
}

