/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.rptclient.gr.rptclient.CompanySelectUI;
import com.kingdee.eas.rptclient.gr.rptclient.UserListUI;
import com.kingdee.eas.rptclient.gr.rptclient.UserTypeEnum;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslEditUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class UserEditUI
extends CslEditUI {
    IUIWindow reportUI = null;
    FilterInfo currentFilter = null;
    protected KDLabelContainer lblNumber;
    protected KDTextField txtNumber;
    protected KDLabelContainer lblName;
    protected KDTextField txtName;
    protected KDLabelContainer lblPwd;
    protected KDPasswordField txtPassword;
    protected KDLabelContainer lblConfPwd;
    protected KDPasswordField txtConfPassword;
    protected KDLabelContainer lblUserType;
    protected KDLabelContainer lblCompany;
    protected KDComboBox cboUserType;
    protected KDTextField txtCompany;
    protected KDButton btnSelectCompany;
    private SimpleDateFormat fmtDate = null;
    private boolean canBrowse = true;

    public UserEditUI() throws Exception {
        this.jbInit();
        this.initUIP();
        this.fmtDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public KDTextField getTxtCompany() {
        return this.txtCompany;
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.setUITitle(this.resHelper.getString("UserEditUI.title"));
        this.lblUserType = new KDLabelContainer();
        this.lblCompany = new KDLabelContainer();
        this.cboUserType = new KDComboBox();
        this.btnSelectCompany = new KDButton();
        this.txtCompany = new KDTextField();
        this.lblNumber = new KDLabelContainer();
        this.txtNumber = new KDTextField();
        this.lblName = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.lblPwd = new KDLabelContainer();
        this.txtPassword = new KDPasswordField();
        this.lblConfPwd = new KDLabelContainer();
        this.txtConfPassword = new KDPasswordField();
        this.lblUserType.setName("lblUserType");
        this.cboUserType.setName("cboUserType");
        this.lblCompany.setName("lblCompay");
        this.btnSelectCompany.setName("btnSelectCompany");
        this.txtCompany.setName("txtCompany");
        this.lblNumber.setName("lblNumber");
        this.txtNumber.setName("txtNumber");
        this.lblName.setName("lblName");
        this.txtName.setName("txtName");
        this.lblPwd.setName("lblPwd");
        this.txtPassword.setName("txtPassword");
        this.lblConfPwd.setName("lblConfPwd");
        this.txtConfPassword.setName("txtConfPassword");
        this.lblNumber.setBoundLabelText(this.resHelper.getString("number"));
        this.lblNumber.setBoundLabelLength(100);
        this.lblNumber.setBoundLabelUnderline(true);
        this.lblName.setBoundLabelText(this.resHelper.getString("name"));
        this.lblName.setBoundLabelLength(100);
        this.lblName.setBoundLabelUnderline(true);
        this.lblPwd.setBoundLabelText(this.resHelper.getString("Password"));
        this.lblPwd.setBoundLabelLength(100);
        this.lblPwd.setBoundLabelUnderline(true);
        this.lblConfPwd.setBoundLabelText(this.resHelper.getString("ConfirmPassword"));
        this.lblConfPwd.setBoundLabelLength(100);
        this.lblConfPwd.setBoundLabelUnderline(true);
        this.lblUserType.setBoundLabelText(this.resHelper.getString("UserType"));
        this.lblUserType.setBoundLabelLength(100);
        this.lblUserType.setBoundLabelUnderline(true);
        this.lblCompany.setBoundLabelText(this.resHelper.getString("lblCompany.text"));
        this.lblCompany.setBoundLabelLength(100);
        this.lblCompany.setBoundLabelUnderline(true);
        this.cboUserType.addItems((Object[])EnumUtils.getEnumAliases(UserTypeEnum.class));
        this.cboUserType.setSelectedIndex(0);
        this.cboUserType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    UserEditUI.this.cboUserType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    UserEditUI.this.handUIException(exc);
                }
            }
        });
        this.btnSelectCompany.setText(this.resHelper.getString("companySel"));
        this.btnSelectCompany.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    UserEditUI.this.btnSelectComanpy_mouseClicked(e);
                }
                catch (Exception exc) {
                    UserEditUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 380, 165));
        this.setLayout(null);
        this.lblNumber.setBounds(new Rectangle(12, 10, 270, 19));
        this.add((Component)this.lblNumber, null);
        this.lblName.setBounds(new Rectangle(12, 33, 270, 19));
        this.add((Component)this.lblName, null);
        this.lblUserType.setBounds(new Rectangle(12, 57, 270, 19));
        this.add((Component)this.lblUserType, null);
        this.lblCompany.setBounds(new Rectangle(12, 79, 270, 19));
        this.add((Component)this.lblCompany, null);
        this.lblPwd.setBounds(new Rectangle(12, 101, 270, 19));
        this.add((Component)this.lblPwd, null);
        this.lblConfPwd.setBounds(new Rectangle(12, 125, 270, 19));
        this.add((Component)this.lblConfPwd, null);
        this.btnSelectCompany.setBounds(new Rectangle(286, 79, 90, 20));
        this.add((Component)this.btnSelectCompany, null);
        this.lblNumber.setBoundEditor((JComponent)this.txtNumber);
        this.txtNumber.setRequired(true);
        this.lblName.setBoundEditor((JComponent)this.txtName);
        this.txtName.setRequired(true);
        this.lblPwd.setBoundEditor((JComponent)this.txtPassword);
        this.lblConfPwd.setBoundEditor((JComponent)this.txtConfPassword);
        this.lblUserType.setBoundEditor((JComponent)this.cboUserType);
        this.lblCompany.setBoundEditor((JComponent)this.txtCompany);
        this.txtCompany.setRequired(true);
        this.txtCompany.setEditable(false);
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuFile.add((JMenuItem)this.menuItemSubmit);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnSubmit);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
    }

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveCompany(String user) throws Exception {
        boolean flag = false;
        if (StringUtils.isEmpty((String)this.txtCompany.getText())) {
            this.disposeUIWindow();
            return false;
        }
        String creator = UIConfig.getLoginUser();
        String number = this.txtNumber.getText();
        Date createDate = new Date(new java.util.Date().getTime());
        String[] companies = this.txtCompany.getText().split(";");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement("insert into T_EAS_User_Company values (?, ?, ?, ?, ?)");
            for (int i = 0; i < companies.length; ++i) {
                String company = companies[i].substring(0, companies[i].lastIndexOf("-"));
                ps.setString(1, Uuid.create().toString());
                ps.setString(2, number);
                ps.setString(3, company);
                ps.setString(4, creator);
                ps.setDate(5, createDate);
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Exception e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        String sql = "select FId from t_eas_user where FNumber = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{this.txtNumber.getText()});
        if (rowSet.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("UserIsExists")));
        }
        char[] pass = this.txtPassword.getPassword();
        sql = "insert into t_eas_user (FId, FNumber, FName, FPassword, FCreator, FCreateTime, FUserType) values (?,?,?,?,?,?,?)";
        Object[] param = new Object[]{Uuid.create().toString(), this.txtNumber.getText(), this.txtName.getText(), pass.toString(), UIConfig.getLoginUser(), this.fmtDate.format(new Date(new java.util.Date().getTime())), new Integer(this.cboUserType.getSelectedIndex())};
        try {
            DbUtil.execute(sql, param);
            int userType = this.cboUserType.getSelectedIndex();
            if (0 == userType) {
                this.saveCompany(param[0].toString());
            }
            MsgBox.showInfo((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            Map context = this.getUIContext();
            UserListUI ui = (UserListUI)((Object)context.get("Owner"));
            if (ui != null) {
                ui.actionRefresh_actionPerformed(null);
            }
            this.txtCompany.setText("");
            this.txtConfPassword.setText("");
            this.txtName.setText("");
            this.txtNumber.setText("");
            this.txtPassword.setText("");
            Arrays.fill(pass, ' ');
        }
        catch (SQLDataException sde) {
            sql = "delete from t_eas_user where fid=?";
            DbUtil.execute(sql, new Object[]{param[0]});
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("AddUserFail"));
        }
        this.disposeUIWindow();
    }

    protected void cboUserType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cboUserType.getSelectedIndex() == 1) {
            this.lblCompany.setEnabled(false);
            this.btnSelectCompany.setEnabled(false);
            this.canBrowse = false;
            this.txtCompany.setText("");
        } else if (this.cboUserType.getSelectedIndex() == 0) {
            this.lblCompany.setEnabled(true);
            this.btnSelectCompany.setEnabled(true);
            this.canBrowse = true;
        }
    }

    protected void btnSelectComanpy_mouseClicked(MouseEvent e) throws Exception {
        if (!this.canBrowse) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companies", (Object)this.txtCompany.getText());
        CompanySelectUI window = (CompanySelectUI)CompanySelectUI.getInstance((Component)((Object)this), null);
        if (window == null) {
            return;
        }
        window.setUIContext2((Map)uiContext);
        window.showWindow();
        String companies = (String)uiContext.get((Object)"companies");
        this.txtCompany.setText(companies);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString((String)"AddNew"));
    }

    private void initUI() throws EASBizException, BOSException {
    }

    @Override
    public boolean isModify() {
        return false;
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("NumberIsNull")));
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("NameIsNull")));
        }
        if (StringUtils.isEmpty((String)this.txtCompany.getText()) && this.cboUserType.getSelectedIndex() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("SelectCompany")));
        }
        char[] password = this.txtPassword.getPassword();
        char[] rePassword = this.txtConfPassword.getPassword();
        if (!StringUtils.equals((String)password.toString(), (String)rePassword.toString())) {
            Arrays.fill(password, ' ');
            Arrays.fill(rePassword, ' ');
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("passwordNotEquals")));
        }
        Arrays.fill(password, ' ');
        Arrays.fill(rePassword, ' ');
    }

    @Override
    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof ListUI) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException(e);
            }
        }
        return super.destroyWindow();
    }

    @Override
    protected String getClassAlise() {
        return this.resHelper.getString("UserEditUI.title");
    }
}

