/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.ChangePasswordUI;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyCfgUI;
import com.kingdee.eas.rptclient.gr.rptclient.UserEditUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslListUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslListUIController;
import com.kingdee.eas.rptclient.gr.rptclient.frame.RptClientItemAction;
import com.kingdee.eas.rptclient.gr.rptclient.query.BaseQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.CslConstant;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class UserListUI
extends CslListUI {
    private ActionChangePassword actionChangePassword = null;
    protected KDWorkButton btnChangePassword;
    protected KDMenuItem menuChangePassword;

    public UserListUI() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.actionChangePassword = new ActionChangePassword((IUIObject)this);
        this.getActionManager().registerAction("actionChangePassword", (ItemAction)this.actionChangePassword);
        this.btnChangePassword = new KDWorkButton();
        this.btnChangePassword.setName("btnChangePassword");
        this.btnChangePassword.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionChangePassword), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnChangePassword.setText(this.resHelper.getString("UserListUI.ChangePassword"));
        this.btnChangePassword.setToolTipText(this.resHelper.getString("UserListUI.ChangePassword"));
        this.menuChangePassword = new KDMenuItem();
        this.menuChangePassword.setName("menuChangePassword");
        this.menuChangePassword.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionChangePassword), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuChangePassword.setText(this.resHelper.getString("UserListUI.ChangePassword") + "(C)");
        this.menuChangePassword.setToolTipText(this.resHelper.getString("UserListUI.ChangePassword") + "(C)");
        this.menuChangePassword.setMnemonic('C');
        this.initTable();
        this.menuItemView.setVisible(false);
        this.btnView.setVisible(false);
        this.actionView.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.btnEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        JToolBar.Separator s = new JToolBar.Separator();
        s.setOrientation(1);
        this.toolBar.add((Component)s);
        this.toolBar.add((Component)this.btnChangePassword);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuTool.add((JMenuItem)this.menuChangePassword);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnChangePassword.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuChangePassword.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionQuery.setEnabled(false);
        this.actionQuery.setVisible(false);
    }

    private void disableC() {
        this.tblMain.getHeadRow(0).getCell(6).getStyleAttributes().setLocked(true);
    }

    @Override
    protected String[] createTableKeys() {
        String[] keys = new String[]{"id", "number", "name", "creator", "createTime", "userType", "company", "lastUpdateUser", "lastUpdateTime"};
        return keys;
    }

    @Override
    protected KDTableHeaderModel createHeader() {
        int size = 9;
        String[][] hd = new String[1][size];
        int[] align = new int[size];
        int[] width = new int[size];
        String[] format = new String[size];
        hd[0][0] = "id";
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        this.setBinder("id", "FId");
        hd[0][1] = this.resHelper.getString("number");
        align[1] = 0;
        width[1] = 100;
        format[1] = "";
        this.setBinder("number", "FNumber");
        hd[0][2] = this.resHelper.getString("name");
        align[2] = 0;
        width[2] = 120;
        format[2] = "";
        this.setBinder("name", "FName");
        hd[0][3] = this.resHelper.getString("creator");
        align[3] = 0;
        width[3] = 100;
        format[3] = "";
        this.setBinder("creator", "FCreator");
        hd[0][4] = this.resHelper.getString("createTime");
        align[4] = 0;
        width[4] = 130;
        format[4] = "%{yyyy-MM-dd  HH:mm:ss}t";
        this.setBinder("createTime", "FCreateTime");
        hd[0][5] = this.resHelper.getString("UserType");
        align[5] = 0;
        width[5] = 100;
        format[5] = "";
        this.setBinder("userType", "FUserType");
        hd[0][6] = this.resHelper.getString("lblCompany.text");
        align[6] = 0;
        width[6] = 150;
        format[6] = "";
        this.setBinder("company", "FCompany");
        hd[0][7] = this.resHelper.getString("lastUpdateUser");
        align[7] = 0;
        width[7] = 100;
        format[7] = "";
        this.setBinder("lastUpdateUser", "FLastUpdateUser");
        hd[0][8] = this.resHelper.getString("lastUpdateTime");
        align[8] = 0;
        width[8] = 130;
        format[8] = "%{yyyy-MM-dd HH:mm:ss}t";
        this.setBinder("lastUpdateTime", "FLastUpdateTime");
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    @Override
    public void query(Object condition) {
        super.doLayout();
        this.tblMain.removeRows();
    }

    @Override
    protected boolean objectExists(String id) throws BOSException, EASBizException {
        String sql = "select fid from t_eas_user where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        return rowSet.size() == 1;
    }

    @Override
    public void showEditUI(String key, String status) throws Exception {
    }

    @Override
    protected void runRemove(String id) throws Exception {
        String sql = "select FId from t_eas_user where FNumber = ? and FId = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getLoginUser(), id});
        if (rowSet.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("CantDeleteCurUser")));
        }
        sql = "delete from T_Eas_User where FId = ?";
        DbUtil.execute(sql, new Object[]{id});
    }

    @Override
    protected String getQuerySql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FNumber, FName, FCreator, FCreateTime, switch(FUserType=1, '" + this.resHelper.getString("ADMIN") + "', FUserType=0, '" + this.resHelper.getString("NORMAL") + "'), '',");
        sql.append("FLastUpdateUser, FLastUpdateTime from t_eas_user");
        if (this.isCanOrderTable()) {
            String order = this.getOrderSql();
            if (!StringUtils.isEmpty((String)order) && order.indexOf("FCompany") < 0) {
                sql.append(" order by ").append(order);
            } else if (StringUtils.isEmpty((String)order)) {
                sql.append(" order by ").append("FNumber ASC");
            }
        }
        return sql.toString();
    }

    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        super.tableDataRequest(e);
        try {
            this.initUserCompany(e.getFirstRow());
        }
        catch (Exception ex) {
            MsgBox.showError((Component)((Object)this), ex.getMessage());
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        String userNumber = this.tblMain.getCell(index, "number").getValue().toString();
        if (StringUtils.isEmpty((String)userNumber)) {
            return;
        }
        if (userNumber.equals(UIConfig.getLoginUser())) {
            MsgBox.showWarning((Component)((Object)this), CslRptClientResourceHelper.getString("112_UserListUI"));
            return;
        }
        Object[] params = new Object[]{userNumber};
        String sql = "delete from T_EAS_User_Company where FUserNumber = ?";
        DbUtil.execute(sql, params);
        sql = "delete from T_EAS_User where FNumber = ?";
        DbUtil.execute(sql, params);
        this.tblMain.removeRow(index);
        this.tblMain.refresh();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        String[] values = CompanyCfgUI.getCompany();
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWindow = null;
        ((CslListUIController)super.getUIController()).addNew();
        uiWindow = ((CslListUIController)super.getUIController()).getNavigator().getUIWindow();
        Window win = SwingUtilities.getWindowAncestor((Component)uiWindow.getUIObject());
    }

    public void actionChangePassword_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String userNumber = (String)this.tblMain.getCell(rowIndex, "number").getValue();
        String userCompany = (String)this.tblMain.getCell(rowIndex, "company").getValue();
        String userType = (String)this.tblMain.getCell(rowIndex, "userType").getValue();
        if ("administrator".equalsIgnoreCase(userNumber)) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("can'tmodify.text"));
            return;
        }
        String id = this.getSelectedKeyValue();
        HashMap returnMap = new HashMap();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)"returnMap", returnMap);
        uiContext.put(CslConstant.USER_ID, (Object)id);
        uiContext.put(CslConstant.USER_NUMBER, (Object)userNumber);
        uiContext.put(CslConstant.USER_COMPANY, (Object)userCompany);
        boolean isAdmin = userType.equals(this.resHelper.getString("ADMIN"));
        if (isAdmin) {
            uiContext.put(CslConstant.SHOW_SELEDT_COMPANY, (Object)new Boolean(false));
            uiContext.put(CslConstant.USER_TYPE, (Object)new Integer(1));
        } else {
            uiContext.put(CslConstant.SHOW_SELEDT_COMPANY, (Object)new Boolean(true));
            uiContext.put(CslConstant.USER_TYPE, (Object)new Integer(0));
        }
        ChangePasswordUI window = (ChangePasswordUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)this), ChangePasswordUI.class.getName(), null);
        window.setUIContext2((Map)uiContext);
        window.showWindow();
        Object result = uiContext.get(CslConstant.CHANGE_RESULT_KEY);
        if (result == CslConstant.CHANGE_RESULT_VALUE_OK) {
            this.tblMain.getCell(rowIndex, "lastUpdateTime").setValue((Object)new Date());
            this.tblMain.getCell(rowIndex, "lastUpdateUser").setValue((Object)UIConfig.getLoginUser());
            if (!isAdmin) {
                this.refresh(rowIndex, userNumber);
            }
        }
    }

    private void refresh(int rowIndex, String userNumber) throws Exception {
        StringBuffer companies = new StringBuffer("");
        String sql = "select c.FNumber, c.FName from T_EAS_Company c inner join T_EAS_User_Company uc on uc.FCompanyNumber = c.FNumber where uc.FUserNumber = ? order by c.FNumber";
        IRowSet rs = DbUtil.executeQuery(sql, new Object[]{userNumber});
        int count = rs.size();
        int pos = 0;
        while (rs.next()) {
            ++pos;
            companies.append(rs.getString(1));
            companies.append("-");
            companies.append(rs.getString(2));
            if (pos >= count) continue;
            companies.append(";");
        }
        this.tblMain.getCell(rowIndex, "company").setValue((Object)companies.toString());
    }

    private void initUserCompany(int from) throws Exception {
        Object user = "";
        StringBuffer sb = new StringBuffer("");
        String sql = "select c.FNumber, c.FName from T_EAS_Company c inner join T_EAS_User_Company uc on uc.FCompanyNumber = c.FNumber where uc.FUserNumber = ? order by c.FNumber";
        int count = this.tblMain.getRowCount3();
        while (from < count) {
            user = this.tblMain.getCell(from, "userType").getValue();
            if (!user.toString().equals(this.resHelper.getString("ADMIN"))) {
                user = this.tblMain.getCell(from, "number").getValue();
                IRowSet rs = DbUtil.executeQuery(sql, new Object[]{user});
                int size = rs.size();
                int pos = 0;
                while (rs.next()) {
                    ++pos;
                    sb.append(rs.getString(1));
                    sb.append("-");
                    sb.append(rs.getString(2));
                    if (pos >= size) continue;
                    sb.append(";");
                }
                if (sb.length() > 0) {
                    this.tblMain.getCell(from, 6).setValue((Object)sb.toString());
                    sb.setLength(0);
                }
            }
            ++from;
        }
    }

    @Override
    protected String getEditUIName() {
        return UserEditUI.class.getName();
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        return null;
    }

    @Override
    protected String[] getNotOrderColumns() {
        String[] cols = new String[]{"id", "company"};
        return cols;
    }

    @Override
    public BaseQueryPanel getQueryPanel() {
        return null;
    }

    protected class ActionChangePassword
    extends RptClientItemAction {
        public ActionChangePassword() {
            this(null);
        }

        public ActionChangePassword(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = UserListUI.this.resHelper.getString("UserListUI.ChangePassword");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl G"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            UserListUI.this.getUIContext().put("ORG.PK", UserListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)UserListUI.this, "ActionChangePassword", "actionChangePassword_actionPerformed", e);
        }
    }
}

