/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DbUtil {
    private static Connection connection = null;
    private static final String CONFIGFILE = "config.xml";
    private static final String CONFIGITEM_DBINFO = "dbinfo";
    private static XMLConfiguration configuration;
    private static ConfigurationItem dbInfoItem;
    private static final String CONFIGITEM_USERNAME = "username";
    private static final String CONFIGITEM_SECRET = "secret";

    public static IRowSet executeQuery(String sql) throws BOSException, EASBizException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws BOSException, EASBizException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void execute(String sql) throws BOSException, EASBizException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = DbUtil.getConnection();
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void execute(String sql, Object[] params) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static Connection getConnection() throws SQLException, EASBizException {
        ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        String dbsite = UIConfig.getDBUrl();
        if (StringUtils.isEmpty((String)dbsite)) {
            throw new EASBizException(new NumericExceptionSubItem("1", resHelper.getString("setDBUrl")));
        }
        File f = new File(dbsite);
        if (!f.exists() || f.isDirectory()) {
            throw new EASBizException(new NumericExceptionSubItem("1", resHelper.getString("dbFileNotExists")));
        }
        String url = "jdbc:odbc:driver={Microsoft Access Driver (*.mdb)};DBQ=" + dbsite;
        if (connection == null) {
            DbUtil.loadDriver("sun.jdbc.odbc.JdbcOdbcDriver");
            connection = DbUtil.openDB(url, DbUtil.getUserName(), DbUtil.getSecret());
        }
        if (connection.isClosed()) {
            connection = DbUtil.openDB(url, DbUtil.getUserName(), DbUtil.getSecret());
        }
        return connection;
    }

    public static RptRowSet executeQuery(String sql, int from, int length) throws BOSException, EASBizException {
        Connection conn = null;
        RptRowSet rst = null;
        try {
            conn = DbUtil.getConnection();
            RptRowSet rptRowSet = rst = DBUtil.executeQuery((String)sql.toString(), null, (int)from, (int)length, (Connection)conn);
            return rptRowSet;
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static RptRowSet executeQuery(String sql, SqlParams params, int from, int length) throws BOSException, EASBizException {
        RptRowSet rst = null;
        Connection conn = null;
        try {
            conn = DbUtil.getConnection();
            RptRowSet rptRowSet = rst = DBUtil.executeQuery((String)sql.toString(), (SqlParams)params, (int)from, (int)length, (Connection)conn);
            return rptRowSet;
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        byte[] value = param.getBytes();
        stmt.setAsciiStream(index, (InputStream)new SerializableByteArrayInputStream(value), value.length);
    }

    public static Connection openDB(String connUrl, String user, String secret) throws SQLException {
        Connection conn = DriverManager.getConnection(connUrl, user, secret);
        return conn;
    }

    public static boolean loadDriver(String driverClass) {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    public static boolean isTableExist(Connection conn, String tableName) throws SQLException {
        List tableList = DbUtil.getAllTables(conn);
        if (tableList == null || tableList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < tableList.size(); ++i) {
            if (!tableName.equalsIgnoreCase((String)tableList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isColumnInTable(Connection conn, String tableName, String columnName) throws SQLException {
        List columnList = DbUtil.getAllColumnInTable(tableName, conn);
        if (columnList == null || columnList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < columnList.size(); ++i) {
            if (!columnName.equalsIgnoreCase((String)columnList.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllTables(Connection conn) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                tableList.add(rs.getString(3));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, null, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllColumnInTable(String tableName, Connection conn) throws SQLException {
        ArrayList<String> columnList = new ArrayList<String>();
        Statement st = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("select top 1 * from ".concat(tableName));
            rsmd = rs.getMetaData();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)st, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)st, (Connection)conn);
        int count = rsmd.getColumnCount();
        for (int i = 0; i < count; ++i) {
            columnList.add(rsmd.getColumnName(i));
        }
        return columnList;
    }

    public static String getUserName() {
        if (dbInfoItem.getProperty(CONFIGITEM_USERNAME) != null) {
            return dbInfoItem.getProperty(CONFIGITEM_USERNAME);
        }
        return "";
    }

    public static String getSecret() {
        if (dbInfoItem.getProperty(CONFIGITEM_SECRET) != null) {
            return dbInfoItem.getProperty(CONFIGITEM_SECRET);
        }
        return "";
    }

    static {
        URL cfgFileUrl = UIConfig.class.getClassLoader().getResource(CONFIGFILE);
        if (cfgFileUrl == null) {
            throw new RuntimeException("cann't find the config file!");
        }
        configuration = XMLConfiguration.getInstance((URL)cfgFileUrl);
        dbInfoItem = configuration.getConfigItem(CONFIGITEM_DBINFO);
    }
}

