/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public class LogUtil {
    public static Logger getRootLogger() {
        return Logger.getRootLogger();
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger((String)clazz.getName());
    }

    public static Logger getPackageLogger(Class cls) {
        return LogUtil.getLogger(LogUtil.getPackageName(cls));
    }

    public static void info(Object obj, Object message) {
        LogUtil.getLogger(obj.getClass()).info(message);
    }

    public static void error(Object obj, Object message) {
        LogUtil.error(obj, message, null);
    }

    public static void error(Object obj, Object message, Throwable t) {
        LogUtil.getLogger(obj.getClass()).error(message, t);
    }

    public static void showException(Logger log, Exception ex) {
        log.error((Object)LogUtil.getExceptionUtil().findMessage(ex), (Throwable)ex);
    }

    private static String getPackageName(Class cls) {
        Package pkg = cls.getPackage();
        if (pkg == null) {
            String clsname = cls.getName();
            int pos = clsname.lastIndexOf(".");
            String pckName = clsname.substring(0, pos);
            return pckName;
        }
        return pkg.getName();
    }

    private static ExceptionUtil getExceptionUtil() {
        return new ExceptionUtil();
    }

    private static class ExceptionUtil {
        private ExceptionUtil() {
        }

        public String findMessage(Throwable t) {
            String msg = null;
            Throwable last = null;
            while (t != null && t != last && (msg = t.getMessage()) == null) {
                last = t;
                t = last.getCause();
            }
            return msg;
        }

        public String makeTrace(Throwable t) {
            if (t == null) {
                return null;
            }
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return sw.getBuffer().toString();
        }

        public String makeMessageStack(Throwable t) {
            StringBuffer sb = new StringBuffer();
            Throwable last = null;
            while (t != null && t != last) {
                if (t.getMessage() != null) {
                    sb.append("\r\n>> ");
                    sb.append(t.getMessage());
                }
                last = t;
                t = last.getCause();
            }
            if (sb.length() == 0) {
                sb.append(CslRptClientResourceHelper.getString("119_LogUtil"));
                if (last != null && last.getClass() != null) {
                    sb.append(last.getClass().getName());
                }
            }
            return sb.toString();
        }

        public Throwable findCause(Throwable t, Class type) {
            Throwable last = null;
            while (t != null && t != last) {
                if (type == t.getClass()) {
                    return t;
                }
                last = t;
                t = last.getCause();
            }
            return null;
        }
    }
}

