/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.BaseBizDataUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReceiveTemplate {
    public static boolean receive(String kdtPath, String password) throws Exception {
        DNFFile file = new DNFFile(kdtPath, password);
        boolean result = true;
        String easVersion = null;
        if (file.getEASVersion() == null) {
            MsgBox.showInfo(CslRptClientResourceHelper.getString("124_ReceiveTemplate"));
            return false;
        }
        easVersion = ClientVersionUtil.getCommonLibVersion();
        if (easVersion.compareTo(file.getEASVersion()) < 0) {
            MsgBox.showInfo(CslRptClientResourceHelper.getString("31_LoginFrame"));
            return false;
        }
        ReceiveTemplate.receiveTemplates(file.getTemplateCollection());
        ReceiveTemplate.receiveCurrency(file.getCurrencyCollection());
        ReceiveTemplate.receiveCompany(file.getOrgUnitCollection());
        ReceiveTemplate.writeUpdateTime(file.getUpdateTime());
        return result;
    }

    public static void receiveTemplates(List templates) throws BOSException, EASBizException {
        String key;
        if (templates == null || templates.isEmpty()) {
            return;
        }
        Integer intTrue = new Integer(1);
        Integer intFalse = new Integer(0);
        StringBuffer overTemplateIds = new StringBuffer();
        StringBuffer insertSql = new StringBuffer("insert into t_eas_template ");
        insertSql.append("(FId,FNumber,FName,FDescription,FVersionNumber");
        insertSql.append(",FPeriodType,FIsIncludeOtherDC, FDynaRpttype,FTemplateType,FIsEditable,FVersionStatus, FCompanyNum)");
        insertSql.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, String[]> localTemplates = new HashMap<String, String[]>();
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FID,FNumber,FTemplateType,FVersionNumber");
        querySql.append(" from T_EAS_Template where FVersionStatus=1 and FCompanyNum = ?");
        IRowSet rs = DbUtil.executeQuery(querySql.toString(), new Object[]{UIConfig.getCurCompanyNumber()});
        try {
            while (rs.next()) {
                key = rs.getString(2) + ";" + rs.getString(3);
                localTemplates.put(key, new String[]{rs.getString(1), rs.getString(4)});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        for (TemplateInfo template : templates) {
            String tid = template.getId().toString();
            key = template.getNumber() + ";" + template.getTemplateType().getValue();
            boolean isNew = !localTemplates.containsKey(key);
            boolean isNewVersion = false;
            if (!isNew) {
                String[] value = (String[])localTemplates.get(key);
                String versionNumber = value[1];
                isNewVersion = ReceiveTemplate.isNewVersion(template.getVersionNumber(), versionNumber);
                if (isNewVersion) {
                    overTemplateIds.append("'").append(value[0]).append("',");
                }
            }
            if (isNew || isNewVersion) {
                values.clear();
                values.add(tid);
                values.add(template.getNumber());
                values.add(template.getName());
                values.add(template.getDescription());
                values.add(template.getVersionNumber());
                values.add(new Integer(template.getPeriodType().getValue()));
                values.add(template.isIncludeOtherDC() ? new Integer(1) : new Integer(0));
                values.add(new Integer(template.getDynaRptType().getValue()));
                values.add(new Integer(template.getTemplateType().getValue()));
                Boolean isAllowChange = (Boolean)template.get("CSL_PROPERTY_ISALLOWCHANGE");
                values.add(isAllowChange != false ? intTrue : intFalse);
                values.add(intTrue);
                values.add(UIConfig.getCurCompanyNumber());
                DbUtil.execute(insertSql.toString(), values.toArray());
                try {
                    TemplateDAO.saveData(tid, template.getData());
                    continue;
                }
                catch (Throwable e) {
                    DbUtil.execute("delete from t_eas_template where fid = '" + tid + "'");
                    throw new EASBizException(new NumericExceptionSubItem("1", e.getMessage()));
                }
            }
            try {
                TemplateDAO.saveData(tid, template.getData());
            }
            catch (Throwable e) {
                DbUtil.execute("delete from t_eas_template where fid = '" + tid + "'");
                throw new EASBizException(new NumericExceptionSubItem("1", e.getMessage()));
            }
        }
        if (overTemplateIds.length() > 0) {
            overTemplateIds.setLength(overTemplateIds.length() - 1);
            String updateSql = "update T_EAS_Template set FVersionStatus=0 where FID in(" + overTemplateIds.toString() + ")";
            DbUtil.execute(updateSql);
        }
    }

    public static void writeUpdateTime(String updateTime) {
        String sql = "update t_eas_company set FUpdateTemplateTime = ? where FNumber = ?";
        try {
            DbUtil.execute(sql, new Object[]{updateTime, UIConfig.getCurCompanyNumber()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isBiggerVersion(String version1, String version2) {
        int j;
        String[] vers1 = version1.split("\\.");
        String[] vers2 = version2.split("\\.");
        int i = Integer.parseInt(vers1[0]);
        if (i > (j = Integer.parseInt(vers2[0]))) {
            return true;
        }
        i = Integer.parseInt(vers1[1]);
        if (i > (j = Integer.parseInt(vers2[1]))) {
            return true;
        }
        return vers1.length == 3 && vers2.length == 3 && (i = Integer.parseInt(vers1[2])) > (j = Integer.parseInt(vers2[2]));
    }

    public static boolean isNewVersion(String newVersion, String oldVersion) {
        String[] version2;
        String[] version1 = newVersion.split("\\.");
        if (version1.length > (version2 = oldVersion.split("\\.")).length) {
            for (int i = 0; i < version2.length; ++i) {
                int number2;
                int number1 = Integer.parseInt(version1[i]);
                if (number1 == (number2 = Integer.parseInt(version2[i]))) continue;
                return number1 > number2;
            }
            return true;
        }
        for (int i = 0; i < version2.length; ++i) {
            int number2;
            int number1 = Integer.parseInt(version1[i]);
            if (number1 == (number2 = Integer.parseInt(version2[i]))) continue;
            return number1 > number2;
        }
        return false;
    }

    public static void main(String[] args) {
        String v1 = "2.2.1";
        String v2 = "2.2.5";
        System.out.println(ReceiveTemplate.isNewVersion("", v2));
    }

    public static void receiveCurrency(ArrayList currencyCollection) throws BOSException, EASBizException {
        if (currencyCollection == null) {
            return;
        }
        Map idAndNumbers = BaseBizDataUtil.getCurrencyIdAndNumber();
        String sql = "insert into T_Eas_Currency (FId, FNumber, FName, FCompanyNumber) values (?, ?, ?, ?)";
        boolean flag = false;
        HashSet set = new HashSet(currencyCollection);
        String company = UIConfig.getCurCompanyNumber();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            Locale locale = LocaleUtils.getDefaultLocale();
            for (CurrencyInfo currency : set) {
                if (currency.getNumber().equals("GLC") || currency.getNumber().equals("GRC") || idAndNumbers.containsKey(currency.getId().toString()) || idAndNumbers.containsValue(currency.getNumber())) continue;
                ps.setString(1, currency.getId().toString());
                ps.setString(2, currency.getNumber());
                ps.setString(3, currency.getName(locale) == null ? (currency.getName() == null ? "" : currency.getName()) : currency.getName(locale));
                ps.setString(4, company);
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
            ps.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static void receiveCompany(ArrayList orgUnitCollection) throws BOSException, EASBizException {
        if (orgUnitCollection == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        OrgUnitInfo company2 = null;
        Map idAndNumbers = BaseBizDataUtil.getCompanyIdAndNumber();
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        try {
            Iterator it = orgUnitCollection.iterator();
            while (it.hasNext()) {
                company2 = (OrgUnitInfo)it.next();
                if (idAndNumbers.containsKey(company2.getId().toString())) {
                    it.remove();
                    continue;
                }
                if (idAndNumbers.containsKey(company2.getId().toString()) || !idAndNumbers.containsValue(company2.getNumber())) continue;
                orgUnits.add(company2);
                it.remove();
            }
            String sql = "insert into T_Eas_Company (FId, FNumber, FName, FIsMtnOrg) values (?, ?, ?, 0)";
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            boolean bool = false;
            HashSet set = new HashSet(orgUnitCollection);
            Locale locale = LocaleUtils.getDefaultLocale();
            for (OrgUnitInfo company2 : set) {
                ps.setString(1, company2.getId().toString());
                ps.setString(2, company2.getNumber());
                ps.setString(3, company2.getName(locale) == null ? (company2.getName() == null ? "" : company2.getName()) : company2.getName(locale));
                ps.addBatch();
                bool = true;
            }
            if (bool) {
                ps.executeBatch();
            }
            ps.clearBatch();
            if (orgUnits.size() > 0) {
                sql = "update T_Eas_Company set FId = ? where FNumber = ?";
                ps = conn.prepareStatement(sql);
                set = new HashSet(orgUnits);
                locale = LocaleUtils.getDefaultLocale();
                for (OrgUnitInfo company2 : set) {
                    ps.setString(1, company2.getId().toString());
                    ps.setString(2, company2.getNumber());
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

