/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ReportDAO {
    private static final Logger log = Logger.getLogger(ReportDAO.class);
    private static final String sql = "select r.FCreatorID, r.FId, r.FName, r.FPeriod, r.FYear, r.FPeriodType, r.FSourceType, r.FTemplateId, r.FTemplateNumber, r.FCurrencyId, c.FNumber, r.FAuditorId, r.FAuditedTime, r.FAuditedStatus, r.FCheckedStatus, r.FCompanyNum, r.FDataCollectNumber  from t_eas_report r inner join T_Eas_Currency c on r.fcurrencyid=c.fid where r.FId = ?";

    public static ReportVO getReportVO(String id) throws Exception {
        ReportVO vo = new ReportVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        if (!rowSet.next()) {
            return null;
        }
        vo.setCreatorID(rowSet.getString("FCreatorID"));
        vo.setPeriod(rowSet.getInt("FPeriod"));
        vo.setYear(rowSet.getInt("FYear"));
        vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
        vo.setName(rowSet.getString("FName"));
        vo.setCurrencyId(rowSet.getString("FCurrencyId"));
        vo.setCurrencyNumber(rowSet.getString("FNumber"));
        vo.setTemplateId(rowSet.getString("FTemplateId"));
        vo.setTemplateNumber(rowSet.getString("FTemplateNumber"));
        vo.setAuditedStatus(rowSet.getInt("FAuditedStatus"));
        vo.setCheckedStatus(rowSet.getInt("FCheckedStatus"));
        vo.setAuditorid(rowSet.getString("FAuditorId"));
        vo.setAuditedTime(rowSet.getTimestamp("FAuditedTime"));
        vo.setSourceType(rowSet.getInt("FSourceType"));
        vo.setCompanyNum(UIConfig.getCurCompanyNumber());
        vo.setDataCollectNumber(rowSet.getString("FDataCollectNumber"));
        vo.setId(id);
        vo.setData(ReportDAO.getData(vo));
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(ReportVO vo) throws Exception {
        String fileDir = UIConfig.getShareFileUrl() + File.separator + ReportDAO.getFileName(vo);
        File f = new File(fileDir);
        if (!f.exists()) {
            ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
            throw new EASBizException(new NumericExceptionSubItem("1", resHelper.getString("KDFIsnull")));
        }
        try (FileInputStream in = null;){
            in = new FileInputStream(f);
            Book book = IOHelper.loadFile((InputStream)in);
            book.setCalculate(false);
            byte[] byArray = IOHelper.packBook((Book)book);
            return byArray;
        }
        return null;
    }

    public static void removeData(String id) throws EASBizException, BOSException {
        ReportVO vo = new ReportVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        try {
            if (rowSet.next()) {
                vo.setCreatorID(rowSet.getString("FCreatorID"));
                vo.setPeriod(rowSet.getInt("FPeriod"));
                vo.setYear(rowSet.getInt("FYear"));
                vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
                vo.setName(rowSet.getString("FName"));
                vo.setCurrencyId(rowSet.getString("FCurrencyId"));
                vo.setCurrencyNumber(rowSet.getString("FNumber"));
                vo.setTemplateId(rowSet.getString("FTemplateId"));
                vo.setTemplateNumber(rowSet.getString("FTemplateNumber"));
                vo.setAuditedStatus(rowSet.getInt("FAuditedStatus"));
                vo.setCheckedStatus(rowSet.getInt("FCheckedStatus"));
                vo.setAuditorid(rowSet.getString("FAuditorId"));
                vo.setAuditedTime(rowSet.getTimestamp("FAuditedTime"));
                vo.setSourceType(rowSet.getInt("FSourceType"));
                vo.setDataCollectNumber(rowSet.getString("FDataCollectNumber"));
                vo.setCompanyNum(UIConfig.getCurCompanyNumber());
                vo.setId(id);
                String fileDir = UIConfig.getShareFileUrl() + File.separator + ReportDAO.getFileName(vo);
                File f = new File(fileDir);
                if (f.exists()) {
                    f.delete();
                    f = null;
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new SQLDataException(e);
        }
    }

    public static void saveData(ReportVO vo) throws Exception {
        String fileDir = UIConfig.getShareFileUrl() + File.separator + ReportDAO.getFileName(vo);
        File f = new File(fileDir);
        if (f.exists()) {
            f.delete();
        }
        Book book = IOHelper.unpackBook((byte[])vo.getData());
        book.setCalculate(false);
        IOHelper.saveToFile((Book)book, (String)fileDir);
    }

    public static void saveData(String id, byte[] data) throws Exception {
        ReportVO vo = new ReportVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        try {
            if (rowSet.next()) {
                vo.setCreatorID(rowSet.getString("FCreatorID"));
                vo.setPeriod(rowSet.getInt("FPeriod"));
                vo.setYear(rowSet.getInt("FYear"));
                vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
                vo.setName(rowSet.getString("FName"));
                vo.setCurrencyId(rowSet.getString("FCurrencyId"));
                vo.setCurrencyNumber(rowSet.getString("FNumber"));
                vo.setTemplateId(rowSet.getString("FTemplateId"));
                vo.setTemplateNumber(rowSet.getString("FTemplateNumber"));
                vo.setAuditedStatus(rowSet.getInt("FAuditedStatus"));
                vo.setCheckedStatus(rowSet.getInt("FCheckedStatus"));
                vo.setAuditorid(rowSet.getString("FAuditorId"));
                vo.setAuditedTime(rowSet.getTimestamp("FAuditedTime"));
                vo.setSourceType(rowSet.getInt("FSourceType"));
                vo.setCompanyNum(UIConfig.getCurCompanyNumber());
                vo.setDataCollectNumber(rowSet.getString("FDataCollectNumber"));
                vo.setId(id);
                vo.setData(data);
                ReportDAO.saveData(vo);
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
            throw new SQLDataException(e);
        }
    }

    private static String getFileName(ReportVO vo) {
        StringBuffer buf = new StringBuffer();
        buf.append(vo.getCompanyNum()).append("-");
        buf.append(vo.getTemplateNumber().trim()).append("-");
        buf.append(vo.getCurrencyNumber().trim()).append("-");
        buf.append(vo.getSourceType()).append("-");
        buf.append(vo.getYear()).append("-");
        buf.append(vo.getPeriod()).append("-");
        buf.append(vo.getPeriodType().getValue()).append("_");
        buf.append(vo.getDataCollectNumber());
        buf.append(".xml");
        return buf.toString();
    }

    public static String getReportFileName(ReportVO vo) {
        return ReportDAO.getFileName(vo);
    }

    public static ArrayList getReportInfo(String FscheduleId) {
        ArrayList<ReportVO> resultList = new ArrayList<ReportVO>();
        ReportVO report = null;
        String sql = "select R.FCreatorID as FCreatorID, R.Fid as RFid,R.FName as RFName,R.FPeriodType as RFPeriodType,R.FYear as RFYear,R.FPeriod as RFPeriod,T.FId as TFId, T.Fnumber as TFnumber,T.FTemplateType as FTemplateType,C.FId as CFId, C.Fnumber as CFnumber, R.FCompanyNum as RCompany  from (T_EAS_Report R inner join T_EAS_Template T on R.FTemplateID=T.Fid)  inner join T_EAS_Currency C on R.FCurrencyID = C.Fid  where R.FAuditedStatus = 2 and R.FCheckedStatus = 2  and T.Fnumber in (select FtemplateNumber from T_EAS_TimeTemplate where FscheduleId='" + FscheduleId + "')  and C.Fnumber in (select FcurrencyNumber from T_EAS_TimeCurrency where FscheduleId='" + FscheduleId + "') order by R.FYear desc,R.FPeriod";
        System.out.println("SQL(getReportInfo):" + sql);
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString());
            while (rowSet.next()) {
                report = new ReportVO();
                report.setCreatorID(rowSet.getString("FCreatorID"));
                report.setId(rowSet.getString("RFid"));
                report.setName(rowSet.getString("RFName"));
                report.setPeriodTypeInt(Integer.parseInt(rowSet.getString("RFPeriodType")));
                report.setYear(Integer.parseInt(rowSet.getString("RFYear")));
                report.setPeriod(Integer.parseInt(rowSet.getString("RFPeriod")));
                report.setTemplateId(rowSet.getString("TFId"));
                report.setTemplateNumber(rowSet.getString("TFnumber"));
                report.setTemplateType(rowSet.getString("FTemplateType"));
                report.setCurrencyId(rowSet.getString("CFId"));
                report.setCurrencyNumber(rowSet.getString("CFnumber"));
                report.setCompanyNum(UIConfig.getCurCompanyNumber());
                report.setDataCollectNumber(rowSet.getString("RDataCollectNumber"));
                resultList.add(report);
            }
        }
        catch (EASBizException e) {
            log.error((Object)e);
        }
        catch (BOSException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return resultList;
    }
}

