/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class TemplateDAO {
    private static final String sql = "select FId, FName, FNumber, FPeriodType, FVersionNumber, FTemplateType, FDynaRptType, FDescription, FIsIncludeOtherDC, FCompanyNum from t_eas_template where FId = ? and FCompanyNum = ?";

    public static TemplateVO getTemplateVO(String id) throws Exception {
        TemplateVO vo = new TemplateVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id, UIConfig.getCurCompanyNumber()});
        try {
            if (!rowSet.next()) {
                return null;
            }
            vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
            vo.setName(rowSet.getString("FName"));
            vo.setNumber(rowSet.getString("FNumber"));
            vo.setVersionNumber(rowSet.getString("FVersionNumber"));
            vo.setTemplateType(rowSet.getInt("FTemplateType"));
            vo.setDynaType(rowSet.getInt("FDynaRptType"));
            vo.setDescription(rowSet.getString("FDescription"));
            vo.setCompanyNum(rowSet.getString("FCompanyNum"));
            vo.setIsIncludeOtherDC(rowSet.getInt("FIsIncludeOtherDC"));
            vo.setId(id);
            vo.setData(TemplateDAO.getData(vo));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return vo;
    }

    public static TemplateVO getTemplateVO(String number, int templateType) throws Exception {
        TemplateVO vo = new TemplateVO();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FName, FNumber, FPeriodType, FVersionNumber, ");
        sql.append(" FTemplateType, FDynaRptType, FDescription, FIsIncludeOtherDC, FCompanyNum ");
        sql.append(" from t_eas_template ");
        sql.append(" where FNumber = '").append(number);
        sql.append("' and FTemplateType = ").append(templateType);
        sql.append(" and FCompanyNum = '").append(UIConfig.getCurCompanyNumber()).append("'");
        sql.append(" order by FVersionNumber desc");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString());
        if (!rowSet.next()) {
            return null;
        }
        vo.setId(rowSet.getString("FId"));
        vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
        vo.setName(rowSet.getString("FName"));
        vo.setNumber(rowSet.getString("FNumber"));
        vo.setVersionNumber(rowSet.getString("FVersionNumber"));
        vo.setTemplateType(rowSet.getInt("FTemplateType"));
        vo.setDynaType(rowSet.getInt("FDynaRptType"));
        vo.setDescription(rowSet.getString("FDescription"));
        vo.setIsIncludeOtherDC(rowSet.getInt("FIsIncludeOtherDC"));
        vo.setCompanyNum(rowSet.getString("FCompanyNum"));
        vo.setData(TemplateDAO.getData(vo));
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(TemplateVO vo) throws Exception {
        String fileDir = UIConfig.getShareFileUrl() + File.separator + TemplateDAO.getFileName(vo);
        File f = new File(fileDir);
        if (!f.exists()) {
            ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
            throw new EASBizException(new NumericExceptionSubItem("1", resHelper.getString("KDFIsnull")));
        }
        try (FileInputStream in = null;){
            in = new FileInputStream(f);
            Book book = IOHelper.loadFile((InputStream)in);
            book.setCalculate(false);
            byte[] byArray = IOHelper.packBook((Book)book);
            return byArray;
        }
        return null;
    }

    public static void removeData(String id) throws EASBizException, BOSException {
        TemplateVO vo = new TemplateVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id, UIConfig.getCurCompanyNumber()});
        try {
            if (rowSet.next()) {
                vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
                vo.setName(rowSet.getString("FName"));
                vo.setNumber(rowSet.getString("FNumber"));
                vo.setVersionNumber(rowSet.getString("FVersionNumber"));
                vo.setTemplateType(rowSet.getInt("FTemplateType"));
                vo.setDynaType(rowSet.getInt("FDynaRptType"));
                vo.setCompanyNum(rowSet.getString("FCompanyNum"));
                vo.setIsIncludeOtherDC(rowSet.getInt("FIsIncludeOtherDC"));
                vo.setId(id);
                String fileDir = UIConfig.getShareFileUrl() + File.separator + TemplateDAO.getFileName(vo);
                File f = new File(fileDir);
                if (f.exists()) {
                    f.delete();
                    f = null;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void saveData(TemplateVO vo) throws Exception {
        String fileDir = UIConfig.getShareFileUrl() + File.separator + TemplateDAO.getFileName(vo);
        File f = new File(fileDir);
        if (f.exists()) {
            f.delete();
        }
        Book book = IOHelper.unpackBook((byte[])vo.getData());
        IOHelper.saveToFile((Book)book, (String)fileDir);
    }

    public static void saveData(String id, byte[] data) throws Exception {
        TemplateVO vo = new TemplateVO();
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id, UIConfig.getCurCompanyNumber()});
        try {
            if (rowSet.next()) {
                vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("FPeriodType")));
                vo.setName(rowSet.getString("FName"));
                vo.setNumber(rowSet.getString("FNumber"));
                vo.setVersionNumber(rowSet.getString("FVersionNumber"));
                vo.setTemplateType(rowSet.getInt("FTemplateType"));
                vo.setDynaType(rowSet.getInt("FDynaRptType"));
                vo.setCompanyNum(rowSet.getString("FCompanyNum"));
                vo.setIsIncludeOtherDC(rowSet.getInt("FIsIncludeOtherDC"));
                vo.setId(id);
                vo.setData(data);
                TemplateDAO.saveData(vo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void saveData(TemplateVO vo, KDSpread spread) throws EASBizException, BOSException, IOException, KDFException {
        String fileDir = UIConfig.getShareFileUrl() + File.separator + TemplateDAO.getFileName(vo);
        File f = new File(fileDir);
        if (f.exists()) {
            f.delete();
        }
        IOHelper.saveToFile((Book)spread.getBook(), (String)fileDir);
    }

    private static String getFileName(TemplateVO vo) {
        StringBuffer buf = new StringBuffer();
        buf.append(vo.getCompanyNum()).append("-");
        buf.append(vo.getNumber()).append("-");
        buf.append(vo.getTemplateType()).append("-");
        buf.append(vo.getPeriodType().getValue()).append("-");
        buf.append(vo.getVersionNumber()).append(".xml");
        return buf.toString();
    }

    public static String getTemplateFileName(TemplateVO vo) {
        return TemplateDAO.getFileName(vo);
    }
}

