/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.tools.k3;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceFacade;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.AisInfo;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;

public class K3Helper {
    private AisInfo[] aisList;
    private Locale locale = null;
    private String id;
    private String server;
    private String username;
    private String password;
    private String k3Account;
    private String k3Url;
    private int dcIndex;
    private int dcId;
    private int state;

    public K3Helper(Locale locale) throws Exception {
        this.locale = locale;
    }

    public K3Helper() {
    }

    public void initK3Info() throws Exception {
        String sql = "SELECT FK3Server, FK3Name, FUserName, FPassword, FState, FDcIndex, FDcId, Fk3Url FROM T_EAS_K3Setting WHERE FCompanyNumber = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
        if (rowSet.next()) {
            this.server = rowSet.getString("FK3Server");
            this.k3Account = rowSet.getString("FK3Name");
            this.username = rowSet.getString("FUserName");
            this.password = rowSet.getString("FPassword");
            this.dcIndex = rowSet.getInt("FDcIndex");
            this.dcId = rowSet.getInt("FDcId");
            this.k3Url = rowSet.getString("Fk3Url");
            return;
        }
        throw new Exception(CslRptClientResourceHelper.getString("125_K3Helper"));
    }

    public void k3login() throws Exception {
        if (StringUtils.isEmpty((String)this.server)) {
            throw new BOSException(this.getResx("ServerIsNull"));
        }
        this.aisList = K3WebServiceFacade.queryAisInfo();
        AisInfo aisInfo = this.aisList[this.dcIndex];
        String loginString = K3WebServiceFacade.login(this.username, this.password, aisInfo.getAisID());
        if (StringUtils.isEmpty((String)loginString)) {
            throw new BOSException(this.getResx("LoginString_isnull"));
        }
        this.parseLoginString(loginString);
    }

    public String parseLoginString(String loginString) throws BOSException {
        String dataSource;
        int end;
        if (!loginString.startsWith("ConnectString")) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        int begin = loginString.indexOf("{");
        String tmpStr = loginString.substring(begin + 1, end = loginString.indexOf("}"));
        if (StringUtils.isEmpty((String)tmpStr)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        String[] param = tmpStr.split("\\;");
        if (param.length == 0) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        HashMap<String, String> context = new HashMap<String, String>();
        for (int i = 0; i < param.length; ++i) {
            String[] strs = param[i].split("=");
            if (strs.length == 2) {
                context.put(strs[0], strs[1]);
                continue;
            }
            if (strs.length == 1) {
                context.put(strs[0], "");
                continue;
            }
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        StringBuffer connectString = new StringBuffer();
        String provider = (String)context.get("Provider");
        if (StringUtils.isEmpty((String)provider)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        if (provider.startsWith("SQLOLEDB")) {
            connectString.append("jdbc:ksql:com.microsoft.jdbc.sqlserver.SQLServerDriver:dbtype=mssqlserver:trace=off:file=null:Optimize=1:");
        }
        if (StringUtils.isEmpty((String)(dataSource = (String)context.get("Data Source")))) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("jdbc:microsoft:sqlserver://").append(dataSource).append(":1433;");
        String dbname = (String)context.get("Initial Catalog");
        if (StringUtils.isEmpty((String)dbname)) {
            throw new BOSException(this.getResx("LoginString_Error"));
        }
        connectString.append("DataBaseName=").append(dbname);
        String userName = (String)context.get("User ID");
        if (StringUtils.isEmpty((String)userName)) {
            throw new BOSException(this.getResx("UserIsNull"));
        }
        String password = (String)context.get("Password");
        return connectString.toString();
    }

    public String getResx(String resxItemName) {
        String resxName = "com.kingdee.eas.rptclient.gr.rptclient.resource.LoginFrameResource";
        if (this.locale == null) {
            this.locale = new Locale("L2");
        }
        return ResourceBase.getString((String)resxName, (String)resxItemName, (Locale)this.locale);
    }

    public AisInfo[] getAisList() {
        return this.aisList;
    }

    public void setAisList(AisInfo[] aisList) {
        this.aisList = aisList;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getK3Account() {
        return this.k3Account;
    }

    public void setK3Account(String account) {
        this.k3Account = account;
    }

    public int getDcIndex() {
        return this.dcIndex;
    }

    public void setDcIndex(int dcIndex) {
        this.dcIndex = dcIndex;
    }

    public int getDcId() {
        return this.dcId;
    }

    public void setDcId(int dcId) {
        this.dcId = dcId;
    }

    public String getK3Url() {
        return this.k3Url;
    }

    public void setK3Url(String url) {
        this.k3Url = url;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

