/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.tools.mail;

import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSend {
    private static final String sql = "select FSMTP, FToAddress, FMailId, FMailPw from T_EAS_Mail where FCompanyNumber = ?";
    private static final Exception MAIL_NOT_COMPLETE = new Exception(CslRptClientResourceHelper.getString("126_MailSend"));
    private String mailContent = "";
    private String mailSubject = "";
    private String smtp = "";
    private String to = "";
    private String mailId = "";
    private String mailPw = "";

    public void isMailComplete() throws Exception {
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
        if (rowSet.next()) {
            boolean isMailComplete;
            this.smtp = rowSet.getString("FSMTP");
            this.to = rowSet.getString("FToAddress");
            this.mailId = rowSet.getString("FMailId");
            this.mailPw = rowSet.getString("FMailPw");
            boolean bl = isMailComplete = StringUtils.isEmpty((String)this.smtp) || StringUtils.isEmpty((String)this.to) || StringUtils.isEmpty((String)this.mailId) || StringUtils.isEmpty((String)this.mailPw);
            if (isMailComplete) {
                throw MAIL_NOT_COMPLETE;
            }
        } else {
            throw MAIL_NOT_COMPLETE;
        }
    }

    public void send() throws Exception {
        this.isMailComplete();
        if (StringUtils.isEmpty((String)this.mailContent)) {
            throw new Exception(CslRptClientResourceHelper.getString("127_MailSend"));
        }
        if (StringUtils.isEmpty((String)this.mailSubject)) {
            throw new Exception(CslRptClientResourceHelper.getString("128_MailSend"));
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtp);
        props.put("mail.smtp.auth", "true");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailSend.this.mailId, MailSend.this.mailPw);
            }
        });
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        MimeMessage mimeMsg = new MimeMessage(session);
        InternetAddress fromAddr = new InternetAddress(this.mailId);
        mimeMsg.addFrom(new Address[]{fromAddr});
        mimeMsg.addRecipients(Message.RecipientType.TO, (Address[])this.getToAddress());
        mimeMsg.setSubject(MimeUtility.encodeText((String)this.mailSubject, (String)"UTF-8", (String)"B"));
        body.setHeader("Content-Transfer-Encoding", "base64");
        body.setContent((Object)this.mailContent, "text/plain; charset=UTF-8");
        mp.addBodyPart((BodyPart)body);
        mimeMsg.setContent((Multipart)mp);
        mimeMsg.saveChanges();
        Transport.send((Message)mimeMsg);
    }

    private InternetAddress[] getToAddress() throws AddressException {
        InternetAddress[] adds = null;
        if (!StringUtils.isEmpty((String)this.to)) {
            if (this.to.indexOf(44) != -1) {
                String[] strs = this.to.split(",");
                adds = new InternetAddress[strs.length];
                for (int i = 0; i < strs.length; ++i) {
                    InternetAddress address;
                    adds[i] = address = new InternetAddress(strs[i]);
                }
                return adds;
            }
            return new InternetAddress[]{new InternetAddress(this.to)};
        }
        return null;
    }

    public String getMailContent() {
        return this.mailContent;
    }

    public void setMailContent(String mailContent) {
        this.mailContent = mailContent;
    }

    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }
}

