/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.update;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class FtpConfigService {
    private static final String FTP_IP = "ip";
    private static final String FTP_LOGINNAME = "username";
    private static final String FTP_PASSWORD = "password";
    private static final String FTP_PATH = "path";
    private static final String FTP_NAME = "FTP";
    private static final String FTP_AUTOUPDATE = "autoupdate";
    private static final String FTP_UPDATE = "update";
    private static final String CLIENTJARUPDATE_USERCONFIG = "clientJarUpdate-userconfig.xml";
    private static FtpConfigService service = null;
    private ConfigurationItem FTPItem;
    private ConfigurationItem autoUpdateItem;
    private XMLConfiguration configuration;
    private String ip = "";
    private String DFPath = "";
    private String username = "";
    private String secret = "";
    private String autoupdate = "false";
    private static Logger logger = Logger.getLogger(FtpConfigService.class);

    private FtpConfigService() {
        this.loadConfigFile();
    }

    private void loadConfigFile() {
        String fileName = FilenameUtils.normalize((String)FtpConfigService.getConfigPath());
        File cfgFile = new File(fileName);
        if (!cfgFile.exists()) {
            FtpConfigService.initDefaultConfigFile4UpdateJar(cfgFile);
        }
        this.configuration = XMLConfiguration.getInstance((File)cfgFile);
        this.FTPItem = this.configuration.getConfigItem(FTP_NAME);
        this.autoUpdateItem = this.configuration.getConfigItem(FTP_UPDATE);
        this.ip = this.FTPItem.getProperty(FTP_IP, "");
        this.DFPath = this.FTPItem.getProperty(FTP_PATH, "");
        this.username = this.FTPItem.getProperty(FTP_LOGINNAME, "");
        this.secret = this.FTPItem.getProperty(FTP_PASSWORD, "");
        this.autoupdate = this.autoUpdateItem.getProperty(FTP_AUTOUPDATE);
    }

    private static void initDefaultConfigFile4UpdateJar(File cfgFile) {
        FtpConfigService.saveConfigFile4UPpdateJar(cfgFile, "", "", "", "", "false");
    }

    private static void saveConfigFile4UPpdateJar(File cfgFile, String ip, String DFPath, String logname, String secret, String autoupdate) {
        OutputStreamWriter writer = null;
        try {
            if (StringUtils.isEmpty((String)ip)) {
                ip = "";
            }
            if (StringUtils.isEmpty((String)DFPath)) {
                DFPath = "";
            }
            if (StringUtils.isEmpty((String)logname)) {
                logname = "";
            }
            if (StringUtils.isEmpty((String)secret)) {
                secret = "";
            }
            if (StringUtils.isEmpty((String)autoupdate)) {
                autoupdate = "false";
            }
            String lineSeperator = "\r\n";
            writer = new FileWriter(cfgFile);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(lineSeperator);
            writer.write("<config>");
            writer.write(lineSeperator);
            writer.write("  <configitem name=\"FTP\">");
            writer.write(lineSeperator);
            writer.write("      <attribute key=\"ip\" value=\"" + ip + "\" />");
            writer.write(lineSeperator);
            writer.write("      <attribute key=\"name\" value=\"" + logname + "\" />");
            writer.write(lineSeperator);
            writer.write("      <attribute key=\"password\" value=\"" + secret + "\" />");
            writer.write(lineSeperator);
            writer.write("      <attribute key=\"path\" value=\"" + DFPath + "\" />");
            writer.write(lineSeperator);
            writer.write("  </configitem>");
            writer.write("  <configitem name=\"update\">");
            writer.write(lineSeperator);
            writer.write("      <attribute key=\"autoupdate\" value=\"" + autoupdate + "\" />");
            writer.write(lineSeperator);
            writer.write("  </configitem>");
            writer.write("</config>");
        }
        catch (IOException e) {
            throw new RuntimeException("initial default config file error!", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"writer.close()", (Throwable)e);
                }
            }
        }
    }

    public static FtpConfigService getInstance() {
        if (service == null) {
            service = new FtpConfigService();
        }
        return service;
    }

    public boolean isInvalidFTPparams() {
        return StringUtil.isEmptyString((String)this.ip) || StringUtil.isEmptyString((String)this.DFPath) || StringUtil.isEmptyString((String)this.username);
    }

    public void saveConfigFile(String _ip, String _DFPath, String _logname, String _secret) {
        this.FTPItem.setProperty(FTP_IP, _ip);
        this.FTPItem.setProperty(FTP_LOGINNAME, _logname);
        this.FTPItem.setProperty(FTP_PASSWORD, _secret);
        this.FTPItem.setProperty(FTP_PATH, _DFPath);
        this.configuration.store();
        this.ip = _ip;
        this.DFPath = _DFPath;
        this.username = _logname;
        this.secret = _secret;
    }

    public String getIp() {
        return this.ip;
    }

    public String getDFPath() {
        return this.DFPath;
    }

    public String getLogname() {
        return this.username;
    }

    public String getPassword() {
        return this.secret;
    }

    public boolean isAutoupdate() {
        return StringUtil.isEmptyString((String)this.autoupdate) ? false : "true".equalsIgnoreCase(this.autoupdate);
    }

    private static String getConfigPath() {
        String root = System.getProperty("user.dir");
        String subname = "" + File.separator + "config" + File.separator;
        return new StringBuffer(80).append(root).append(subname).append(CLIENTJARUPDATE_USERCONFIG).toString();
    }

    public static void main(String[] args) {
        FtpConfigService.getInstance();
    }
}

