/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.rptclient.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.ItemFormulaChangeEvent;
import com.kingdee.eas.rptclient.newrpt.client.designer.ItemFormulaChangeListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardUI;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ItemFormulaPanel
extends KDPanel {
    private static final long serialVersionUID = -4911153025073003176L;
    private KDWorkButton btnItem;
    private KDTextField txtItemFormula;
    private KDWorkButton btnOption;
    private KDButtonGroup grpOption;
    private int state = 1;
    private static final int ALWAYS_SHOW = 0;
    private static final int ASNEEDED_SHOW = 1;
    private static final int NEVER_SHOW = 2;
    private boolean showItem = false;
    private KDPopupMenu popupOptionMenu = null;
    private KDCheckBoxMenuItem menuAlwaysShow = null;
    private KDCheckBoxMenuItem menuShowAsNeeded = null;
    private KDCheckBoxMenuItem menuNeverShow = null;
    private ItemPanelStateChangeListener itemPanelStateChangeListener;
    private IItemFormulaProvider formulaProvider;
    private int width = 0;
    private ItemFormulaChangeListener itemFormulaChangeListener;
    private FormulaWizardUI wizard;
    private static final int EDIT_BEGIN = 1;
    private static final int EDIT_END = 0;
    private int editState = 0;

    public ItemFormulaPanel() {
        this.setLayout(new ItemPanelLayout());
        this.initComponents();
        this.initCompActions();
    }

    private void initComponents() {
        this.btnItem = new KDWorkButton();
        this.txtItemFormula = new KDTextField();
        this.btnOption = new KDWorkButton();
        this.add((Component)this.btnItem);
        this.btnItem.setToolTipText(ResourceHelper.getItemPanelResource("ItemFormulaPanel.0"));
        this.add((Component)this.txtItemFormula);
        this.btnOption.setToolTipText(ResourceHelper.getItemPanelResource("ItemFormulaPanel.1"));
        this.add((Component)this.btnOption);
        this.menuAlwaysShow = new KDCheckBoxMenuItem(ResourceHelper.getItemPanelResource("ItemFormulaPanel.2"));
        this.menuShowAsNeeded = new KDCheckBoxMenuItem(ResourceHelper.getItemPanelResource("ItemFormulaPanel.3"));
        this.menuNeverShow = new KDCheckBoxMenuItem(ResourceHelper.getItemPanelResource("ItemFormulaPanel.4"));
        this.grpOption = new KDButtonGroup();
        this.grpOption.add((AbstractButton)this.menuAlwaysShow);
        this.grpOption.add((AbstractButton)this.menuShowAsNeeded);
        this.grpOption.add((AbstractButton)this.menuNeverShow);
        this.popupOptionMenu = new KDPopupMenu();
        this.popupOptionMenu.add((JMenuItem)this.menuAlwaysShow);
        this.popupOptionMenu.add((JMenuItem)this.menuShowAsNeeded);
        this.popupOptionMenu.add((JMenuItem)this.menuNeverShow);
        this.btnItem.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_showformula"));
        this.btnOption.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.grpOption.setSelected(this.menuShowAsNeeded.getModel(), true);
        this.btnOption.setToolTipText(ResourceHelper.getItemPanelResource("ItemFormulaPanel.5"));
        this.txtItemFormula.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ItemFormulaPanel.this.editState = 1;
            }

            @Override
            public void focusLost(FocusEvent e) {
                ItemFormulaPanel.this.editState = 0;
            }
        });
        this.txtItemFormula.setSelectAllOnFocus(false);
    }

    public void addItemFormulaChangeListener(ItemFormulaChangeListener l) {
        this.itemFormulaChangeListener = l;
        this.txtItemFormula.getDocument().addDocumentListener(new DocumentListener(){
            ItemFormulaChangeEvent e;
            {
                this.e = new ItemFormulaChangeEvent((Object)ItemFormulaPanel.this, null);
            }

            private void update(DocumentEvent de) {
                if (ItemFormulaPanel.this.txtItemFormula.isFocusOwner()) {
                    String text = ItemFormulaPanel.this.txtItemFormula.getText();
                    this.e.setFormula(text);
                    ItemFormulaPanel.this.itemFormulaChangeListener.formulaChanged(this.e);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }
        });
    }

    private void setShowState(int s) {
        this.state = s;
        this.setItemFormulaLine(this.txtItemFormula.getText());
    }

    public void refreshItemFormula(Cell cell, int viewMode) {
        if (this.editState != 1) {
            if (cell == null) {
                this.setItemFormulaLine(null);
            }
            if (this.formulaProvider != null) {
                this.setItemFormulaLine(this.formulaProvider.getDisplayingItemFormula(cell, viewMode));
            }
        }
    }

    public void setItemFormulaLine(String formula) {
        this.txtItemFormula.setText(formula);
        if (this.state == 1) {
            this.setPanelVisible(!StringUtils.isEmpty((String)formula));
        } else if (this.state == 0) {
            this.setPanelVisible(true);
        } else {
            this.setPanelVisible(false);
        }
    }

    private void initCompActions() {
        this.btnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.initWizard();
                ItemFormulaPanel.this.wizard.open();
            }
        });
        this.btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = ItemFormulaPanel.this.btnOption.getBounds();
                ItemFormulaPanel.this.popupOptionMenu.show((Component)ItemFormulaPanel.this.btnOption, bounds.x, bounds.y + bounds.height);
            }
        });
        this.menuAlwaysShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(0);
            }
        });
        this.menuShowAsNeeded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(1);
            }
        });
        this.menuNeverShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemFormulaPanel.this.setShowState(2);
            }
        });
    }

    public void setPanelVisible(boolean visible) {
        if (visible && this.showItem) {
            return;
        }
        this.showItem = visible;
        this.txtItemFormula.setVisible(visible);
        this.btnItem.setVisible(visible);
        this.layout();
    }

    public void setStateChangeListener(ItemPanelStateChangeListener l) {
        this.itemPanelStateChangeListener = l;
    }

    public IItemFormulaProvider getFormulaProvider() {
        return this.formulaProvider;
    }

    public void setFormulaProvider(IItemFormulaProvider formulaProvider) {
        this.formulaProvider = formulaProvider;
    }

    public void setEnabled(boolean enabled) {
        this.txtItemFormula.setEnabled(enabled);
        this.btnItem.setEnabled(enabled);
    }

    private void initWizard() {
        try {
            if (this.wizard != null) {
                return;
            }
            this.wizard = FormulaWizardUI.creatFormulaWizard(SwingUtilities.getWindowAncestor((Component)((Object)this)));
            this.wizard.setFormulaWizardListener(new FormulaPickListener(){

                @Override
                public String pickFormulaLine() {
                    String s = ItemFormulaPanel.this.txtItemFormula.getText();
                    if (s == null || s.trim().length() < 1) {
                        return "Item()";
                    }
                    if (s.charAt(0) == '=') {
                        s = s.substring(1);
                    }
                    return s;
                }

                @Override
                public void setFormulaLine(String line) {
                    String string = '=' + line;
                    ItemFormulaPanel.this.txtItemFormula.setText(string);
                    if (ItemFormulaPanel.this.itemFormulaChangeListener != null) {
                        ItemFormulaChangeEvent e = new ItemFormulaChangeEvent((Object)ItemFormulaPanel.this.wizard);
                        e.setFormula(string);
                        ItemFormulaPanel.this.itemFormulaChangeListener.formulaChanged(e);
                    }
                }
            });
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
    }

    private class ItemPanelLayout
    implements LayoutManager {
        private static final int PANEL_HEIGHT = 20;
        private int itemFormulaWidth = 300;

        private ItemPanelLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = ItemFormulaPanel.this.getHeight();
            Insets insets = ItemFormulaPanel.this.getInsets();
            int left = insets.left;
            int top = insets.top;
            int bottom = insets.bottom;
            int compH = h - top - bottom;
            int x = left;
            int y = top;
            x += 2;
            if (ItemFormulaPanel.this.showItem) {
                int total = ItemFormulaPanel.this.getBounds().width;
                ItemFormulaPanel.this.btnItem.setBounds(x, y, compH + 2, compH);
                ItemFormulaPanel.this.txtItemFormula.setLocation(x += compH + 2, y);
                int itemWidth = total - x - 16 - 1;
                if (itemWidth < 0 && total < x + 16 + 2) {
                    itemWidth = this.itemFormulaWidth;
                } else {
                    this.itemFormulaWidth = itemWidth;
                }
                ItemFormulaPanel.this.txtItemFormula.setSize(itemWidth, compH);
                ItemFormulaPanel.this.txtItemFormula.setBounds(x, y, itemWidth, compH);
                x += itemWidth + 1;
            }
            ItemFormulaPanel.this.btnOption.setBounds(x, y, 16, compH);
            int newWidth = x + ((ItemFormulaPanel)ItemFormulaPanel.this).btnOption.getBounds().width;
            if (ItemFormulaPanel.this.itemPanelStateChangeListener != null && newWidth != ItemFormulaPanel.this.width) {
                ItemFormulaPanel.this.width = newWidth;
                ItemFormulaPanel.this.itemPanelStateChangeListener.changeWidth(ItemFormulaPanel.this.width);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }
    }

    public static interface ItemPanelStateChangeListener {
        public void changeWidth(int var1);
    }
}

