/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.DynaRangeProvider;
import com.kingdee.eas.rptclient.gr.rptclient.DynaRangeUI;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslTemplateDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.newrpt.client.designer.CompanyFiller;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportSettingUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportSheetManagerListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.SheetManagerUI;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.DesignerConstants;
import com.kingdee.eas.rptclient.newrpt.designer.check.CompanyFillUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.IRptCheckListener;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheckHelper;
import com.kingdee.eas.rptclient.newrpt.designer.check.RptCheckUI;
import com.kingdee.eas.rptclient.newrpt.util.AdvMsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.SpreadHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;

public class ReportActionManager {
    private ReportDesigner designer;
    private Map actionMapping = new HashMap(5);
    private final SpreadContext spreadContainer;
    public static final String Report_Check_wizard = "Report_Check_wizard";
    public static final String Report_Check = "Report_Check";
    public static final String Company_Fill = "Company_Fill";
    public static final String Sheet_Manager = "Sheet_Manager";
    public static final String Exit = "Exit";
    public static final String CLEAR_ITEM = "CLEAR_ITEM";
    public static final String REPORT_SETTING = "REPORT_SETTING";
    public static final String Export = "Export";
    public static final String Import = "Import";
    public static final String Sheet_Protection = "Sheet_Protection";
    public static final String Book_Protection = "Book_Protection";
    public static final String Dyna_Range = "Dyna_Range";

    public ReportActionManager(SpreadContext spreadContainer) {
        this.spreadContainer = spreadContainer;
    }

    public AbstractAction getAction(String actionName) {
        Object action = this.spreadContainer.getActionManager().getAction(actionName);
        if (action != null) {
            return action;
        }
        action = (AbstractAction)this.actionMapping.get(actionName);
        if (action != null) {
            return action;
        }
        if (Company_Fill.equals(actionName)) {
            action = this.createCompanyFillAction();
        } else if (Report_Check_wizard.equals(actionName)) {
            action = this.createReportCheckWizardAction();
        } else if (Report_Check.equals(actionName)) {
            action = this.createReportCheckAction();
        } else if (Sheet_Manager.equals(actionName)) {
            action = this.createSheetManagerAction();
        } else if (Exit.equals(actionName)) {
            action = this.createExitAction();
        } else if (CLEAR_ITEM.equals(actionName)) {
            action = this.createClearItemFormulaAction();
        } else if (REPORT_SETTING.equals(actionName)) {
            action = this.createReportSettingAction();
        } else if (Import.equalsIgnoreCase(actionName)) {
            action = new ImportAction();
        } else if (Export.equalsIgnoreCase(actionName)) {
            action = new ExportAction();
        } else if (Sheet_Protection.equalsIgnoreCase(actionName)) {
            action = new SheetProtectionAction();
        } else if (Book_Protection.equalsIgnoreCase(actionName)) {
            action = new BookProtectionAction();
        } else if (Dyna_Range.equalsIgnoreCase(actionName)) {
            action = new DynaRangeAction();
        } else {
            return null;
        }
        this.actionMapping.put(actionName, action);
        return action;
    }

    public AbstractAction getReportCheckWizardAction() {
        return this.getAction(Report_Check_wizard);
    }

    public AbstractAction getReportCheckAction() {
        return this.getAction(Report_Check);
    }

    public AbstractAction getCompanyFillAction() {
        return this.getAction(Company_Fill);
    }

    public AbstractAction getSheetManagerAction() {
        return this.getAction(Sheet_Manager);
    }

    public AbstractAction getExitAction() {
        return this.getAction(Exit);
    }

    public AbstractAction getClearItemFormulaAction() {
        return this.getAction(CLEAR_ITEM);
    }

    public AbstractAction getReportSettingAction() {
        return this.getAction(REPORT_SETTING);
    }

    public AbstractAction getDynaRangeAction() {
        return this.getAction(Dyna_Range);
    }

    private AbstractAction createReportCheckWizardAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptCheckUI instance = RptCheckUI.getInstance((Component)((Object)ReportActionManager.this.designer), null);
                instance.setRptCheckListener(new IRptCheckListener(){

                    @Override
                    public RptCheckExpTank loadRptCheckExpTank() {
                        return BookProperties.loadFromSpread(ReportActionManager.this.getSpread().getBook()).getOperationSchema().getExpTank();
                    }

                    @Override
                    public List loadSheetNames() {
                        return SpreadHelper.getAllSheetsName(ReportActionManager.this.getSpread());
                    }

                    @Override
                    public void restoreCheckExpTank(RptCheckExpTank exps) {
                        BookProperties loadFromSpread = BookProperties.loadFromSpread(ReportActionManager.this.getSpread().getBook());
                        loadFromSpread.getOperationSchema().setExpTank(exps);
                        loadFromSpread.restoreToSpread(ReportActionManager.this.getSpread().getBook());
                    }
                });
                if (instance != null) {
                    instance.open();
                }
            }
        };
        return action;
    }

    private AbstractAction createReportCheckAction() {
        return new ReportCheckAction();
    }

    private AbstractAction createCompanyFillAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sheet sheet = ReportActionManager.this.getSpread().getBook().getActiveSheet();
                if (sheet != null) {
                    ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
                    Point basePoint = null;
                    int col = sheet.getActiveCol();
                    int row = sheet.getActiveRow();
                    if (col >= 0 && row >= 0) {
                        basePoint = new Point(col, row);
                        if (basePointList.size() > 0 && (basePoint = DynamicTemplateUtility.getBasePoint(sheet, basePoint, basePointList)) == null && basePointList.size() == 1) {
                            basePoint = (Point)basePointList.get(0);
                        }
                    } else if (basePointList.size() > 0) {
                        basePoint = (Point)basePointList.get(0);
                    }
                    if (basePoint == null) {
                        MsgBox.showError((Component)((Object)ReportActionManager.this.designer), CslRptClientResourceHelper.getString("133_ReportActionManager"));
                        return;
                    }
                }
                CompanyFillUI instance = (CompanyFillUI)CompanyFillUI.getInstance((Component)((Object)ReportActionManager.this.designer), null);
                instance.setFillListener(new CompanyFiller(ReportActionManager.this.getSpread()));
                if (instance != null) {
                    instance.showWindow();
                }
            }
        };
        return action;
    }

    private AbstractAction createSheetManagerAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SheetManagerUI managerUI = SheetManagerUI.createUI((Object)ReportActionManager.this.designer, ReportActionManager.this.getSpread());
                    managerUI.setMaintainListener(new ReportSheetManagerListener(ReportActionManager.this.getSpread()));
                    managerUI.showWindow();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle(e1);
                }
            }
        };
        return action;
    }

    private AbstractAction createExitAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportActionManager.this.designer.destory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        action.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_quit"));
        return action;
    }

    private AbstractAction createClearItemFormulaAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportActionManager.this.getSpread().getBook().getSelectionRange().clear(false, false, false, DesignerConstants.CONTENT_CLEAR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return action;
    }

    private AbstractAction createReportSettingAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HashMap<String, ReportCalculateErrorProvider> ctx = new HashMap<String, ReportCalculateErrorProvider>();
                    BookProperties p = BookProperties.loadFromSpread(ReportActionManager.this.spreadContainer.getSpread().getBook());
                    ReportCalculateErrorProvider errorp = p.getErrorProvider();
                    if (errorp == null) {
                        errorp = new ReportCalculateErrorProvider();
                    }
                    p.setErrorProvider(errorp);
                    ctx.put("RPT_ERRORHANDLER", errorp);
                    ReportSettingUI set = (ReportSettingUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)ReportActionManager.this.designer), ReportSettingUI.class.getName(), ctx);
                    set.showWindow();
                    p.restoreToSpread(ReportActionManager.this.spreadContainer.getSpread().getBook());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        return action;
    }

    protected ReportDesigner getDesigner() {
        return this.designer;
    }

    protected void setDesigner(ReportDesigner designer) {
        this.designer = designer;
    }

    private KDSpread getSpread() {
        return this.spreadContainer.getSpread();
    }

    private class ReportCheckAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ReportCheckAction() {
        }

        private AdvMsgBox createAdvMsgBox(String title, String msg, String detail, int msgType, int option) {
            AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)ReportActionManager.this.getSpread(), title, msg, detail, msgType, option);
            return box;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RptCheckExpTank expTank = BookProperties.loadFromSpread(ReportActionManager.this.getSpread().getBook()).getOperationSchema().getExpTank();
            try {
                if (expTank == null || expTank.getExpressions() == null || expTank.getExpressions().size() < 1) {
                    MsgBox.showInfo((Component)ReportActionManager.this.getSpread(), ResourceHelper.getActionMessageResource("ReportActionManager.0"));
                    return;
                }
                Book book = SpreadHelper.copySpread(ReportActionManager.this.getSpread()).getBook();
                Map result = ReportCheckHelper.checkReportResult(book, ReportActionManager.this.designer.getDataProvider(), expTank, LocaleUtils.getDefaultLocale());
                Boolean isCheckedPass = (Boolean)result.get("isCheckPass");
                String checkedResult = (String)result.get("checkResult");
                if (isCheckedPass.booleanValue() && StringUtils.isEmpty((String)checkedResult)) {
                    MsgBox.showInfo((Component)ReportActionManager.this.getSpread(), ResourceHelper.getActionMessageResource("ReportActionManager.4"));
                } else {
                    this.createAdvMsgBox(ResourceHelper.getActionMessageResource("ReportActionManager.2"), ResourceHelper.getActionMessageResource("ReportActionManager.3"), checkedResult == null ? "" : checkedResult, 1, 8188).show();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)ReportActionManager.this.getSpread(), (Throwable)ex);
            }
        }
    }

    abstract class BasicIOAction
    extends AbstractAction {
        public static final String KDF = "kdf";
        public static final String XLS = "xls";
        public static final String XML = "xml";
        protected KDFileChooser _fileChooser;

        BasicIOAction() {
        }

        protected String addExtension(String fileName, String extension) {
            if (fileName.endsWith(extension)) {
                return fileName;
            }
            return fileName + "." + extension;
        }

        protected KDFileChooser getFileChooser() {
            if (this._fileChooser == null) {
                this._fileChooser = this.createFileChooser();
            }
            return this._fileChooser;
        }

        protected KDFileChooser createFileChooser() {
            KDFileChooser fc = new KDFileChooser();
            fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter(XLS, ResourceHelper.getMenuResource("MenuManager.136")));
            fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter(XML, ResourceHelper.getMenuResource("MenuManager.140")));
            return fc;
        }
    }

    class DynaRangeAction
    extends AbstractAction {
        DynaRangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object info;
            DynaRangeProvider range = new DynaRangeProvider();
            int sourceType = -1;
            if (ReportActionManager.this.designer.getDataProvider() instanceof CslReportDataProvider) {
                info = ((CslReportDataProvider)ReportActionManager.this.designer.getDataProvider()).getReportVO();
                sourceType = ((ReportVO)info).getSourceType();
            } else {
                info = ((CslTemplateDataProvider)ReportActionManager.this.designer.getDataProvider()).getTemplateVO();
                sourceType = ((TemplateVO)info).getTemplateType();
            }
            Book book = null;
            try {
                book = ReportActionManager.this.getSpread().getBook();
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)ReportActionManager.this.getSpread(), (Throwable)e1);
            }
            try {
                DynaRangeUI instance = DynaRangeUI.getInstance((Component)((Object)ReportActionManager.this.designer), null);
                Map map = range.getRangeProp(sourceType, book, ReportActionManager.this.designer);
                if (map == null || map.size() <= 0) {
                    MsgBox.showError(CslRptClientResourceHelper.getString("134_ReportActionManager"));
                    return;
                }
                instance.onLoad(map);
                if (instance != null) {
                    instance.showWindow();
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle(e1);
            }
        }
    }

    class ImportAction
    extends BasicIOAction {
        ImportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDFileChooser chooser = this.getFileChooser();
            chooser.setDialogTitle(ResourceHelper.getMenuResource("MenuManager.import"));
            int result = chooser.showOpenDialog((Component)ReportActionManager.this.spreadContainer);
            if (result == 0) {
                try {
                    File file = chooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    String ext = FileUtil.getExtension((File)file);
                    String str = ResourceHelper.getMenuResource("MenuManager.nosupported");
                    KDSpread spread = ReportActionManager.this.spreadContainer.getSpread();
                    boolean autoCalculate = spread.getBook().isAutoCalculate();
                    if ("xls".equalsIgnoreCase(ext)) {
                        KDSBook kdsbook = POIXlsReader.parse((String)fileName);
                        if (kdsbook != null) {
                            Book book = KDSBookToBook.traslate((KDSBook)kdsbook);
                            ReportActionManager.this.spreadContainer.setBook(book);
                        } else {
                            WindowUtil.msgboxInfo((Object)str, (String)str, (Component)spread);
                        }
                    } else {
                        ReportActionManager.this.spreadContainer.setBook(IOHelper.loadFile((String)fileName));
                    }
                    spread.getBook().setCalculate(autoCalculate);
                    ReportActionManager.this.designer.initVarialbes();
                    ReportActionManager.this.designer.initCalculateContext();
                }
                catch (Exception e2) {
                    ExceptionHandler.handle(e2);
                }
            }
        }
    }

    class ExportAction
    extends BasicIOAction {
        ExportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDSpread spread = ReportActionManager.this.spreadContainer.getSpread();
            KDFileChooser chooser = this.getFileChooser();
            chooser.setDialogTitle(ResourceHelper.getMenuResource("MenuManager.savefile"));
            int result = chooser.showSaveDialog((Component)spread);
            if (result == 0) {
                try {
                    FileFilter filter = chooser.getFileFilter();
                    File file = chooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    if (filter instanceof SimpleFileFilter) {
                        SimpleFileFilter sff = (SimpleFileFilter)filter;
                        if (sff.acceptExtension("xml")) {
                            fileName = this.addExtension(fileName, "xml");
                            IOHelper.saveToFile((Book)spread.getBook(), (String)fileName);
                        } else if (sff.acceptExtension("xls")) {
                            fileName = this.addExtension(fileName, "xls");
                            KDSBook kdsbook = BookToKDSBook.traslate((Book)spread.getBook());
                            ExportManager em = new ExportManager();
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                            em.exportToExcel(kdsbook, fileName);
                        }
                    } else {
                        IOHelper.saveToFile((Book)spread.getBook(), (String)fileName);
                    }
                }
                catch (Exception e2) {
                    ExceptionHandler.handle(e2);
                }
            }
        }
    }

    private class BookProtectionAction
    extends AbstractAction {
        BookProtectionAction() {
            this.init();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookProtection protection = ReportActionManager.this.spreadContainer.getSpread().getBook().getProtection();
            if (protection != null && protection.isProtected()) {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("UnProtectBook").actionPerformed(e);
            } else {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("Show_ProtectBook_Wizzard").actionPerformed(e);
            }
            this.init();
        }

        private void init() {
            BookProtection protection = ReportActionManager.this.spreadContainer.getSpread().getBook().getProtection();
            if (protection.isProtected()) {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectBook"));
            } else {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectBook"));
            }
        }
    }

    private class SheetProtectionAction
    extends AbstractAction {
        SheetProtectionAction() {
            this.init();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Protection protection = ReportActionManager.this.spreadContainer.getBook().getActiveSheet().getSheetOption().getProtection(false);
            if (protection != null && protection.isProtected()) {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("UnProtectSheet").actionPerformed(e);
            } else {
                ReportActionManager.this.spreadContainer.getActionManager().getAction("Show_ProtectSheet_Wizzard").actionPerformed(e);
            }
            this.init();
        }

        private void init() {
            Protection protection = ReportActionManager.this.spreadContainer.getBook().getActiveSheet().getSheetOption().getProtection(false);
            if (protection != null && protection.isProtected()) {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectSheet"));
            } else {
                this.putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectSheet"));
            }
        }
    }
}

