/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.DefaultBookChangeListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.DefaultItemRenderProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.rptclient.newrpt.client.designer.MenuManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportActionManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportHeaderFooterSetupUI;
import com.kingdee.eas.rptclient.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class ReportDesigner
extends KDFrame {
    private static final long serialVersionUID = -5923251652372822217L;
    private SpreadManager _manager;
    private IDataProvider dataProvider = null;
    private MenuManager _menuManager = null;
    private ReportActionManager _actionManager = null;
    private IMenuStrategy menuStrategy = null;
    private String operState;
    private BookProperties bookProperties = null;
    private IReportVariableProvider variableProvider = null;

    public ReportDesigner() {
        Variant.nullVariant.setObject(null);
    }

    public static void main(String[] args) throws Exception {
        Locale.setDefault(new Locale("l2"));
        CtrlUIEnv.setKingdeeLAF();
        ReportDesigner main = new ReportDesigner();
        main.initApplication();
        main.setExtendedState(6);
        main.setDefaultCloseOperation(3);
        main.setVisible(true);
        main.requestFocus();
    }

    public void initApplication() throws Exception {
        Variant.nullVariant.setObject(null);
        this.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.height -= 70;
        this.setSize(screenSize);
        this._manager = new SpreadManager();
        this._actionManager = new ReportActionManager(this._manager.getSpreadContainer());
        this._actionManager.setDesigner(this);
        this._manager.registerDefaultFormulaWizard();
        this._manager.registerDefaultItemFormulaWizard();
        this._manager.registerCellDisplayProvider(new UserCellDisplayProvider());
        this.getSpreadManager().getSpreadContainer().getUserObjectRegister().setUserObjectsProvider(this.getUserObjectTrans());
        KDToolBar commonToolbar = this._manager.getSpreadContainer().getToolBarManager().getToolBar("common");
        AbstractAction exitAction = this._actionManager.getAction("Exit");
        JButton exitButton = commonToolbar.add((Action)exitAction);
        exitButton.setToolTipText(ResourceHelper.getActionMessageResource("ReportActionManager.exitToolTip"));
        KDToolBar toolBar = this._manager.getSpreadContainer().getToolBarManager().getToolBar("style");
        commonToolbar.setIsControlByParent(false);
        toolBar.setIsControlByParent(false);
        commonToolbar.setTextIconDisStyle((short)2);
        toolBar.setTextIconDisStyle((short)2);
        this.addToolBar((JToolBar)commonToolbar, "common");
        this.addToolBar((JToolBar)toolBar, "style");
        commonToolbar.setPopupMenuShowable(true);
        toolBar.setPopupMenuShowable(true);
        this.getContentPane().add((Component)this._manager.getSpreadContainer());
        this.initPrintSetting();
        this.initSpread();
        this.getSpread().getBook().setCalculate(false);
        if (this.menuStrategy != null) {
            this.menuStrategy.applyMenuState(this.getOperState());
        }
        this.initCalculateResource();
        this._manager.registerFunctionImpl();
        this._manager.getSpreadContainer().addBookChangeListener((BookChangeListener)new DefaultBookChangeListener(this._manager.getSpreadContainer(), this.variableProvider));
        this._manager.getSpreadContainer().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    ReportDesigner.this.onSheetActived();
                }
            }
        });
        this.getSpreadManager().getSpreadContainer().addSheetPropertyChangeListener(new SheetPropertyChangeListener(){

            public void changed(SheetPropertyChangeEvent e) {
                if ("Changed_SheetName".equals(e.getType())) {
                    ReportDesigner.this.onRenameSheet(e.getSheet(), (String)e.getOldValue(), (String)e.getNewValue());
                }
            }
        });
        this._menuManager = new MenuManager(this._manager.getSpreadContainer(), this._actionManager);
        this.setJMenuBar((JMenuBar)this._menuManager.createMenuBar());
        ((KDCheckBoxMenuItem)this._menuManager.findMenuUsingPath("calculate/SetManualCalc")).setSelected(true);
        ((KDCheckBoxMenuItem)this._menuManager.findMenuUsingPath("view/ShowValue")).setSelected(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ReportDesigner.this.destory();
            }
        });
        Variant.nullVariant.setObject(null);
    }

    protected void destory() {
        if (this.checkBeforeWindowClosing()) {
            this.dispose();
        }
    }

    protected boolean checkBeforeWindowClosing() {
        if (OprtState.VIEW.equals(this.getOperState())) {
            return true;
        }
        this.getSpreadManager().getSpreadContainer().getStateManager().stopEditing();
        boolean bclose = true;
        if (this.getSpread().getBook().getUndoManager().canUndo()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionFileSave_actionPerform(null);
                    bclose = true;
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
                    SysUtil.abort();
                    bclose = false;
                }
            } else {
                bclose = result == 1;
            }
        }
        return bclose;
    }

    protected void actionFileSave_actionPerform(ActionEvent e) {
        Variant.nullVariant.setObject(null);
        this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
        this.getSpreadManager().getSpreadContainer().getBook().getUndoManager().discardAllEdits();
        this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getSpread().getBook().getActiveSheet(), "Sheet_Hide"));
    }

    protected Book.IUserObjectProvider getUserObjectTrans() {
        return new UserObjectTrans(true);
    }

    protected void onRenameSheet(Sheet sheet, String oldName, String newName) {
        this.getBookProperties().notifyRenameSheet(oldName, newName);
    }

    private void initPrintSetting() {
        this.getSpreadManager().getSpreadContainer().getPrintManager().getPrinter().setVariantParser(new IVariantParser(){

            public String parse(String varName, PainterInfo info) {
                if (varName == null) {
                    return null;
                }
                if ((varName = varName.trim()).length() <= 1) {
                    return varName;
                }
                if (varName.charAt(0) != '=') {
                    return varName;
                }
                Variant calcFormula = ReportDesigner.this.getSpread().getBook().getActiveSheet().calcFormula(varName);
                return calcFormula.toString();
            }
        });
        this.getSpreadManager().getSpreadContainer().getPrintManager().setHeadFootUI(ReportHeaderFooterSetupUI.class);
    }

    protected void onSheetActived() {
        Protection protection = this.getSpread().getBook().getActiveSheet().getSheetOption().getProtection(false);
        if (protection != null && protection.isProtected()) {
            this.getActionManager().getAction("Sheet_Protection").putValue("Name", ResourceHelper.getMenuResource("MenuManager.UnProtectSheet"));
        } else {
            this.getActionManager().getAction("Sheet_Protection").putValue("Name", ResourceHelper.getMenuResource("MenuManager.ProtectSheet"));
        }
    }

    protected void initCalculateResource() throws SQLException, BOSException, EASBizException {
        CalculateContext.getInstance().initSDSNMapping(DbUtil.getConnection());
        CalculateContext.getInstance().setDefaultSDSN(UIConfig.getK3Url());
        this.initCalculateContext();
    }

    protected void initCalculateContext() {
        ReportCalculateErrorProvider ee = this.bookProperties.getErrorProvider();
        this.bookProperties.restoreToSpread(this.getSpread().getBook());
        CalculateContext.getInstance().setErrorProvider((IErrorProvider)ee);
        this.getSpread().getBook().setUserObject("CTX", (Object)this.dataProvider);
    }

    protected void initSpread() throws Exception {
        Book book;
        if (this.dataProvider != null && (book = this.dataProvider.loadBook()) != null) {
            this._manager.getSpreadContainer().setBook(book);
        }
        this.initVarialbes();
    }

    protected void initVarialbes() {
        this.bookProperties = BookProperties.loadFromSpread(this.getSpread().getBook());
        ReportVariables variables = this.bookProperties.getVariables();
        if (this.variableProvider != null && "ADDNEW".equalsIgnoreCase(this.getOperState())) {
            this.variableProvider.initReportDefaultVariable(variables);
        }
        if (this.variableProvider != null) {
            Book book = this.getSpread().getBook();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                this.variableProvider.initSheetDefaultVariable(sheet.getSheetName(), variables);
            }
        }
    }

    public KDSpread getSpread() {
        return this._manager.getSpread();
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    protected PopMenuManager getPopMenuManager() {
        return this._manager.getSpreadContainer().getPopMenuManager();
    }

    protected MenuManager getMenuManager() {
        return this._menuManager;
    }

    protected void setMenuManager(MenuManager manager) {
        this._menuManager = manager;
    }

    protected ReportActionManager getActionManager() {
        return this._actionManager;
    }

    protected void setActionManager(ReportActionManager manager) {
        this._actionManager = manager;
    }

    protected IMenuStrategy getMenuStrategy() {
        return this.menuStrategy;
    }

    protected void setMenuStrategy(IMenuStrategy menuStrategy) {
        this.menuStrategy = menuStrategy;
    }

    public String getOperState() {
        return this.operState;
    }

    public void setOperState(String operState) {
        this.operState = operState;
    }

    public IReportVariableProvider getVarialbeProvider() {
        return this.variableProvider;
    }

    public void setVarialbeProvider(IReportVariableProvider varialbeProvider) {
        this.variableProvider = varialbeProvider;
    }

    public SpreadManager getSpreadManager() {
        return this._manager;
    }

    public BookProperties getBookProperties() {
        return this.bookProperties;
    }

    public void setBookProperties(BookProperties bookProperties) {
        this.bookProperties = bookProperties;
    }

    protected void reloadProperties() {
        this.bookProperties = BookProperties.loadFromSpread(this.getSpread().getBook());
    }

    static {
        UserCellDisplayProvider.addRenderProvider(new DefaultItemRenderProvider());
    }
}

