/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.rptclient.newrpt.client.designer.ISheetManagerListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.SheetManagerUI;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.util.Uuid;
import java.util.Iterator;
import java.util.List;

public class ReportSheetManagerListener
implements ISheetManagerListener {
    private KDSpread spread;
    private BookProperties properties;

    public ReportSheetManagerListener(KDSpread spread) {
        this.spread = spread;
        this.properties = BookProperties.loadFromSpread(spread.getBook());
    }

    @Override
    public void applySheets(List sheets) {
        String tuo = Uuid.create().toString();
        this.spread.getBook().insertSheet(0, new Sheet(this.spread.getBook(), tuo));
        try {
            this.doRemove(sheets);
            this.preProcessSheetReName(sheets);
            this.doInsert(sheets);
            this.doEdit(sheets);
        }
        finally {
            this.spread.getBook().removeSheet(tuo);
        }
        this.doSheetSort(sheets);
        this.spread.repaint();
    }

    private void preProcessSheetReName(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            if (e.inserted() || !e.edited()) continue;
            e.setEdit();
            String old = e.getOriginalSheetName();
            String nwe = e.getSheetName();
            if (!old.equals(nwe)) {
                if (this.spread.getBook().getSheet(nwe) != null) {
                    return;
                }
                this.spread.getBook().getSheet(old).setName(nwe);
                e.setOriginalSheetName(nwe);
            }
            e.setDummy(false);
            e.setUnEdit();
        }
    }

    private void doSheetSort(List sheets) {
        Book book = this.spread.getBook();
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            e.setNone();
            if (e.getSheetName().equalsIgnoreCase(book.getSheet(i).getSheetName())) continue;
            int target = book.getSheet(e.getSheetName()).getIntMark();
            book.exchangeSheetIndex(i, target);
        }
    }

    private void doInsert(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            if (e.isDummy() || !e.inserted()) continue;
            this.spread.getBook().addSheet(new Sheet(this.spread.getBook(), e.getSheetName()));
        }
    }

    private void doEdit(List sheets) {
        for (int i = 0; i < sheets.size(); ++i) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)sheets.get(i);
            if (e.isDummy() || e.deleted()) continue;
            if (!e.inserted() && e.edited()) {
                String old = e.getOriginalSheetName();
                String nwe = e.getSheetName();
                this.spread.getBook().getSheet(old).setName(nwe);
                e.setOriginalSheetName(nwe);
                this.properties.notifyRenameSheet(old, nwe);
            }
            if (e.isHidden()) {
                this.spread.getBook().hideSheet(e.getSheetName());
                continue;
            }
            this.spread.getBook().unhideSheet(e.getSheetName());
        }
    }

    private void doRemove(List sheets) {
        Iterator iter = sheets.iterator();
        while (iter.hasNext()) {
            SheetManagerUI.SheetPropertyEntry e = (SheetManagerUI.SheetPropertyEntry)iter.next();
            if (e.isDummy() || !e.deleted()) continue;
            if (!e.inserted()) {
                this.spread.getBook().removeSheet(e.getSheetName());
                this.properties.notifyDeleteSheet(e.getSheetName());
            }
            iter.remove();
        }
    }

    @Override
    public void applyVariables(ReportVariables variables) {
        variables.storeToBook(this.spread.getBook());
    }
}

