/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.designer.comment.CommentUtil;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.base.ModelDialogFactory;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.AbstractRptCommentEditUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class RptCommentEditUI
extends AbstractRptCommentEditUI {
    private SpreadContext context = null;
    private int mode;
    private boolean isCancel;
    private ArrayList listeners;
    private RptCommentTank comments;

    public static RptCommentEditUI getInstance(Component owner, SpreadContext context) {
        try {
            ModelDialogFactory factory = new ModelDialogFactory();
            AbstractPanel panel = factory.create(owner, RptCommentEditUI.class.getName(), (Map)new UIContext((Object)owner));
            RptCommentEditUI ui = (RptCommentEditUI)panel;
            ui.context = context;
            ui.loadComments(new RptCommentTank());
            ui.addSimpleDialogListener((ISimpleDialogListener)new EditorListener());
            ui.setEditMode(true);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    @Override
    public void commit() {
        if (this.isCancel) {
            this.context.getStateManager().stop();
            Sheet sheet = this.context.getBook().getActiveSheet();
            RptCommentTank nc = this.getComments();
            if (nc == null || nc.getSize() < 1) {
                nc = null;
            }
            if (this.mode == 2) {
                this.context.getBook().setComment((Comment)nc);
            } else if (this.mode == 1) {
                sheet.setComment((Comment)nc);
            } else {
                this.context.getRangeManager().getActiveCellRange().setComment((Comment)nc);
            }
        }
    }

    public void show() {
        this.showWindow();
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public void open(Object cookie, String title) {
        this.open(cookie, title, true);
    }

    public void open(Object cookie, String title, boolean isEditable) {
        this.setEditMode(isEditable);
        this.fireListenersSetout();
        if (!this.loadComments((RptCommentTank)cookie)) {
            this.fireListenersReturnee(null, false);
        }
        this.setUITitle(title);
        this.showWindow();
    }

    private void fireListenersSetout() {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotSetout((ISimpleDialog)this);
        }
    }

    protected void fireListenersReturnee(RptCommentTank cmtTank, boolean isOk) {
        for (ISimpleDialogListener l : this.listeners) {
            if (l == null) continue;
            l.pilotReturnee((ISimpleDialog)this, (Object)cmtTank, isOk);
        }
    }

    @Override
    public boolean prepare() {
        RptCommentTank comment;
        this.context.getStateManager().stop();
        if (this.mode == 2) {
            Comment cm = this.context.getBook().getComment();
            if (cm != null && !(cm instanceof Comment)) {
                if (cm != null) {
                    cm = cm.getCopy();
                }
                comment = CommentUtil.convertComment((Comment)cm, null);
            } else {
                comment = (RptCommentTank)cm;
            }
        } else if (this.mode == 1) {
            Comment cm = this.context.getBook().getActiveSheet().getComment();
            if (cm != null && !(cm instanceof Comment)) {
                cm = cm.getCopy();
                comment = CommentUtil.convertComment((Comment)cm, null);
            } else {
                comment = (RptCommentTank)cm;
            }
        } else {
            Comment cm = this.context.getRangeManager().getActiveCellRange().getComment();
            if (cm != null) {
                cm = cm.getCopy();
            }
            comment = CommentUtil.convertComment((Comment)cm, null);
        }
        if (comment == null) {
            comment = new RptCommentTank();
        }
        this.setComments(comment);
        this.getComments().setTable(this.tblMain);
        this.getComments().refresh();
        return true;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    protected boolean loadComments(RptCommentTank cmtTank) {
        RptComment cmt;
        this.comments = new RptCommentTank();
        if (this.comments == null || !this.comments.copyFrom(cmtTank)) {
            return false;
        }
        this.comments.setTable(this.tblMain);
        if (this.txtComment.isEditable() && (cmt = this.comments.getFreshEntry()) == null) {
            cmt = this.createComment();
            this.comments.addEntry(cmt);
        }
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock bk = e.getPrevSelectBlock();
                if (bk != null && bk.getMode() == 2 && bk.getBeginRow() >= 0) {
                    RptCommentEditUI.this.comments.setContent(bk.getBeginRow(), RptCommentEditUI.this.txtComment.getText());
                }
                if ((bk = e.getSelectBlock()) == null || bk.getMode() != 2 || bk.getBeginRow() < 0) {
                    return;
                }
                RptCommentEditUI.this.txtComment.setText(RptCommentEditUI.this.comments.getContent(bk.getBeginRow()));
                RptCommentEditUI.this.setEditStatus(bk.getBeginRow());
            }
        });
        this.cbxSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptCommentEditUI.this.comments.sort(RptCommentEditUI.this.cbxSort.getSelectedIndex());
                    RptCommentEditUI.this.tblMain.getSelectManager().select(RptCommentEditUI.this.comments.indexOf(RptCommentEditUI.this.comments.getFreshEntry()), 1, 2);
                }
            }
        });
        this.comments.refresh();
        int sz = this.comments.getSize();
        if (sz > 0) {
            this.tblMain.getSelectManager().removeAll(true);
            this.tblMain.getSelectManager().select(sz - 1, sz - 1);
        } else {
            this.txtComment.setEditable(false);
        }
        return true;
    }

    private RptComment createComment() {
        return this.fireListenersNeedFreahComment();
    }

    private RptComment fireListenersNeedFreahComment() {
        IControlledDialogListener l;
        RptComment res = null;
        Iterator ls = this.listeners.iterator();
        while (ls.hasNext() && ((l = (IControlledDialogListener)ls.next()) == null || (res = (RptComment)l.getTrueController()) == null)) {
        }
        return res;
    }

    private void setEditStatus(int index) {
        String cu = UIConfig.getLoginUser();
        RptComment cmt = (RptComment)this.comments.getElementAt(index);
        String cid = cu;
        boolean enable = this.txtComment.isEditable() && cu != null && cmt != null && cu.equals(cid);
        this.txtComment.setEditable(enable);
        this.btnDelete.setEnabled(enable);
    }

    public void setEditMode(boolean isEditable) {
        this.btnAdd.setEnabled(isEditable);
        this.btnDelete.setEnabled(isEditable);
        this.txtComment.setEditable(isEditable);
        this.btnOk.setVisible(isEditable);
    }

    @Override
    public void addSimpleDialogListener(ISimpleDialogListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }
    }

    private void endEditor(boolean isOk) {
        this.comments.setContent(this.tblMain.getSelectManager().getActiveRowIndex(), this.txtComment.getText());
        this.disposeUIWindow();
        this.fireListenersReturnee(this.comments, isOk);
    }

    public RptCommentTank getComments() {
        return this.comments;
    }

    public void setComments(RptCommentTank comments) {
        this.comments = comments;
    }

    @Override
    protected void actionBtnCancel_actionPerformed(ActionEvent e) {
        super.actionBtnOK_actionPerformed(e);
        this.isCancel = true;
        this.endEditor(false);
    }

    @Override
    protected void actionBtnOK_actionPerformed(ActionEvent e) {
        super.actionBtnCancel_actionPerformed(e);
        this.endEditor(true);
        this.isCancel = false;
    }

    @Override
    protected void actionBtnDelete_actionPerformed(ActionEvent e) {
        super.actionBtnDelete_actionPerformed(e);
        if (this.comments.deletEntry(this.tblMain.getSelectManager().getActiveRowIndex())) {
            this.txtComment.setText("");
            this.tblMain.getSelectManager().select(0, 1, 2);
            if (this.tblMain.getExpandedRowCount() > 0) {
                this.txtComment.setText(this.comments.getContent(0));
                this.setEditStatus(0);
            }
        }
    }

    @Override
    protected void actionBtnAdd_actionPerformed(ActionEvent e) {
        super.actionBtnAdd_actionPerformed(e);
        RptComment cmt = this.comments.getFreshEntry();
        if (cmt == null) {
            cmt = this.createComment();
            this.comments.addEntry(cmt);
        } else {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"OneUserOneReportCanAddOnlyOnePostil"));
        }
        this.tblMain.getSelectManager().select(this.comments.indexOf(cmt), 1, 2);
        RptHelper.setFocusTo((Component)this.txtComment);
    }

    private static class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        public Object getTrueController() {
            return new RptComment();
        }

        public void pilotSetout(ISimpleDialog source) {
        }

        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                // empty if block
            }
        }
    }
}

