/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.client.designer;

import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.FunctionRegister;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectReplacer;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.ItemFormulaChangeEvent;
import com.kingdee.eas.rptclient.newrpt.client.designer.ItemFormulaChangeListener;
import com.kingdee.eas.rptclient.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.rptclient.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizard;
import com.kingdee.eas.rptclient.newrpt.functionimpl.FunctionProviderImpl;
import com.kingdee.eas.rptclient.newrpt.functionimpl.ICalculateContext;
import com.kingdee.eas.rptclient.newrpt.util.SpreadHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;

public class SpreadManager {
    private SpreadContext _spreadContainer;
    private ItemFormulaPanel itemFormulaPanel;

    SpreadManager() {
    }

    public void registerUserObjeFinder(Object serModes, ICellUserObjectMatcher finder, ICellUserObjectReplacer replacer) {
        this._spreadContainer.getUserObjectRegister().addUserObjectFinder(serModes, finder, replacer);
    }

    public void registerCustomFormulaWizzard(ISpreadWizzard wizzard) {
        this._spreadContainer.getFacadeManager().putWizzard(FacadeManager.WIZZARD_Formula, wizzard);
    }

    public void registerCellDisplayProvider(ICellDisplayProvider provider) {
        this._spreadContainer.getRenderManager().setUserCellDisplayProvider(provider);
    }

    public void setRightCompOnEditPanel(JComponent rightComp, boolean adjustable) {
        this._spreadContainer.getFacadeManager().getPromptPanel().setRightComponent(rightComp);
        this._spreadContainer.getFacadeManager().getPromptPanel().setAdjustable(adjustable);
        this._spreadContainer.getFacadeManager().getPromptPanel().setDependSecondSize(true);
    }

    public void setRightCompOnEditPanel(JComponent rightComp) {
        this.setRightCompOnEditPanel(rightComp, true);
    }

    public void setRightCompOnEditPanelWidth(int width) {
        this._spreadContainer.getFacadeManager().getPromptPanel().getRightComponent().setPreferredSize(new Dimension(width, 10));
        this._spreadContainer.getFacadeManager().getPromptPanel().getRightComponent().invalidate();
        this._spreadContainer.getFacadeManager().getPromptPanel().validate();
        this._spreadContainer.getFacadeManager().getPromptPanel().repaint();
    }

    public KDToolBar getToolBar(String toolBarName) {
        return this._spreadContainer.getToolBarManager().getToolBar(toolBarName);
    }

    public static void registerRenderProvider(IRenderProvider p) {
        UserCellDisplayProvider.addRenderProvider(p);
    }

    SpreadContext getSpreadContainer() {
        if (this._spreadContainer == null) {
            this._spreadContainer = new SpreadContext();
            this.initSpreadManager();
        }
        return this._spreadContainer;
    }

    public void setUserExtRender(IExtRender render) {
        this.getSpreadContainer().getRenderManager().setUserExtRender(render);
    }

    void initSpreadManager() {
    }

    public KDSpread getSpread() {
        return this.getSpreadContainer().getSpread();
    }

    public List getAllSheetsName() {
        return SpreadHelper.getAllSheetsName(this.getSpread());
    }

    public void registerDefaultFormulaWizard() throws Exception {
        FormulaWizard wizard = new FormulaWizard((Component)this._spreadContainer);
        this.registerCustomFormulaWizzard(wizard);
        wizard.setFormulaPickListener(new FormulaPickListener(){

            @Override
            public String pickFormulaLine() {
                return SpreadManager.this.getSpread().getBook().getActiveCellRange().getFormula();
            }

            @Override
            public void setFormulaLine(String line) {
                SpreadManager.this.getSpread().getBook().getActiveCellRange().setFormula('=' + line);
            }
        });
    }

    public void registerDefaultItemFormulaWizard() throws Exception {
        this._spreadContainer.addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (SpreadManager.this.getSpreadContainer().getBook().getActiveSheet() != e.getSheet()) {
                    return;
                }
                SpreadManager.this.itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCell(), e.getSheet().getSheetOption().getCellDisplayMode());
            }
        });
        this.itemFormulaPanel = new ItemFormulaPanel();
        this.itemFormulaPanel.setStateChangeListener(new ItemFormulaPanel.ItemPanelStateChangeListener(){

            @Override
            public void changeWidth(int newWidth) {
                SpreadManager.this.setRightCompOnEditPanelWidth(newWidth);
            }
        });
        this.setRightCompOnEditPanel((JComponent)((Object)this.itemFormulaPanel));
        this.itemFormulaPanel.addItemFormulaChangeListener(new ItemFormulaChangeListener(){

            @Override
            public void formulaChanged(ItemFormulaChangeEvent e) {
                Range cell = SpreadManager.this.getSpread().getBook().getActiveCellRange();
                ItemFormula formula = null;
                if (cell != null) {
                    formula = (ItemFormula)cell.getUserObject("ITEM");
                }
                Range range = SpreadManager.this.getSpread().getBook().getActiveCellRange();
                if (e.getNewFormula() == null || e.getNewFormula().trim().length() < 1) {
                    range.setUserObject("ITEM", null);
                    return;
                }
                if (formula == null) {
                    formula = new ItemFormula();
                } else if (!formula.getFormula().equalsIgnoreCase(e.getNewFormula())) {
                    formula = new ItemFormula();
                }
                formula.FormulaToObject(e.getNewFormula());
                range.setUserObject("ITEM", (Object)formula);
            }
        });
        this.itemFormulaPanel.setFormulaProvider(new IItemFormulaProvider(){

            @Override
            public String getDisplayingItemFormula(Cell cell, int viewMode) {
                if (cell == null) {
                    return null;
                }
                ItemFormula v = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (v == null) {
                    return null;
                }
                return v.toString();
            }
        });
    }

    protected void registerFunctionImpl() {
        FunctionRegister functionRegister = this.getSpreadContainer().getFunctionRegister();
        FunctionProviderImpl functionProviderImpl = new FunctionProviderImpl();
        functionProviderImpl.setContext(new ICalculateContext(){

            @Override
            public Book getBook() {
                return SpreadManager.this.getSpread().getBook();
            }
        });
        functionRegister.addFunctionProvider((Object)functionProviderImpl, true);
        BookProperties properties = BookProperties.loadFromSpread(this.getSpread().getBook());
        ReportCalculateErrorProvider errorProvider = properties.getErrorProvider();
        if (errorProvider != null) {
            String as = errorProvider.getZeroDivDisplayAs();
            if (StringUtils.isEmpty((String)as)) {
                as = "#DIV/0!";
                errorProvider.setZeroDivDisplayAs(as);
            }
            functionRegister.addFunctionErrorProvider(Exception.class, (IErrorProvider)errorProvider);
            functionRegister.setErrorResultProvider((IErrorResultProvider)new InnerErrorProvider(errorProvider));
        }
    }

    public void setItemFormulasetEnabled(boolean able) {
        this.itemFormulaPanel.setEnabled(able);
    }

    public void addKDSBookChangeListener(BookChangeListener l) {
        this.getSpreadContainer().addBookChangeListener(l);
    }

    private class InnerErrorProvider
    implements IErrorResultProvider {
        private final ReportCalculateErrorProvider error;

        public InnerErrorProvider(ReportCalculateErrorProvider error) {
            this.error = error;
        }

        public String getText(long errorCode) {
            String as;
            if (errorCode == 2L && !StringUtils.isEmpty((String)(as = this.error.getZeroDivDisplayAs()))) {
                return as;
            }
            return null;
        }
    }
}

