/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.batch;

import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.designer.batch.BizFmlCalculater;
import com.kingdee.eas.rptclient.newrpt.designer.batch.FormulaCalcInstaller;
import java.util.ArrayList;
import java.util.Map;

public class FormulaRepository {
    private FormulaCalcInstaller instialler = FormulaCalcInstaller.getInstance();
    public static DefaultCalculator defaultCalculator = null;

    public Class getFormulaCalculator(String formulaName) {
        return this.getFormulaCalculatorClass(formulaName);
    }

    public Class getFormulaCalculatorClass(String formulaName) {
        String[] str = (String[])this.instialler.install().get(formulaName.toUpperCase());
        if (str == null) {
            System.out.println(CslRptClientResourceHelper.getString("135_FormulaRepository") + formulaName + CslRptClientResourceHelper.getString("136_FormulaRepository"));
            return null;
        }
        try {
            return Class.forName(str[2]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class[] getAllFormulaCalculatorProviders() {
        ArrayList list = new ArrayList();
        for (String[] defs : this.instialler.install().values()) {
            Class<?> cls = null;
            try {
                cls = Class.forName(defs[1]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (cls == null) continue;
            list.add(cls);
        }
        return list.toArray(new Class[list.size()]);
    }

    public static void registerFormulaToBook(FunctionManager manager) throws Exception {
        FormulaRepository rp = new FormulaRepository();
        Class[] providers = rp.getAllFormulaCalculatorProviders();
        for (int i = 0; i < providers.length; ++i) {
            manager.addFunctionProvider(providers[i].newInstance(), true);
        }
    }

    public static BizFmlCalculater getDefaultCalculator(String msg) {
        if (defaultCalculator == null) {
            defaultCalculator = new DefaultCalculator(null);
        }
        defaultCalculator.setError(msg);
        return defaultCalculator;
    }

    public static BizFmlCalculater getDefaultCalculator() {
        return FormulaRepository.getDefaultCalculator(null);
    }

    private static class DefaultCalculator
    extends BizFmlCalculater {
        String message = null;

        public void setError(String msg) {
            this.message = msg;
        }

        public DefaultCalculator(Map context) {
            super(null);
        }

        @Override
        public void batchMethodQuery(String methodName, SortedParameterArray params) {
            String msg = this.message == null ? "#BAD FUNCTION :" + methodName : "#BAD FUNCTION :" + this.message;
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)msg);
            }
        }
    }
}

