/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.BaseCompanyListUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.ICompanyFillListener;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CompanyFillUI
extends BaseCompanyListUI {
    protected ICompanyFillListener fillListener;

    public CompanyFillUI() throws Exception {
        this.initCompany();
    }

    @Override
    public void initCompany() throws BOSException, SQLException, EASBizException {
        this.table.removeRows();
        StringBuffer s = new StringBuffer();
        s.append(" select FID,Fnumber,Fname from T_EAS_Company where fnumber <> ?");
        s.append(" order by fnumber");
        IRowSet rs = DbUtil.executeQuery(s.toString(), new Object[]{UIConfig.getCurCompanyNumber()});
        while (rs.next()) {
            String fId = rs.getString("FID");
            if (fId.length() == 36) continue;
            String fNumber = rs.getString("Fnumber");
            String fName = rs.getString("Fname");
            IRow row = this.table.addRow();
            row.getCell(0).setValue((Object)new Boolean(false));
            row.getCell(1).setValue((Object)fId);
            row.getCell(2).setValue((Object)fNumber);
            row.getCell(3).setValue((Object)fName);
        }
    }

    public static BaseCompanyListUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            CompanyFillUI ui = (CompanyFillUI)fy.create(parent, CompanyFillUI.class.getName(), ctx);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapRange;
        if (this.table == null || this.table.getRowCount() == 0) {
            return;
        }
        ArrayList companys = new ArrayList();
        int size = this.table.getRowCount();
        boolean isCompanySelect = false;
        for (int i = 0; i < size; ++i) {
            Object number;
            isCompanySelect = (Boolean)this.table.getRow(i).getCell(0).getValue();
            if (!isCompanySelect || (number = this.table.getRow(i).getCell(2).getValue()) == null) continue;
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            Object id = this.table.getRow(i).getCell(1).getValue();
            map2.put("ID", id);
            map2.put("number", number);
            map2.put("name", this.table.getRow(i).getCell(3).getValue());
            companys.add(map2);
        }
        if (this.fillListener != null && !companys.isEmpty() && this.fillListener.fillCompany(companys, mapRange = new HashMap())) {
            this.fillListener.replaceCompanyNumber(mapRange);
            this.fillListener.clearNullLine();
        }
        this.disposeUIWindow();
    }

    public ICompanyFillListener getFillListener() {
        return this.fillListener;
    }

    public void setFillListener(ICompanyFillListener fillListener) {
        this.fillListener = fillListener;
    }
}

