/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.AbstractFormulaPickerUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaFilter;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptContextManager;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormula;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaCategory;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaComp;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptOperObject;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormulaPickerUI
extends AbstractFormulaPickerUI
implements ISpreadWizzard {
    private static final long serialVersionUID = 5453649731201093719L;
    private boolean isAdvMode;
    private boolean canBeAdvance;
    private HashSet listeners;
    private String formulaLine;
    private Point basePos;
    private Point wizardPos;
    protected RptContextManager context;
    private FormulaFilter fmFilter = null;
    private boolean showAdvance;
    private Dimension normalSize = null;
    private Dimension advanceSize = null;

    public static FormulaPickerUI creatFormulaPicker(Component parent) {
        try {
            FormulaPickerUI ui = (FormulaPickerUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create(parent, FormulaPickerUI.class.getName(), null);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public FormulaPickerUI() {
        this.btnPlus.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivision.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_dividesign"));
        this.btnBracket.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_unequaltosign"));
        this.btnInsert.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_showformula"));
        this.btnClear.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_delete"));
        this.btnSearch.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_find"));
    }

    public void open(String filter, boolean showAdvance) {
        this.fireListenersSetout();
        this.isAdvMode = false;
        try {
            this.LoadFormulaComp(filter);
            Window w = this.getOwnerWindow();
            if (w instanceof KDDialog) {
                KDDialog d = (KDDialog)w;
                d.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FormulaPickerUI.this.endPicker(false);
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                        if (FormulaPickerUI.this.showAdvance) {
                            FormulaPickerUI.this.setAdvance();
                        }
                    }
                });
                this.showAdvance = showAdvance;
            }
            this.showFormulas("all formulas");
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog((Component)((Object)this), CslRptClientResourceHelper.getString("156_FormulaPickerUI"));
            e1.printStackTrace();
        }
        this.showAdvance = showAdvance;
        this.showAdvance();
        this.showWindow();
    }

    public void open(String filter) {
        this.open(filter, false);
    }

    public void open() {
        this.open(null);
    }

    public synchronized void addFormulaPickerListener(FormulaPickListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersReturnee(boolean isOk) {
        if (!isOk) {
            return;
        }
        for (FormulaPickListener l : this.listeners) {
            if (l == null) continue;
            l.setFormulaLine(this.formulaLine);
        }
        this.disposeUIWindow();
    }

    private void fireListenersSetout() {
    }

    public void setExtendable(boolean canExtend) {
        this.canBeAdvance = canExtend;
        this.btnAdvance.setEnabled(this.canBeAdvance);
    }

    public boolean isAdvMode() {
        return this.isAdvMode;
    }

    public void setLocation(Point p) {
        if (p != null) {
            this.basePos.x = p.x;
            this.basePos.y = p.y;
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnPlus.setText(null);
        this.btnMinus.setText(null);
        this.btnMultiply.setText(null);
        this.btnDivision.setText(null);
        this.btnBracket.setText(null);
        this.btnInsert.setText(null);
        this.btnClear.setText(null);
        this.btnSearch.setText(null);
        this.isAdvMode = false;
        this.canBeAdvance = true;
        this.listeners = new HashSet(1, 0.75f);
        this.basePos = new Point(100, 100);
        this.wizardPos = new Point(100, 100);
        this.txtSearch.setEnabledPopup(false);
        this.lstFormula.setFixedCellHeight(18);
        this.lstFormula.setModel(new DefaultListModel());
        this.lstFormula.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FormulaPickerUI.this.lstFormula.ensureIndexIsVisible(FormulaPickerUI.this.lstFormula.getSelectedIndex());
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int cnt = FormulaPickerUI.this.lstFormula.getElementCount();
                RptOperObject fm = cnt < 1 || FormulaPickerUI.this.lstFormula.getSelectedIndex() >= cnt ? null : (RptFormula)FormulaPickerUI.this.lstFormula.getSelectedValue();
                FormulaPickerUI.this.txtDescription.setText(fm == null ? null : fm.getDescription());
            }
        });
        this.lstFormula.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        FormulaPickerUI.this.callWizard();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.cbxGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptFormulaCategory cat = (RptFormulaCategory)e.getItem();
                    RptFormulaComp.getInstance().setCurCategory(cat);
                    FormulaPickerUI.this.showFormulas(cat.getName());
                }
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FormulaPickerUI.this.callWizard();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        SearchAction sa = new SearchAction();
        this.txtSearch.addActionListener((ActionListener)sa);
        this.btnSearch.addActionListener((ActionListener)sa);
        this.getOwnerWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FormulaPickerUI.this.endPicker(false);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (FormulaPickerUI.this.isAdvMode) {
                    // empty if block
                }
            }
        });
    }

    protected void searchFormula() {
        String text = this.txtSearch.getText();
        if (text != null && text.length() > 0) {
            text = text.trim().toLowerCase();
            DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
            int curPos = this.lstFormula.getSelectedIndex();
            boolean isFound = false;
            int size = listModel.size();
            for (int i = 0; i < size; ++i) {
                String item = listModel.elementAt(curPos = this.getNextPos(curPos, 0, size - 1)).toString().toLowerCase();
                if (item.indexOf(text) == -1) continue;
                isFound = true;
                break;
            }
            if (isFound) {
                this.lstFormula.setSelectedIndex(curPos);
                this.lstFormula.ensureIndexIsVisible(curPos);
                this.lstFormula.requestFocus();
                return;
            }
        }
        this.txtSearch.requestFocus();
    }

    private int getNextPos(int curPos, int minPos, int maxPos) {
        if (curPos < minPos || curPos >= maxPos) {
            curPos = minPos - 1;
        }
        return curPos + 1;
    }

    public void LoadFormulaComp(String filter) throws Exception {
        ItemListener[] its;
        RptFormulaComp comp;
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        if (filter != null) {
            this.fmFilter.setFilter(filter);
        }
        if (!(comp = RptFormulaComp.getInstance()).isLoaded()) {
            comp.load();
        }
        if ((its = this.cbxGroup.getItemListeners()) != null && its.length > 0) {
            this.cbxGroup.removeItemListener(its[0]);
        }
        Iterator cs = comp.getFormulaCategory().iterator();
        this.cbxGroup.setModel(new DefaultComboBoxModel());
        while (cs.hasNext()) {
            RptFormulaCategory ct = (RptFormulaCategory)cs.next();
            if (this.fmFilter.filtrateCate(ct.getName())) continue;
            this.cbxGroup.addItem((Object)ct);
        }
        RptFormulaCategory cn = comp.getCurCategory();
        if (cn != null) {
            this.cbxGroup.removeItem((Object)cn);
            this.cbxGroup.insertItemAt((Object)cn, 0);
        }
        if (this.cbxGroup.getItemCount() > 0) {
            this.cbxGroup.setSelectedIndex(0);
        }
        if (its != null && its.length > 0) {
            this.cbxGroup.addItemListener(its[0]);
        }
        this.showFormulas(cn == null ? null : cn.getName());
    }

    public void setFilter(String filter) {
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        this.fmFilter.setFilter(filter);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void initSize() {
        Window w;
        if (this.normalSize == null && (w = this.getOwnerWindow()) != null && w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            this.normalSize = d.getSize();
            this.advanceSize = new Dimension();
            this.advanceSize.width = this.normalSize.width + this.pnlAdvance.getSize().width;
            this.advanceSize.height = this.normalSize.height;
        }
    }

    public void setAdvance() {
        this.initSize();
        Window w = this.getOwnerWindow();
        if (w != null && w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            this.isAdvMode = true;
            d.setSize(this.advanceSize);
            this.btnOk.setText(this.resHelper.getString("btnFinish.text"));
            this.txtExpression.setSelectAllOnFocus(false);
            this.txtExpression.requestFocus();
            if (this.formulaLine != null && this.formulaLine.length() > 1 && this.formulaLine.charAt(0) == '=') {
                this.txtExpression.setText(this.formulaLine.substring(1));
            }
        }
    }

    @Override
    protected void btnAdvance_actionPerformed(ActionEvent e) throws Exception {
        Dimension AdvSize = this.getOwnerWindow().getSize();
        if (this.isAdvMode) {
            AdvSize.width -= this.pnlAdvance.getSize().width;
            this.btnOk.setText(this.resHelper.getString("btnOk.text"));
        } else {
            AdvSize.width += this.pnlAdvance.getSize().width;
            this.btnOk.setText(this.resHelper.getString("btnFinish.text"));
            this.txtExpression.setSelectAllOnFocus(false);
            this.txtExpression.requestFocus();
            this.setFormulaLine(this.formulaLine);
        }
        this.isAdvMode = !this.isAdvMode;
        this.getOwnerWindow().setSize(AdvSize);
    }

    private void showFormulas(String cateName) {
        if ("all formulas".equalsIgnoreCase(cateName)) {
            cateName = null;
        }
        RptFormulaComp comp = RptFormulaComp.getInstance();
        Iterator fms = comp.getFormulasByCategory(cateName).iterator();
        DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
        listModel.removeAllElements();
        int index = -1;
        int pos = 0;
        while (fms.hasNext()) {
            RptFormula fm = (RptFormula)fms.next();
            if (this.fmFilter.filtrateFormula(fm)) continue;
            if (index == -1 && fm.equals(comp.getCurFormula())) {
                index = pos;
            }
            ++pos;
            listModel.addElement(fm);
        }
        if (index >= 0) {
            this.lstFormula.setSelectedIndex(index);
            this.lstFormula.ensureIndexIsVisible(index);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.endPicker(false);
        this.isAdvMode = false;
        this.btnOk.setText(this.resHelper.getString("btnOk.text"));
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.isAdvMode) {
            this.endPicker(true);
        } else {
            this.callWizard();
        }
    }

    private void endPicker(boolean isOk) {
        if (isOk) {
            if (this.isAdvMode) {
                this.isAdvMode = false;
                this.formulaLine = this.txtExpression.getText().trim();
            }
        } else {
            this.formulaLine = null;
        }
        this.getOwnerWindow().setVisible(false);
        this.fireListenersReturnee(isOk);
    }

    private void callWizard() throws Exception {
        if (this.lstFormula.getModel().getSize() < 1) {
            return;
        }
        RptFormula fm = (RptFormula)this.lstFormula.getSelectedValue();
        if (fm == null) {
            return;
        }
        RptFormulaComp.getInstance().setCurFormula(fm);
        FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard(fm.getWizard(), (Object)this);
        wizard.setFormulaWizardListener(new FormulaPickListener(){

            @Override
            public String pickFormulaLine() {
                return null;
            }

            @Override
            public void setFormulaLine(String line) {
                if (!FormulaPickerUI.this.isAdvMode) {
                    FormulaPickerUI.this.formulaLine = line;
                    FormulaPickerUI.this.fireListenersReturnee(true);
                } else {
                    FormulaPickerUI.this.txtExpression.insert(line, FormulaPickerUI.this.txtExpression.getCaretPosition());
                }
            }
        });
        wizard.open(fm.getName());
    }

    public void wizardSetout(FormulaWizardUI wizard) {
    }

    public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
        if (!this.isAdvMode) {
            this.formulaLine = formulaLine;
            this.endPicker(isOk);
        } else if (isOk) {
            this.txtExpression.insert(formulaLine, this.txtExpression.getCaretPosition());
        }
    }

    private boolean canInsert(char ch, int insertPos) {
        String line = this.txtExpression.getText();
        char preChar = '\u0000';
        if (line == null || line.length() == 0) {
            insertPos = -1;
        } else if (insertPos > 0) {
            preChar = line.charAt(insertPos - 1);
        }
        boolean res = false;
        switch (ch) {
            case '+': {
                res = true;
                break;
            }
            case '-': {
                res = true;
                break;
            }
            case '*': {
                res = insertPos > 0;
                break;
            }
            case '/': {
                res = insertPos > 0;
                break;
            }
            case '(': {
                res = true;
            }
        }
        return res;
    }

    private void insertOperator(char ch) {
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch, pos)) {
            if (ch != '(') {
                this.txtExpression.insert(Character.toString(ch), pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
        }
    }

    @Override
    public void insertOperatorAction_actionPerformed(ActionEvent e) {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivision) {
            ch = 47;
        } else if (src == this.btnBracket) {
            ch = 40;
        }
        this.insertOperator((char)ch);
        this.txtExpression.requestFocus();
    }

    public void setRptContext(RptContextManager rptContext) {
        this.context = rptContext;
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public void showAdvance() {
        if (this.showAdvance) {
            try {
                this.btnAdvance_actionPerformed(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAdvMode(boolean isAdvMode) {
        this.isAdvMode = isAdvMode;
    }

    public String getFormulaLine() {
        return this.formulaLine;
    }

    public void setFormulaLine(String formulaLine) {
        this.formulaLine = formulaLine;
        if (formulaLine != null && formulaLine.length() > 1) {
            if (formulaLine.charAt(0) == '=') {
                this.txtExpression.setText(formulaLine.substring(1));
            } else {
                this.txtExpression.setText(formulaLine);
            }
        } else {
            this.txtExpression.setText(formulaLine);
        }
    }

    public void showWizzard() {
        this.setVisible(true);
    }

    public void commit() {
    }

    public boolean isModal() {
        return true;
    }

    public boolean prepare() {
        return true;
    }

    private class SearchAction
    implements ActionListener {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaPickerUI.this.searchFormula();
        }
    }
}

