/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IRptDataPublisher;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaDataType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaEnumType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaRelaxType;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptOperObject;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RptFormulaParameter
extends RptOperObject
implements IRptDataPublisher {
    protected static final int STA_CMTS = 1;
    protected static final int STA_CMT = 2;
    protected static final int STA_TYPE = 3;
    protected static final int STA_ALIAS = 4;
    protected static final int STA_LNAME = 5;
    protected String type;
    protected String defaultValue;
    protected boolean isNeed = true;
    protected int valueType = 0;
    protected int repeatNum;
    private String temp;
    private int repeat = 0;
    protected boolean enabled = true;
    protected boolean inquiryOnFocus = false;
    protected boolean overleap = false;
    private List depends = null;

    public RptFormulaParameter(String name, IRptDataPublisher pb) {
        super(name, pb);
    }

    @Override
    public void clear() {
        super.clear();
    }

    public int getRepeatNum() {
        return this.repeatNum;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNeed() {
        return this.isNeed;
    }

    @Override
    public void goContent(String value) {
        if (this.status == 2) {
            this.description.put(this.temp, value);
        } else if (this.status == 5) {
            this.alias.put(this.temp, value);
        }
    }

    @Override
    public void goInto(String target, Attributes atts) throws SAXException {
        if (target.equalsIgnoreCase("param")) {
            this.status = 0;
            String av = atts.getValue("name");
            if (av == null) {
                throw new SAXException(RptResourceHelper.getString("rptformula-exp-noname"));
            }
            this.name = av.trim();
            av = atts.getValue("type");
            this.type = av != null ? av.trim() : "string";
            av = atts.getValue("required");
            this.isNeed = CommonUtil.isTrue(av, true);
            av = atts.getValue("repeat");
            this.repeatNum = av == null ? 1 : Integer.parseInt(av.trim());
            av = atts.getValue("default");
            this.defaultValue = av == null ? null : av.trim();
            av = atts.getValue("enabled");
            this.enabled = CommonUtil.isTrue(av, true);
            av = atts.getValue("depends");
            if (!StringUtils.isEmpty((String)av)) {
                this.splitToDepends(av);
            }
            if (!StringUtils.isEmpty((String)(av = atts.getValue("inquiryOnFocus")))) {
                this.inquiryOnFocus = CommonUtil.isTrue(av, false);
            }
            av = atts.getValue("overleap");
            this.overleap = CommonUtil.isTrue(av, false);
        } else if (target.equalsIgnoreCase("comments")) {
            this.status = this.status != 0 ? -1 : 1;
        } else if (target.equalsIgnoreCase("comment")) {
            if (this.status != 1) {
                this.status = -1;
            } else {
                this.status = 2;
                String av = atts.getValue("language");
                this.temp = av != null ? av : "default";
            }
        } else if (target.equalsIgnoreCase("alias")) {
            this.status = this.status != 0 ? -1 : 4;
        } else if (target.equalsIgnoreCase("local_name")) {
            if (this.status != 4) {
                this.status = -1;
            } else {
                this.status = 5;
                String av = atts.getValue("language");
                this.temp = av != null ? av.trim() : "default";
            }
        } else if (target.equalsIgnoreCase("type")) {
            if (this.status != 0) {
                this.status = -1;
            } else {
                this.status = 3;
                RptFormulaRelaxType t = new RptFormulaRelaxType(target, this);
                this.publisher.keep(t);
                t.goInto(target, atts);
            }
        } else if (target.equalsIgnoreCase("enum")) {
            if (this.status != 0) {
                this.status = -1;
            } else {
                this.status = 3;
                RptFormulaEnumType t = new RptFormulaEnumType(target, this);
                this.publisher.keep(t);
                t.goInto(target, atts);
            }
        } else {
            this.status = 0;
        }
    }

    private void splitToDepends(String s) {
        String[] ss = s.split(",");
        for (int i = 0; i < ss.length; ++i) {
            if (this.depends == null) {
                this.depends = new ArrayList(ss.length);
            }
            this.depends.add(ss[i]);
        }
    }

    @Override
    public void goOut(String target) {
        if (target.equalsIgnoreCase("param")) {
            this.status = 0;
            this.publisher.publish(this);
        } else {
            this.status = target.equalsIgnoreCase("comments") ? (this.status != 1 ? -1 : 0) : (target.equalsIgnoreCase("comment") ? 1 : (target.equalsIgnoreCase("alias") ? (this.status != 4 ? -1 : 0) : (target.equalsIgnoreCase("local_name") ? 4 : (target.equalsIgnoreCase("type") ? (this.status != 3 ? -1 : 0) : (target.equalsIgnoreCase("enum") ? (this.status != 3 ? -1 : 0) : 0)))));
        }
    }

    @Override
    public void keep(RptOperObject ob) {
        this.publisher.keep(ob);
    }

    @Override
    public void publish(RptOperObject ob) {
        if (ob instanceof RptFormulaDataType) {
            this.publisher.publish(ob);
        }
        this.publisher.keep(this);
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int vt) {
        this.valueType = vt;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public int incRepeat() {
        return ++this.repeat;
    }

    public List getDepends() {
        return this.depends;
    }

    public boolean isInquiryOnFocus() {
        return this.inquiryOnFocus;
    }

    public void setInquiryOnFocus(boolean inquiryOnFocus) {
        this.inquiryOnFocus = inquiryOnFocus;
    }
}

