/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceContext;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.K3AccFunctionsSoapStub;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.IFormulaBatchExecute;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class AcctcashBatchExecute
extends IFormulaBatchExecute {
    private static final Logger logger = Logger.getLogger(AcctcashBatchExecute.class);

    @Override
    protected void execOne(Parameter p) throws Exception {
        IDataProvider dataProvider;
        Book book = this.getBook();
        Sheet sheet = book.getSheet(p.getSheetName());
        ReportVariables variables = BookProperties.loadVariables(book);
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        String sdsnName = (String)((Variant)args[6]).getValue();
        int year = ((Number)((Variant)args[3]).getValue()).intValue();
        int startp = ((Number)((Variant)args[4]).getValue()).intValue();
        int endp = ((Number)((Variant)args[5]).getValue()).intValue();
        if (year <= 0) {
            year += variables.getIntValue("StartYear", sheet.getSheetName(), 0);
        }
        if (startp <= 0) {
            startp += variables.getIntValue("StartPeriod", sheet.getSheetName(), 0);
        }
        if (endp <= 0) {
            endp += variables.getIntValue("EndPeriod", sheet.getSheetName(), 0);
        }
        boolean include = variables.getBoolValue("IncludePosted", sheet.getSheetName(), false);
        String currency = (String)((Variant)args[2]).getValue();
        if (StringUtils.isEmpty((String)currency)) {
            currency = variables.getStringValue("Currency", sheet.getSheetName());
        }
        if ((dataProvider = (IDataProvider)book.getUserObjectValue("CTX")) instanceof CslReportDataProvider) {
            CslReportDataProvider pp = (CslReportDataProvider)dataProvider;
            int ryear = pp.getReportVO().getYear();
            int rperiod = pp.getReportVO().getPeriod();
            RptPeriodTypeEnum periodType = pp.getReportVO().getPeriodType();
            Date date = RPTDateUtil.getPeriodLastDate((int)ryear, (int)rperiod, (RptPeriodTypeEnum)periodType);
            int[] yearAndPeriod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
            if (year <= 0) {
                year += yearAndPeriod[0];
            }
            if (startp <= 0) {
                startp += yearAndPeriod[1];
            }
            if (endp <= 0) {
                endp += yearAndPeriod[1];
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = pp.getReportVO().getCurrencyNumber();
            }
        }
        Object result = this.acctCash((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), currency, year, startp, endp, include, sdsnName);
        Variant var = null;
        try {
            if (result instanceof Number) {
                BigDecimal value = new BigDecimal(result.toString());
                var = new Variant((Object)value);
            } else {
                var = new Variant(result);
            }
            p.setValue((Object)var);
        }
        catch (Exception e) {
            logger.error((Object)e);
            p.setValue(result);
        }
    }

    public Object acctCash(String item, String fetchType, String currency, int year, int startPeriod, int endPeriod, boolean include, String sdName) throws Exception {
        try {
            String oldc = currency;
            currency = CalculateContext.getInstance().getK3CurrencyNumber(currency);
            if (StringUtils.isEmpty((String)currency)) {
                if ("GLC".equals(currency)) {
                    currency = "";
                } else {
                    throw new Exception("#BAD CURRENCY: " + oldc);
                }
            }
            K3AccFunctionsSoapStub proxy = new K3AccFunctionsSoapStub(K3WebServiceContext.getInstance().getK3FunctionEndPoint(), (Service)new org.apache.axis.client.Service());
            StringBuffer sb = new StringBuffer();
            sb.append(item).append(',').append(fetchType).append(',').append(currency == null ? "" : currency).append(',').append(year).append(',').append(startPeriod).append(',').append(endPeriod).append(',').append(include ? "Y" : "N");
            String sdsn = K3WebServiceContext.getInstance().getSDSNByName(sdName);
            if (StringUtils.isEmpty((String)sdsn)) {
                throw new SyntaxErrorException(0x400000L, (Object)CslRptClientResourceHelper.getString("3_K3WebServiceContext"));
            }
            String acct = proxy.acctCash(sdsn, sb.toString());
            if ("#".equals(acct)) {
                return "0";
            }
            return acct;
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

