/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceContext;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.K3AccFunctionsSoapStub;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.IFormulaBatchExecute;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class AcctextBatchExecute
extends IFormulaBatchExecute {
    private static final Logger logger = Logger.getLogger(AcctextBatchExecute.class);

    @Override
    protected void execOne(Parameter p) throws Exception {
        IDataProvider dataProvider;
        String customFilter;
        Book book = this.getBook();
        Sheet sheet = book.getSheet(p.getSheetName());
        ReportVariables variables = BookProperties.loadVariables(book);
        Object[] args = p.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        if (!StringUtils.isEmpty((String)(customFilter = (String)((Variant)args[2]).getValue()))) {
            throw new Exception("not support the thrid param");
        }
        String sdsnName = (String)((Variant)args[7]).getValue();
        String startdate = (String)((Variant)args[5]).getValue();
        String enddate = (String)((Variant)args[6]).getValue();
        if (StringUtils.isEmpty((String)startdate) && StringUtils.equals((String)(startdate = variables.getStringValue("StartDate", sheet.getSheetName())), (String)"0")) {
            startdate = null;
        }
        if (StringUtils.isEmpty((String)enddate) && StringUtils.equals((String)(enddate = variables.getStringValue("EndDate", sheet.getSheetName())), (String)"0")) {
            enddate = null;
        }
        boolean include = variables.getBoolValue("IncludePosted", sheet.getSheetName(), false);
        String currency = (String)((Variant)args[4]).getValue();
        if (StringUtils.isEmpty((String)currency)) {
            currency = variables.getStringValue("Currency", sheet.getSheetName());
        }
        if ((dataProvider = (IDataProvider)book.getUserObjectValue("CTX")) instanceof CslReportDataProvider) {
            CslReportDataProvider pp = (CslReportDataProvider)dataProvider;
            int ryear = pp.getReportVO().getYear();
            int rperiod = pp.getReportVO().getPeriod();
            RptPeriodTypeEnum periodType = pp.getReportVO().getPeriodType();
            Date date = RPTDateUtil.getPeriodLastDate((int)ryear, (int)rperiod, (RptPeriodTypeEnum)periodType);
            DateFormat df = DateFormat.getDateInstance(2, Locale.CHINA);
            String dateStr = df.format(date);
            if (startdate == null) {
                startdate = dateStr;
            }
            if (enddate == null) {
                enddate = dateStr;
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = pp.getReportVO().getCurrencyNumber();
            }
        }
        Object result = this.AcctExt((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), (String)((Variant)args[2]).getValue(), (String)((Variant)args[3]).getValue(), currency, startdate, enddate, include, sdsnName);
        Variant var = null;
        try {
            if (result instanceof Number) {
                BigDecimal value = new BigDecimal(result.toString());
                var = new Variant((Object)value);
            } else {
                var = new Variant(result);
            }
            p.setValue((Object)var);
        }
        catch (Exception e) {
            logger.error((Object)e);
            p.setValue(result);
        }
    }

    public Object AcctExt(String account, String oppAccount, String filter, String fetchType, String currency, String startDate, String endDate, boolean include, String sdName) throws Exception {
        try {
            String oldc = currency;
            currency = CalculateContext.getInstance().getK3CurrencyNumber(currency);
            if (StringUtils.isEmpty((String)currency)) {
                if ("GLC".equals(currency)) {
                    currency = "";
                } else {
                    throw new Exception("#BAD CURRENCY: " + oldc);
                }
            }
            K3AccFunctionsSoapStub proxy = new K3AccFunctionsSoapStub(K3WebServiceContext.getInstance().getK3FunctionEndPoint(), (Service)new org.apache.axis.client.Service());
            StringBuffer sb = new StringBuffer();
            sb.append(account).append(',').append(oppAccount).append(',').append(filter).append(',').append(fetchType).append(',').append(currency == null ? "" : currency).append(',').append(startDate).append(',').append(endDate).append(',').append(include ? "Y" : "N");
            String sdsn = K3WebServiceContext.getInstance().getSDSNByName(sdName);
            if (StringUtils.isEmpty((String)sdsn)) {
                throw new SyntaxErrorException(0x400000L, (Object)CslRptClientResourceHelper.getString("3_K3WebServiceContext"));
            }
            String acct = proxy.acctExt(sdsn, sb.toString());
            if ("#".equals(acct)) {
                return "0";
            }
            return acct;
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

