/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.util;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericException;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.log4j.Logger;

public class ExceptionHandler {
    private static Logger logger = Logger.getLogger(ExceptionHandler.class);
    private static String commonResource = "com.kingdee.eas.common.CommonResource";
    private static String easCommonResource = "com.kingdee.eas.common.EASCommonResource";
    private static String fatalErrMsg = EASResource.getString((String)easCommonResource, (String)"fatalErrMsg");

    public static void handle(Throwable exc) {
        exc.printStackTrace();
        ExceptionHandler.handle(null, ExceptionHandler.getFriendlyMsg(exc), exc);
    }

    public static void handle(String errMsg, Throwable exc) {
        ExceptionHandler.handle(null, errMsg, exc);
    }

    public static void handle(Component owner, Throwable exc) {
        ExceptionHandler.handle(owner, ExceptionHandler.getFriendlyMsg(exc), exc);
    }

    public static void handle(Component owner, String errMsg, Throwable exc) {
        logger.error((Object)errMsg, exc);
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (exc instanceof AbortException) {
            return;
        }
        if (!ExceptionHandler.handleArrayIndexOutOfBounds(owner, exc) && !ExceptionHandler.handleNullPointerException(owner, exc)) {
            if (exc instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException uex = (UndeclaredThrowableException)exc;
                if (uex != null) {
                    ExceptionHandler.handle(owner, uex.getUndeclaredThrowable());
                } else {
                    ExceptionHandler.handle(owner, exc);
                }
                return;
            }
            if (exc instanceof IllegalComponentStateException) {
                if ("component must be showing on the screen to determine its location".equals(exc.getMessage())) {
                    return;
                }
            } else if (!ExceptionHandler.isTheIllegalAgumentException(exc)) {
                if (ExceptionHandler.handleClassNotFoundException(owner, exc)) {
                    ExceptionHandler.handleClassNotFoundException(owner, exc);
                } else {
                    if (exc instanceof EASBizException) {
                        MsgBox.showError(owner, errMsg);
                        return;
                    }
                    MsgBox.showError(owner, errMsg, ExceptionHandler.buildDetail(exc));
                    return;
                }
            }
        }
    }

    private static boolean isTheIllegalAgumentException(Throwable exc) {
        boolean isIt = false;
        if (exc instanceof IllegalArgumentException) {
            String msg = "TextHitInfo is out of range";
            if (exc.getMessage() != null && exc.getMessage().equals(msg)) {
                isIt = true;
            }
        }
        return isIt;
    }

    private static boolean handleClassNotFoundException(Component owner, Throwable exc) {
        boolean handled = false;
        Throwable cause = exc;
        do {
            if (!(cause instanceof ClassNotFoundException)) continue;
            String detail = ExceptionHandler.buildDetail(exc);
            logger.debug((Object)"handle ClassNotFound Exception!");
            logger.debug((Object)detail);
            String msg = "ClassNotFound";
            MsgBox.showError(owner, msg);
            handled = true;
            break;
        } while ((cause = cause.getCause()) != null);
        return handled;
    }

    private static String buildDetail(Throwable exc) {
        StringBuffer detail = new StringBuffer();
        if (exc instanceof NumericException) {
            detail.append(EASResource.getString((String)commonResource, (String)"errorNo"));
            detail.append(((NumericException)exc).getCode());
            detail.append(System.getProperty("line.separator"));
        }
        detail.append(EASResource.getString((String)commonResource, (String)"errorMessage"));
        detail.append(exc.getMessage());
        detail.append(System.getProperty("line.separator"));
        detail.append(EASResource.getString((String)commonResource, (String)"errorStackDetail"));
        if (exc instanceof BaseException) {
            detail.append(ExceptionHandler.getStackTraceFromBaseException(exc));
        } else {
            detail.append(ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
        }
        logger.error((Object)detail);
        return detail.toString();
    }

    private static String getStackTraceFromBaseException(Throwable exc) {
        String str = "";
        try {
            BaseException be = (BaseException)exc;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, false, "UTF8");
            be.printStackTrace(ps);
            str = baos.toString("UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static String getFriendlyMsg(Throwable exc) {
        if (exc.getMessage() != null) {
            return exc.getMessage();
        }
        return fatalErrMsg;
    }

    private static boolean handleArrayIndexOutOfBounds(Component owner, Throwable e) {
        String aim = "javax.swing.RepaintManager";
        if (e instanceof ArrayIndexOutOfBoundsException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    if (stackTraces[i].toString().indexOf("javax.swing.RepaintManager") == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean handleNullPointerException(Component owner, Throwable e) {
        String aim = "sun.awt.windows.WInputMethod.dispatchEvent(WInputMethod.java:253)";
        String aim2 = "com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI$StyleData.getInteger(KingdeeTabbedPaneUI.java:722)";
        if (e instanceof NullPointerException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    if (stackTraces[i].toString().indexOf("sun.awt.windows.WInputMethod.dispatchEvent(WInputMethod.java:253)") == -1 && stackTraces[i].toString().indexOf("com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI$StyleData.getInteger(KingdeeTabbedPaneUI.java:722)") == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

