/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.rpt.IReaderPattern;
import com.kingdee.eas.fi.rpt.SqlUtilFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class CSLCompanyPattern
implements IReaderPattern {
    String pattern = null;
    public static final String CSL_COMPANY_PATTERN = "{CSL_COMPANY_NUMBERS|";

    public CSLCompanyPattern(String pattern) {
        this.pattern = pattern;
    }

    public static final boolean isCLSCompanyPattern(String pattern) {
        return pattern != null && pattern.startsWith(CSL_COMPANY_PATTERN);
    }

    @Override
    public String getValue() {
        return this.getCompanyListStr();
    }

    @Override
    public void check() {
    }

    private String getFiledName() {
        int index = this.pattern.indexOf("|");
        return this.pattern.substring(index + 1, this.pattern.length() - 1);
    }

    private String getCompanyListStr() {
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        try {
            OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
            OrgUnitInfo company = cslCtx.getCurOrgGroup();
            String id = orgBound.getId().toString();
            String number = company.getId().toString();
            IRowSet rs = SqlUtilFacadeFactory.getRemoteInstance().getCSLCompanyNumbers(id, number);
            String field = this.getFiledName();
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                number = rs.getString(1);
                sb.append(" ").append(field).append("=").append("'").append(number).append("' ");
                sb.append("or");
            }
            if (sb.length() > 0) {
                String str = sb.substring(0, sb.length() - 2);
                str = " and ( " + str + " ) ";
                return str;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public Object getReaderPattern() {
        return this.pattern;
    }
}

