/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.BizFormulaMover;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.util.StringUtils;
import java.util.List;

public class CsrefFormulaMover
extends BizFormulaMover {
    private int paramIndex = 7;

    public String[] getFormulaNames() {
        return new String[]{"CsRef"};
    }

    private String fill(String cellNumber, int direction) {
        CellNumberPart cnp = new CellNumberPart(cellNumber);
        if (direction == 4) {
            cnp.fillLeft();
        } else if (direction == 2) {
            cnp.fillRitht();
        } else if (direction == 1) {
            cnp.fillUp();
        } else {
            cnp.fillDown();
        }
        return cnp.getString();
    }

    public void move(int direction, String fuctionName, List params) {
        String str = params.get(this.paramIndex).toString().toUpperCase();
        CellNumberPart cnp = new CellNumberPart(str);
        params.set(this.paramIndex, cnp.fill(direction));
    }

    public int[] getModifiedParasIndexs() {
        return new int[]{this.paramIndex};
    }

    public void move(int derection, FunctionExpr expression) {
        StringExpr str = (StringExpr)expression.parameters.get(this.paramIndex);
        CellNumberPart cnp = new CellNumberPart(str.value);
        str.value = derection == 4 || derection == 1 ? cnp.fill(1) : cnp.fill(3);
    }

    public static int convertColStringToNum(String ref) {
        int retval = 0;
        int pos = 0;
        for (int k = ref.length() - 1; k > -1; --k) {
            char thechar = ref.charAt(k);
            retval = pos == 0 ? (retval += Character.getNumericValue(thechar) - 9) : (retval += (Character.getNumericValue(thechar) - 9) * (pos * 26));
            ++pos;
        }
        return retval - 1;
    }

    public static String convertNumToColString(int col) {
        String retval = null;
        if (col < 0) {
            col = 0;
        }
        int mod = col % 26;
        int div = col / 26;
        char small = (char)(mod + 65);
        char big = (char)(div + 64);
        retval = div == 0 ? "" + small : "" + big + "" + small;
        return retval;
    }

    private class CellNumberPart {
        String leftPart = null;
        int rightPart = 0;

        public CellNumberPart(String number) {
            if (StringUtils.isEmpty((String)number)) {
                this.rightPart = 0;
                this.leftPart = "";
                return;
            }
            for (int i = 0; i < number.length(); ++i) {
                if (number.charAt(i) < '0' || number.charAt(i) > '9') continue;
                this.rightPart = Integer.valueOf(number.substring(i));
                this.leftPart = number.substring(0, i).toUpperCase();
                break;
            }
        }

        private void fillUp() {
            if (this.rightPart > 1) {
                --this.rightPart;
            }
        }

        private void fillRitht() {
            this.leftPart = CsrefFormulaMover.convertNumToColString(CsrefFormulaMover.convertColStringToNum(this.leftPart) + 1);
        }

        private void fillDown() {
            ++this.rightPart;
        }

        private void fillLeft() {
            this.leftPart = CsrefFormulaMover.convertNumToColString(CsrefFormulaMover.convertColStringToNum(this.leftPart) - 1);
        }

        public String getString() {
            if (this.rightPart == 0 || StringUtils.isEmpty((String)this.leftPart)) {
                return "";
            }
            return this.leftPart + this.rightPart;
        }

        public String fill(int direction) {
            switch (direction) {
                case 4: {
                    this.fillLeft();
                    break;
                }
                case 2: {
                    this.fillRitht();
                    break;
                }
                case 3: {
                    this.fillDown();
                    break;
                }
                case 1: {
                    this.fillUp();
                }
            }
            return this.getString();
        }
    }
}

