/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.eas.fi.rpt.BizFormulaMover;
import com.kingdee.eas.fi.rpt.BizFormulaMoverAdapter;
import com.kingdee.eas.fi.rpt.GenerateSolution;
import com.kingdee.eas.fi.rpt.Moveable;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class FormulaMoveTool
implements Moveable {
    private String formulaStr = null;
    private CodeExpr codeExpr = null;
    private GenerateSolution solution;
    private static HashMap bizFormulaMoverMap = new HashMap(1);
    private static final Logger log = Logger.getLogger((String)FormulaMoveTool.class.getName());
    private int moveDirection = 1;
    private int prefixIndex = 0;
    private ArrayList specSumFuctionList = null;

    private FormulaMoveTool() {
    }

    public static String[] generate(GenerateSolution s, String formula) throws Exception {
        FormulaMoveTool tool = new FormulaMoveTool(s, formula);
        return tool.generate();
    }

    private String[] generate() throws ParserException {
        if (this.solution == null) {
            return null;
        }
        String[] strList = new String[this.solution.getCount()];
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = this.move();
        }
        return strList;
    }

    public static void registBizFormulaMover(BizFormulaMover _bizMov) {
        BizFormulaMoverAdapter bizMov = new BizFormulaMoverAdapter(_bizMov);
        String[] formulaNames = bizMov.getFormulaNames();
        if (formulaNames == null) {
            return;
        }
        for (int i = 0; i < formulaNames.length; ++i) {
            bizFormulaMoverMap.put(formulaNames[i].trim().toUpperCase(), bizMov);
        }
    }

    public FormulaMoveTool(String _formulaStr) {
        this.formulaStr = this.initProcessParam("value" + _formulaStr + ";");
    }

    public FormulaMoveTool(GenerateSolution g, String _formulaStr) {
        this.solution = g;
        this.formulaStr = this.initProcessParam("value" + _formulaStr + ";");
    }

    public String moveUp() throws ParserException {
        this.moveDirection = 1;
        return this.move();
    }

    private String move() throws ParserException {
        for (SpecSumParam var : this.specSumFuctionList) {
            var.move();
        }
        return this.processReturnString(this.walkTree());
    }

    public String moveDown() throws ParserException {
        this.moveDirection = 3;
        return this.move();
    }

    public String moveLeft() throws ParserException {
        this.moveDirection = 4;
        return this.move();
    }

    public String moveRight() throws ParserException {
        this.moveDirection = 2;
        return this.move();
    }

    private String walkTree() throws ParserException {
        this.initEnv();
        if (this.codeExpr instanceof BinaryOpExpr) {
            this.walkBintryTree(this.codeExpr);
        } else if (this.codeExpr instanceof MethodInvokeExpr) {
            this.walkMethodExpr(this.codeExpr);
        } else if (this.codeExpr instanceof IdentifierExpr) {
            this.doIdentifierExpr(this.codeExpr);
        }
        return this.codeExpr.toString();
    }

    private void initEnv() throws ParserException {
        if (this.codeExpr == null) {
            Lexer lexer = new Lexer(this.formulaStr);
            TokenList tokList = new TokenList(lexer);
            KScriptParser parser = new KScriptParser(tokList);
            parser.parse();
            List list = parser.stmtList;
            ExprStmt stmt = (ExprStmt)list.get(0);
            if (!(stmt.expr instanceof BinaryOpExpr)) {
                throw new ParserException("find unexpected expression.", (Object)"", "");
            }
            BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
            this.codeExpr = expr.right;
        }
    }

    public static String[] generateBysolution(GenerateSolution s, String formula) throws Exception {
        FormulaMoveTool tool = new FormulaMoveTool();
        tool.solution = s;
        tool.formulaStr = formula;
        return tool.generateBysolution();
    }

    private String[] generateBysolution() throws Exception {
        if (this.solution == null) {
            return null;
        }
        List result = this.generateListMoveResult();
        String[] strList = new String[result.size()];
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = (String)result.get(i);
        }
        return strList;
    }

    private List generateListMoveResult() throws Exception {
        Expression expression = ExcelFormulaPaserHelper.parse(this.formulaStr);
        ArrayList<String> result = new ArrayList<String>();
        ReplaceHandler replaceHandler = new ReplaceHandler();
        for (int i = 0; i < this.solution.getCount(); ++i) {
            ExcelFormulaPaserHelper.walk(expression, replaceHandler);
            result.add(expression.toString());
        }
        return result;
    }

    public static String formatFormaulBysolution(GenerateSolution s, String formula) throws Exception {
        FormulaMoveTool tool = new FormulaMoveTool();
        tool.solution = s;
        return tool.generateMoveResult(formula);
    }

    private String generateMoveResult(String formula) throws Exception {
        Expression expression = ExcelFormulaPaserHelper.parse(formula);
        SpecialReplaceHandler replaceHandler = new SpecialReplaceHandler();
        ExcelFormulaPaserHelper.walk(expression, replaceHandler);
        return expression.toString();
    }

    private void walkBintryTree(CodeExpr binOpExpr) {
        if (binOpExpr instanceof BinaryOpExpr) {
            CodeExpr left = ((BinaryOpExpr)binOpExpr).left;
            CodeExpr right = ((BinaryOpExpr)binOpExpr).right;
            if (left instanceof BinaryOpExpr) {
                this.walkBintryTree(left);
            } else if (left instanceof MethodInvokeExpr) {
                this.walkMethodExpr(left);
            } else if (left instanceof IdentifierExpr) {
                this.doIdentifierExpr(left);
            }
            if (right instanceof BinaryOpExpr) {
                this.walkBintryTree(right);
            } else if (right instanceof MethodInvokeExpr) {
                this.walkMethodExpr(right);
            } else if (right instanceof IdentifierExpr) {
                this.doIdentifierExpr(right);
            }
        }
    }

    private void walkMethodExpr(CodeExpr codeExpr) {
        for (Object obj : ((MethodInvokeExpr)codeExpr).paramList) {
            if (obj instanceof MethodInvokeExpr) {
                this.walkMethodExpr((CodeExpr)obj);
                continue;
            }
            if (obj instanceof BinaryOpExpr) {
                this.walkBintryTree((CodeExpr)obj);
                continue;
            }
            if (!(obj instanceof IdentifierExpr)) continue;
            this.doIdentifierExpr((CodeExpr)obj);
        }
        String methodName = ((MethodInvokeExpr)codeExpr).methodName;
        BizFormulaMoverAdapter bizMov = (BizFormulaMoverAdapter)bizFormulaMoverMap.get(methodName.trim().toUpperCase());
        if (bizMov != null) {
            if (this.solution != null && this.solution.isFormulaEnable()) {
                for (int step = this.solution.getFormulaStep(); step > 0; --step) {
                    if (this.solution.getFomulaAspect() == 1) {
                        bizMov.move(2, (MethodInvokeExpr)codeExpr);
                        continue;
                    }
                    bizMov.move(1, (MethodInvokeExpr)codeExpr);
                }
            } else if (this.solution == null) {
                bizMov.move(this.moveDirection, (MethodInvokeExpr)codeExpr);
            }
        }
    }

    private void doIdentifierExpr(CodeExpr identifierExpr) {
        if (identifierExpr instanceof IdentifierExpr) {
            String str = ((IdentifierExpr)identifierExpr).value;
            ((IdentifierExpr)identifierExpr).value = this.moveCell(str);
        }
    }

    private String moveCell(String str) {
        if (this.isCellReference(str)) {
            String[] str2 = this.splitCellReference(str);
            if (this.solution != null) {
                int step;
                if (this.solution.isCellColumnEnable()) {
                    for (step = this.solution.getCellColumnStep(); step > 0; --step) {
                        if (this.solution.getCellColumnAspect() == 1) {
                            str2[0] = this.increamentCellReferenceCharPart(str2[0]);
                            continue;
                        }
                        str2[0] = this.decrementCellReferenceCharPart(str2[0]);
                    }
                }
                if (this.solution.isCellRowEnable()) {
                    step = this.solution.getCellRowStep();
                    if (this.solution.getCellRowAspect() == 1) {
                        int temp = Integer.parseInt(str2[1]);
                        str2[1] = Integer.toString(temp + step);
                    } else {
                        int temp = Integer.parseInt(str2[1]);
                        if ((temp -= step) < 1) {
                            temp = 1;
                        }
                        str2[1] = Integer.toString(temp);
                    }
                }
            } else if (this.moveDirection == 4) {
                str2[0] = this.decrementCellReferenceCharPart(str2[0]);
            } else if (this.moveDirection == 2) {
                str2[0] = this.increamentCellReferenceCharPart(str2[0]);
            } else if (this.moveDirection == 1) {
                int temp = Integer.parseInt(str2[1]);
                if (temp > 1) {
                    str2[1] = Integer.toString(temp - 1);
                }
            } else if (this.moveDirection == 3) {
                int temp = Integer.parseInt(str2[1]);
                str2[1] = Integer.toString(temp + 1);
            }
            return str2[0] + str2[1];
        }
        return str;
    }

    private boolean isCellReference(String string) {
        if (string == null) {
            return false;
        }
        String str = string.toUpperCase().trim();
        int flag = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= 'Z' && str.charAt(i) >= 'A') {
                if (flag == 2) {
                    return false;
                }
                flag = 1;
                continue;
            }
            if (str.charAt(i) <= '9' && str.charAt(i) >= '0') {
                if (flag == 0) {
                    return false;
                }
                flag = 2;
                continue;
            }
            return false;
        }
        return flag != true;
    }

    private String[] splitCellReference(String string) {
        int i;
        String[] str2 = new String[2];
        String str = string.toUpperCase().trim();
        for (i = 0; i < str.length() && (str.charAt(i) > '9' || str.charAt(i) < '0'); ++i) {
        }
        str2[0] = str.substring(0, i);
        str2[1] = str.substring(i);
        return str2;
    }

    private String increamentCellReferenceCharPart(String str) {
        StringBuffer buf = new StringBuffer();
        boolean increamentFlag = true;
        for (int index = str.length() - 1; index >= 0; --index) {
            if (increamentFlag) {
                if (str.charAt(index) + '\u0001' > 90) {
                    buf.append('A');
                    continue;
                }
                buf.append((char)(str.charAt(index) + '\u0001'));
                increamentFlag = false;
                continue;
            }
            buf.append(str.charAt(index));
        }
        if (increamentFlag) {
            buf.append('A');
            increamentFlag = false;
        }
        StringBuffer buf2 = new StringBuffer();
        for (int j = buf.length() - 1; j >= 0; --j) {
            buf2.append(buf.charAt(j));
        }
        return buf2.toString();
    }

    private String decrementCellReferenceCharPart(String str) {
        StringBuffer buf = new StringBuffer();
        boolean decrementFlag = true;
        for (int index = str.length() - 1; index >= 0; --index) {
            if (decrementFlag) {
                if (str.charAt(index) - '\u0001' < 65) {
                    if (index <= 0) continue;
                    buf.append('Z');
                    continue;
                }
                buf.append((char)(str.charAt(index) - '\u0001'));
                decrementFlag = false;
                continue;
            }
            buf.append(str.charAt(index));
        }
        if (buf.length() == 0) {
            return str;
        }
        StringBuffer buf2 = new StringBuffer();
        for (int j = buf.length() - 1; j >= 0; --j) {
            buf2.append(buf.charAt(j));
        }
        return buf2.toString();
    }

    private String initProcessParam(String str) {
        this.prefixIndex = 0;
        this.specSumFuctionList = new ArrayList();
        if (str == null) {
            return null;
        }
        str = str.replaceAll(" ", "");
        ArrayList segList = this.lookForSpecSumSeg(str = str.replaceAll("<>", "-NOTEQUALFLAG-"));
        if (segList == null || segList.size() == 0) {
            return str;
        }
        int lastIndex = 0;
        StringBuffer buf = new StringBuffer();
        for (StringSeg seg : segList) {
            String preStrSeg = str.substring(lastIndex, seg.startIndex);
            buf.append(preStrSeg == null ? "" : preStrSeg);
            buf.append(this.replaceSUMPerifx(str.substring(seg.startIndex, seg.endIndex + 1)));
            lastIndex = seg.endIndex + 1;
        }
        if (lastIndex < str.length()) {
            String tempStr = str.substring(lastIndex);
            buf.append(tempStr == null ? "" : tempStr);
        }
        return buf.toString();
    }

    private String processReturnString(String str) {
        str = str.replaceAll(" ", "");
        str = str.replaceAll("-NOTEQUALFLAG-", "<>");
        if (this.specSumFuctionList == null || this.specSumFuctionList.size() == 0) {
            return str;
        }
        String tempStr = str;
        for (SpecSumParam var : this.specSumFuctionList) {
            tempStr = tempStr.replaceFirst(var.getPrefix(), var.getString());
        }
        return tempStr;
    }

    private ArrayList lookForSpecSumSeg(String _str) {
        int pos;
        String str = _str.toUpperCase();
        ArrayList<Integer> posArray = new ArrayList<Integer>();
        ArrayList<StringSeg> segArray = new ArrayList<StringSeg>();
        int index = 0;
        while (index < str.length() && (pos = str.indexOf("SUM", index)) != -1) {
            index = pos + 3;
            posArray.add(new Integer(pos));
        }
        for (int i = 0; i < posArray.size(); ++i) {
            int startPos = (Integer)posArray.get(i);
            int endPos = i == posArray.size() - 1 ? str.length() - 1 : (Integer)posArray.get(i + 1) - 1;
            boolean isFuction = false;
            int count = 0;
            boolean isBeginFlag = false;
            int endFucPos = -1;
            for (int j = startPos + 3; j <= endPos; ++j) {
                if (!isBeginFlag && str.charAt(j) != '(' && str.charAt(j) != ' ') {
                    isFuction = false;
                    break;
                }
                if (str.charAt(j) == '(') {
                    ++count;
                    isBeginFlag = true;
                }
                if (str.charAt(j) != ')' || --count != 0) continue;
                isFuction = true;
                endFucPos = j;
                break;
            }
            if (!isFuction || str.substring(startPos, endFucPos).indexOf(58) == -1) continue;
            StringSeg seg = new StringSeg();
            seg.startIndex = startPos;
            seg.endIndex = endFucPos;
            segArray.add(seg);
        }
        return segArray;
    }

    private String replaceSUMPerifx(String str) {
        int start = str.indexOf(40);
        int split = str.indexOf(58);
        SpecSumParam specSumParam = new SpecSumParam();
        specSumParam.left = str.substring(start + 1, split);
        specSumParam.right = str.substring(split + 1, str.length() - 1);
        this.specSumFuctionList.add(specSumParam);
        return specSumParam.getPrefix();
    }

    static {
        String[] bizFormulaMoverConfigList = new String[]{"com.kingdee.eas.fi.rpt.AcctFormulaMover", "com.kingdee.eas.fi.rpt.CsrefFormulaMover"};
        for (int i = 0; i < bizFormulaMoverConfigList.length; ++i) {
            try {
                Class<?> c = Class.forName(bizFormulaMoverConfigList[i]);
                try {
                    FormulaMoveTool.registBizFormulaMover((BizFormulaMover)c.newInstance());
                }
                catch (InstantiationException e1) {
                    log.debug((Object)e1.getMessage());
                }
                catch (IllegalAccessException e1) {
                    log.debug((Object)e1.getMessage());
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)e.getMessage());
            }
        }
    }

    private class StringSeg {
        private int startIndex;
        private int endIndex;

        private StringSeg() {
        }
    }

    private class SpecSumParam {
        public String left = null;
        public String right = null;
        private String prefix = null;

        private SpecSumParam() {
        }

        public String getPrefix() {
            if (this.prefix == null) {
                FormulaMoveTool.this.prefixIndex++;
                this.prefix = "SUMNo" + FormulaMoveTool.this.prefixIndex + "Prefix";
            }
            return this.prefix;
        }

        public String getString() {
            return "SUM(" + (this.left != null ? this.left : "") + ":" + (this.right != null ? this.right : "") + ")";
        }

        public void move() {
            if (this.left != null) {
                this.left = FormulaMoveTool.this.moveCell(this.left);
            }
            if (this.right != null) {
                this.right = FormulaMoveTool.this.moveCell(this.right);
            }
        }
    }

    private class ReplaceHandler
    implements IExpressionHandler {
        private ReplaceHandler() {
        }

        @Override
        public void handle(Expression expr) {
            if (expr instanceof ReferenceExpr) {
                ReferenceExpr referenceExpr = (ReferenceExpr)expr;
                this.moveReferenceExpr(referenceExpr);
            } else if (expr instanceof AreaExpr) {
                AreaExpr areaExpr = (AreaExpr)expr;
                this.moveAreaExpr(areaExpr);
            } else if (expr instanceof FunctionExpr) {
                FunctionExpr functionExpr = (FunctionExpr)expr;
                this.moveFunctionExpr(functionExpr);
            }
        }

        private void moveFunctionExpr(FunctionExpr functionExpr) {
            String methodName = functionExpr.funcionName;
            BizFormulaMoverAdapter bizMov = (BizFormulaMoverAdapter)bizFormulaMoverMap.get(methodName.trim().toUpperCase());
            if (bizMov != null && FormulaMoveTool.this.solution != null && FormulaMoveTool.this.solution.isFormulaEnable()) {
                for (int step = FormulaMoveTool.this.solution.getFormulaStep(); step > 0; --step) {
                    if (FormulaMoveTool.this.solution.getFomulaAspect() == 1) {
                        bizMov.getMover().move(3, functionExpr);
                        continue;
                    }
                    bizMov.getMover().move(1, functionExpr);
                }
            }
        }

        private void moveAreaExpr(AreaExpr areaExpr) {
            if (FormulaMoveTool.this.solution.isCellColumnEnable()) {
                if (FormulaMoveTool.this.solution.getCellColumnAspect() == 1) {
                    if (areaExpr.isFirstColRel()) {
                        areaExpr.start_col += FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.isLastColRel()) {
                        areaExpr.end_col += FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                } else {
                    if (areaExpr.isFirstColRel()) {
                        areaExpr.start_col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.isLastColRel()) {
                        areaExpr.end_col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.start_col < 0) {
                        areaExpr.start_col = 0;
                    }
                    if (areaExpr.end_col < 0) {
                        areaExpr.end_col = 0;
                    }
                }
            }
            if (FormulaMoveTool.this.solution.isCellRowEnable()) {
                if (FormulaMoveTool.this.solution.getCellRowAspect() == 1) {
                    if (areaExpr.isFirstRowRel()) {
                        areaExpr.start_row += FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.isLastRowRel()) {
                        areaExpr.end_row += FormulaMoveTool.this.solution.getCellRowStep();
                    }
                } else {
                    if (areaExpr.isFirstRowRel()) {
                        areaExpr.start_row -= FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.isLastRowRel()) {
                        areaExpr.end_row -= FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.start_row < 0) {
                        areaExpr.start_row = 0;
                    }
                    if (areaExpr.end_row < 0) {
                        areaExpr.end_row = 0;
                    }
                }
            }
        }

        private void moveReferenceExpr(ReferenceExpr referenceExpr) {
            if (FormulaMoveTool.this.solution.isCellColumnEnable()) {
                if (FormulaMoveTool.this.solution.getCellColumnAspect() == 1) {
                    referenceExpr.col += FormulaMoveTool.this.solution.getCellColumnStep();
                } else {
                    referenceExpr.col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    if (referenceExpr.col < 0) {
                        referenceExpr.col = 0;
                    }
                }
            }
            if (FormulaMoveTool.this.solution.isCellRowEnable()) {
                if (FormulaMoveTool.this.solution.getCellRowAspect() == 1) {
                    referenceExpr.row += FormulaMoveTool.this.solution.getCellRowStep();
                } else {
                    referenceExpr.row -= FormulaMoveTool.this.solution.getCellRowStep();
                    if (referenceExpr.row < 0) {
                        referenceExpr.row = 0;
                    }
                }
            }
        }
    }

    private class SpecialReplaceHandler
    implements IExpressionHandler {
        private SpecialReplaceHandler() {
        }

        @Override
        public void handle(Expression expr) {
            if (expr instanceof ReferenceExpr) {
                ReferenceExpr referenceExpr = (ReferenceExpr)expr;
                int size = referenceExpr.getName().split("\\$").length - 1;
                if (size <= 1) {
                    this.moveReferenceExpr(referenceExpr);
                }
            } else if (expr instanceof AreaExpr) {
                AreaExpr areaExpr = (AreaExpr)expr;
                this.moveAreaExpr(areaExpr);
            }
        }

        private void moveAreaExpr(AreaExpr areaExpr) {
            if (FormulaMoveTool.this.solution.isCellColumnEnable()) {
                if (FormulaMoveTool.this.solution.getCellColumnAspect() == 1) {
                    if (areaExpr.isFirstColRel()) {
                        areaExpr.start_col += FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.isLastColRel()) {
                        areaExpr.end_col += FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                } else {
                    if (areaExpr.isFirstColRel()) {
                        areaExpr.start_col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.isLastColRel()) {
                        areaExpr.end_col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    }
                    if (areaExpr.start_col < 0) {
                        areaExpr.start_col = 0;
                    }
                    if (areaExpr.end_col < 0) {
                        areaExpr.end_col = 0;
                    }
                }
            }
            if (FormulaMoveTool.this.solution.isCellRowEnable()) {
                if (FormulaMoveTool.this.solution.getCellRowAspect() == 1) {
                    if (areaExpr.isFirstRowRel()) {
                        areaExpr.start_row += FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.isLastRowRel()) {
                        areaExpr.end_row += FormulaMoveTool.this.solution.getCellRowStep();
                    }
                } else {
                    if (areaExpr.isFirstRowRel()) {
                        areaExpr.start_row -= FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.isLastRowRel()) {
                        areaExpr.end_row -= FormulaMoveTool.this.solution.getCellRowStep();
                    }
                    if (areaExpr.start_row < 0) {
                        areaExpr.start_row = 0;
                    }
                    if (areaExpr.end_row < 0) {
                        areaExpr.end_row = 0;
                    }
                }
            }
        }

        private void moveReferenceExpr(ReferenceExpr referenceExpr) {
            if (FormulaMoveTool.this.solution.isCellColumnEnable()) {
                if (FormulaMoveTool.this.solution.getCellColumnAspect() == 1) {
                    referenceExpr.col += FormulaMoveTool.this.solution.getCellColumnStep();
                } else {
                    referenceExpr.col -= FormulaMoveTool.this.solution.getCellColumnStep();
                    if (referenceExpr.col < 0) {
                        referenceExpr.col = 0;
                    }
                }
            }
            if (FormulaMoveTool.this.solution.isCellRowEnable()) {
                if (FormulaMoveTool.this.solution.getCellRowAspect() == 1) {
                    referenceExpr.row += FormulaMoveTool.this.solution.getCellRowStep();
                } else {
                    referenceExpr.row -= FormulaMoveTool.this.solution.getCellRowStep();
                    if (referenceExpr.row < 0) {
                        referenceExpr.row = 0;
                    }
                }
            }
        }
    }
}

