/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.BalanceHint;
import com.kingdee.eas.fi.rpt.ConvertHint;
import com.kingdee.eas.fi.rpt.ISheetEditObserver;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RptBalanceFullHint
implements Serializable,
ISheetEditObserver {
    private static final long serialVersionUID = 20041129105359L;
    public static final int MD_NEWSHEET = 0;
    public static final int MD_REFRESH = 1;
    public static final int MD_NEWREPOT = 2;
    public Collection cvHint = null;
    public Collection baHint = null;
    public int cvMode = 0;

    public void onDeleteSheet(String name) {
        this.removeConvertsSheetName(name);
        this.removeBanlanceHintsBySheetname(name);
    }

    public void onRenameSheet(String oldName, String newName) {
        this.renameConvertHintsSheetName(oldName, newName);
        this.renameBalanceHintsSheetName(oldName, newName);
    }

    public void onAddNewSheet(String newSheet) {
    }

    public void mergeConvertHints(Collection c) {
        if (c == null) {
            return;
        }
        if (this.cvHint == null) {
            this.cvHint = new ArrayList();
        }
        this.cvHint.addAll(c);
    }

    public void mergeBalanceHints(Collection c) {
        if (c == null) {
            return;
        }
        if (this.baHint == null) {
            this.baHint = new ArrayList();
        }
        this.baHint.addAll(c);
    }

    private void renameConvertHintsSheetName(String oldName, String newName) {
        if (this.cvHint == null) {
            return;
        }
        for (ConvertHint h : this.cvHint) {
            List l = h.sheetName;
            if (l == null) continue;
            for (int i = 0; i < l.size(); ++i) {
                String theName = (String)l.get(i);
                if (theName == null || !theName.equalsIgnoreCase(oldName)) continue;
                l.set(i, newName);
            }
        }
    }

    private void renameBalanceHintsSheetName(String oldName, String newName) {
        if (this.baHint == null || oldName == null || newName == null) {
            return;
        }
        for (BalanceHint h : this.baHint) {
            if (h.base != null && h.base.sheetName != null && oldName.equalsIgnoreCase(h.base.sheetName)) {
                h.base.sheetName = newName;
            }
            if (h.expression == null) continue;
            h.expression = StringUtils.replaceIgnoreCase((String)h.expression, (String)(oldName + '!'), (String)(newName + '!'));
        }
    }

    private void removeConvertsSheetName(String name) {
        if (this.cvHint == null || name == null) {
            return;
        }
        Iterator it = this.cvHint.iterator();
        while (it.hasNext()) {
            ConvertHint h = (ConvertHint)it.next();
            List l = h.sheetName;
            if (l == null) {
                it.remove();
                continue;
            }
            for (int i = 0; i < l.size(); ++i) {
                String theName = (String)l.get(i);
                if (theName == null || !theName.equalsIgnoreCase(name)) continue;
                l.remove(i);
            }
        }
    }

    private void removeBanlanceHintsBySheetname(String name) {
        if (this.baHint == null || name == null) {
            return;
        }
        name = name.toLowerCase();
        Iterator it = this.baHint.iterator();
        while (it.hasNext()) {
            BalanceHint h = (BalanceHint)it.next();
            if (h.base != null && h.base.sheetName != null && name.equalsIgnoreCase(h.base.sheetName)) {
                it.remove();
                continue;
            }
            if (h.expression == null || h.expression.toLowerCase().indexOf(name + '!') == -1) continue;
            it.remove();
        }
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator i = UserObjectTrans.createObjectIterator((String)s);
        if (i.hasNext()) {
            this.cvHint = (ArrayList)i.nextObject();
        }
        if (i.hasNext()) {
            this.baHint = (ArrayList)i.nextObject();
        }
        if (i.hasNext()) {
            this.cvMode = (Integer)i.nextObject();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString((ArrayList)((ArrayList)this.cvHint), (StringBuffer)sb);
        UserObjectTrans.toString((ArrayList)((ArrayList)this.baHint), (StringBuffer)sb);
        UserObjectTrans.toString((Integer)new Integer(this.cvMode), (StringBuffer)sb);
        return sb.toString();
    }
}

