/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.eas.fi.rpt.CellReference;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.AreaExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class TableToolkit {
    public static final String RG_FULLTABLE = "ALL";

    public static Collection parseIndices(String line, int minIndex, int maxIndex) {
        if (line == null) {
            return null;
        }
        String[] tokens = line.split(",");
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        int size = tokens.length;
        ArrayList res = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            if (TableToolkit.parseIndices(res, tokens[i].trim(), minIndex, maxIndex)) continue;
            return null;
        }
        Collections.sort(res);
        int count = res.size();
        if (count > 0) {
            int h = (Integer)res.get(0);
            if (h < minIndex) {
                return null;
            }
            int t = (Integer)res.get(count - 1);
            if (t > maxIndex) {
                return null;
            }
        }
        return res;
    }

    public static boolean isCellRef(String ref) {
        return Pattern.compile("(.+!)?((\\s*[a-zA-Z]+\\d+)\\s*|(\\s*[a-zA-Z]+\\d+\\s*:\\s*[a-zA-Z]+\\d+\\s*))").matcher(ref).matches();
    }

    private static boolean parseIndices(ArrayList chain, String token, int minIndex, int maxIndex) {
        if (token == null || token.length() == 0) {
            return true;
        }
        try {
            int mid = token.indexOf(45);
            if (mid == -1) {
                TableToolkit.putIndices(chain, Integer.parseInt(token) - 1);
            } else {
                String tail;
                String head = token.substring(0, mid).trim();
                int vh = minIndex;
                if (head != null && head.length() > 0) {
                    vh = Integer.parseInt(head) - 1;
                }
                mid = token.lastIndexOf(45);
                int vt = maxIndex;
                if (mid < token.length() - 1 && (tail = token.substring(mid + 1).trim()) != null && tail.length() > 0) {
                    vt = Integer.parseInt(tail) - 1;
                }
                TableToolkit.putIndices(chain, vh, vt);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String formatIndices(int[] indices) {
        if (indices == null || indices.length == 0) {
            return null;
        }
        String res = "";
        int head = indices[0] + 1;
        int tail = indices[0] + 1;
        int current = 0;
        for (int i = 0; i <= indices.length; ++i) {
            int n = current = i < indices.length ? indices[i] + 1 : tail + 2;
            if (current == tail) continue;
            if (current == tail + 1) {
                ++tail;
                continue;
            }
            res = tail == head ? res + String.valueOf(tail) : (tail - head == 1 ? res + String.valueOf(head) + ',' + String.valueOf(tail) : res + String.valueOf(head) + '-' + String.valueOf(tail));
            head = current;
            tail = current;
            if (i >= indices.length) continue;
            res = res + ',';
        }
        return res;
    }

    private static void putIndices(ArrayList res, int value) {
        Integer v = new Integer(value);
        if (res.indexOf(v) < 0) {
            res.add(v);
        }
    }

    private static void putIndices(ArrayList res, int head, int tail) {
        if (head > tail) {
            int tmp = head;
            head = tail;
            tail = tmp;
        }
        while (head <= tail) {
            TableToolkit.putIndices(res, head++);
        }
    }

    public static CellReference parsePosition(String pos) {
        if (pos == null) {
            return null;
        }
        if ((pos = pos.trim()).length() < 1) {
            return null;
        }
        String sheetName = null;
        Rect region = null;
        int nsn = pos.indexOf(33);
        if (nsn != -1) {
            int tsn;
            if (nsn < 1 || nsn == pos.length() - 1) {
                return null;
            }
            char c = pos.charAt(0);
            int ssn = c == '\'' ? 1 : 0;
            c = pos.charAt(nsn - 1);
            int n = tsn = c == '\'' ? nsn - 2 : nsn - 1;
            if (ssn <= tsn && (ssn == 1 && tsn == nsn - 2 || ssn == 0 && tsn == nsn - 1)) {
                sheetName = pos.substring(ssn, tsn + 1);
                pos = pos.substring(nsn + 1);
            } else {
                return null;
            }
        }
        return (region = TableToolkit.range2xy(pos)) != null ? new CellReference(sheetName, region) : null;
    }

    public static String formatReference(CellReference ref) {
        String sheetName;
        if (ref == null) {
            return null;
        }
        String sR = TableToolkit.xy2range(ref.region);
        if (sR == null) {
            return null;
        }
        String string = sheetName = ref.sheetName == null ? null : ref.sheetName.trim();
        if (sheetName != null && sheetName.length() == 0) {
            sheetName = null;
        }
        return sheetName != null ? sheetName + '!' + sR : sR;
    }

    public static String xy2range(Rect pos) {
        String sH = TableToolkit.xy2range(pos.x1, pos.y1);
        String sT = TableToolkit.xy2range(pos.x2, pos.y2);
        if (sH == null) {
            return sT;
        }
        return sT != null ? sH + ':' + sT : sH;
    }

    public static String xy2range(int x, int y) {
        ++y;
        String sX = TableToolkit.int2pos(x);
        if (sX == null) {
            return y >= 1 ? String.valueOf(y) : null;
        }
        return y >= 1 ? sX + String.valueOf(y) : sX;
    }

    public static Rect range2xy(String range) {
        if (range == null) {
            return null;
        }
        int len = (range = range.trim()).length();
        if (len == 0) {
            return null;
        }
        Rect rt = new Rect();
        rt.x1 = -1;
        rt.x2 = -1;
        rt.y1 = -1;
        rt.y2 = -1;
        if (RG_FULLTABLE.equalsIgnoreCase(range)) {
            rt.y1 = 0;
            rt.x1 = 0;
            rt.y2 = Integer.MAX_VALUE;
            rt.x2 = Integer.MAX_VALUE;
            return rt;
        }
        boolean isFirst = true;
        int head = 0;
        String sX1 = null;
        String sY1 = null;
        String sX2 = null;
        String sY2 = null;
        int where = -1;
        int preWhere = -1;
        for (int i = 0; i <= len; ++i) {
            if (i == len) {
                where = 4;
            } else {
                char ch = range.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    where = 1;
                } else if (ch == ':') {
                    where = 2;
                } else {
                    if (ch == ' ' || ch == '\t') continue;
                    if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                        where = 3;
                    } else {
                        return null;
                    }
                }
            }
            if (i > 0 && where != preWhere) {
                if (preWhere == 3) {
                    if (isFirst) {
                        sX1 = range.substring(head, i);
                    } else {
                        sX2 = range.substring(head, i);
                    }
                } else if (preWhere == 1 && where != 3) {
                    if (isFirst) {
                        sY1 = range.substring(head, i);
                        isFirst = false;
                    } else {
                        sY2 = range.substring(head, i);
                    }
                }
                head = i;
            }
            preWhere = where;
            if (where != 2) continue;
            isFirst = false;
        }
        rt.x1 = TableToolkit.pos2int(sX1);
        rt.x2 = TableToolkit.pos2int(sX2);
        try {
            rt.y1 = Integer.parseInt(sY1) - 1;
            if (rt.y1 < 0) {
                rt.y1 = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            rt.y2 = Integer.parseInt(sY2) - 1;
            if (rt.y2 < 0) {
                rt.y2 = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rt;
    }

    public static int pos2int(String pos) {
        if (pos == null) {
            return -1;
        }
        int len = (pos = pos.trim()).length();
        if (len == 0) {
            return -1;
        }
        int iValue = 0;
        for (int i = 0; i < len; ++i) {
            char ch = pos.charAt(i);
            if (ch < 'A' || ch > 'Z' && ch < 'a' || ch > 'z') {
                return -1;
            }
            if (ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            int V = ch - 97 + 1;
            int R = (int)Math.pow(26.0, len - i - 1);
            iValue += V * R;
        }
        return iValue - 1;
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int Q = intVal / 26;
            int R = intVal % 26;
            if (R < 1) {
                R = 26;
                --Q;
            }
            tmp[i--] = (char)(65 + R - 1);
            if (Q == 0) break;
            intVal = Q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static KDTSelectBlock rangeToBlock(String range) {
        int step = 0;
        Rect rt = null;
        rt = RG_FULLTABLE.equalsIgnoreCase(range) ? new Rect(-1, -1, -1, -1) : TableToolkit.range2xy(range);
        if (rt == null) {
            return null;
        }
        rt.normalize();
        KDTSelectBlock sb = new KDTSelectBlock();
        int mode = 1;
        if (rt.x1 == -1 && rt.y1 == -1) {
            rt.x1 = rt.x2;
            rt.y1 = rt.y2;
        }
        if (rt.x1 == -1 && rt.x2 == -1) {
            mode = 2;
            rt.x1 = 0;
            rt.x2 = 0;
            ++step;
        }
        if (rt.y1 == -1 && rt.y2 == -1) {
            mode = 4;
            rt.y1 = 0;
            rt.y2 = 0;
            ++step;
        }
        if (step == 2) {
            mode = 8;
        }
        sb.setTop(rt.y1);
        sb.setLeft(rt.x1);
        sb.setBottom(rt.y2);
        sb.setRight(rt.x2);
        sb.setMode(mode);
        return sb;
    }

    public static String blockToRange(KDTSelectBlock sb) {
        if (sb == null) {
            return null;
        }
        String rg = null;
        switch (sb.getMode()) {
            case 1: {
                if (sb.getLeft() == sb.getRight() && sb.getTop() == sb.getBottom()) {
                    rg = TableToolkit.xy2range(sb.getLeft(), sb.getTop());
                    break;
                }
                rg = TableToolkit.xy2range(new Rect(sb.getLeft(), sb.getTop(), sb.getRight(), sb.getBottom()));
                break;
            }
            case 2: {
                int y1 = sb.getTop() + 1;
                int y2 = sb.getBottom() + 1;
                if (y1 == y2) {
                    rg = String.valueOf(y1);
                    break;
                }
                rg = y1 + ":" + y2;
                break;
            }
            case 4: {
                if (sb.getLeft() == sb.getRight()) {
                    rg = TableToolkit.int2pos(sb.getLeft());
                    break;
                }
                rg = TableToolkit.xy2range(new Rect(sb.getLeft(), -1, sb.getRight(), -1));
                break;
            }
            case 8: {
                rg = RG_FULLTABLE;
                break;
            }
        }
        return rg;
    }

    public static ArrayList parseMulitFormula(String formulaLine) {
        ArrayList<String> mulitFormula = new ArrayList<String>();
        StringTokenizer stformulaLine = new StringTokenizer(formulaLine, "=+-/*");
        int i = 0;
        int stringPoint = 0;
        while (stformulaLine.hasMoreElements()) {
            String temp;
            if (i == 0) {
                temp = stformulaLine.nextToken();
                stringPoint = temp.length();
                mulitFormula.add(temp);
            } else {
                String previous = (String)mulitFormula.get(i - 1);
                if (!previous.endsWith(")")) {
                    mulitFormula.remove(i - 1);
                    --i;
                    temp = stformulaLine.nextToken();
                    String currToken = formulaLine.substring(stringPoint + 1, stringPoint + 2);
                    stringPoint = stringPoint + temp.length() + 1;
                    mulitFormula.add(previous + currToken + temp);
                } else {
                    temp = stformulaLine.nextToken();
                    stringPoint = temp.length();
                    mulitFormula.add(temp);
                }
            }
            ++i;
        }
        return mulitFormula;
    }

    public static FormulaHint parseFormula(String formulaLine) {
        char ch;
        int tail;
        char ch2;
        int head;
        if (formulaLine == null) {
            return null;
        }
        String prefix = "=+-(";
        for (head = 0; head < formulaLine.length() && (Character.isWhitespace(ch2 = formulaLine.charAt(head)) || prefix.indexOf(ch2) != -1); ++head) {
        }
        for (tail = head + 1; tail < formulaLine.length() && !Character.isWhitespace(ch = formulaLine.charAt(tail)) && ch != '('; ++tail) {
        }
        if (tail > formulaLine.length()) {
            tail = formulaLine.length();
        }
        String name = formulaLine.substring(head, tail);
        ArrayList<String> params = new ArrayList<String>(11);
        char[] param = new char[formulaLine.length()];
        boolean inQuota = false;
        boolean isQuotaData = false;
        int nBracket = 0;
        int pos = 0;
        block7: for (head = tail; head < formulaLine.length(); ++head) {
            int ch3 = formulaLine.charAt(head);
            if (ch3 == 34) {
                if (formulaLine.charAt(head - 1) == '\"') {
                    param[pos++] = 34;
                }
                boolean bl = inQuota = !inQuota;
                if (!inQuota) continue;
                isQuotaData = true;
                continue;
            }
            if (inQuota) {
                if (ch3 == 44) {
                    ch3 = 35;
                }
                param[pos++] = ch3;
                continue;
            }
            switch (ch3) {
                case 40: {
                    if (++nBracket <= 1) continue block7;
                    param[pos++] = 40;
                    continue block7;
                }
                case 41: {
                    if (--nBracket <= 0) {
                        String av = TableToolkit.getTrueParamValue(param, pos, isQuotaData);
                        if (av.length() != 0 || params.size() > 0) {
                            params.add(TableToolkit.getTrueParamValue(param, pos, isQuotaData));
                        }
                        isQuotaData = false;
                        pos = 0;
                        break block7;
                    }
                    param[pos++] = 41;
                    continue block7;
                }
                case 44: {
                    if (nBracket == 1) {
                        params.add(TableToolkit.getTrueParamValue(param, pos, isQuotaData));
                        isQuotaData = false;
                        pos = 0;
                        continue block7;
                    }
                    param[pos++] = 35;
                    continue block7;
                }
                default: {
                    if (Character.isWhitespace((char)ch3)) continue block7;
                    param[pos++] = ch3;
                }
            }
        }
        if (inQuota || nBracket != 0) {
            params.clear();
        }
        FormulaHint hint = new FormulaHint();
        hint.name = name;
        hint.params = new String[params.size()];
        hint.text = formulaLine;
        for (int i = 0; i < params.size(); ++i) {
            String v = (String)params.get(i);
            hint.params[i] = v.trim().replace('#', ',');
        }
        return hint;
    }

    public static List parseExcelFormula(String formulaLine, boolean justFunction) throws ParserException {
        try {
            ArrayList<FormulaHint> result = new ArrayList<FormulaHint>(1);
            if (formulaLine == null || formulaLine.length() < 1) {
                return null;
            }
            if (!formulaLine.startsWith("=")) {
                return null;
            }
            Expression expression = ExcelFormulaPaserHelper.parse(formulaLine);
            if (expression instanceof BinaryOperationExpr) {
                TableToolkit.walkTree(expression, result, justFunction);
            } else if (expression instanceof FunctionExpr) {
                FormulaHint formula = new FormulaHint();
                StringBuffer sb = new StringBuffer();
                expression.output(sb);
                formula.text = sb.toString();
                TableToolkit.readParams(((FunctionExpr)expression).parameters, formula);
                formula.name = ((FunctionExpr)expression).funcionName;
                result.add(formula);
            } else if (expression instanceof UnaryOperationExpr) {
                Expression curExpression = ((UnaryOperationExpr)expression).operand;
                if (curExpression instanceof BinaryOperationExpr) {
                    TableToolkit.walkTree(curExpression, result, justFunction);
                } else {
                    FormulaHint formula = new FormulaHint();
                    StringBuffer sb = new StringBuffer();
                    expression.output(sb);
                    formula.text = sb.toString();
                    if (((UnaryOperationExpr)expression).operand instanceof FunctionExpr) {
                        TableToolkit.readParams(((FunctionExpr)((UnaryOperationExpr)expression).operand).parameters, formula);
                        formula.name = ((FunctionExpr)((UnaryOperationExpr)expression).operand).funcionName;
                    }
                    result.add(formula);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ParserException("007", formulaLine, RptUtil.getResourceSince51("FormulaError"), (Throwable)e);
        }
    }

    public static List parseFormula(String formulaLine, boolean justFunction) throws ParserException {
        ArrayList<FormulaHint> result = new ArrayList<FormulaHint>(1);
        try {
            if (formulaLine == null || formulaLine.length() < 1) {
                return null;
            }
            if (formulaLine.charAt(0) != '=') {
                return null;
            }
            formulaLine = "value" + formulaLine;
            if (formulaLine.charAt(formulaLine.length() - 1) != ';') {
                formulaLine = formulaLine + ";";
            }
            ExprStmt stmt = RptFormulaParser.parse(formulaLine);
            BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
            CodeExpr codeExpr = expr.right;
            if (codeExpr instanceof BinaryOpExpr) {
                TableToolkit.walkSyntaxTree(codeExpr, result, justFunction);
            } else if (codeExpr instanceof MethodInvokeExpr) {
                FormulaHint formula = new FormulaHint();
                StringBuffer sb = new StringBuffer();
                codeExpr.output(sb);
                formula.text = sb.toString();
                TableToolkit.readParamList(((MethodInvokeExpr)codeExpr).paramList, formula);
                formula.name = ((MethodInvokeExpr)codeExpr).methodName;
                result.add(formula);
            } else if (!justFunction) {
                codeExpr.getClass();
            }
        }
        catch (ParserException e) {
            result.add(TableToolkit.parseFormula(formulaLine));
        }
        return result;
    }

    private static void walkSyntaxTree(CodeExpr expr, List formulaList, boolean justFunction) {
        if (expr instanceof BinaryOpExpr) {
            StringBuffer sb;
            FormulaHint formula;
            CodeExpr left = ((BinaryOpExpr)expr).left;
            CodeExpr right = ((BinaryOpExpr)expr).right;
            if (right instanceof MethodInvokeExpr) {
                formula = new FormulaHint();
                sb = new StringBuffer();
                right.output(sb);
                formula.text = sb.toString();
                formula.name = ((MethodInvokeExpr)right).methodName;
                TableToolkit.readParamList(((MethodInvokeExpr)right).paramList, formula);
                formulaList.add(formula);
            } else {
                TableToolkit.walkSyntaxTree(right, formulaList, justFunction);
            }
            if (left instanceof MethodInvokeExpr) {
                formula = new FormulaHint();
                sb = new StringBuffer();
                left.output(sb);
                formula.text = sb.toString();
                formula.name = ((MethodInvokeExpr)left).methodName;
                TableToolkit.readParamList(((MethodInvokeExpr)left).paramList, formula);
                formulaList.add(formula);
            } else {
                TableToolkit.walkSyntaxTree(left, formulaList, justFunction);
            }
        }
    }

    private static String[] readParamList(List paramList, FormulaHint formula) {
        if (paramList == null || paramList.size() < 1) {
            return null;
        }
        String[] result = new String[paramList.size()];
        int[] types = new int[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            CodeExpr expr = (CodeExpr)paramList.get(i);
            result[i] = expr instanceof com.kingdee.bos.kscript.dom.expr.StringExpr ? ((com.kingdee.bos.kscript.dom.expr.StringExpr)expr).text : (expr instanceof IntExpr ? ((IntExpr)expr).text : expr.toString());
            types[i] = expr.exprType;
        }
        formula.params = result;
        formula.setParamType(types);
        return result;
    }

    private static void walkTree(Expression expr, List formulaList, boolean justFunction) {
        if (expr instanceof BinaryOperationExpr) {
            StringBuffer sb;
            FormulaHint formula;
            Expression left = ((BinaryOperationExpr)expr).left;
            Expression right = ((BinaryOperationExpr)expr).right;
            if (right instanceof FunctionExpr) {
                formula = new FormulaHint();
                sb = new StringBuffer();
                right.output(sb);
                formula.text = sb.toString();
                formula.name = ((FunctionExpr)right).funcionName;
                TableToolkit.readParams(((FunctionExpr)right).parameters, formula);
                formulaList.add(formula);
            } else {
                TableToolkit.walkTree(right, formulaList, justFunction);
            }
            if (left instanceof FunctionExpr) {
                formula = new FormulaHint();
                sb = new StringBuffer();
                left.output(sb);
                formula.text = sb.toString();
                formula.name = ((FunctionExpr)left).funcionName;
                TableToolkit.readParams(((FunctionExpr)left).parameters, formula);
                formulaList.add(formula);
            } else {
                TableToolkit.walkTree(left, formulaList, justFunction);
            }
        }
    }

    public static boolean isValidStmt(String txt) {
        try {
            if (StringUtils.isEmpty((String)txt)) {
                return false;
            }
            txt = txt.charAt(0) == '=' ? "value" + txt + ';' : "value=" + txt + ';';
            ExprStmt stmt = RptFormulaParser.parse(txt);
            if (((BinaryOpExpr)stmt.expr).right instanceof IdentifierExpr) {
                return false;
            }
        }
        catch (ParserException e) {
            return false;
        }
        return true;
    }

    private static String[] readParams(List paramList, FormulaHint formula) {
        if (paramList == null || paramList.size() < 1) {
            return null;
        }
        String[] result = new String[paramList.size()];
        int[] types = new int[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            Expression expr = (Expression)paramList.get(i);
            result[i] = expr instanceof StringExpr ? ((StringExpr)expr).value : expr.toString();
            if (expr instanceof ReferenceExpr || expr instanceof AreaExpr) {
                types[i] = 33;
                continue;
            }
            if (!(expr instanceof Ref3DExpr) && !(expr instanceof Area3DExpr)) continue;
            types[i] = 34;
        }
        formula.params = result;
        formula.setParamType(types);
        return result;
    }

    private static String getTrueParamValue(char[] param, int length, boolean isQuotaData) {
        if (param == null || length < 0) {
            return "";
        }
        String res = new String(param, 0, length);
        if (isQuotaData) {
            if ("\"".equals(res)) {
                res = "";
            }
            return res;
        }
        char[] matchs = new char[]{'(', ')', ','};
        for (int i = 0; i < matchs.length; ++i) {
            if (res.indexOf(matchs[i]) == -1) continue;
            return "";
        }
        CellReference ref = TableToolkit.parsePosition(res);
        if (ref != null) {
            if (ref.sheetName == null && ref.region.x1 == -1 && ref.region.x2 == -1 && ref.region.y2 == -1) {
                return res;
            }
            return "," + res;
        }
        return res;
    }

    public static String formatExpression(String expr) {
        if (expr == null) {
            return "";
        }
        String res = expr;
        int mid = expr.indexOf(61);
        if (mid > 0 && mid < expr.length()) {
            String head = expr.substring(0, mid);
            String tail = expr.substring(mid + 1);
            res = "((" + head + ")-(" + tail + "))";
        }
        return res;
    }

    public static boolean isValidSheetName(String name) {
        if (name == null || name.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = name.length() - 1; i > 0; --i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllTable(Rect region) {
        if (region == null) {
            return false;
        }
        return region.x1 == 0 && region.y1 == 0 && region.x2 == Integer.MAX_VALUE && region.y2 == Integer.MAX_VALUE;
    }

    public static Point getHotPoint(KDTSelectBlock selectBlock) {
        if (selectBlock == null) {
            return null;
        }
        int x = 0;
        int y = 0;
        switch (selectBlock.getMode()) {
            case 8: {
                y = 0;
                x = 0;
                break;
            }
            case 2: {
                x = 0;
                y = selectBlock.getTop();
                break;
            }
            case 4: {
                x = selectBlock.getLeft();
                y = 0;
                break;
            }
            case 1: {
                x = selectBlock.getLeft();
                y = selectBlock.getTop();
            }
        }
        return new Point(x, y);
    }

    public static boolean isFormulaLine(String text) {
        return text != null && text.length() > 1 && text.charAt(0) == '=';
    }

    public static boolean isChangedFormula(String lhv, String rhv) {
        int ps = RptUtil.comparePointers(lhv, rhv);
        if (ps == 0) {
            return false;
        }
        if (ps != 1) {
            return lhv != null ? TableToolkit.isFormulaLine(lhv) : TableToolkit.isFormulaLine(rhv);
        }
        return TableToolkit.isFormulaLine(lhv) && TableToolkit.isFormulaLine(rhv) && !lhv.equals(rhv);
    }

    public static int parsePostfixNumber(String line) {
        int lst;
        int n = lst = line == null ? -1 : line.length() - 1;
        if (lst < 0) {
            return -1;
        }
        char[] buf = new char[lst + 1];
        while (lst >= 0) {
            char ch = line.charAt(lst);
            if (!Character.isDigit(ch)) {
                ++lst;
                break;
            }
            buf[lst--] = ch;
        }
        if (lst < 0) {
            lst = 0;
        }
        Integer num = null;
        try {
            num = Integer.valueOf(new String(buf, lst, buf.length - lst));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num == null ? -1 : num;
    }

    public static AcctountAsstItemParser.AccountAsstItem parseAcctItem(String strAcctItem) throws ParseException {
        return AcctountAsstItemParser.parse(strAcctItem);
    }

    public static void main(String[] args) throws ParserException, ParseException {
        String s = "1151|002|supplierGroupStandard#66:CC.01&003#222&002#G002#";
        TableToolkit.range2xy("a5");
    }

    public static boolean isCorrectSingleCellSelect(String str) {
        if (str != null && (str.indexOf(",") > 0 || str.indexOf(":") > 0)) {
            return false;
        }
        if (!TableToolkit.isCellRef(str)) {
            return false;
        }
        Rect rect = null;
        rect = str.indexOf("!") >= 0 ? TableToolkit.range2xy(str.substring(str.indexOf("!") + 1)) : TableToolkit.range2xy(str);
        return rect != null && rect.x1 >= 0 && rect.y1 >= 0;
    }
}

