/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AbstractSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.AbstractSortState;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.ICombineRowSetHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.RowSetCombineHandler;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountWildcarQuery {
    private static final String RPT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fi.rpt.RPTAutoGenerateResource";
    private static Logger logger = Logger.getLogger(AccountWildcarQuery.class);
    private static final Comparator itemComparator = new AsstActTypeComarator();
    private static final int BATCH_SIZE = 50;
    private List formulaList = new ArrayList();
    private List expandFormulaList = new ArrayList();
    private List assistItemWildcarFormulaList = new ArrayList();
    private BatchHelper batchHelper;
    private BatchSQLSorterRegister register;
    private Context context;

    public AccountWildcarQuery(Context context) {
        this.context = context;
        this.batchHelper = new BatchHelper(context);
        this.register = new BatchSQLSorterRegister(new HashMap());
        this.register.setSortState(new AccountWildcarQuerySortState());
    }

    public void addFormula(AcctCalculaterExt acct) {
        this.formulaList.add(acct);
        if (!acct.isAccountHasWildcar() && acct.isItemHasWildcar()) {
            acct.setACCTValue((Object)new BigDecimal("0"));
            this.expandFormulaList.add(acct);
            this.assistItemWildcarFormulaList.add(acct);
        } else if (acct.isAccountHasWildcar()) {
            this.register.register((IFormulaCalculator)acct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAccountWildcarQuery() throws BOSException {
        try {
            RowSetCombineHandler combineHandler = new RowSetCombineHandler(new ICombineRowSetHandler(){

                @Override
                public void processRowSet(IRowSet rs, IFormulaCalculator formula, IBatchSQLProcessor sqlBuilder) throws SQLException {
                    AcctCalculaterExt acctExt = (AcctCalculaterExt)formula;
                    String accountNumber = rs.getString("FNumber");
                    if (accountNumber.matches(acctExt.getAccountItem().startAccount.getAccountNumber().replace('*', '.'))) {
                        acctExt.getAccountItem().startAccount.setHasWildcarExpand(true);
                        AcctountAsstItemParser.AccountAsstItem accountAsstItem = acctExt.getAccountItem().getAccountAsstItem();
                        AcctStruct dumpStrct = acctExt.getStruct().copy();
                        accountAsstItem.endNumber = accountAsstItem.startNumber = accountNumber;
                        dumpStrct.setAccountItem(accountAsstItem.toOldString());
                        AcctCalculaterExt expandAcctExt = AccountWildcarQuery.this.newAcctCalculaterExt(dumpStrct, acctExt, true);
                        AccountWildcarQuery.this.expandFormulaList.add(expandAcctExt);
                        if (acctExt.isItemHasWildcar()) {
                            AccountWildcarQuery.this.assistItemWildcarFormulaList.add(expandAcctExt);
                        }
                    }
                }
            });
            this.batchHelper.batchCalculateBigDecimalBySorter(new AccountWildcarQuerySQLProcessor(), this.register, combineHandler);
            for (IBatchSQLSortState state : this.register.getSortStates()) {
                this.checkAccountWildcarExpand(state.getFormulaList());
            }
        }
        finally {
            this.register.clearRegister();
        }
    }

    private Map getAssistItemWildcarFormulaItemType() {
        HashMap<String, AsstActType> itemTypeMap = new HashMap<String, AsstActType>();
        for (AcctCalculaterExt acctExt : this.assistItemWildcarFormulaList) {
            for (AssistantItemExt assistantItem : acctExt.getAccountItem().itemValues()) {
                if (itemTypeMap.keySet().contains(assistantItem.getItemTypeNumber())) continue;
                itemTypeMap.put(assistantItem.getItemTypeNumber(), assistantItem.itemType);
            }
        }
        return itemTypeMap;
    }

    private void executeAssistantItemWildcarQuery() throws BOSException {
        if (this.assistItemWildcarFormulaList.isEmpty()) {
            return;
        }
        Map itemTypeMap = this.getAssistItemWildcarFormulaItemType();
        Iterator it = itemTypeMap.values().iterator();
        while (it.hasNext()) {
            ArrayList paramList = new ArrayList();
            AsstActType asstActType = (AsstActType)it.next();
            if (!this.isNeedExpandAsstActType(asstActType)) continue;
            StringBuffer kqlBuffer = new StringBuffer();
            kqlBuffer.append("SELECT asstActType.FNumber AS FNumber FROM ").append(asstActType.realtionDataObject).append(" asstActType WHERE (");
            ArrayList<AcctCalculaterExt> batchList = new ArrayList<AcctCalculaterExt>();
            ArrayList<AcctCalculaterExt> expandAssistantItemList = new ArrayList<AcctCalculaterExt>();
            ArrayList<String> paramVarList = new ArrayList<String>();
            HashSet<String> paramVarSet = new HashSet<String>();
            boolean isFirst = true;
            StringBuffer itemNumberBuffer = new StringBuffer();
            Iterator iter = this.assistItemWildcarFormulaList.iterator();
            while (iter.hasNext()) {
                AcctCalculaterExt acctExt = (AcctCalculaterExt)iter.next();
                AssistantItemExt assistantItem = (AssistantItemExt)acctExt.getAccountItem().getItem(asstActType.number);
                if (assistantItem == null || assistantItem.startItem == null || !assistantItem.startItem.isHasWildcar) {
                    expandAssistantItemList.add(acctExt);
                } else {
                    String acctItem = assistantItem.startItem.number.replace('*', '_');
                    boolean isContainsItem = paramVarSet.contains(acctItem);
                    if (!isFirst && !isContainsItem) {
                        itemNumberBuffer.append(" OR ");
                    } else {
                        isFirst = false;
                    }
                    if (!isContainsItem) {
                        itemNumberBuffer.append(" asstActType.FNumber LIKE ? ");
                        paramVarList.add(acctItem);
                        paramVarSet.add(acctItem);
                    }
                    batchList.add(acctExt);
                }
                if (paramVarList.size() <= 50 && iter.hasNext() || batchList.size() <= 0) continue;
                StringBuffer executeSQLBuffer = new StringBuffer();
                executeSQLBuffer.append(kqlBuffer).append(itemNumberBuffer);
                executeSQLBuffer.append(")");
                ArrayList exeParamList = new ArrayList();
                exeParamList.addAll(paramList);
                exeParamList.addAll(paramVarList);
                IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)executeSQLBuffer.toString(), (Object[])exeParamList.toArray());
                try {
                    if (rowSet.size() == 0) {
                        acctExt.setACCTValue((Object)new BigDecimal("0"));
                    }
                    while (rowSet.next()) {
                        String fnumber = rowSet.getString("FNumber");
                        this.expandAssistantItemFormula(batchList, fnumber, asstActType.number, expandAssistantItemList);
                    }
                }
                catch (SQLException ex) {
                    throw new SQLDataException(ex);
                }
                batchList.clear();
                itemNumberBuffer.setLength(0);
                paramVarList.clear();
                paramVarSet.clear();
                isFirst = true;
                if (iter.hasNext()) continue;
                this.assistItemWildcarFormulaList = expandAssistantItemList;
            }
        }
        if (!this.assistItemWildcarFormulaList.isEmpty()) {
            this.expandFormulaList.removeAll(this.assistItemWildcarFormulaList);
            this.expandFormulaList.addAll(this.assistItemWildcarFormulaList);
        }
    }

    private void expandAssistantItemFormula(List formulaList, String itemNumber, String itemTypeNumber, List expandAssistantItemList) {
        for (AcctCalculaterExt acctExt1 : formulaList) {
            AssistantItem assistantItem1 = acctExt1.getAccountItem().getItem(itemTypeNumber);
            if (assistantItem1 == null || !itemNumber.matches(assistantItem1.startItem.number.replace('*', '.'))) continue;
            if (this.expandFormulaList.contains(acctExt1)) {
                this.expandFormulaList.remove(acctExt1);
            }
            assistantItem1.setHasWildcarExpand(true);
            AcctStruct dumpStrct = acctExt1.getStruct().copy();
            AcctountAsstItemParser.AsstItem[] asstItem = acctExt1.getAccountItem().getAccountAsstItem().asstItems;
            for (int i = 0; i < asstItem.length; ++i) {
                if (!itemTypeNumber.equalsIgnoreCase(asstItem[i].asstTypeNumber)) continue;
                asstItem[i].startNumber = itemNumber;
                asstItem[i].endNumber = itemNumber;
            }
            dumpStrct.setAccountItem(acctExt1.getAccountItem().getAccountAsstItem().toOldString());
            AcctCalculaterExt expandAcctExt = this.newAcctCalculaterExt(dumpStrct, acctExt1, false);
            expandAssistantItemList.add(expandAcctExt);
        }
    }

    private boolean isNeedExpandAsstActType(AsstActType itemType) {
        if (itemType.realtionDataObject == null) {
            return false;
        }
        return RptUtil.isUseLongNumber(itemType.useLongNumber, itemType.realtionDataObject) && !"T_BD_GeneralAsstActType".equalsIgnoreCase(itemType.realtionDataObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWildcarQuery() throws BOSException {
        try {
            long startExpandAccount = System.currentTimeMillis();
            this.executeAccountWildcarQuery();
            DebugLogger.info(logger, "expandAccount time", new Long(System.currentTimeMillis() - startExpandAccount));
            long startExpandAssistantItem = System.currentTimeMillis();
            this.executeAssistantItemWildcarQuery();
            DebugLogger.info(logger, "expandAssistantItem time", new Long(System.currentTimeMillis() - startExpandAssistantItem));
            DebugLogger.info(logger, "expandFormulaSize: " + this.getExpandFormulaList().size());
        }
        catch (Exception ex) {
            logger.info((Object)ex);
            for (AcctCalculaterExt acctExt : this.formulaList) {
                acctExt.setACCTValue((Object)ex);
            }
            this.expandFormulaList.clear();
        }
        finally {
            this.assistItemWildcarFormulaList.clear();
        }
    }

    private void checkAccountWildcarExpand(List formulaList) {
        for (AcctCalculaterExt acctExt : formulaList) {
            Object value = acctExt.getParameter().getValue();
            if (acctExt.getAccountItem().startAccount.isHasWildcarExpand() || value instanceof Exception || value instanceof String && ((String)value).startsWith(ExprErr.getString((long)128L))) continue;
            acctExt.setACCTValue((Object)new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{EASResource.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"28_AcctBatchCalculaterNew")}));
        }
    }

    private AcctCalculaterExt newAcctCalculaterExt(AcctStruct acctStruct, AcctCalculaterExt acctExt, boolean isAccountExpand) {
        AcctCalculaterExt expandAcctExt = new AcctCalculaterExt(acctStruct, acctExt.getStruct().getBackFiller());
        if (!isAccountExpand) {
            try {
                expandAcctExt.getAccountItem().parseAcctItem(acctStruct.getAccountItem());
            }
            catch (ReportException ex) {
                expandAcctExt.setACCTValue((Object)ex);
            }
            catch (ParseException ex) {
                expandAcctExt.setACCTValue((Object)new ReportException(ReportException.ACCOUNT_PARSE_ERROR));
            }
        }
        for (AssistantItemExt assistantItem : acctExt.getAccountItem().itemValues()) {
            expandAcctExt.getAccountItem().setItemType(assistantItem.itemType);
        }
        expandAcctExt.setItemHasWildcar(acctExt.isItemHasWildcar());
        expandAcctExt.setCurrency(acctExt.getCurrency());
        expandAcctExt.setCompany(acctExt.getCompany());
        expandAcctExt.setAcctBatchQueryService(acctExt.getAcctBatchQueryService());
        expandAcctExt.setContext(acctExt.getContext());
        expandAcctExt.setAccountTable(acctExt.getAccountTable());
        expandAcctExt.setCorrectAccountTable(acctExt.isCorrectAccountTable());
        return expandAcctExt;
    }

    public List getExpandFormulaList() {
        return this.expandFormulaList;
    }

    class AccountWildcarQuerySQLProcessor
    extends AbstractSQLProcessor {
        AccountWildcarQuerySQLProcessor() {
        }

        @Override
        public void buildSelectPart(Set nullSet, StringBuffer sql) {
            sql.append("SELECT account.FNumber FNumber    \n");
        }

        @Override
        public void buildFromPart(Set nullSet, StringBuffer sql) {
            sql.append("FROM T_BD_AccountView account     \n");
            AccountWildcarQuerySortState accountWildcarQuerySortState = (AccountWildcarQuerySortState)this.sortState;
            if (!accountWildcarQuerySortState.itemList.isEmpty()) {
                if (accountWildcarQuerySortState.isIncludeDetailAccountAsstItem) {
                    sql.append(" INNER JOIN T_BD_AccountView leafAccount ON charindex(account.FNumber,leafAccount.FNumber) = 1              \n").append(" AND leafAccount.FCompanyID = account.FCompanyID AND leafAccount.FAccountTableID = account.FAccountTableID     \n");
                }
                for (String itemType : accountWildcarQuerySortState.itemList) {
                    String asstAccountAlias = "asstAccount" + itemType;
                    String relAlias = "rel" + itemType;
                    String asstActTypeAlias = "asstActType" + itemType;
                    sql.append(" INNER JOIN T_BD_AsstAccount ").append(asstAccountAlias).append(" ON account.FCaa = ").append(asstAccountAlias).append(".FID \n").append(" INNER JOIN T_BD_AsstActGroupDetail ").append(relAlias).append(" ON ").append(asstAccountAlias).append(".FID = ").append(relAlias).append(".FAsstAccountID \n").append(" INNER JOIN T_BD_AsstActType ").append(asstActTypeAlias).append(" ON ").append(asstActTypeAlias).append(".FID = ").append(relAlias).append(".FAsstActTypeID \n").append(" AND ").append(asstActTypeAlias).append(".FNumber = '").append(itemType).append("'\n");
                }
            }
        }

        @Override
        public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
            AccountWildcarQuerySortState accountWildcarQuerySortState = (AccountWildcarQuerySortState)this.sortState;
            sql.append(" WHERE account.FCompanyID = ? AND account.FAccountTableID = ?  \n");
            params.add(accountWildcarQuerySortState.companyId);
            params.add(accountWildcarQuerySortState.accountTableId);
            sql.append(" AND (");
        }

        @Override
        public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
            AcctCalculaterExt acct = (AcctCalculaterExt)formula;
            sql.append(" account.FNumber LIKE ?");
            params.add(acct.getAccountItem().startAccount.getAccountNumber().replace('*', '_'));
        }

        @Override
        public void buildGroupByPart(Set nullSet, StringBuffer sql) {
            sql.append(") GROUP BY account.FNumber");
        }
    }

    class AccountWildcarQuerySortState
    extends AbstractSortState {
        private String companyId;
        private String accountTableId;
        private List itemList;
        private boolean isIncludeDetailAccountAsstItem;

        AccountWildcarQuerySortState() {
        }

        @Override
        public void setState(IFormulaCalculator formula) {
            AcctCalculaterExt acct = (AcctCalculaterExt)formula;
            this.companyId = acct.getCompany().getId().toString();
            this.accountTableId = acct.getAccountTable().getId().toString();
            this.itemList = new ArrayList(acct.getAccountItem().itemSet());
            Collections.sort(this.itemList, itemComparator);
            this.isIncludeDetailAccountAsstItem = acct.isIncludeDetailAccountAsstItem();
        }

        @Override
        public String generateKey() {
            StringBuffer key = new StringBuffer();
            key.append("[").append(this.companyId).append("]");
            key.append("[").append(this.accountTableId).append("]");
            if (!this.itemList.isEmpty()) {
                key.append("[");
                for (String item : this.itemList) {
                    key.append("|").append(item);
                }
                key.append("]");
            }
            key.append("[").append(this.isIncludeDetailAccountAsstItem ? "1" : "0").append("]");
            return key.toString();
        }

        @Override
        public Object clone() {
            AccountWildcarQuerySortState sortState = new AccountWildcarQuerySortState();
            sortState.companyId = this.companyId;
            sortState.accountTableId = this.accountTableId;
            sortState.itemList = this.itemList;
            sortState.isIncludeDetailAccountAsstItem = this.isIncludeDetailAccountAsstItem;
            return sortState;
        }

        @Override
        public void reset() {
            this.companyId = null;
            this.accountTableId = null;
            this.itemList = null;
            this.isIncludeDetailAccountAsstItem = false;
        }
    }
}

