/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.AcctFormula.comm;

import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.Solution;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectField;
import com.kingdee.eas.fi.rpt.batchquery.sql.SelectFieldCollection;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;

public class MaterialGroupQuerySolution
extends Solution {
    public MaterialGroupQuerySolution(Connection _conn) {
        super(_conn);
    }

    @Override
    public boolean configAutoItemIsNeedGroupBy() {
        return false;
    }

    @Override
    public WhereItems configStaticWherePart() {
        WhereItems ws = new WhereItems();
        ws.addItem(new WhereItem("G.FGroupStandard = S.FID"));
        return ws;
    }

    @Override
    public String configFromPart() {
        return "T_BD_MaterialGroup G, T_BD_MaterialGroupStandard S";
    }

    public void add(GroupTreeNode item, String stdid) {
        AssistantGroupQueryObject qo = new AssistantGroupQueryObject(item, stdid);
        try {
            this.configQueryObjectToSolution(qo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class AssistantGroupQueryObject
    extends IQueryObject {
        GroupTreeNode _group = null;
        String _standardID = null;

        public AssistantGroupQueryObject(GroupTreeNode group, String stdid) {
            this._group = group;
            this._standardID = stdid;
        }

        @Override
        public WhereItems configWhereItems() {
            WhereItems w = new WhereItems();
            w.addItem(new WhereItem("G.FNumber", this._group.number));
            w.addItem(new WhereItem("S.FID", this._standardID));
            return w;
        }

        @Override
        public String[] configDefaultKeys() {
            String[] keys = new String[]{this._group.number + "|" + this._standardID, this._group.number + "|" + this._standardID};
            return keys;
        }

        @Override
        public SelectFieldCollection configSelectFields() {
            SelectFieldCollection sc = new SelectFieldCollection();
            sc.addSelectField(new SelectField("G.FID", "FID"));
            sc.addSelectField(new SelectField("G.FNumber", "FNumber"));
            sc.addSelectField(new SelectField("G.FLongNumber", "FLongNumber"));
            sc.addSelectField(new SelectField("G.FLevel", "FLevel"));
            sc.addSelectField(new SelectField("S.FID", "SFID"));
            return sc;
        }

        @Override
        public void fillValueObject(Object value) {
        }

        @Override
        public void fillValueList(Object[] value) {
            this._group.number = value[1].toString();
            this._group.longNumber = value[2].toString();
            this._group.level = ((Number)value[3]).intValue();
        }
    }
}

