/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.PsSql;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctItemCalcuter {
    private static final Logger log = Logger.getLogger((String)AcctItemCalcuter.class.getName());
    private ICalculateContextProvider context;
    private Context ServerCtx = null;
    private ChecFmlParamPermissionUtil checkTool;
    private HashMap itemFromToMap = new HashMap();
    private HashMap acctItemIndexMap = new HashMap();
    private HashMap orgTreeId = new HashMap();
    private Map bgOrgCache = new HashMap();
    public static final int NORMAL = 1;
    public static final int CHECK_ITEM = 2;
    public static final int CHECK_ACCTITEM = 3;
    private int calcType = 1;
    List tempSql = new ArrayList();
    private int unionRecordSize = 50;
    public PeriodCollection periods = null;
    public boolean isMergeByFiscalPeriod = false;
    public boolean isSupport13Period = false;
    private HashMap tables = new HashMap();
    Map baseOrgTree = new HashMap();
    private String treeNumber = null;

    public AcctItemCalcuter(ICalculateContextProvider calContext, Context _serverCtx) {
        this.context = calContext;
        this.ServerCtx = _serverCtx;
        this.checkTool = ChecFmlParamPermissionUtil.getInstance(calContext);
    }

    public int getCalcType() {
        return this.calcType;
    }

    public void setCalcType(int calcType) {
        this.calcType = calcType;
    }

    public void execute(SortedParameterArray params) {
        this.initBatchSize();
        int keyCount = 0;
        this.isMergeByFiscalPeriod = CSLParamUtil.getSysParamBoolValFromContext((Context)this.ServerCtx, (String)"GR_CSL_MergeByFiscalPeriod", (boolean)true);
        boolean isSupportOtherDS = CSLParamUtil.getSysParamBoolValFromContext((Context)this.ServerCtx, (String)"GR_CSL_SupportOtherDS", (boolean)true);
        this.isSupport13Period = CSLParamUtil.getSysParamBoolValFromContext((Context)this.ServerCtx, (String)"GR_CSL_Support13Period", (boolean)true);
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.ServerCtx, (ICalculateContextProvider)this.context);
        }
        HashMap checkPermission = new HashMap();
        for (int i = 0; i < params.size(); ++i) {
            AcctItem acctItem;
            block19: {
                Parameter _param = params.getParameter(i);
                boolean checkParamPass = true;
                int length = _param.getArgs().length;
                for (int j = 4; j < length; ++j) {
                    Object pn = _param.getArgs()[j];
                    if (pn != null && pn.toString().trim().length() != 0 || j == 14) continue;
                    checkParamPass = false;
                    break;
                }
                acctItem = new AcctItem(params.getParameter(i), this.isSupport13Period);
                if (acctItem.isSubmit) continue;
                if (StringUtils.isEmpty((String)acctItem._orgBound)) {
                    acctItem.value.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"42_AcctItemCalcuter", (Locale)this.ServerCtx.getOriginLocale())}));
                    acctItem.submit();
                    continue;
                }
                if (!checkParamPass) {
                    acctItem.value.setException(new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"43_AcctItemCalcuter", (Locale)this.ServerCtx.getOriginLocale())}));
                    acctItem.submit();
                    continue;
                }
                if (this.getCalcType() == 2 || this.getCalcType() == 3) {
                    acctItem._commitStatus = -1;
                }
                try {
                    if (this.checkTool == null) break block19;
                    Integer isAdjustReport = (Integer)this.context.getReportAdapter().getReportProperty("isAdjustReport");
                    if (isAdjustReport == null || isAdjustReport != 1) {
                        int m;
                        if (acctItem._dataSource.length == 1 && this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number") == null && (!(this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) && (acctItem._dataSource[0] == 1 || acctItem._dataSource[0] == 7) || this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter && acctItem.isConvertedCompany)) {
                            for (m = 0; m < acctItem.companysForPermissionCheck.length; ++m) {
                                this.checkTool.checkCompanyPermision(acctItem.companysForPermissionCheck[m]);
                            }
                        } else {
                            for (m = 0; m < acctItem.companysForPermissionCheck.length; ++m) {
                                this.checkTool._checkUnitCompPermision(acctItem._orgBound, acctItem.companysForPermissionCheck[m]);
                            }
                            this.checkTool.checkOrgTreePremision(acctItem._orgBound);
                        }
                    }
                    if (!isSupportOtherDS) break block19;
                    CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)this.ServerCtx, (String)this.ServerCtx.getCaller().toString(), (String)acctItem._dataCollect, checkPermission);
                }
                catch (Throwable a) {
                    acctItem.value.setException(a);
                    acctItem.submit();
                    continue;
                }
            }
            acctItem.acctItemId = Integer.toString(i);
            if (acctItem.isSubmit()) continue;
            ArrayList<AcctItem> tempList = (ArrayList<AcctItem>)this.itemFromToMap.get(acctItem._itemNumberStart + "|" + acctItem._itemNumberEnd);
            if (tempList == null) {
                tempList = new ArrayList<AcctItem>();
                this.itemFromToMap.put(acctItem._itemNumberStart + "|" + acctItem._itemNumberEnd, tempList);
                ++keyCount;
                this.tempSql.add(" select '" + acctItem._itemNumberStart + "' as startItem , '" + acctItem._itemNumberEnd + "' as endItem  \r\n");
            }
            tempList.add(acctItem);
            tempList = (ArrayList<AcctItem>)this.orgTreeId.get(acctItem.getOrgBoundKey());
            if (tempList == null) {
                tempList = new ArrayList<AcctItem>();
                this.orgTreeId.put(acctItem.getOrgBoundKey(), tempList);
            }
            tempList.add(acctItem);
            this.acctItemIndexMap.put(acctItem.acctItemId, acctItem);
        }
        try {
            if (this.acctItemIndexMap.size() < 1) {
                return;
            }
            this.queryMapField();
            this.queryOrgTreeId();
            this.check();
            this.queryItemDataEntryIDs();
            this.queryData();
            this.submitData();
        }
        catch (Exception e) {
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)new SyntaxErrorException(128L, (Object)e));
            }
        }
    }

    private void check() {
        Iterator it = this.acctItemIndexMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            AcctItem acct = (AcctItem)en.getValue();
            if (acct.orgBoundAllVersList != null && acct.orgBoundAllVersList.size() >= 1) continue;
            acct.setValue(CslConstant.BGZERO, 0);
            acct.submit();
            it.remove();
        }
    }

    private void queryItemDataEntryIDs() throws SQLException, BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append(" from T_CSL_ItemDataEntry ItemDataBd  \r\n");
        buf.append(" inner join T_CSL_ItemData  ItemDataHd on ItemDataBd.FItemDataID = ItemDataHd.FID \r\n");
        buf.append(" Inner join T_Csl_RptReceived Received on Received.FReportID = ItemDataHd.FReportID \r\n");
        buf.append(" left outer join T_ORG_BaseUnit company on ItemDataHd.FCompanyID = company.FID \r\n");
        buf.append(" left outer join T_BD_Currency cur on ItemDataHd.FCurrencyID = cur.FID \r\n");
        buf.append(" left outer join T_BD_Currency tgtcur on ItemDataHd.FTargetCurrencyID = tgtcur.FID \r\n");
        buf.append(" where \r\n");
        long sqlMaxSize = 61440L;
        int maxParams = 1600;
        Iterator itl = this.orgTreeId.values().iterator();
        boolean isAdjustSeparate = false;
        try {
            isAdjustSeparate = CSLParamUtil.getSysParamBoolValFromContext((Context)this.ServerCtx, (String)"GR_CSL_AdjustSeparate", (boolean)true);
        }
        catch (Exception e1) {
            log.debug((Object)e1.getMessage());
        }
        while (itl.hasNext()) {
            StringBuffer tempBuf = new StringBuffer();
            ArrayList param = new ArrayList(maxParams);
            HashMap returnKeyHashMap = new HashMap();
            int i = 0;
            for (AcctItem item : (ArrayList)itl.next()) {
                if (++i > 1) {
                    tempBuf.append(" UNION ");
                }
                tempBuf.append(item.getSelect());
                tempBuf.append(buf);
                tempBuf.append(item.getOutLineWhereItem(param, isAdjustSeparate));
                tempBuf.append(" and (");
                tempBuf.append(item.getWhereItem(param, returnKeyHashMap));
                tempBuf.append(") \r\n");
                if (i <= 0) continue;
                String aaa = PsSql.getSqlWithParams((Object)tempBuf, (Object[])param.toArray(), (int)1, (boolean)false);
                IRowSet rs = DbUtil.executeQuery((Context)this.ServerCtx, (String)tempBuf.toString(), (Object[])param.toArray());
                while (rs.next()) {
                    StringBuffer key = new StringBuffer();
                    key.append(rs.getObject("tgtcur_FNumber").toString());
                    key.append("|").append(rs.getObject("FPeriodType").toString());
                    key.append("|").append(rs.getObject("FDataElement").toString());
                    key.append("|").append(rs.getObject("FValueType").toString());
                    key.append("|").append(item._isGetDataFromDoingRpt);
                    key.append("|").append(rs.getObject("FDataCollect").toString());
                    String adjust = rs.getObject("FIsAdjusted").toString();
                    key.append("|").append(adjust);
                    key.append("|").append(rs.getObject("company_fnumber").toString());
                    key.append("|").append(rs.getObject("FDataSource").toString());
                    ArrayList tempList = returnKeyHashMap.containsKey(rs.getString("cur_FNumber") + "|" + key.toString()) ? this.getFromKey(returnKeyHashMap, rs.getObject("cur_FNumber").toString() + "|" + key.toString()) : this.getFromKey(returnKeyHashMap, key.toString());
                    Iterator itt = tempList.iterator();
                    String id = rs.getObject("fid").toString();
                    while (itt.hasNext()) {
                        AcctItem _item = (AcctItem)itt.next();
                        _item.addIds(adjust, id);
                    }
                }
                tempBuf = new StringBuffer();
                param = new ArrayList();
                returnKeyHashMap = new HashMap();
                i = 0;
            }
        }
    }

    private void queryData() throws BOSException, SQLException {
        for (Table table : this.tables.values()) {
            table.query();
        }
    }

    private void submitData() {
        for (AcctItem t : this.acctItemIndexMap.values()) {
            t.submit();
        }
    }

    private void queryOrgTreeId() throws EASBizException, BOSException {
        for (String orgBoundKey : this.orgTreeId.keySet()) {
            Map mapOrgTree = null;
            Set set = null;
            ArrayList list = (ArrayList)this.orgTreeId.get(orgBoundKey);
            AcctItem item2 = (AcctItem)list.get(0);
            ArrayList<OrgBoundAllVers> OrgBoundAllVersList = new ArrayList<OrgBoundAllVers>();
            try {
                mapOrgTree = FiscalPeriodHelper.getOrgTreeByPeriods((Context)this.ServerCtx, (PeriodCollection)this.periods, (String)item2._orgBound, (int)item2._startYear, (int)item2._endYear, (int)item2._startPeriod, (int)item2._endPeriod, (int)item2._periodType, (boolean)this.isMergeByFiscalPeriod, (boolean)this.isSupport13Period);
            }
            catch (Exception e) {
                mapOrgTree = new HashMap();
            }
            set = mapOrgTree.keySet();
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String strOrgTreeID = ite.next().toString();
                Map mapPeriod = (Map)mapOrgTree.get(strOrgTreeID);
                OrgBoundAllVers ver = new OrgBoundAllVers();
                ver._orgBound = strOrgTreeID;
                ver._startYear = (Integer)mapPeriod.get("KEY_STARTYEAR");
                ver._endYear = item2._endYear;
                ver._startPeriod = (Integer)mapPeriod.get("KEY_STARTPERIOD");
                ver._endPeriod = item2._endPeriod;
                OrgBoundAllVersList.add(ver);
            }
            for (AcctItem item2 : list) {
                if (OrgBoundAllVersList == null || OrgBoundAllVersList.size() < 1) {
                    // empty if block
                }
                item2.orgBoundAllVersList = OrgBoundAllVersList;
            }
        }
    }

    private void queryMapField() throws BOSException, SQLException {
        if (this.tempSql.size() == 0) {
            return;
        }
        long maxSize = 10000L;
        StringBuffer tempSqlBuffer = new StringBuffer();
        long sqlSize = maxSize;
        for (int i = 0; i < this.tempSql.size(); ++i) {
            if (tempSqlBuffer.length() > 0) {
                tempSqlBuffer.append(" union ");
            }
            String str = (String)this.tempSql.get(i);
            tempSqlBuffer.append(str);
            if ((sqlSize -= (long)(str.length() + 10)) > 0L && i != this.tempSql.size() - 1) continue;
            StringBuffer buf = new StringBuffer();
            buf.append("Select b.FTableName FTableName,b.FFieldName FFieldName,a.FNumber FNumber ,\r\nitemFromTo.startItem as startItem ,itemFromTo.endItem as endItem  From \r\n ").append(" T_CSL_RptItem a inner join T_CSL_ItemFieldMapped  b  on a.FID=b.FItemID \r\n ").append(" inner join \r\n").append("(\r\n").append(tempSqlBuffer.toString());
            buf.append(") as itemFromTo  on 1=1 \r\n");
            buf.append(" where (a.FNumber >= itemFromTo.startItem  and a.FNumber <=itemFromTo.endItem) \r\n").append(" and FIsFreezed=0");
            IRowSet rs = DbUtil.executeQuery((Context)this.ServerCtx, (String)buf.toString());
            while (rs.next()) {
                String key = rs.getObject("startItem").toString() + "|" + rs.getObject("endItem").toString();
                String tableName = rs.getObject("FTableName").toString();
                String fieldName = rs.getObject("FFieldName").toString();
                String fnumber = rs.getObject("FNumber").toString();
                Table table = (Table)this.tables.get(tableName);
                if (table == null) {
                    table = new Table(tableName);
                    this.tables.put(tableName, table);
                }
                table.addField(fieldName, fnumber);
                ArrayList tempList = (ArrayList)this.itemFromToMap.get(key);
                for (AcctItem item : tempList) {
                    item.insertDataField(table, fieldName);
                }
            }
            sqlSize = maxSize;
            tempSqlBuffer = new StringBuffer();
        }
    }

    private int getReport_Year() {
        return this.context == null ? 0 : (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return this.context == null ? 0 : (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
    }

    private int getReport_PeriodType() {
        return this.context == null ? 0 : (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
    }

    private String getCorrect_Currency_Number() {
        String currency = this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        return currency;
    }

    private String getSource_Currency_Number() {
        return this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("SourceCurrency.Number");
    }

    private String getOrgUnit_Number() {
        return this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getCompany_Number() {
        return this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    private String getOrgTreeNumber() {
        if (this.treeNumber == null) {
            OrgTreeInfo info;
            String orgTreeNumber;
            String string = orgTreeNumber = this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
            if (orgTreeNumber == null && (info = (OrgTreeInfo)this.ServerCtx.get((Object)"KEY_ORGTREE_INFO")) != null) {
                orgTreeNumber = info.getNumber();
            }
            this.treeNumber = orgTreeNumber;
        }
        return this.treeNumber;
    }

    private String getDataCollectNumber() {
        String dataCollectNumber;
        String string = dataCollectNumber = this.context == null ? "" : (String)this.context.getReportAdapter().getReportProperty("CSLReport_DataCollect_Number");
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = (String)this.ServerCtx.get((Object)"KEY_DATACOLLECT_NUMBER");
        }
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = "ACTUALDATA";
        }
        return dataCollectNumber;
    }

    private String getDataCollectNumberChecked(String dc) {
        if (dc == null || dc.equals("")) {
            return this.getDataCollectNumber();
        }
        return "ACTUALDATA".equalsIgnoreCase(dc) || "BUDGETDATA".equalsIgnoreCase(dc) ? dc : this.getDataCollectNumber();
    }

    ArrayList getFromKey(HashMap map, String key) {
        ArrayList list = (ArrayList)map.get(key);
        if (list == null) {
            list = new ArrayList();
            map.put(key, list);
        }
        return list;
    }

    private void initBatchSize() {
        String sql = "SELECT FKEY,FVALUE FROM T_CSL_CSLParam WHERE FKEY = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ServerCtx, (String)sql, (Object[])new Object[]{"ACCTITEM_UNION_SIZE"});
            if (rowSet.next()) {
                String stringSize = rowSet.getString("FVALUE");
                this.unionRecordSize = Integer.parseInt(stringSize);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
    }

    class CalculateBackFiller {
        private Throwable _exception = null;
        Parameter param = null;

        public CalculateBackFiller(Parameter _param) {
            this.param = _param;
        }

        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            if (value.toString().trim().length() == 0) {
                return;
            }
        }

        public void setException(Throwable exception) {
            this._exception = exception;
        }

        void submit(List vlist) {
            if (this._exception != null) {
                IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(this._exception.getClass());
                if (errorProvider != null && this._exception instanceof Exception) {
                    Object value = errorProvider.getProperValue((Exception)this._exception).getValue();
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.param.setValue(value);
                } else {
                    FormulaValueBackfill err = new FormulaValueBackfill(this.param);
                    err.setException(this._exception);
                }
            } else {
                Object obj = this.param.getValue();
                if (obj == null || !(obj instanceof BigDecimal)) {
                    obj = new BigDecimal("0");
                }
                BigDecimal r = (BigDecimal)obj;
                for (int i = 0; i < vlist.size(); ++i) {
                    Object object = vlist.get(i);
                    if (!(object instanceof BigDecimal)) continue;
                    r = r.add((BigDecimal)object);
                }
                this.param.setValue((Object)r);
            }
        }
    }

    private class Table {
        private HashMap fields = new HashMap();
        private String tableName = null;
        StringBuffer selectSql = new StringBuffer();
        ArrayList list = new ArrayList();

        Table(String _tableName) {
            this.tableName = _tableName;
        }

        void addField(String field, String number) {
            if (!this.fields.keySet().contains(field)) {
                String numTemp = number.replaceAll("\\.", "_");
                numTemp = numTemp.replaceAll("\\-", "_");
                numTemp = numTemp.replaceAll("\\+", "_");
                numTemp = numTemp.replaceAll("\\*", "_");
                numTemp = numTemp.replaceAll("/", "_");
                String alias = "FF" + numTemp.replaceAll("\\.", "_") + "_" + this.fields.size();
                this.fields.put(field, alias);
                if (this.selectSql.length() > 0) {
                    this.selectSql.append(",");
                }
                this.selectSql.append("sum(dataTable." + field + ") as  " + alias + " ");
            }
        }

        String getSelectSql() {
            return "Select " + this.selectSql.toString();
        }

        void addAcciItem(AcctItem item) {
            this.list.add(item);
        }

        void query() throws BOSException, SQLException {
            ArrayList param = new ArrayList();
            StringBuffer buf = new StringBuffer();
            buf.append(this.getSelectSql()).append(" ,idtable.findex as findex, idtable.type as type ").append(" from ").append(this.tableName).append("  as dataTable \r\n ").append("inner join ");
            buf.append("( ");
            long sqlMaxSize = 61440L;
            long sqlSize = sqlMaxSize -= (long)buf.length();
            Iterator it = this.list.iterator();
            int i = 0;
            StringBuffer tempBuf = new StringBuffer();
            int pin = 1;
            while (it.hasNext()) {
                AcctItem item = (AcctItem)it.next();
                String str = item.getIDTable(param);
                if (i == 0) {
                    pin = str.length() / 100 + 2;
                }
                if (str != null && str.trim().length() > 0) {
                    if (i >= 1) {
                        tempBuf.append(" union ");
                    }
                    tempBuf.append(str);
                    ++i;
                }
                if ((long)tempBuf.length() < sqlSize && it.hasNext() && i <= 100 / pin || i <= 0) continue;
                tempBuf.append(") as idtable on  idtable.fid=dataTable.fid");
                tempBuf.append(" group by idtable.findex, idtable.type");
                String sql = buf.toString();
                sql = sql.replaceAll(CslConstant.SEP_ONE_DASHES, CslConstant.SEP_FOUR_UNDERLINE);
                IRowSet rs = DbUtil.executeQuery((Context)AcctItemCalcuter.this.ServerCtx, (String)(sql + tempBuf.toString()), (Object[])param.toArray(new Object[param.size()]));
                while (rs.next()) {
                    AcctItem acctItem = (AcctItem)AcctItemCalcuter.this.acctItemIndexMap.get(rs.getObject("findex").toString());
                    if (acctItem == null) continue;
                    List list = acctItem.getTableFields(this);
                    Iterator itF = list.iterator();
                    while (itF.hasNext()) {
                        String entry = itF.next().toString();
                        String entrySep = this.fields.get(entry).toString();
                        entrySep = entrySep.replaceAll(CslConstant.SEP_ONE_DASHES, CslConstant.SEP_FOUR_UNDERLINE);
                        BigDecimal value = rs.getBigDecimal(entrySep);
                        int type = rs.getInt("type");
                        if (value == null) continue;
                        acctItem.setValue(value, type);
                    }
                }
                tempBuf = new StringBuffer();
                i = 0;
                param = new ArrayList();
            }
        }
    }

    private class AcctItem {
        String _orgBound;
        String[] _companys;
        String _currency;
        String _convertCurrency;
        String _itemNumberStart;
        String _itemNumberEnd;
        int _periodType;
        int[] _dataSource;
        int _dataElement;
        int _valueType;
        int _startYear;
        int _endYear;
        int _startPeriod;
        int _endPeriod;
        int _isAdjusted;
        int _itemdatatype;
        boolean _isGetDataFromDoingRpt = false;
        int _commitStatus = 3;
        int _itemNumberLevelStart = 0;
        int _itemNumberLevelEnd = 5;
        boolean isConvertedCompany;
        String _dataCollect = "";
        boolean _isCaliber;
        String acctItemId;
        String[] companysForPermissionCheck;
        List ids_before = new ArrayList(4);
        List ids_adjusting = new ArrayList(4);
        List ids_adjusted = new ArrayList(4);
        List ids_caliadjusting = new ArrayList(4);
        List ids_caliadjusted = new ArrayList(4);
        Map tableField = new HashMap();
        private List value_beforeadjust = new ArrayList(4);
        private List value_adjust = new ArrayList(4);
        private List value_adjusted = new ArrayList(4);
        private List value_caliadjusting = new ArrayList(4);
        private List value_caliadjusted = new ArrayList(4);
        List orgBoundAllVersList;
        CalculateBackFiller value = null;
        boolean isSubmit = false;

        public void addIds(String adjust, String id) {
            if (String.valueOf(0).equals(adjust)) {
                this.ids_before.add(id);
            } else if (String.valueOf(1).equals(adjust)) {
                this.ids_adjusting.add(id);
            } else if (String.valueOf(2).equals(adjust)) {
                this.ids_adjusted.add(id);
            } else if (String.valueOf(11).equals(adjust)) {
                this.ids_caliadjusting.add(id);
            } else if (String.valueOf(12).equals(adjust)) {
                this.ids_caliadjusted.add(id);
            } else {
                throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"44_AcctItemCalcuter", (Locale)AcctItemCalcuter.this.ServerCtx.getOriginLocale()) + id);
            }
        }

        public void submit() {
            if (this._itemdatatype == 2 || this._itemdatatype == 12) {
                if (this._itemdatatype == 2) {
                    if (this.value_adjusted.size() > 0) {
                        this.value.submit(this.value_adjusted);
                    } else {
                        this.value.submit(this.value_beforeadjust);
                        if (AcctItemCalcuter.this.getCalcType() == 1 || AcctItemCalcuter.this.getCalcType() == 3) {
                            this.value.submit(this.value_adjust);
                        }
                    }
                }
                if (this._itemdatatype == 12) {
                    if (this.value_caliadjusted.size() > 0) {
                        this.value.submit(this.value_caliadjusted);
                    } else if (this.value_adjusted.size() > 0) {
                        this.value.submit(this.value_adjusted);
                        if (AcctItemCalcuter.this.getCalcType() == 1 || AcctItemCalcuter.this.getCalcType() == 3) {
                            this.value.submit(this.value_caliadjusting);
                        }
                    } else {
                        this.value.submit(this.value_beforeadjust);
                        if (AcctItemCalcuter.this.getCalcType() == 1 || AcctItemCalcuter.this.getCalcType() == 3) {
                            this.value.submit(this.value_adjust);
                        }
                        if (AcctItemCalcuter.this.getCalcType() == 1 || AcctItemCalcuter.this.getCalcType() == 3) {
                            this.value.submit(this.value_caliadjusting);
                        }
                    }
                }
            } else {
                this.value.submit(this.value_beforeadjust);
            }
        }

        public String getIDTable(ArrayList param) {
            StringBuffer buf = new StringBuffer();
            Iterator it = this.ids_before.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" union ");
                }
                buf.append(" select '" + it.next() + "' as fid ," + this.acctItemId + " as findex, 0 as type \r\n");
            }
            it = this.ids_adjusting.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" union ");
                }
                buf.append(" select '" + it.next() + "' as fid ," + this.acctItemId + " as findex, 1 as type \r\n");
            }
            it = this.ids_adjusted.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" union ");
                }
                buf.append(" select '" + it.next() + "' as fid ," + this.acctItemId + " as findex, 2 as type \r\n");
            }
            it = this.ids_caliadjusting.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" union ");
                }
                buf.append(" select '" + it.next() + "' as fid ," + this.acctItemId + " as findex, 11 as type \r\n");
            }
            it = this.ids_caliadjusted.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(" union ");
                }
                buf.append(" select '" + it.next() + "' as fid ," + this.acctItemId + " as findex, 12 as type \r\n");
            }
            return buf.toString();
        }

        String getOrgBoundKey() {
            return this._orgBound + "|" + this._startYear + "|" + this._endYear + "|" + this._startPeriod + "|" + this._endPeriod + "|" + this._periodType;
        }

        public void insertDataField(Table table, String number) {
            ArrayList<String> tb = (ArrayList<String>)this.tableField.get(table);
            if (tb == null) {
                tb = new ArrayList<String>();
                this.tableField.put(table, tb);
                table.addAcciItem(this);
            }
            tb.add(number);
        }

        List getTableFields(Table table) {
            List tb = (List)this.tableField.get(table);
            return tb;
        }

        public String getSelect() {
            StringBuffer buf = new StringBuffer();
            buf.append("Select ItemDataBd.fid as fid ,");
            if (!StringUtils.isEmpty((String)this._currency)) {
                buf.append("cur.FNumber as cur_FNumber ,");
            } else {
                buf.append(" '' as cur_FNumber, ");
            }
            buf.append("tgtcur.FNumber as tgtcur_FNumber,ItemDataHd.FPeriodType as FPeriodType ,ItemDataBd.FDataElement as FDataElement,ItemDataBd.FValueType as FValueType,ItemDataHd.FIsAdjusted as FIsAdjusted,ItemDataHd.FDataCollectNumber as FDataCollect,company.fnumber as company_fnumber,ItemDataHd.FDataSource as FDataSource \r\n");
            return buf.toString();
        }

        public String getOutLineWhereItem(ArrayList param, boolean isAdjustSeparate) {
            StringBuffer buf = new StringBuffer();
            buf.append("  (");
            for (int i = 0; i < this.orgBoundAllVersList.size(); ++i) {
                OrgBoundAllVers v = (OrgBoundAllVers)this.orgBoundAllVersList.get(i);
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(" (");
                String baseOrgTreeId = null;
                if (!isAdjustSeparate && this._isAdjusted == 1) {
                    buf.append("(");
                    int year = v._startYear;
                    int period = v._startPeriod;
                    int periodType = this._periodType;
                    String key = String.valueOf(periodType) + String.valueOf(year) + String.valueOf(period);
                    if (AcctItemCalcuter.this.baseOrgTree.get(key) == null) {
                        Date date = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)AcctItemCalcuter.this.periods, (int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod);
                        try {
                            baseOrgTreeId = CslRptUtil.getBasicTree((Context)AcctItemCalcuter.this.ServerCtx, (Date)date);
                        }
                        catch (EASBizException e) {
                            log.debug((Object)e.getMessage());
                        }
                        catch (BOSException e) {
                            log.debug((Object)e.getMessage());
                        }
                        AcctItemCalcuter.this.baseOrgTree.put(key, baseOrgTreeId);
                    } else {
                        baseOrgTreeId = (String)AcctItemCalcuter.this.baseOrgTree.get(key);
                    }
                }
                buf.append(" Received.FOrgTreeID = ?");
                param.add(v._orgBound);
                if (!isAdjustSeparate && this._isAdjusted == 1) {
                    buf.append("  or Received.FOrgTreeID = ? ");
                    param.add(baseOrgTreeId);
                    buf.append("  or ItemDataHd.FIsAdjusted=2 )");
                }
                if (v._startYear < v._endYear) {
                    buf.append(" and ItemDataBd.FYear= ? ");
                    param.add(new Integer(v._startYear));
                    buf.append(" and ItemDataBd.FPeriod>= ? ");
                    param.add(new Integer(v._startPeriod));
                    buf.append(" or (ItemDataBd.FYear> ? ");
                    param.add(new Integer(v._startYear));
                    buf.append(" and ItemDataBd.FYear< ? )");
                    param.add(new Integer(v._endYear));
                    buf.append(" or (ItemDataBd.FYear= ? ");
                    param.add(new Integer(v._endYear));
                    buf.append(" and ItemDataBd.FPeriod<= ? )");
                    param.add(new Integer(v._endPeriod));
                } else {
                    buf.append(" and ItemDataBd.FYear>= ? ");
                    param.add(new Integer(v._startYear));
                    buf.append(" and ItemDataBd.FYear<= ? ");
                    param.add(new Integer(v._endYear));
                    buf.append(" and ItemDataBd.FPeriod>= ? ");
                    param.add(new Integer(v._startPeriod));
                    buf.append(" and ItemDataBd.FPeriod<= ? ");
                    param.add(new Integer(v._endPeriod));
                }
                buf.append(")");
            }
            if (this.orgBoundAllVersList.size() < 1) {
                buf.append(" 1=1 ");
            }
            buf.append(")");
            return buf.toString();
        }

        public String getWhereItem(ArrayList param, HashMap map) {
            int i;
            StringBuffer tempKey = new StringBuffer();
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            if (!StringUtils.isEmpty((String)this._currency)) {
                buf.append("cur.FNumber=? and ");
                param.add(this._currency);
                tempKey.append(this._currency + "|");
            }
            buf.append(" tgtcur.FNumber=? ");
            param.add(this._convertCurrency);
            tempKey.append(this._convertCurrency + "|");
            buf.append(" and ( ");
            for (i = 0; i < this._companys.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(" company.fnumber =? ");
                param.add(this._companys[i]);
            }
            buf.append(" )");
            buf.append(" and ItemDataHd.FPeriodType=? ");
            param.add(new Integer(this._periodType));
            tempKey.append(this._periodType + "|");
            buf.append(" and (");
            if (this._dataSource.length > 1) {
                for (i = 0; i < this._dataSource.length; ++i) {
                    if (i > 0) {
                        buf.append(" or ");
                    }
                    buf.append("  ItemDataHd.FDataSource= ?  ");
                    param.add(new Integer(this._dataSource[i]));
                }
            } else if (this._dataSource[0] == 1 || this._dataSource[0] == 7) {
                buf.append("  ItemDataHd.FDataSource= ? or  ItemDataHd.FDataSource= ? ");
                param.add(new Integer(1));
                param.add(new Integer(7));
            } else {
                buf.append("  ItemDataHd.FDataSource= ?  ");
                param.add(new Integer(this._dataSource[0]));
            }
            buf.append(" ) ");
            buf.append(" and ItemDataBd.FDataElement=? ");
            param.add(new Integer(this._dataElement));
            tempKey.append(this._dataElement + "|");
            buf.append(" and ItemDataBd.FValueType=? ");
            param.add(new Integer(this._valueType));
            tempKey.append(this._valueType + "|");
            tempKey.append(this._isGetDataFromDoingRpt);
            tempKey.append("|");
            buf.append(" and ItemDataHd.FDataCollectNumber = ? ");
            param.add(this._dataCollect);
            tempKey.append(this._dataCollect + "|");
            if (this._isAdjusted != 1) {
                buf.append(" and ItemDataHd.FIsAdjusted=? ");
                param.add(new Integer(this._isAdjusted));
            }
            if (this._dataSource.length == 1) {
                if (this._dataSource[0] != 4 && this._commitStatus > 0) {
                    if (this._isGetDataFromDoingRpt) {
                        buf.append(" and ItemDataHd.FCommitStatus in (?,?,?) ");
                        param.add(new Integer(this._commitStatus));
                        param.add(new Integer(1));
                        param.add(new Integer(2));
                    } else {
                        if (this._itemdatatype == 12) {
                            buf.append(" and (ItemDataHd.FIsAdjusted=2 or ItemDataHd.FIsAdjusted=12 or (ItemDataHd.FIsAdjusted in (0,1,11) and  ItemDataHd.FCommitStatus=?))");
                        } else if (this._itemdatatype == 2) {
                            buf.append(" and (ItemDataHd.FIsAdjusted=2 or (ItemDataHd.FIsAdjusted in (0,1) and  ItemDataHd.FCommitStatus=?))");
                        } else if (this._itemdatatype == 0) {
                            buf.append(" and ItemDataHd.FIsAdjusted=0 and  ItemDataHd.FCommitStatus=? ");
                        }
                        param.add(new Integer(this._commitStatus));
                    }
                } else if (this._itemdatatype == 12) {
                    buf.append(" and ItemDataHd.FIsAdjusted in (0,1,2,11,12) ");
                } else if (this._itemdatatype == 2) {
                    buf.append(" and ItemDataHd.FIsAdjusted in (0,1,2) ");
                } else if (this._itemdatatype == 0) {
                    buf.append(" and ItemDataHd.FIsAdjusted=0 ");
                }
                buf.append(")\r\n");
                for (i = 0; i < this._companys.length; ++i) {
                    ArrayList tempList;
                    if (this._dataSource.length > 1) {
                        for (int j = 0; j < this._dataSource.length; ++j) {
                            ArrayList tempList2;
                            String k;
                            if (this._itemdatatype == 2 || this._itemdatatype == 12) {
                                k = tempKey.toString() + "0|" + this._companys[i] + "|" + this._dataSource[j];
                                tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                                tempList2.add(this);
                                k = tempKey.toString() + "1|" + this._companys[i] + "|" + this._dataSource[j];
                                tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                                tempList2.add(this);
                                k = tempKey.toString() + "2|" + this._companys[i] + "|" + this._dataSource[j];
                                tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                                tempList2.add(this);
                                k = tempKey.toString() + "11|" + this._companys[i] + "|" + this._dataSource[j];
                                tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                                tempList2.add(this);
                                k = tempKey.toString() + "12|" + this._companys[i] + "|" + this._dataSource[j];
                                tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                                tempList2.add(this);
                                continue;
                            }
                            k = tempKey.toString() + "0|" + this._companys[i] + "|" + this._dataSource[j];
                            tempList2 = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList2.add(this);
                        }
                        continue;
                    }
                    if (this._dataSource[0] == 1 || this._dataSource[0] == 7) {
                        if (this._itemdatatype == 2 || this._itemdatatype == 12) {
                            String k = tempKey.toString() + "0|" + this._companys[i] + "|" + 1;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "0|" + this._companys[i] + "|" + 7;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "1|" + this._companys[i] + "|" + 1;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "1|" + this._companys[i] + "|" + 7;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "2|" + this._companys[i] + "|" + 1;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "2|" + this._companys[i] + "|" + 7;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "11|" + this._companys[i] + "|" + 1;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "11|" + this._companys[i] + "|" + 7;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "12|" + this._companys[i] + "|" + 1;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            k = tempKey.toString() + "12|" + this._companys[i] + "|" + 7;
                            tempList = AcctItemCalcuter.this.getFromKey(map, k);
                            tempList.add(this);
                            continue;
                        }
                        String k = tempKey.toString() + "0|" + this._companys[i] + "|" + 1;
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        k = tempKey.toString() + "0|" + this._companys[i] + "|" + 7;
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        continue;
                    }
                    if (this._itemdatatype == 2 || this._itemdatatype == 12) {
                        String k = tempKey.toString() + "0|" + this._companys[i] + "|" + this._dataSource[0];
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        k = tempKey.toString() + "1|" + this._companys[i] + "|" + this._dataSource[0];
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        k = tempKey.toString() + "2|" + this._companys[i] + "|" + this._dataSource[0];
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        k = tempKey.toString() + "11|" + this._companys[i] + "|" + this._dataSource[0];
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        k = tempKey.toString() + "12|" + this._companys[i] + "|" + this._dataSource[0];
                        tempList = AcctItemCalcuter.this.getFromKey(map, k);
                        tempList.add(this);
                        continue;
                    }
                    String k = tempKey.toString() + "0|" + this._companys[i] + "|" + this._dataSource[0];
                    tempList = AcctItemCalcuter.this.getFromKey(map, k);
                    tempList.add(this);
                }
            }
            return buf.toString();
        }

        AcctItem(Parameter _param, boolean isSupport13Period) {
            this.init(_param, isSupport13Period);
        }

        String[] getKeys() {
            return null;
        }

        public boolean isSubmit() {
            return this.isSubmit;
        }

        private void init(Parameter _param, boolean isSupport13Period) {
            boolean hasCompany;
            int[] yd;
            int int_periodType;
            Variant var14;
            int endPeriodOffset;
            int startPeriodOffset;
            int yearOffset;
            Object[] params = null;
            params = _param.getArgs()[0] instanceof Object[] ? (Object[])_param.getArgs()[0] : _param.getArgs();
            int int_dataSource = -1;
            this.value = new CalculateBackFiller(_param);
            String orgBoundNumber = ((Variant)params[0]).getValue() == null ? null : ((Variant)params[0]).getValue().toString();
            String orgUnitNumber = ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString();
            String currencyNumber = ((Variant)params[2]).getValue() == null ? null : ((Variant)params[2]).getValue().toString();
            String covertCurrencyNumber = ((Variant)params[3]).getValue() == null ? null : ((Variant)params[3]).getValue().toString();
            String startItemNumber = ((Variant)params[4]).getValue() == null ? null : ((Variant)params[4]).getValue().toString();
            String endItemNumber = ((Variant)params[5]).getValue() == null ? null : ((Variant)params[5]).getValue().toString();
            String rptPeriodType = ((Variant)params[6]).getValue() == null ? null : ((Variant)params[6]).getValue().toString();
            try {
                yearOffset = ((Variant)params[7]).intValue();
            }
            catch (SyntaxErrorException e1) {
                yearOffset = 0;
            }
            try {
                startPeriodOffset = ((Variant)params[8]).intValue();
            }
            catch (SyntaxErrorException e1) {
                startPeriodOffset = 0;
            }
            try {
                endPeriodOffset = ((Variant)params[9]).intValue();
            }
            catch (SyntaxErrorException e1) {
                endPeriodOffset = 0;
            }
            Variant variant = (Variant)params[10];
            String dataSource = null;
            if (variant.getValue() instanceof Integer) {
                try {
                    int_dataSource = variant.intValue();
                }
                catch (SyntaxErrorException syntaxErrorException) {}
            } else {
                dataSource = variant.getValue() == null ? null : variant.getValue().toString();
            }
            String dataElement = ((Variant)params[11]).getValue() == null ? null : ((Variant)params[11]).getValue().toString();
            int int_valueType = -1;
            variant = (Variant)params[12];
            String valueType = null;
            if (variant.getValue() instanceof Integer) {
                try {
                    int_valueType = variant.intValue();
                }
                catch (SyntaxErrorException syntaxErrorException) {}
            } else {
                String string = valueType = variant.getValue() == null ? null : variant.getValue().toString();
            }
            if (valueType != null) {
                int_valueType = FormulaAdapter.getValueType((String)valueType);
            }
            Variant v = (Variant)params[13];
            boolean isAdjust = true;
            if (v == null || v.isNull() || v.isEmpty()) {
                isAdjust = true;
                v.setBoolean(isAdjust);
            } else {
                isAdjust = ((Variant)params[13]).getValue() instanceof Boolean ? (Boolean)((Variant)params[13]).getValue() : true;
            }
            this._isAdjusted = isAdjust ? 2 : 0;
            String dataCollect = null;
            boolean isGetDataFromDoingRpt = false;
            int itemdatatype = -1;
            boolean isCaliber = false;
            if (params.length == 15) {
                var14 = (Variant)params[14];
                if (var14 != null && !var14.isNull() && !var14.isEmpty()) {
                    if (var14.getValue().toString().equalsIgnoreCase("ACTUALDATA") || var14.getValue().toString().equalsIgnoreCase("BUDGETDATA")) {
                        dataCollect = var14.toString();
                    } else {
                        isGetDataFromDoingRpt = (Boolean)var14.getValue();
                    }
                }
            } else if (params.length > 15) {
                var14 = (Variant)params[14];
                if (var14 == null || var14.isNull() || var14.isEmpty() || StringUtils.isEmpty((String)var14.toString())) {
                    isGetDataFromDoingRpt = false;
                } else {
                    String value = var14.toString();
                    boolean isRight = "false".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
                    isGetDataFromDoingRpt = isRight ? (Boolean)((Variant)params[14]).getValue() : false;
                }
                Variant var15 = (Variant)params[15];
                if (var15 != null && !var15.isNull() && !var15.isEmpty()) {
                    dataCollect = var15.getValue().toString();
                    dataCollect = AcctItemCalcuter.this.getDataCollectNumberChecked(dataCollect);
                }
                Variant v2 = null;
                if (params.length == 17) {
                    v2 = (Variant)params[16];
                    if (v2 == null || v2.isNull() || v2.isEmpty()) {
                        isCaliber = false;
                        v2.setBoolean(isCaliber);
                    } else {
                        isCaliber = (Boolean)v2.getValue();
                    }
                }
            }
            int n = isCaliber ? 12 : (itemdatatype = this._isAdjusted > 0 ? 2 : 0);
            if (StringUtils.isEmpty(dataCollect)) {
                dataCollect = AcctItemCalcuter.this.getDataCollectNumber();
            }
            if ((int_periodType = rptPeriodType == null || rptPeriodType.trim().equals("") ? AcctItemCalcuter.this.getReport_PeriodType() : FormulaAdapter.getRptPeriodType((String)rptPeriodType)) == -1) {
                FormulaValueBackfill err = new FormulaValueBackfill(_param);
                err.setException((Throwable)new ReportException(ReportException.PERIOD_ERROR));
                this.isSubmit = true;
                return;
            }
            int rptYear = 0;
            int rptPeriod = 0;
            rptYear = AcctItemCalcuter.this.getReport_Year();
            rptPeriod = AcctItemCalcuter.this.getReport_Period();
            if (AcctItemCalcuter.this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                String bfperiodNumber = (String)AcctItemCalcuter.this.context.getReportAdapter().getReportProperty("BG_PERIOD_NUMBER");
                try {
                    yd = RptUtil.transYearAndPeriodFromBgNumber2(bfperiodNumber);
                }
                catch (Exception e) {
                    _param.setValue((Object)new SyntaxErrorException(128L, (Object)e.getMessage()));
                    this.isSubmit = true;
                    return;
                }
                rptYear = yd[0];
                rptPeriod = yd[1];
            }
            if (int_periodType != AcctItemCalcuter.this.getReport_PeriodType()) {
                Date date = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)AcctItemCalcuter.this.periods, (int)rptYear, (int)rptPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)AcctItemCalcuter.this.getReport_PeriodType()), (boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod);
                yd = FiscalPeriodHelper.getYearAndPeriod((PeriodCollection)AcctItemCalcuter.this.periods, (Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)int_periodType), (boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod);
                rptYear = yd[0];
                rptPeriod = yd[1];
            }
            if (!FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)int_periodType)) && endPeriodOffset + rptPeriod == 0 && "YTDAMOUNT".equals(dataElement)) {
                _param.setValue((Object)new BigDecimal("0"));
                this.isSubmit = true;
                return;
            }
            if (covertCurrencyNumber == null || covertCurrencyNumber.trim().equals("")) {
                covertCurrencyNumber = AcctItemCalcuter.this.getCorrect_Currency_Number();
            }
            if (dataSource != null) {
                int_dataSource = FormulaAdapter.getDataSource((String)dataSource);
            }
            int int_dataElement = -1;
            try {
                int_dataElement = AcctItemCalcuter.this.ServerCtx == null ? DataElementProvider.getDataElementInnerValue((String)dataElement) : DataElementProvider.getDataElementInnerValue((Context)AcctItemCalcuter.this.ServerCtx, (String)dataElement);
            }
            catch (Exception e) {
                _param.setValue((Object)new SyntaxErrorException(128L, (Object)e.getMessage()));
                this.isSubmit = true;
                return;
            }
            int isAdjusted = 0;
            isAdjusted = isAdjust ? 1 : 0;
            int[] start = null;
            int[] end = null;
            if (isSupport13Period) {
                start = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset, (boolean)isSupport13Period);
                end = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset, (boolean)isSupport13Period);
            } else {
                start = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)AcctItemCalcuter.this.periods, (int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)startPeriodOffset, (boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod);
                end = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)AcctItemCalcuter.this.periods, (int)rptYear, (int)rptPeriod, (int)int_periodType, (int)yearOffset, (int)endPeriodOffset, (boolean)AcctItemCalcuter.this.isMergeByFiscalPeriod);
            }
            int startYear = 0;
            int startPeriod = 0;
            int endYear = 0;
            int endPeriod = 0;
            if (start == null) {
                startYear = rptYear;
                startPeriod = rptPeriod;
            } else {
                startYear = start[0];
                startPeriod = start[1];
            }
            if (end == null) {
                endYear = rptYear;
                endPeriod = rptPeriod;
            } else {
                endYear = end[0];
                endPeriod = end[1];
            }
            this._itemNumberStart = startItemNumber;
            this._itemNumberEnd = endItemNumber;
            this._periodType = int_periodType;
            this._dataElement = int_dataElement;
            this._valueType = int_valueType;
            this._startYear = startYear;
            this._endYear = endYear;
            this._startPeriod = startPeriod;
            this._endPeriod = endPeriod;
            this._isAdjusted = isAdjusted;
            this._isGetDataFromDoingRpt = isGetDataFromDoingRpt;
            this._dataCollect = dataCollect;
            this._itemdatatype = itemdatatype;
            this._isCaliber = isCaliber;
            boolean bl = hasCompany = !StringUtils.isEmpty((String)orgUnitNumber);
            if (AcctItemCalcuter.this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
                String orgForPerm;
                try {
                    if (StringUtils.isEmpty((String)orgUnitNumber)) {
                        String[] bgUnit_Number = this.getBgUnit_Number();
                        orgUnitNumber = bgUnit_Number[0];
                        AcctItemCalcuter.this.treeNumber = bgUnit_Number[1];
                        if (bgUnit_Number[2] != null) {
                            this.isConvertedCompany = true;
                        }
                    }
                }
                catch (Exception e) {
                    this.value.setException(e);
                    this.isSubmit = true;
                    this.submit();
                    return;
                }
                if (StringUtils.isEmpty((String)orgBoundNumber)) {
                    orgBoundNumber = AcctItemCalcuter.this.getOrgTreeNumber();
                }
                String string = orgForPerm = ((Variant)params[1]).getValue() == null ? null : ((Variant)params[1]).getValue().toString();
                if (orgForPerm == null || orgForPerm.trim().equals("")) {
                    hasCompany = true;
                    orgForPerm = AcctItemCalcuter.this.getOrgUnit_Number();
                    if (StringUtils.isEmpty((String)orgForPerm)) {
                        orgForPerm = AcctItemCalcuter.this.getCompany_Number();
                    }
                }
                if (!StringUtils.isEmpty((String)orgForPerm)) {
                    ArrayList stringToArrayList = CslRptUtil.stringToArrayList((String)orgForPerm, (String)"|");
                    this.companysForPermissionCheck = stringToArrayList.toArray(new String[stringToArrayList.size()]);
                }
            } else {
                if ((orgBoundNumber == null || orgBoundNumber.trim().equals("")) && !(AcctItemCalcuter.this.context.getReportAdapter() instanceof RptReportPropertyAdapter)) {
                    orgBoundNumber = AcctItemCalcuter.this.getOrgTreeNumber();
                }
                if (orgUnitNumber == null || orgUnitNumber.trim().equals("")) {
                    hasCompany = true;
                    orgUnitNumber = AcctItemCalcuter.this.getOrgUnit_Number();
                    if (StringUtils.isEmpty((String)orgUnitNumber)) {
                        orgUnitNumber = AcctItemCalcuter.this.getCompany_Number();
                    }
                }
            }
            this._orgBound = orgBoundNumber;
            this._currency = currencyNumber;
            this._convertCurrency = covertCurrencyNumber;
            ArrayList companyNumber = CslRptUtil.stringToArrayList((String)orgUnitNumber, (String)"|");
            this._companys = companyNumber.toArray(new String[companyNumber.size()]);
            if (this.companysForPermissionCheck == null) {
                this.companysForPermissionCheck = this._companys;
            }
            this._dataSource = int_dataSource == 2 && !hasCompany ? new int[]{1, 2} : new int[]{int_dataSource};
        }

        public void setValue(Object v, int type) {
            if (type == 0) {
                this.value_beforeadjust.add(v);
            } else if (type == 1) {
                this.value_adjust.add(v);
            } else if (type == 2) {
                this.value_adjusted.add(v);
            } else if (type == 11) {
                this.value_caliadjusting.add(v);
            } else if (type == 12) {
                this.value_caliadjusted.add(v);
            }
        }

        private String[] getBgUnit_Number() throws EASBizException, BOSException {
            if (AcctItemCalcuter.this.context != null) {
                String number = (String)AcctItemCalcuter.this.context.getReportAdapter().getReportProperty("BgCostCenterNum");
                if (AcctItemCalcuter.this.bgOrgCache.get(number) != null) {
                    return (String[])AcctItemCalcuter.this.bgOrgCache.get(number);
                }
                FullOrgUnitInfo unit = null;
                FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)AcctItemCalcuter.this.ServerCtx).getFullOrgUnitCollection(" where number = '" + number + "'");
                if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
                    unit = fullOrgUnitCollection.get(0);
                }
                if (unit != null && unit.isIsCompanyOrgUnit()) {
                    CompanyOrgUnitInfo companyOrgUnit = null;
                    CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)AcctItemCalcuter.this.ServerCtx).getCompanyOrgUnitCollection(" where number = '" + number + "'");
                    if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
                        companyOrgUnit = companyOrgUnitCollection.get(0);
                    }
                    if (companyOrgUnit != null && companyOrgUnit.isIsBizUnit()) {
                        String[] result = new String[]{number, AcctItemCalcuter.this.treeNumber, null};
                        AcctItemCalcuter.this.bgOrgCache.put(number, result);
                        return result;
                    }
                }
                if (unit != null) {
                    StringBuffer sql = new StringBuffer();
                    Timestamp startTime = new Timestamp(RPTDateUtil.getPeriodFirstDate((int)this._startYear, (int)this._startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this._periodType)).getTime());
                    Timestamp endTimestamp = new Timestamp(RPTDateUtil.getPeriodLastDate((int)this._endYear, (int)this._endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this._periodType)).getTime());
                    sql.append("select distinct t.FNumber treenumber, u.FNumber unitnumber,t.FStartDate ");
                    sql.append(" from T_BG_BgJCArea b join t_org_tree t on b.FareaId = t.FId ");
                    sql.append(" join t_org_baseunit u on b.FUnitId = u.FId ");
                    sql.append(" where b.FOrgUnitId = ? and ((t.FStartDate >= ? and t.FStartDate<= ?) or ( t.FEndDate >=? and t.FEndDate <= ? ) or ( t.FStartDate <=? and t.FEndDate >= ? ) or (t.FStartDate <= ? and t.FEndDate is null) ) order by t.FStartDate desc");
                    IRowSet rowSet = DbUtil.executeQuery((Context)AcctItemCalcuter.this.ServerCtx, (String)sql.toString(), (Object[])new Object[]{unit.getId().toString(), startTime, endTimestamp, startTime, endTimestamp, startTime, endTimestamp, startTime});
                    try {
                        if (rowSet.next()) {
                            String[] result = new String[]{rowSet.getString("unitnumber"), rowSet.getString("treenumber"), "converted"};
                            AcctItemCalcuter.this.bgOrgCache.put(number, result);
                            return result;
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"45_AcctItemCalcuter", (Locale)AcctItemCalcuter.this.ServerCtx.getOriginLocale())});
        }
    }

    class OrgBoundAllVers {
        String _orgBound;
        int _startYear;
        int _endYear;
        int _startPeriod;
        int _endPeriod;
        String key = null;

        OrgBoundAllVers() {
        }

        String getKey() {
            if (this.key == null) {
                this.key = this._orgBound + "|" + this._startYear + "|" + this._endYear + "|" + this._startPeriod + "|" + this._endPeriod;
            }
            return this.key;
        }

        public boolean in(String orgBound, int y, int p) {
            return y >= this._startYear && y <= this._endYear && p >= this._startPeriod && p <= this._endPeriod && this._orgBound.equals(orgBound);
        }
    }
}

