/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormulaInfoSQLProcessor;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.ICombineHandler;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaMutiReturnValue;
import com.kingdee.eas.fi.rpt.batch.IMutiReturnValueSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.ISingleSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.OrgTreeQueryWrapper;
import com.kingdee.eas.fi.rpt.batch.PrepareStateCombineHandler;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.batch.acct.AcctBatchProcessor;
import com.kingdee.eas.fi.rpt.batch.hint.ISQLHintSource;
import com.kingdee.eas.fi.rpt.batch.hint.SQLHintMatcher;
import com.kingdee.eas.fi.rpt.batch.hint.biz.SQLHintSourceFactory;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.DefaultTempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValue;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableUtil;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BatchHelper {
    private static final String RPT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fi.rpt.RPTAutoGenerateResource";
    private static Logger logger = Logger.getLogger(BatchHelper.class);
    private LogService logService;
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final int NOT_NUMBER_VALUE = -9999;
    public static final String MULTI_COMPANY_SEPARATOR_REGEX = "\\||\\,|\\;";
    private int batchSize = 100;
    private ICalculateContextProvider calCulateContext;
    private Context serverContext = null;
    private HashMap companyCache;
    private ChecFmlParamPermissionUtil permissionUtil;
    public static final String STR_SEPRATOR = "|";
    public static final String LONG_NUMBER_FIELD = "FLongNumber";
    public static final String SHORT_NUMBER_FIELD = "FNumber";
    private boolean isTempTableSchemeDebug = false;
    private HashMap cacheContainer;
    private Map<String, String> cacheDelegateFIOrgs = new HashMap<String, String>();
    private int threadCount = 1;
    public LinkedBlockingQueue<IBatchSQLSortState> queue = new LinkedBlockingQueue();
    public AtomicInteger atomic = new AtomicInteger(0);

    public BatchHelper(ICalculateContextProvider context, Context serverCtx) {
        this(serverCtx);
        this.calCulateContext = context;
    }

    public BatchHelper(Context serverCtx) {
        this.serverContext = serverCtx;
        this.companyCache = new HashMap();
        this.logService = new LogService(logger, this.isDebugMode());
        try {
            String count = CSLParamUtil.getStringCslParamValue((Context)serverCtx, (String)"GR_CSL_RPTCALCULATE_THREADCOUNT");
            if (!StringUtils.isEmpty((String)count)) {
                this.threadCount = Integer.valueOf(count.trim());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"get threadcount error.", (Throwable)ex);
        }
    }

    public String getCompany_Number() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("Company.Number");
    }

    public String getCompany_ID() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("Company.ID");
    }

    public String getOrgGroup_Number() {
        if (this.calCulateContext.getReportAdapter() instanceof CSLPropertyAdapter) {
            return (String)this.calCulateContext.getReportAdapter().getReportProperty("CSLReport_OrgUnit_Group");
        }
        return null;
    }

    public int getReport_Year() {
        Integer year = (Integer)this.calCulateContext.getReportAdapter().getReportProperty("Report.Year");
        return year == null ? -1 : year;
    }

    public int getReport_Period() {
        Integer period = (Integer)this.calCulateContext.getReportAdapter().getReportProperty("Report.Period");
        return period == null ? -1 : period;
    }

    public String getTemplateId() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("Report.TemplateId");
    }

    public int getSheet_StartYear(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", sheetName, 0);
    }

    public int getSheet_EndYear(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndYear", sheetName, 0);
    }

    public int getSheet_StartPeriod(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartPeriod", sheetName, 0);
    }

    public int getSheet_EndPeriod(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", sheetName, 0);
    }

    public String getCorrect_Currency_Number(String sheetName) {
        String currency = this.calCulateContext.getReportVariables().getStringValue("Currency", sheetName);
        if (StringUtils.isEmpty((String)currency)) {
            currency = (String)this.calCulateContext.getReportAdapter().getReportProperty("Currency.Number");
        }
        return currency;
    }

    public String getCorrect_Currency_Number() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("Currency.Number");
    }

    public void checkCompanyPermision(String orgUnitForNonType) throws BOSException, EASBizException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            OrgType reportOrgType = this.getRptOrgType();
            if (reportOrgType == null || OrgType.Company.equals((Object)reportOrgType)) {
                perm.checkCompanyPermision(orgUnitForNonType);
            } else {
                perm.checkCompanyPermision(reportOrgType, orgUnitForNonType);
            }
        }
    }

    public void checkCompanyPermision(OrgType reportOrgType, String orgUnitForNonType) throws BOSException, EASBizException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            perm.checkCompanyPermision(reportOrgType, orgUnitForNonType);
        }
    }

    public void checkCompanyPermisionNotSplit(OrgType reportOrgType, String orgUnitForNonType) throws BOSException, EASBizException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            perm.checkCompanyPermisionNotSplit(reportOrgType, orgUnitForNonType);
        }
    }

    public OrgType getRptOrgType() {
        if (this.calCulateContext == null || this.calCulateContext.getReportAdapter() == null) {
            return OrgType.Company;
        }
        OrgType rptOrgType = (OrgType)this.calCulateContext.getReportAdapter().getReportProperty("orgType");
        if (rptOrgType == null) {
            rptOrgType = OrgType.Company;
        }
        return rptOrgType;
    }

    public void checkCommitRepotPermision(String orgTree, String company) throws BOSException, EASBizException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            OrgType rptOrgType = this.getRptOrgType();
            if (rptOrgType == null || OrgType.Company.equals((Object)rptOrgType)) {
                perm.checkCommitRepotPermision(orgTree, company);
            } else {
                perm.checkCommitRepotPermision(rptOrgType, orgTree, company);
            }
        }
    }

    public int getReport_PeriodType() {
        Integer period = (Integer)this.calCulateContext.getReportAdapter().getReportProperty("PeriodType");
        if (period == null) {
            return -1;
        }
        return period;
    }

    public String getSource_Currency_Number() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("SourceCurrency.Number");
    }

    public int getReport_SourceType() {
        Integer i = (Integer)this.calCulateContext.getReportAdapter().getReportProperty("Report.SourceType");
        return i != null ? i : -1;
    }

    public String getOrgUnit_Number() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    public String getOrgUnit_ID() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("OrgUnit.Id");
    }

    public Date getSheet_StartDate(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return null;
        }
        String start = vs.getStringValue("StartDate", sheetName);
        try {
            Date endDate = dateFormat.parse(start);
            return endDate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getSheet_EndDate(String sheetName) {
        ReportVariables vs = this.calCulateContext.getReportVariables();
        if (vs == null) {
            return null;
        }
        String start = vs.getStringValue("EndDate", sheetName);
        try {
            Date endDate = dateFormat.parse(start);
            return endDate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getReport_EndDate() {
        return (Date)this.calCulateContext.getReportAdapter().getReportProperty("Report_EndDate");
    }

    public CompanyOrgUnitInfo getCacheCompany(String fiOrgUnit) throws BOSException {
        if (this.companyCache.get(fiOrgUnit) == null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)fiOrgUnit, CompareType.EQUALS));
            ICompanyOrgUnit company = null;
            company = this.serverContext == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.serverContext);
            CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
            if (coms != null && coms.size() > 0) {
                this.companyCache.put(fiOrgUnit, coms.get(0));
            }
        }
        return (CompanyOrgUnitInfo)this.companyCache.get(fiOrgUnit);
    }

    public static boolean isNonFIOrgType(FullOrgUnitInfo unit, boolean defaultValue) {
        if (unit == null) {
            return defaultValue;
        }
        return !unit.isIsCompanyOrgUnit() && unit.isIsProfitOrgUnit();
    }

    public static String buildInSql(String[] array) {
        StringBuffer sql = new StringBuffer("\n(");
        for (int i = 0; i < array.length; ++i) {
            sql.append(" '").append(array[i].trim()).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")\n");
        return sql.toString();
    }

    public static String buildInSql(Iterator iterator, Context ctx) throws SQLDataException {
        if (!iterator.hasNext()) {
            throw new SQLDataException(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"25_AcctAcCalculator", (Locale)ctx.getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(")\n");
        return sql.toString();
    }

    public String createInSql(Iterator iterator) throws SQLDataException {
        return BatchHelper.buildInSql(iterator, this.serverContext);
    }

    public static String createInSqlForStatic(Iterator iterator, List params) {
        if (!iterator.hasNext()) {
            return "";
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" ? ");
                params.add(iterator.next());
                first = false;
                continue;
            }
            sql.append(" , ?");
            params.add(iterator.next());
        }
        sql.append(")\n");
        return sql.toString();
    }

    public String createInSql(Iterator iterator, List params) throws SQLDataException {
        if (!iterator.hasNext()) {
            throw new SQLDataException(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"25_AcctAcCalculator", (Locale)this.serverContext.getOriginLocale()));
        }
        boolean first = true;
        StringBuffer sql = new StringBuffer("\n(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" ? ");
                params.add(iterator.next());
                first = false;
                continue;
            }
            sql.append(" , ?");
            params.add(iterator.next());
        }
        sql.append(")\n");
        return sql.toString();
    }

    public SQLStringWrapper createMultiAndCondition(Map conditions) throws SQLDataException {
        StringBuffer sb = new StringBuffer();
        Collection values = conditions.values();
        int lastSize = -1;
        for (List list : values) {
            if (lastSize == -1) {
                lastSize = list.size();
                continue;
            }
            if (lastSize == list.size()) continue;
            throw new SQLDataException(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"55_BatchHelper", (Locale)this.serverContext.getOriginLocale()));
        }
        Set keys = conditions.keySet();
        ArrayList params = new ArrayList(lastSize * keys.size());
        sb.append(" (");
        for (int i = 0; i < lastSize; ++i) {
            if (i != 0) {
                sb.append(" OR (");
            }
            boolean first = true;
            for (String key : keys) {
                List valueList = (List)conditions.get(key);
                Object value = valueList.get(i);
                if (first) {
                    sb.append(" (");
                    first = false;
                } else {
                    sb.append(" AND (");
                }
                sb.append(key).append("=?");
                sb.append(")");
                params.add(value);
            }
            sb.append(" )\n");
        }
        SQLStringWrapper wrapper = new SQLStringWrapper(sb.toString(), params);
        return wrapper;
    }

    public String getOrgTreeNumber() {
        OrgTreeInfo info;
        String orgTreeNumber = (String)this.calCulateContext.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (orgTreeNumber == null && !(this.calCulateContext.getReportAdapter() instanceof RptReportPropertyAdapter) && (info = (OrgTreeInfo)this.calCulateContext.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeNumber = info.getNumber();
        }
        return orgTreeNumber;
    }

    public void checkOrgTreePremision(String orgTree) throws ReportException, BOSException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            perm.checkOrgTreePremision(orgTree);
        }
    }

    public ChecFmlParamPermissionUtil getPermissionUtilInstance() {
        if (this.permissionUtil == null) {
            this.permissionUtil = ChecFmlParamPermissionUtil.getInstance(this.calCulateContext);
        }
        return this.permissionUtil;
    }

    public void checkUnitCompPermision(String unit) throws ReportException, BOSException {
        ChecFmlParamPermissionUtil perm = this.getPermissionUtilInstance();
        if (perm != null) {
            OrgType reportOrgType = this.getRptOrgType();
            if (reportOrgType == null || OrgType.Company.equals((Object)reportOrgType)) {
                perm.checkUnitCompPermision(unit);
            } else {
                perm.checkUnitCompPermision(reportOrgType, unit);
            }
        }
    }

    public boolean isSheet_IncludePosted(String sheetName) {
        return this.calCulateContext.getReportVariables().getBoolValue("IncludePosted", sheetName, false);
    }

    public Date getReport_StartDate() {
        return (Date)this.calCulateContext.getReportAdapter().getReportProperty("Report_StartDate");
    }

    public String getReportID() {
        if (this.calCulateContext != null && this.calCulateContext.getReportAdapter() != null) {
            return (String)this.calCulateContext.getReportAdapter().getReportProperty("Report.ID");
        }
        return "NotUsedBooktoCalculate";
    }

    public Map getOrgTreeCollectionByNumberAndDate(Set orgTreeQueryWrapperSet) throws BOSException {
        if (orgTreeQueryWrapperSet.size() == 0) {
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,FNumber,FStartDate,FEndDate from T_ORG_Tree where  \n");
        boolean first = true;
        ArrayList<Object> params = new ArrayList<Object>();
        for (OrgTreeQueryWrapper treeWrapper : orgTreeQueryWrapperSet) {
            if (!first) {
                sql.append(" OR \n");
            } else {
                first = false;
            }
            sql.append(" ( FNumber = ? and FStartDate >= ? and FEndDate <= ?");
            params.add(treeWrapper.getOrgTreeNumber());
            params.add(treeWrapper.getQueryStartDate());
            params.add(treeWrapper.getQueryEndDate());
            sql.append(" )\n");
        }
        sql.append(" and (FStatus in (1,2))  \n");
        sql.append(" order by FstartDate desc,FendDate desc");
        HashMap<String, OrgTreeCollection> orgBoundNumber2OrgTreeCollectionMap = new HashMap<String, OrgTreeCollection>();
        IRowSet row = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (row.next()) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)row.getString("Fid")));
                String number = row.getString(SHORT_NUMBER_FIELD);
                info.setNumber(number);
                info.setStartDate(row.getTimestamp("FStartDate"));
                info.setEndDate(row.getTimestamp("FEndDate"));
                OrgTreeCollection collection = (OrgTreeCollection)orgBoundNumber2OrgTreeCollectionMap.get(number);
                if (collection == null) {
                    collection = new OrgTreeCollection();
                }
                collection.add(info);
                orgBoundNumber2OrgTreeCollectionMap.put(number, collection);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return orgBoundNumber2OrgTreeCollectionMap;
    }

    public void buildFormulaCalculatorKey(Object value, StringBuffer sb) {
        sb.append("[").append(value).append("]");
    }

    public void buildFormulaCalculatorKey(int value, StringBuffer sb) {
        sb.append("[").append(value).append("]");
    }

    public void fillKey2FormulaCalculatorMap(Map map, String key, IFormulaCalculator formula) {
        Object oldParameter = map.get(key);
        if (oldParameter != null) {
            if (oldParameter instanceof List) {
                List list = (List)oldParameter;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) != formula) continue;
                    return;
                }
                ((List)oldParameter).add(formula);
            } else if (oldParameter != formula) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(oldParameter);
                list.add(formula);
                map.put(key, list);
            }
        } else {
            map.put(key, formula);
        }
    }

    public void batchCalculateBigDecimal(IBatchSQLProcessor sqlBuilder) throws BOSException {
        TempTableJdbcTemplate tempTableJdbcTemplate = null;
        try {
            tempTableJdbcTemplate = new TempTableJdbcTemplate(this.serverContext);
            tempTableJdbcTemplate.initConnection();
            this.batchCalculateBigDecimal(sqlBuilder, null, tempTableJdbcTemplate, new PrepareStateCombineHandler());
        }
        finally {
            tempTableJdbcTemplate.cleanupConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchCalculateBigDecimal(IBatchSQLProcessor sqlBuilder, ICombineHandler combineHandler) throws BOSException {
        TempTableJdbcTemplate tempTableJdbcTemplate = null;
        try {
            tempTableJdbcTemplate = new TempTableJdbcTemplate(this.serverContext);
            tempTableJdbcTemplate.initConnection();
            this.batchCalculateBigDecimal(sqlBuilder, null, tempTableJdbcTemplate, combineHandler);
        }
        finally {
            tempTableJdbcTemplate.cleanupConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchCalculateBigDecimal(IBatchSQLProcessor sqlBuilder, IBatchSQLSortState sortState, TempTableJdbcTemplate tempTableJdbcTemplate, ICombineHandler combineHandler) throws BOSException {
        String tempTableName = null;
        String extTempTableName = null;
        try {
            CalculatorCombiner combiner = new CalculatorCombiner();
            combiner.setPrepareState(sqlBuilder.getCombineState());
            Map nullComtinationFormula = this.buildNullcombinationFormulaMap(sqlBuilder.getFormulaCalculators(), sqlBuilder.getAllowedNullFields());
            SQLHintMatcher sqlHintMatcher = new SQLHintMatcher(this.serverContext);
            ISQLHintSource formulatHintSource = new SQLHintSourceFactory().getSource(sortState, sqlBuilder);
            StringBuffer sql = new StringBuffer();
            StringBuffer property = new StringBuffer();
            ArrayList<IFormulaCalculator> usedDyItemList = new ArrayList<IFormulaCalculator>();
            ArrayList params = new ArrayList();
            for (Map.Entry entry : nullComtinationFormula.entrySet()) {
                List blockFormulaList = (List)entry.getValue();
                if (blockFormulaList == null || blockFormulaList.size() == 0) continue;
                Set nullSet = (Set)entry.getKey();
                IFormulaCalculator finalFormula = null;
                for (int i = blockFormulaList.size() - 1; i >= 0 && (finalFormula = (IFormulaCalculator)blockFormulaList.get(i)).isException(); --i) {
                }
                boolean isFirtstSQL = true;
                int index = 0;
                while (index < blockFormulaList.size()) {
                    sqlBuilder.buildSelectPart(nullSet, sql);
                    sqlBuilder.buildFromPart(nullSet, sql);
                    boolean isUseTempTableScheme = false;
                    if (sqlBuilder instanceof ITempTableSQLProcessor) {
                        isUseTempTableScheme = ((ITempTableSQLProcessor)sqlBuilder).isUseTempTableScheme();
                    }
                    boolean addOr = false;
                    if (!isUseTempTableScheme) {
                        sqlBuilder.builderConstantWherePart(nullSet, sql, params);
                        int variablesSize = 0;
                        while (variablesSize < sqlBuilder.getMaxSQLVaribleSize()) {
                            IFormulaCalculator formula = null;
                            if (index < blockFormulaList.size()) {
                                formula = (IFormulaCalculator)blockFormulaList.get(index);
                            } else {
                                if (isFirtstSQL) break;
                                formula = finalFormula;
                            }
                            if (formula == null) break;
                            if (!formula.isException()) {
                                if (addOr) {
                                    if (!(sqlBuilder instanceof ItemFormulaInfoSQLProcessor)) {
                                        sql.append(" OR \n");
                                    }
                                } else {
                                    addOr = true;
                                }
                                int paramCursor = params.size();
                                sqlBuilder.buildVariableWherePart(sql, params, formula);
                                variablesSize += params.size() - paramCursor;
                                if (index < blockFormulaList.size()) {
                                    usedDyItemList.add(formula);
                                }
                            }
                            ++index;
                        }
                    } else {
                        if (!(sqlBuilder instanceof ITempTableSQLProcessor)) {
                            throw new BOSException("sqlBuilder is not instanceof ITempTableSQLProcessor,sqlBuilder must implement ITempTableSQLProcessor");
                        }
                        ITempTableSQLProcessor tempTableSQLProcessor = (ITempTableSQLProcessor)sqlBuilder;
                        ArrayList<ITempTableValue> valuesList = new ArrayList<ITempTableValue>();
                        HashMap<ITempTableValue, ITempTableValue> valuesMap = new HashMap<ITempTableValue, ITempTableValue>();
                        while (index < blockFormulaList.size()) {
                            IFormulaCalculator formula = (IFormulaCalculator)blockFormulaList.get(index);
                            ITempTableValue tempTableValue = tempTableSQLProcessor.insertTempTableValues(formula);
                            if (tempTableValue.getTempTableValueItems().size() > 0 && !valuesMap.containsKey(tempTableValue)) {
                                valuesList.add(tempTableValue);
                                valuesMap.put(tempTableValue, tempTableValue);
                            }
                            usedDyItemList.add(formula);
                            ++index;
                            addOr = true;
                        }
                        if (valuesList.size() > 0) {
                            ITempTableField tempTableField = tempTableSQLProcessor.getTempTableField();
                            tempTableName = TempTableUtil.createDBSystemTempTable(tempTableJdbcTemplate, tempTableField, this.isTempTableSchemeDebug);
                            this.buildInnerJoinTempTable(tempTableSQLProcessor, sql, tempTableName, tempTableField);
                            ITempTableValueInsertProcessor tempTableValueInsertProcessor = tempTableSQLProcessor.getTempTableValueInsertProcessor();
                            if (tempTableValueInsertProcessor == null) {
                                tempTableValueInsertProcessor = new DefaultTempTableValueInsertProcessor();
                            }
                            tempTableValueInsertProcessor.processTempTableValueInsert(tempTableJdbcTemplate, tempTableField, tempTableName, valuesList);
                            tempTableJdbcTemplate.analyzeTable(tempTableName);
                        }
                        sqlBuilder.builderConstantWherePart(nullSet, sql, params);
                        tempTableSQLProcessor.buildDivisionalVariableWherePart(nullSet, sql, params);
                    }
                    sqlBuilder.buildGroupByPart(nullSet, sql);
                    if (addOr) {
                        block37: {
                            block38: {
                                try {
                                    this.handleHint(sql, formulatHintSource, sqlHintMatcher);
                                    this.showDebugLogInfo(sql, params, usedDyItemList);
                                    this.indexFormulas(sqlBuilder, usedDyItemList, combiner.getPropertyToCalculatorMap());
                                    long startTime = System.currentTimeMillis();
                                    this.logService.addLogItem("execute kql", "" + sql.toString());
                                    long executeTime = 0L;
                                    if (!this.isDebugSheetOnCurCalcSheet()) {
                                        if (sqlBuilder instanceof AcctBatchProcessor) {
                                            extTempTableName = ((AcctBatchProcessor)sqlBuilder).preHandle(sql, params, tempTableJdbcTemplate, isUseTempTableScheme);
                                        }
                                        IRowSet rs = tempTableJdbcTemplate.queryForRowSet(sql.toString(), params.toArray());
                                        executeTime = System.currentTimeMillis() - startTime;
                                        while (rs.next()) {
                                            this.indexResultSet(rs, nullSet, sqlBuilder.getIndexResultSetFields(), property);
                                            combineHandler.processCombine(usedDyItemList, rs, combiner, sqlBuilder, property);
                                            property.setLength(0);
                                        }
                                        this.combineMutiValue(combiner, usedDyItemList, sqlBuilder);
                                    }
                                    this.logService.addLogItem("execute kql time", "" + new Long(executeTime));
                                    this.logService.logIt();
                                    this.logService.reset();
                                    if (this.isTempTableSchemeDebug) break block37;
                                    if (tempTableName == null) break block38;
                                }
                                catch (SQLException e) {
                                    try {
                                        throw new SQLDataException(e);
                                        catch (Exception e2) {
                                            logger.error((Object)"calculator error.", (Throwable)e2);
                                            throw new BOSException((Throwable)e2);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (this.isTempTableSchemeDebug) throw throwable;
                                        if (tempTableName != null) {
                                            TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, tempTableName);
                                            tempTableName = null;
                                        }
                                        if (extTempTableName == null) throw throwable;
                                        TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, extTempTableName);
                                        extTempTableName = null;
                                        throw throwable;
                                    }
                                }
                                TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, tempTableName);
                                tempTableName = null;
                            }
                            if (extTempTableName != null) {
                                TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, extTempTableName);
                                extTempTableName = null;
                            }
                        }
                        combiner.getPropertyToCalculatorMap().clear();
                    }
                    sql.setLength(0);
                    usedDyItemList.clear();
                    params.clear();
                    if (!isFirtstSQL) continue;
                    isFirtstSQL = false;
                }
            }
            return;
        }
        finally {
            if (tempTableName != null && !this.isTempTableSchemeDebug) {
                TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, tempTableName);
            }
        }
    }

    private void handleHint(StringBuffer sql, ISQLHintSource formulatHintSource, SQLHintMatcher sqlHintMatcher) {
        try {
            boolean hasHint = false;
            if (!StringUtils.isEmpty((String)formulatHintSource.defineKey().toUpperCase()) && this.calCulateContext != null) {
                String hintStr = this.calCulateContext.getReportVariables().getStringValue(formulatHintSource.defineKey().toUpperCase(), (String)this.calCulateContext.getReportAdapter().getReportProperty("curCalcSheetName"));
                if (StringUtils.isEmpty((String)hintStr)) {
                    hintStr = this.calCulateContext.getReportVariables().getStringValue(formulatHintSource.defineKey().toUpperCase(), null);
                }
                if (!StringUtils.isEmpty((String)hintStr)) {
                    int dbType = DbType.getValue((String)ContextUtil.getDbType((Context)this.serverContext));
                    if (3 == dbType) {
                        String hintSql = "/*dialect*/ " + PsSql.transSql(sql.toString(), dbType) + " " + hintStr;
                        sql.setLength(0);
                        sql.append(hintSql);
                        return;
                    }
                    hasHint = true;
                    String hintSql = formulatHintSource.insertHint(sql.toString(), hintStr);
                    sql.setLength(0);
                    sql.append(hintSql);
                }
            }
            if (!hasHint) {
                String hintSql = sqlHintMatcher.addHint(sql.toString(), formulatHintSource);
                sql.setLength(0);
                sql.append(hintSql);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    private boolean isDebugMode() {
        return DebugLogger.isDebug || this.isDebugSheetOnCurCalcSheet();
    }

    private void combineMutiValue(CalculatorCombiner combiner, List usedDyItemList, IBatchSQLProcessor sqlBuilder) {
        if (!(sqlBuilder instanceof IMutiReturnValueSQLProcessor) || !((IMutiReturnValueSQLProcessor)((Object)sqlBuilder)).isMutiReturnValue()) {
            return;
        }
        for (IFormulaCalculator formula : usedDyItemList) {
            if (formula == null || !(formula instanceof IFormulaMutiReturnValue)) continue;
            Object value = ((IFormulaMutiReturnValue)((Object)formula)).getMutiReturnValue();
            combiner.combineEachValue(formula, value, true);
        }
    }

    private void buildInnerJoinTempTable(ITempTableSQLProcessor tempTableSQLProcessor, StringBuffer sql, String tempTableName, ITempTableField tempTableField) {
        tempTableSQLProcessor.buildInnerJoinTempTable(sql, tempTableName, tempTableField);
    }

    public void batchCalculateBigDecimalBySorter(IBatchSQLSorterProcessor sqlBuilder, IBatchSQLSorterRegister register) throws BOSException {
        this.batchCalculateBigDecimalBySorter(sqlBuilder, register, new PrepareStateCombineHandler(), true);
    }

    public void batchCalculateBigDecimalBySorter(IBatchSQLSorterProcessor sqlBuilder, IBatchSQLSorterRegister register, ICombineHandler combineHandler) throws BOSException {
        this.batchCalculateBigDecimalBySorter(sqlBuilder, register, combineHandler, false);
    }

    public void batchCalculateBigDecimalBySorter(IBatchSQLSorterProcessor sqlBuilder, IBatchSQLSorterRegister register, ICombineHandler combineHandler, boolean isSupportMultiThread) throws BOSException {
        int sortSize = register.getSortStates().size();
        DebugLogger.info(logger, "batch sort size", new Integer(sortSize));
        int sortIndex = 0;
        boolean isCanMultThread = false;
        if (this.threadCount > 1 && isSupportMultiThread) {
            try {
                RptUtil.copyObject(sqlBuilder);
                isCanMultThread = true;
            }
            catch (Throwable ex) {
                logger.error((Object)"", ex);
                isCanMultThread = false;
            }
        }
        try {
            for (IBatchSQLSortState sortState : register.getSortStates()) {
                this.logService.addLogItem("sort[" + sortIndex + "]key", sortState.generateKey());
                this.logService.addLogItem("sort[" + sortIndex + "]zie", "" + new Integer(sortState.getFormulaList().size()));
                ++sortIndex;
                if (isCanMultThread) {
                    this.queue.add(sortState);
                    continue;
                }
                this.batchCalculateBigDecimalForThread(sqlBuilder, sortState, combineHandler);
            }
            if (isCanMultThread) {
                this.multiThreadCalc(sqlBuilder, combineHandler);
            }
        }
        catch (Exception e) {
            logger.error((Object)"rpt calculate thread error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void multiThreadCalc(final IBatchSQLSorterProcessor sqlBuilder, final ICombineHandler combineHandler) throws BOSException {
        if (!this.queue.isEmpty()) {
            int curThreadCount = this.threadCount;
            if (this.queue.size() < this.threadCount) {
                curThreadCount = this.queue.size();
            }
            for (int i = 0; i < curThreadCount; ++i) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            IBatchSQLSorterProcessor curSqlBuilder = (IBatchSQLSorterProcessor)RptUtil.copyObject(sqlBuilder);
                            BatchHelper.this.atomic.incrementAndGet();
                            while (!BatchHelper.this.queue.isEmpty()) {
                                IBatchSQLSortState sortState = (IBatchSQLSortState)BatchHelper.this.queue.remove();
                                BatchHelper.this.batchCalculateBigDecimalForThread(curSqlBuilder, sortState, combineHandler);
                            }
                        }
                        catch (Exception ex) {
                            logger.error((Object)"", (Throwable)ex);
                        }
                        finally {
                            BatchHelper.this.atomic.decrementAndGet();
                        }
                    }
                };
                thread.start();
            }
            try {
                while (this.atomic.get() > 0 || this.queue.size() > 0) {
                    Thread.sleep(50L);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void batchCalculateBigDecimalForThread(IBatchSQLSorterProcessor sqlBuilder, IBatchSQLSortState sortState, ICombineHandler combineHandler) throws BOSException {
        sqlBuilder.setSortState(sortState);
        TempTableJdbcTemplate tempTableJdbcTemplate = null;
        try {
            tempTableJdbcTemplate = new TempTableJdbcTemplate(this.serverContext);
            tempTableJdbcTemplate.initConnection();
            this.batchCalculateBigDecimal(sqlBuilder, sortState, tempTableJdbcTemplate, combineHandler);
        }
        catch (Exception ex) {
            logger.error((Object)"batchCalculateBigDecimal error", (Throwable)ex);
            this.handException(sortState, ex);
        }
        finally {
            tempTableJdbcTemplate.cleanupConnection();
        }
    }

    protected void handException(IBatchSQLSortState sortState, Exception ex) {
        List formulaCalculators = sortState.getFormulaList();
        for (IFormulaCalculator formula : formulaCalculators) {
            FormulaValueBackfill err = new FormulaValueBackfill(formula.getParameter());
            if (DebugLogger.isDebug && this.isDebugSheet(formula.getSheetName())) {
                err.setException(ex);
                continue;
            }
            if (ex.getCause() instanceof SQLException) {
                ex = new BOSException(ResourceBase.getString((String)RPT_AUTO_GENERATE_RESOURCE, (String)"56_BatchHelper", (Locale)this.serverContext.getOriginLocale()) + "::" + ex.getMessage());
                err.setException(ex);
                continue;
            }
            err.setException(ex);
        }
    }

    public void singleCalculateBigDecimal(ISingleSQLProcessor sqlBuilder) throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        for (AbstractFormulaCalculatorParameter formula : sqlBuilder.getFormulaCalculators()) {
            sqlBuilder.preparedBuildSQL(formula);
            sqlBuilder.buildSelectPart(formula.getNullFields(), sql);
            sqlBuilder.buildFromPart(formula.getNullFields(), sql);
            sqlBuilder.builderConstantWherePart(formula.getNullFields(), sql, params);
            sqlBuilder.buildVariableWherePart(sql, params, formula);
            sqlBuilder.buildGroupByPart(formula.getNullFields(), sql);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
            BigDecimal result = CslConstant.BGZERO;
            try {
                while (rs.next()) {
                    BigDecimal newValue = rs.getBigDecimal(sqlBuilder.getValueColumn(formula));
                    if (newValue == null) continue;
                    result = result.add(newValue);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            formula.getParameter().setValue((Object)result);
        }
        sql.setLength(0);
        params.clear();
    }

    private Map buildNullcombinationFormulaMap(List formulaList, Set allowedNullSet) {
        HashMap<Set, List> nullCombinaion = new HashMap<Set, List>();
        if (allowedNullSet == null || allowedNullSet.size() == 0) {
            nullCombinaion.put(new HashSet(), formulaList);
            return nullCombinaion;
        }
        Set allPossibleCombination = CalculatorCombiner.getAllPossibleCombination(allowedNullSet);
        for (Set combinationSet : allPossibleCombination) {
            nullCombinaion.put(combinationSet, new ArrayList());
        }
        for (AbstractFormulaCalculatorParameter formula : formulaList) {
            List list = (List)nullCombinaion.get(formula.getNullFields());
            list.add(formula);
        }
        return nullCombinaion;
    }

    private void indexFormulas(IBatchSQLProcessor sqlBuilder, List usedDyItemList, Map propertyToCalculatorMap) {
        StringBuffer sb = new StringBuffer();
        for (IFormulaCalculator formula : usedDyItemList) {
            Object[][] conditions = sqlBuilder.getIndexFormulaFields(formula);
            for (int j = 0; j < conditions.length; ++j) {
                Object[] indexFormulaFields = conditions[j];
                for (int i = 0; i < indexFormulaFields.length; ++i) {
                    Object field = indexFormulaFields[i];
                    if (field == null || field.toString().equals("")) continue;
                    this.buildFormulaCalculatorKey(field, sb);
                }
                this.fillKey2FormulaCalculatorMap(propertyToCalculatorMap, sb.toString(), formula);
                sb.setLength(0);
            }
        }
    }

    private void indexResultSet(IRowSet rs, Set nullSet, String[] indexResultSetFields, StringBuffer property) throws SQLException {
        for (int i = 0; i < indexResultSetFields.length; ++i) {
            if (nullSet.contains(indexResultSetFields[i])) continue;
            this.buildFormulaCalculatorKey(rs.getObject(indexResultSetFields[i]), property);
        }
    }

    public Context getServerContext() {
        return this.serverContext;
    }

    public ICalculateContextProvider getCalCulateContext() {
        return this.calCulateContext;
    }

    public static void printExceptionMessage(Exception e) throws EASBizException {
        if (e instanceof EASBizException) {
            throw (EASBizException)((Object)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(e);
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\nat " + trace[i]);
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            BatchHelper.printStackTraceAsCause(sb, ourCause, trace);
        }
        throw new EASBizException(new NumericExceptionSubItem("001", sb.toString()));
    }

    private static void printStackTraceAsCause(StringBuffer sb, Throwable ourCause, StackTraceElement[] causedTrace) {
        if (ourCause == null || causedTrace == null) {
            return;
        }
        StackTraceElement[] trace = ourCause.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        sb.append("Caused by: " + ourCause);
        for (int i = 0; i <= m; ++i) {
            sb.append("\nat " + trace[i]);
        }
        if (framesInCommon != 0) {
            sb.append("\t\t... " + framesInCommon + " more");
        }
        Throwable ourCause2 = ourCause.getCause();
        if (ourCause != null) {
            BatchHelper.printStackTraceAsCause(sb, ourCause2, trace);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void initBatchSize(String key) {
        String sql = "select FValue From T_CSL_CSLParam where FKey = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql, (Object[])new Object[]{key});
            if (rowSet.next()) {
                String stringSize = rowSet.getString("FValue");
                this.setBatchSize(Integer.parseInt(stringSize));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTempTableSchemeDebug(boolean isTempTableSchemeDebug) {
        this.isTempTableSchemeDebug = isTempTableSchemeDebug;
    }

    private boolean isDebugSheet(String sheetName) {
        if (StringUtils.isEmpty((String)sheetName)) {
            return false;
        }
        return sheetName.equalsIgnoreCase("debug");
    }

    public boolean isDebugSheetOnCurCalcSheet() {
        if (this.calCulateContext != null) {
            return this.isDebugSheet((String)this.calCulateContext.getReportAdapter().getReportProperty("curCalcSheetName"));
        }
        return false;
    }

    private void showDebugLogInfo(StringBuffer sql, List params, List usedDyItemList) {
        if (this.isDebugMode()) {
            String kql = null;
            for (IFormulaCalculator formula : usedDyItemList) {
                if (!this.isDebugSheet(formula.getSheetName())) continue;
                kql = this.backFillSQL(sql, params);
                if (formula.getParameter() == null) continue;
                Object value = formula.getParameter().getValue();
                if (value != null) {
                    formula.getParameter().setValue((Object)(value + "\n" + kql + "\n"));
                    continue;
                }
                formula.getParameter().setValue((Object)(kql + "\n"));
            }
            kql = this.backFillSQL(sql, params);
            if (this.calCulateContext != null) {
                this.logService.addLogItem("params size", Integer.toString(params.size()) + "   [reportID:" + this.calCulateContext.getReportAdapter() == null ? "" : this.getReportID() + "]");
            } else {
                this.logService.addLogItem("params size", Integer.toString(params.size()));
            }
            this.logService.addLogItem("batch execute kql", kql);
            this.logService.addLogItem("params", params.toArray());
        }
    }

    private String backFillSQL(StringBuffer sql, List params) {
        String kql;
        try {
            String dbType = ContextUtil.getDbType((Context)this.serverContext);
            kql = PsSql.getSqlWithParams(sql, params.toArray(), DbType.getValue((String)dbType), false);
            kql = TransUtil.Translate((String)kql.toString(), (int)DbType.getValue((String)dbType));
        }
        catch (Exception e) {
            kql = sql.toString() + "\n";
            Iterator it1 = params.iterator();
            while (it1.hasNext()) {
                kql = kql + "[" + it1.next() + "]";
            }
        }
        return kql;
    }

    public String getDataCollectNumber() {
        String dataCollectNumber;
        String string = dataCollectNumber = this.calCulateContext == null ? "" : (String)this.calCulateContext.getReportAdapter().getReportProperty("CSLReport_DataCollect_Number");
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = (String)this.serverContext.get((Object)"KEY_DATACOLLECT_NUMBER");
        }
        if (StringUtils.isEmpty((String)dataCollectNumber)) {
            dataCollectNumber = "ACTUALDATA";
        }
        return dataCollectNumber;
    }

    public int initNumberParam(Variant variant) {
        if (variant.getValue() instanceof Number) {
            return ((Number)variant.getValue()).intValue();
        }
        try {
            return Integer.valueOf(variant.getValue().toString());
        }
        catch (Exception ex) {
            return -9999;
        }
    }

    public HashMap getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(HashMap cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public String getK3Template() {
        return (String)this.calCulateContext.getReportAdapter().getReportProperty("isReportFormK3Template");
    }

    public String convertFIOrgUnit(String orgUnitForNonFI) throws EASBizException, BOSException {
        if (orgUnitForNonFI == null) {
            return null;
        }
        OrgType orgTypeForReport = (OrgType)this.calCulateContext.getReportAdapter().getReportProperty("orgType");
        if (orgTypeForReport == null || OrgType.Company.equals((Object)orgTypeForReport)) {
            return orgUnitForNonFI;
        }
        if (orgUnitForNonFI.indexOf(";") != -1) {
            String[] multiOrgUnits = orgUnitForNonFI.split(";\\s*");
            StringBuffer newFiOrgUnitNums = new StringBuffer();
            String key = null;
            StringBuffer orgUnitNumsForQuery = new StringBuffer();
            for (String oneOrgUnit : multiOrgUnits) {
                key = this.keyForCacheDelegateFIOrg(orgTypeForReport, oneOrgUnit);
                if (this.cacheDelegateFIOrgs.containsKey(key)) {
                    newFiOrgUnitNums.append(";" + this.cacheDelegateFIOrgs.get(key));
                    continue;
                }
                orgUnitNumsForQuery.append(",'");
                orgUnitNumsForQuery.append(oneOrgUnit);
                orgUnitNumsForQuery.append("'");
            }
            if (orgUnitNumsForQuery.length() == 0) {
                if (newFiOrgUnitNums.length() > 0) {
                    newFiOrgUnitNums.deleteCharAt(0);
                    return newFiOrgUnitNums.toString();
                }
                throw new ReportException(ReportException.FIND_COMPANY_ERROR);
            }
            orgUnitNumsForQuery.deleteCharAt(0);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            CompanyOrgUnitCollection fiOrgUnitInfos = RptNewUIUtil.getDelegateCompany((Context)this.serverContext, (OrgType)orgTypeForReport, (String)("bu.fnumber in( " + orgUnitNumsForQuery + " )"), (String)"bu", (SelectorItemCollection)selectors);
            if (fiOrgUnitInfos.isEmpty()) {
                // empty if block
            }
            for (int i = 0; i < fiOrgUnitInfos.size(); ++i) {
                String delegateFIOrgNum = fiOrgUnitInfos.get(i).getNumber();
                this.cacheDelegateFIOrgs.put(key, delegateFIOrgNum);
                newFiOrgUnitNums.append(";" + delegateFIOrgNum);
            }
            if (newFiOrgUnitNums.length() > 0) {
                newFiOrgUnitNums.deleteCharAt(0);
                return newFiOrgUnitNums.toString();
            }
            logger.error((Object)(" unvalid org:" + orgUnitForNonFI));
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        String key = this.keyForCacheDelegateFIOrg(orgTypeForReport, orgUnitForNonFI);
        if (this.cacheDelegateFIOrgs.containsKey(key)) {
            return this.cacheDelegateFIOrgs.get(key);
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("number");
        CompanyOrgUnitCollection fiOrgUnitInfos = RptNewUIUtil.getDelegateCompany((Context)this.serverContext, (OrgType)orgTypeForReport, (String)("bu.fnumber='" + orgUnitForNonFI + "'"), (String)"bu", (SelectorItemCollection)selectors);
        if (fiOrgUnitInfos.isEmpty()) {
            // empty if block
        }
        String delegateFIOrgNum = fiOrgUnitInfos.get(0).getNumber();
        this.cacheDelegateFIOrgs.put(key, delegateFIOrgNum);
        return delegateFIOrgNum;
    }

    private String keyForCacheDelegateFIOrg(OrgType orgTypeForReport, String fiOrgUnit) {
        return orgTypeForReport.getValue() + STR_SEPRATOR + fiOrgUnit;
    }

    public String getOrgTreeNumber(int startYear, int startPeriod, int endYear, int endPeriod, int periodType, String orgUnitNumbers, Map orgTreeMap, PeriodCollection periodColls, boolean isMergeByFiscalPeriod) throws EASBizException, BOSException {
        boolean isSingRpt;
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (PeriodCollection)periodColls, (boolean)isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periodColls, (int)endYear, (int)endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)isMergeByFiscalPeriod);
        Timestamp startTime = new Timestamp(startDate.getTime());
        Timestamp endTimestamp = new Timestamp(endDate.getTime());
        String key = orgUnitNumbers + "!" + startTime + "!" + endTimestamp;
        Iterator it = orgTreeMap.keySet().iterator();
        while (it.hasNext()) {
            String keyTem = it.next().toString();
            if (!key.equals(keyTem)) continue;
            return orgTreeMap.get(key).toString();
        }
        String templateid = null;
        int sourceType = this.getReport_SourceType();
        boolean bl = isSingRpt = sourceType == 7 || sourceType == 10 || sourceType == 13;
        if (isSingRpt) {
            templateid = this.getTemplateId();
            try {
                if (templateid != null) {
                    String treeNumber = this.getOrgTreesByDate(this.serverContext, orgUnitNumbers, key, templateid, startDate, endDate, orgTreeMap);
                    return treeNumber;
                }
            }
            catch (BOSException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.FNumber treenumber \n");
        sql.append("from t_org_tree t \n");
        sql.append("inner join T_CSL_TempletDispense dispense on t.fid = dispense.forgboundid \n");
        sql.append("inner join t_org_baseunit baseunit on dispense.fcompanyid =  baseunit.fid \n");
        sql.append("where  baseunit.fnumber = ? and (t.fishide is null or  t.fishide = 0) \n");
        sql.append(" and ((t.FStartDate >= ? and t.FStartDate<= ?) or ( t.FEndDate >=? and t.FEndDate <= ? ) or ( t.FStartDate <=? and t.FEndDate >= ? ) \n");
        sql.append(" or (t.FStartDate <= ? and t.FEndDate is null)) \n");
        sql.append(" order by t.FNumber");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])new Object[]{orgUnitNumbers, startTime, endTimestamp, startTime, endTimestamp, startTime, endTimestamp, startTime});
            if (rowSet.next()) {
                String result = rowSet.getString("treenumber");
                orgTreeMap.put(key, result);
                return result;
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String getOrgTreesByDate(Context ctx, String orgUnitNumbers, String key, String templateid, Date startDate, Date endDate, Map orgTreeMap) throws BOSException, SQLException {
        String treeNumber = null;
        Set<String> orgTreeNumbers = this.getOrgTreeNumbers(ctx, templateid, orgUnitNumbers);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", orgTreeNumbers, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.NOTEQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        OrgTreeCollection orgTreeColl = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection(view);
        if (orgTreeColl != null && !orgTreeColl.isEmpty()) {
            Iterator it = orgTreeColl.iterator();
            Timestamp orgStartDate = null;
            Timestamp orgEndDate = null;
            while (it.hasNext()) {
                OrgTreeInfo orgTree = (OrgTreeInfo)it.next();
                if (orgTree.isIsHide()) continue;
                orgStartDate = orgTree.getStartDate();
                orgEndDate = orgTree.getEndDate();
                if (!(((Date)orgStartDate).compareTo(startDate) >= 0 && ((Date)orgStartDate).compareTo(endDate) <= 0 || orgEndDate != null && ((Date)orgStartDate).compareTo(startDate) >= 0 && ((Date)orgEndDate).compareTo(endDate) <= 0 || orgEndDate != null && ((Date)orgStartDate).compareTo(startDate) <= 0 && ((Date)orgEndDate).compareTo(endDate) >= 0) && (((Date)orgStartDate).compareTo(startDate) > 0 || orgEndDate != null)) continue;
                treeNumber = orgTree.getNumber();
                orgTreeMap.put(key, treeNumber);
                return treeNumber;
            }
        }
        return treeNumber;
    }

    private Set<String> getOrgTreeNumbers(Context ctx, String templateId, String orgUnitNumber) throws BOSException, SQLException {
        HashSet<String> orgTreeNumbers = new HashSet<String>();
        String newestTmplId = this.getNewestTemplateId(ctx, templateId);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT tree.FNumber as treeNumber \n");
        sql.append(" FROM T_CSL_TempletDispense td \n");
        sql.append(" INNER JOIN T_ORG_TREE tree \n");
        sql.append(" ON tree.FID = td.FOrgBoundID and tree.FStatus <> 0 \n");
        sql.append(" inner join t_org_baseunit unit On td.FCompanyID = unit.Fid \n");
        sql.append(" Where td.FDispenseSrcID = ? And unit.FNumber = ? \n");
        ArrayList<String> params = new ArrayList<String>();
        params.add(newestTmplId);
        params.add(orgUnitNumber);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        while (rs.next()) {
            String treeNumber = rs.getString("treeNumber");
            orgTreeNumbers.add(treeNumber);
        }
        return orgTreeNumbers;
    }

    private String getNewestTemplateId(Context ctx, String templateId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select t.FId as id  \n");
        sql.append(" From T_Rpt_Template t \n");
        sql.append(" Inner Join T_Rpt_Template t0 ON t.FGROUP  = t0.FGROUP \n");
        sql.append(" Where t0.FID  = ? And t.FVersionStatus = ? And t.FIsFreezed = ? And t.FIsK3Tpl = ? And t.FGroupTemplateID is null ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(templateId);
        params.add(1);
        params.add(0);
        params.add(0);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        if (rs.next()) {
            return rs.getString("id");
        }
        return null;
    }
}

