/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmSysStatusCtrlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashCaculaterHelper {
    private static CashCaculaterHelper cclh = null;
    private Logger logger = Logger.getLogger(this.getClass());

    public static CashCaculaterHelper getInstance() {
        if (cclh == null) {
            cclh = new CashCaculaterHelper();
        }
        return cclh;
    }

    private CashCaculaterHelper() {
    }

    public BigDecimal cash(Context serverCtx, Object[] args) throws Exception {
        String companyNum = args[0] == null ? "" : args[0].toString();
        CashDataSourceEnum dataSource = CashDataSourceEnum.getEnum((String)args[1].toString());
        String bankAcctNum = args[3] == null ? "" : args[2].toString();
        String currencyNum = args[4] == null ? "" : args[3].toString();
        Date beginDate = null;
        Date endDate = null;
        try {
            beginDate = FMConstants.FORMAT_DAY.parse(args[4].toString());
            endDate = FMConstants.FORMAT_DAY.parse(args[5].toString());
        }
        catch (ParseException e) {
            beginDate = DateHelper.getDayBegin();
            endDate = DateHelper.getDayBegin();
        }
        CashDataTypeEnum dataType = CashDataTypeEnum.getEnum((String)args[6].toString());
        FMVerifyHelper.checkBlank((Object)dataType, (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        if (dataSource == CashDataSourceEnum.C) {
            bankAcctNum = null;
        }
        if (dataSource == null) {
            dataSource = CashDataSourceEnum.CB;
        }
        if (!this.isValidPair(dataSource, dataType)) {
            throw new CasDataException(CasDataException.PAIR_ERROR);
        }
        Set companyIdSet = this.getCompanyIds(serverCtx, companyNum);
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        Set bankAcctIdSet = this.getBankAcctIds(serverCtx, bankAcctNum);
        String currencyId = this.getCurrencyId(serverCtx, currencyNum);
        if (currencyId == null) {
            currencyId = ContextHelperFactory.getLocalInstance((Context)serverCtx).getCurrentCompany().getBaseCurrency().getId().toString();
        }
        if (beginDate != null) {
            beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        }
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("accountTable.number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNum));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = this.getComp(serverCtx).getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo company = coll.get(0);
        String acctTableNum = null;
        if (!company.isIsOnlyUnion()) {
            acctTableNum = company.getAccountTable().getNumber();
        }
        String sql = null;
        sql = this.getSql(serverCtx, dataSource, companyIdSet, acctTableNum, null, bankAcctIdSet, currencyId, beginDate, endDate, dataType, false);
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(serverCtx, sql.toString());
        }
        if (currencyId != null && result != null) {
            ICurrency currency = CurrencyFactory.getLocalInstance((Context)serverCtx);
            CurrencyInfo curInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            result = result.setScale(curInfo.getPrecision(), 4);
        }
        return result;
    }

    private boolean isValidPair(CashDataSourceEnum dataSource, CashDataTypeEnum dataType) {
        boolean flag = true;
        if (dataSource == null && dataType != null) {
            return true;
        }
        switch (dataSource.getValue()) {
            case 2: 
            case 6: 
            case 7: {
                if (dataType.getValue() <= 2) break;
                flag = false;
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                if (dataType.getValue() <= 2) break;
                flag = false;
            }
        }
        return flag;
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private String composeParse(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sIds = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            sIds.append("'").append(it.next()).append("',");
        }
        if (sIds.length() > 0) {
            sIds = sIds.deleteCharAt(sIds.length() - 1);
        }
        return sIds.toString();
    }

    private Set getAccountIds(Context ctx, String acctTableNum, String companyId, CashDataSourceEnum dataSource, String accountNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)accountNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select t1.FId from t_bd_accountview t1 inner join t_bd_accountTable t2").append(" on t1.FAccountTableID =t2.FID ").append("where  t1.FIsLeaf = 1 ");
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        CtrlUnitInfo cu = companyOrgUnitInfo.getCU();
        sql.append(" and t1.FControlUnitId='").append(cu.getId().toString()).append("'");
        if (!StringUtils.isEmpty((String)accountNum)) {
            if (accountNum.indexOf(",") > 0) {
                sql.append(" and t1.FNumber in (");
                String[] nums = accountNum.split(",");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" t1.FNumber = '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and t1.FNumber = '").append(accountNum.trim()).append("'");
            }
        }
        if (dataSource.getValue() == 1 || dataSource.getValue() == 3) {
            sql.append(" and t1.FIsBank = 1");
        } else if (dataSource.getValue() == 0 || dataSource.getValue() == 2) {
            sql.append(" and t1.FIsCash = 1");
        }
        if (acctTableNum != null) {
            sql.append("and t2.FNumber = '").append(acctTableNum).append("'");
        }
        HashSet<String> acctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (acctIdSet.size() > 0) {
            return FMHelper.getAllRefAcctIdSet((Context)ctx, (String)cu.getId().toString(), acctIdSet);
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNT);
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (FMHelper.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private ICompanyOrgUnit getComp(Context serverCtx) throws BOSException {
        ICompanyOrgUnit comp = serverCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)serverCtx);
        return comp;
    }

    private String getSql(Context ctx, CashDataSourceEnum dataSource, Set companyIdSet, String acctTableNum, String accountNum, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<StringBuffer> sqls = new ArrayList<StringBuffer>();
        Iterator it = companyIdSet.iterator();
        int system = 7;
        Map startPeriodMap = FmSysStatusCtrlUtils.getStartPeriod((Context)ctx, (int)system, (Set)companyIdSet);
        Map currentPeriodMap = FmSysStatusCtrlUtils.getCurrentPeriod((Context)ctx, (int)system, (Set)companyIdSet);
        PeriodInfo startPeriod = null;
        PeriodInfo currentPeriod = null;
        while (it.hasNext()) {
            String companyId = (String)it.next();
            startPeriod = (PeriodInfo)startPeriodMap.get(companyId);
            currentPeriod = (PeriodInfo)currentPeriodMap.get(companyId);
            Set accountIdSet = this.getAccountIds(ctx, acctTableNum, companyId, dataSource, accountNum);
            StringBuffer subSql = new StringBuffer();
            String querySql = null;
            querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod) : this.getSummarySql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled));
            if (querySql == null) continue;
            subSql.append(" select sum(SubResult) Result from ( ");
            subSql.append(querySql);
            subSql.append(") SubQuery");
            this.logger.debug((Object)("sql: " + subSql));
            sqls.add(subSql);
        }
        if (sqls.size() <= 0) {
            return null;
        }
        sql.append(sqls.get(0));
        for (int i = 1; i < sqls.size(); ++i) {
            sql.append(" union all ").append(sqls.get(i));
        }
        return sql.toString();
    }

    private String getAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String cAvgSql = this.getJTypeAvgSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod);
        String bAvgSql = this.getJTypeAvgSql(ctx, CashDataSourceEnum.B, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod);
        String rAvgSql = this.getRTypeAvgSql(ctx, CashDataSourceEnum.R, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, startPeriod, currentPeriod);
        String sAvgSql = this.getSTypeAvgSql(companyId, currencyId, accountIdSet, beginDate, endDate);
        if (cAvgSql == null || bAvgSql == null || rAvgSql == null || sAvgSql == null) {
            return null;
        }
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rAvgSql);
                break;
            }
            case 0: {
                sql.append(cAvgSql);
                break;
            }
            case 1: {
                sql.append(bAvgSql);
                break;
            }
            case 2: {
                sql.append(sAvgSql);
                break;
            }
            case 5: {
                sql.append(cAvgSql).append(" union all ").append(rAvgSql);
                break;
            }
            case 4: {
                sql.append(cAvgSql).append(" union all ").append(bAvgSql);
                break;
            }
            case 6: {
                sql.append(sAvgSql).append(" union all ").append(bAvgSql);
                break;
            }
            case 7: {
                sql.append(sAvgSql).append(" union all ").append(rAvgSql);
            }
        }
        return sql.toString();
    }

    private String getBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String cBalanceSql = this.getJTypeBalanceSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod);
        String bBalanceSql = this.getJTypeBalanceSql(ctx, CashDataSourceEnum.B, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod);
        String rBalanceSql = this.getRTypeBalanceSql(ctx, CashDataSourceEnum.R, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, startPeriod);
        String sBalanceSql = this.getSTypeBalanceSql(companyId, currencyId, accountIdSet, beginDate, endDate, dataType);
        if (cBalanceSql == null || bBalanceSql == null || rBalanceSql == null || sBalanceSql == null) {
            return null;
        }
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rBalanceSql);
                break;
            }
            case 0: {
                sql.append(cBalanceSql);
                break;
            }
            case 1: {
                sql.append(bBalanceSql);
                break;
            }
            case 2: {
                sql.append(sBalanceSql);
                break;
            }
            case 5: {
                sql.append(cBalanceSql).append(" union all ").append(rBalanceSql);
                break;
            }
            case 4: {
                sql.append(cBalanceSql).append("union all  ").append(bBalanceSql);
                break;
            }
            case 6: {
                sql.append(sBalanceSql).append(" union all ").append(bBalanceSql);
                break;
            }
            case 7: {
                sql.append(sBalanceSql).append(" union all ").append(rBalanceSql);
            }
        }
        return sql.toString();
    }

    private String getSTypeBalanceSql(String companyId, String currencyId, Set accountIdSet, Date beginDate, Date endDate, CashDataTypeEnum dataType) {
        String accountIds = this.composeParse(accountIdSet);
        StringBuffer sql = new StringBuffer(200);
        sql.append("select SubResult  from (").append("select top 1 FSubTotal SubResult from t_cas_CashCount ").append("where FCompanyId = '").append(companyId).append("'");
        if (accountIds != null && !accountIds.equals("")) {
            sql.append(" and FAccountId in ( ").append(accountIds).append(")");
        }
        sql.append(" and FCurrencyId = '").append(currencyId);
        if (dataType.getValue() == 0) {
            sql.append("' and FCountedDate <={ ").append(TypeConversionUtils.objToDate((Object)DateHelper.getBeforeDay((Date)endDate))).append("}");
        } else if (dataType.getValue() == 1) {
            sql.append("' and FCountedDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        }
        sql.append(" order by FCountedDate desc ) SubQuery");
        return sql.toString();
    }

    private String getSummarySql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String rTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.R, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled));
        String bTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.B, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled));
        String cTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.C, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled));
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rTypeSql);
                break;
            }
            case 0: {
                sql.append(cTypeSql);
                break;
            }
            case 1: {
                sql.append(bTypeSql);
                break;
            }
            case 2: {
                return null;
            }
            case 5: {
                sql.append(cTypeSql).append("union all  ").append(rTypeSql);
                break;
            }
            case 4: {
                sql.append(cTypeSql).append("union all  ").append(bTypeSql);
            }
        }
        return sql.toString();
    }

    private String getRTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return this.getRTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, startPeriod);
    }

    private String getRTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, PeriodInfo startPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (startPeriod == null) {
            return null;
        }
        Date calculateBeginDate = null;
        Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 ? DateHelper.getBeforeDay((Date)endDate) : endDate;
        calculateBeginDate = startPeriod.getBeginDate();
        sql.append(this.getPeriodStartSql(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, startPeriod));
        sql.append(" union all ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, calculateBeginDate, calculateEndDate, dataType, null));
        return sql.toString();
    }

    private String getJTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return this.getJTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod);
    }

    private String getJTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        if (startPeriod == null || currentPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        PeriodInfo period = null;
        Date calculateBeginDate = null;
        Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 ? DateHelper.getBeforeDay((Date)endDate) : endDate;
        period = calculateEndDate.before(startPeriod.getBeginDate()) ? startPeriod : (calculateEndDate.after(currentPeriod.getBeginDate()) ? currentPeriod : PeriodUtils.getPeriodInfo((Context)ctx, (Date)calculateEndDate, (CompanyOrgUnitInfo)company));
        calculateBeginDate = period.getBeginDate();
        sql.append(this.getPeriodStartSql(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, period));
        sql.append(" union all ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, calculateBeginDate, calculateEndDate, dataType, new Boolean(isIncludeUnsettled)));
        return sql.toString();
    }

    private String getPeriodStartSql(CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, PeriodInfo period) {
        StringBuffer sql = new StringBuffer();
        String accountIds = this.composeParse(accountIdSet);
        String accountBankIds = this.composeParse(bankAcctIdSet);
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(period.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID in (").append(accountBankIds + ")");
        }
        if (accountIds != null && accountIds.length() > 0) {
            sql.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        return sql.toString();
    }

    private String getRangeSql(String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, CashDataSourceEnum dataSource, Date beginDate, Date endDate, CashDataTypeEnum dataType, Boolean isIncludeUnsettled) {
        StringBuffer sql = new StringBuffer(200);
        String field = this.getFiled(dataSource, dataType);
        if (dataType.getValue() == 2) {
            field = field + TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate)) + "}) ";
        }
        String from = this.getFrom(dataSource);
        String where = this.getWhere(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, isIncludeUnsettled);
        if (dataSource.equals((Object)CashDataSourceEnum.R)) {
            if (dataType.equals((Object)CashDataTypeEnum.QJF)) {
                where = where + " and FIsDebit =1";
            } else if (dataType.equals((Object)CashDataTypeEnum.QDF)) {
                where = where + " and FIsDebit =0";
            }
        }
        sql.append("select ").append(field).append(from).append(where);
        return sql.toString();
    }

    private String getWhere(CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, Boolean isIncludeUnsettled) {
        String accountIds = this.composeParse(accountIdSet);
        String bankAcctIds = this.composeParse(bankAcctIdSet);
        StringBuffer where = new StringBuffer(100);
        where.append(" where FCompanyId in ('").append(companyId).append("') ").append(" and FCreateDate >={").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        if (currencyId != null) {
            where.append(" and FCurrencyId = '").append(currencyId).append("'");
        }
        if (accountIds != null) {
            where.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && bankAcctIds != null) {
            where.append(" and FAccountBankId in (").append(bankAcctIds).append(")");
        }
        if (dataSource.equals((Object)CashDataSourceEnum.B)) {
            where.append(" and FType = 2 ");
        } else if (dataSource.equals((Object)CashDataSourceEnum.C)) {
            where.append(" and FType = 1 ");
        }
        return where.toString();
    }

    private String getFrom(CashDataSourceEnum dataSource) {
        switch (dataSource.getValue()) {
            case 3: {
                return " SubResult from t_cas_Bankstatement ";
            }
            case 0: {
                return " SubResult from t_cas_JournalSummary ";
            }
            case 1: {
                return " SubResult from t_cas_JournalSummary ";
            }
            case 2: {
                return " SubResult from t_cas_CashCount ";
            }
        }
        return null;
    }

    private String getFiled(CashDataSourceEnum dataSource, CashDataTypeEnum dataType) {
        switch (dataSource.getValue()) {
            case 3: {
                return this.getStatementField(dataType);
            }
            case 0: {
                return this.getJournalField(dataType);
            }
            case 1: {
                return this.getJournalField(dataType);
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    private String getStatementField(CashDataTypeEnum dataType) {
        String field = null;
        switch (dataType.getValue()) {
            case 3: {
                field = "sum(FDebitAmount)";
                break;
            }
            case 4: {
                field = "sum(FCreditAmount)";
                break;
            }
            case 6: {
                field = "count(FID)";
                break;
            }
            case 5: {
                field = "count(FID)";
                break;
            }
            case 0: 
            case 1: {
                field = "sum(FCreditAmount-FDebitAmount) ";
                break;
            }
            case 2: {
                field = "( FCreditAmount - FDebitAmount)*datediff(d,FCreateDate,{";
            }
        }
        return field;
    }

    private String getJournalField(CashDataTypeEnum dataType) {
        String field = null;
        switch (dataType.getValue()) {
            case 3: {
                field = "sum(FDebitAmount)";
                break;
            }
            case 4: {
                field = "sum(FCreditAmount)";
                break;
            }
            case 5: {
                field = "sum(FDebitCount)";
                break;
            }
            case 6: {
                field = "sum(FCreditCount)";
                break;
            }
            case 0: {
                field = "sum(FDebitAmount - FCreditAmount) ";
                break;
            }
            case 1: {
                field = "sum(FDebitAmount - FCreditAmount) ";
                break;
            }
            case 2: {
                field = "(FDebitAmount - FCreditAmount)*datediff(d,FCreateDate,{";
            }
        }
        return field;
    }

    private String getRTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getRTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C));
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, null));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private String getRTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getRTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C, startPeriod));
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, null));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private String getSTypeAvgSql(String companyId, String currencyId, Set accountIdSet, Date beginDate, Date endDate) {
        StringBuffer sql = new StringBuffer(200);
        StringBuffer field = new StringBuffer();
        StringBuffer from = new StringBuffer();
        StringBuffer where = new StringBuffer();
        String accountIds = this.composeParse(accountIdSet);
        field.append(" sum(FSubTotal)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate))).append("})");
        from.append("SubResult from t_cas_CashCount ");
        where.append("where FCompanyId = '").append(companyId).append("'");
        if (accountIds != null) {
            where.append("and FAccountId in ( ").append(accountIds).append(")");
        }
        where.append(" and FCurrencyId = '").append(currencyId).append("' and FCountedDate >={ ").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCountedDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        sql.append("select ").append(field).append(from).append(where);
        return sql.toString();
    }

    private String getJTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        if (beginDate.before(startPeriod.getBeginDate())) {
            beginDate = startPeriod.getBeginDate();
        }
        StringBuffer sql = new StringBuffer();
        String balanceSql = this.getJTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C, isIncludeUnsettled);
        if (balanceSql == null) {
            return null;
        }
        sql.append(balanceSql);
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled)));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private String getJTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        if (startPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        if (beginDate.before(startPeriod.getBeginDate())) {
            beginDate = startPeriod.getBeginDate();
        }
        StringBuffer sql = new StringBuffer();
        String balanceSql = this.getJTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C, isIncludeUnsettled, startPeriod, currentPeriod);
        if (balanceSql == null) {
            return null;
        }
        sql.append(balanceSql);
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled)));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private BigDecimal exeQuerySql(Context ctx, String sql) throws SQLDataException, BOSException {
        IRowSet rs = null;
        BigDecimal result = FMConstants.ZERO;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                BigDecimal value = rs.getBigDecimal("Result");
                if (value == null) continue;
                result = result.add(value);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("sql: " + sql));
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

