/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaAdapter;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLPermissionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ElimDataInvTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElimDataCalculator
extends AbstractCalculator {
    private static Logger logger = Logger.getLogger(ElimDataCalculator.class);
    private LogService logService = new LogService(logger);
    private List formulaCalculatorList_OrgUnitGroup;
    private Map sortMap;
    private Map sortMap_OrgUnitGroup;
    private PeriodCollection fiscalPeriods = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isSupportOtherDS = false;
    private boolean isSupport13Period = false;
    private int batchSize = 50;
    private boolean isUserTmpTable = true;
    private String autoParentItem = null;
    private String autoParentItem2 = null;

    public ElimDataCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        String autoParentItemStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"98_AdjustDynamicItemControllerBean", (Locale)serverCtx.getOriginLocale());
        this.autoParentItem = "'" + autoParentItemStr + "'";
        this.autoParentItem2 = "'" + autoParentItemStr + " *'";
        this.formulaCalculatorList_OrgUnitGroup = new LinkedList();
        boolean[] values = CSLParamUtil.batchGetParam((Context)serverCtx, (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_SupportOtherDS", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupportOtherDS = values[1];
        this.isSupport13Period = values[2];
        this.fiscalPeriods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)serverCtx, (ICalculateContextProvider)context);
        Object[] cslValues = CSLParamUtil.batchGetCslParam((Context)serverCtx, (String[])new String[]{"KEY_CSLPARAM_ELIMDATA_USERTMPTABLE", "KEY_CSLPARAM_ELIMDATA_BATCHSIZE"});
        try {
            if (cslValues[0] != null && cslValues[0].toString().trim().equalsIgnoreCase("FALSE")) {
                this.isUserTmpTable = false;
            }
            if (cslValues[1] != null) {
                this.batchSize = Integer.valueOf(cslValues[1].toString().trim());
            }
        }
        catch (Exception e) {
            logger.error((Object)"get cslParams error.", (Throwable)e);
        }
    }

    private List getFormulaCalculatorList_OrgUnitGroup() {
        return this.formulaCalculatorList_OrgUnitGroup;
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.sortFormulaByElimType();
        if (this.sortMap != null) {
            this.calulateFormula(this.sortMap, true);
        }
        if (this.sortMap_OrgUnitGroup != null) {
            this.calulateFormula(this.sortMap_OrgUnitGroup, false);
        }
    }

    private void sortFormulaByElimType() {
        if (this.getFormulaCalculatorParameterList().size() > 0) {
            this.sortMap = new HashMap(4);
            this.sort(this.sortMap, this.getFormulaCalculatorParameterList());
        }
        if (this.getFormulaCalculatorList_OrgUnitGroup().size() > 0) {
            this.sortMap_OrgUnitGroup = new HashMap(4);
            this.sort(this.sortMap_OrgUnitGroup, this.getFormulaCalculatorList_OrgUnitGroup());
        }
    }

    private void sort(Map map, List formulaList) {
        if (formulaList.size() > 0) {
            for (ElimData elimData : formulaList) {
                List<ElimData> FormulaTypeList;
                String ElimTypeName = elimData.ElimType;
                if (map.containsKey(ElimTypeName)) {
                    FormulaTypeList = (List)map.get(ElimTypeName);
                    FormulaTypeList.add(elimData);
                    continue;
                }
                FormulaTypeList = new ArrayList();
                FormulaTypeList.add(elimData);
                map.put(ElimTypeName, FormulaTypeList);
            }
        }
    }

    private void calulateFormula(Map map, boolean isOrgUnitGroup) throws EASBizException, BOSException {
        ArrayList<ElimData> formulaListSingle = new ArrayList<ElimData>();
        ArrayList<ElimData> formulaListP = new ArrayList<ElimData>();
        ArrayList<ElimData> formulaList = new ArrayList<ElimData>();
        ArrayList<ElimData> adjustOrElimListSingle = new ArrayList<ElimData>();
        ArrayList<ElimData> adjustOrElimListP = new ArrayList<ElimData>();
        ArrayList<ElimData> adjustOrElimList = new ArrayList<ElimData>();
        ArrayList<ElimData> otherListSingle = new ArrayList<ElimData>();
        ArrayList<ElimData> otherListP = new ArrayList<ElimData>();
        ArrayList<ElimData> otherList = new ArrayList<ElimData>();
        for (String key : map.keySet()) {
            List formulaListTemp = (List)map.get(key);
            for (ElimData elimData : formulaListTemp) {
                if (isOrgUnitGroup) {
                    if (!StringUtils.isEmpty((String)elimData.orgTarCompanyNumber)) {
                        if (elimData.startItemNumber.equals(elimData.endItemNumber)) {
                            adjustOrElimListSingle.add(elimData);
                            continue;
                        }
                        if (elimData.endItemNumber.contains(".")) {
                            adjustOrElimListP.add(elimData);
                            continue;
                        }
                        adjustOrElimList.add(elimData);
                        continue;
                    }
                    if (elimData.startItemNumber.equals(elimData.endItemNumber)) {
                        otherListSingle.add(elimData);
                        continue;
                    }
                    if (elimData.endItemNumber.contains(".")) {
                        otherListP.add(elimData);
                        continue;
                    }
                    otherList.add(elimData);
                    continue;
                }
                if (elimData.startItemNumber.equals(elimData.endItemNumber)) {
                    formulaListSingle.add(elimData);
                    continue;
                }
                if (elimData.endItemNumber.contains(".")) {
                    formulaListP.add(elimData);
                    continue;
                }
                formulaList.add(elimData);
            }
            if (!adjustOrElimListSingle.isEmpty()) {
                this.calculate_ElimDatas(adjustOrElimListSingle, isOrgUnitGroup);
                adjustOrElimListSingle.clear();
            }
            if (!adjustOrElimList.isEmpty()) {
                this.calculate_ElimDatas(adjustOrElimList, isOrgUnitGroup);
                adjustOrElimList.clear();
            }
            if (!adjustOrElimListP.isEmpty()) {
                this.calculate_ElimDatas(adjustOrElimListP, isOrgUnitGroup);
                adjustOrElimListP.clear();
            }
            if (!otherListSingle.isEmpty()) {
                this.calculate_ElimDatas(otherListSingle, isOrgUnitGroup);
                otherListSingle.clear();
            }
            if (!otherList.isEmpty()) {
                this.calculate_ElimDatas(otherList, isOrgUnitGroup);
                otherList.clear();
            }
            if (!otherListP.isEmpty()) {
                this.calculate_ElimDatas(otherListP, isOrgUnitGroup);
                otherListP.clear();
            }
            if (!formulaListSingle.isEmpty()) {
                this.calculate_ElimDatas(formulaListSingle, isOrgUnitGroup);
                formulaListSingle.clear();
            }
            if (!formulaList.isEmpty()) {
                this.calculate_ElimDatas(formulaList, isOrgUnitGroup);
                formulaList.clear();
            }
            if (formulaListP.isEmpty()) continue;
            this.calculate_ElimDatas(formulaListP, isOrgUnitGroup);
            formulaListP.clear();
        }
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        ElimData temp = null;
        for (int i = 0; i < params.size(); ++i) {
            temp = new ElimData(params.getParameter(i));
            temp.getParameter().setValue((Object)new BigDecimal("0"));
            if (temp.isException()) {
                this.addToErrorList(temp);
                continue;
            }
            if (temp.isCompany_Otherwise_OrgUnitGroup) {
                this.formulaCalculatorList.add(temp);
                continue;
            }
            this.formulaCalculatorList_OrgUnitGroup.add(temp);
        }
    }

    private void preparePropertyMap(List formulaCalculatorParameterList, CalculatorCombiner combiner) {
        for (ElimData elimData : formulaCalculatorParameterList) {
            PropertyContainer property = new PropertyContainer(8);
            property.put("DataElement", (Object)new Integer(elimData.intValue_dataElement));
            property.put("PeriodType", (Object)new Integer(elimData.intValue_rptPeriodType));
            property.put("EntryYear", (Object)new Integer(elimData.year));
            property.put("ValueType", (Object)new Integer(elimData.intValue_valueType));
            property.put("DataCollectNumber", (Object)elimData.dataCollectNumber);
            if (!elimData.isCompany_Otherwise_OrgUnitGroup && !StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber)) {
                property.put("CompanyNumber", (Object)elimData.orgUnitOnlyGroupNumber);
                property.put("GroupCompanyNumber", null);
            } else {
                property.put("CompanyNumber", (Object)elimData.orgUnitNumber);
                property.put("GroupCompanyNumber", (Object)(StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber) ? null : elimData.orgUnitOnlyGroupNumber));
            }
            property.put("SourceCurrencyNumber", (Object)elimData.sourceCurrencyNumber);
            property.put("CurrencyNumber", (Object)elimData.currencyNumber);
            property.put("OrgTreeNumber", (Object)elimData.orgBoundNumber);
            if (!StringUtils.isEmpty((String)elimData.orgTarCompanyNumber)) {
                property.put("targetcompanynumber", (Object)elimData.orgTarCompanyNumber);
            }
            combiner.addFormulaParameter(property, (IFormulaCalculator)elimData);
        }
    }

    private SQLStringWrapper createCalculateSQL(boolean isCompany_Otherwise_OrgUnitGroup, List calList) {
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(ElimEntry.FCredit),0) as Credit, isnull(sum(ElimEntry.FDebit),0) as Debit, \n");
        sql.append(" Item.FNumber as ItemNumber, \t\t\t\t\t\t\t\n");
        sql.append(" Company.FNumber as CompanyNumber, \t\t\t\t\t\t\n");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" GroupUnit.FNumber as GroupCompanyNumber, \t\t\t\n");
        }
        if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
            sql.append(" TCompany.FNumber as targetCompanyNumber,           \n");
        }
        sql.append(" Elim.FPeriodType as PeriodType, \t\t\t\t\t\t\n");
        sql.append(" ElimEntry.FDataElement as DataElement, \t\t\t\t\n");
        sql.append(" SourceCurrency.FNumber as SourceCurrencyNumber, \t\t\n");
        sql.append(" Currency.FNumber as CurrencyNumber, \t\t\t\t\t\n");
        sql.append(" Elim.FDataCollectNumber as DataCollectNumber,                                 \n");
        sql.append(" Elim.FYear as fYear, \t\t\t\t\t\t\t\t\t\n");
        sql.append(" Elim.FPeriod as fPeriod, \t\t\t\t\t\t\t\t\n");
        sql.append(" Elim.FCheckedStatus as CheckedStatus, \t\t\t\t\t\n");
        sql.append(" Elim.FValueType as ValueType, \t\t\t\t\t\t\t\n");
        sql.append(" OrgTree.FNumber as OrgTreeNumber \t\t\t\t\t\t\n");
        sql.append("from T_CSL_ElIMINATIONENTRY ElimEntry \t\t\t\t\t\n");
        sql.append(" inner join T_CSL_ELIMINATION Elim on ElimEntry.FEliminationID = Elim.FID     \n");
        sql.append(" inner join T_CSL_RPTITEM Item on ElimEntry.FItemID = Item.FID                \n");
        sql.append(" inner join T_BD_CURRENCY SourceCurrency on Elim.FSourceCurrencyID = SourceCurrency.FID \n");
        sql.append(" inner join T_BD_CURRENCY Currency on Elim.FCurrencyID = Currency.FID         \n");
        sql.append(" inner join T_ORG_TREE OrgTree on Elim.FOrgBoundID = OrgTree.FID              \n");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" inner join T_ORG_BASEUNIT GroupUnit on Elim.FOrgUnit = GroupUnit.FID     \n");
            if (this.hasTarCompanyNumber(calList)) {
                sql.append(" inner join T_ORG_BASEUNIT Company on ElimEntry.FInvCompanyID = Company.FID  \n");
                sql.append(" inner join T_ORG_BASEUNIT TCompany on ElimEntry.FtargetCompanyId = TCompany.FID \n");
            } else {
                sql.append(" inner join T_ORG_BASEUNIT Company on ElimEntry.FCompanyID = Company.FID  \n");
            }
        } else {
            sql.append(" inner join T_ORG_BASEUNIT Company on Elim.FOrgUnit = Company.FID         \n");
        }
        sql.append("where   \n");
        String andOr = " or \n";
        LinkedList<Object> params = new LinkedList<Object>();
        List formulasList = null;
        formulasList = calList;
        ElimData elimData = null;
        for (int i = 0; i < formulasList.size(); ++i) {
            elimData = (ElimData)formulasList.get(i);
            if (elimData.isException()) continue;
            if (i != 0) {
                sql.append(andOr);
            }
            sql.append(" (");
            if (!elimData.endItemNumber.equals(elimData.startItemNumber)) {
                sql.append(" ((Item.FNumber >= '" + elimData.startItemNumber + "' and Item.FNumber < '" + elimData.endItemNumber + "' and ( ElimEntry.FSUMMARY is null or (ElimEntry.FSUMMARY <>" + this.autoParentItem + " and ElimEntry.FSUMMARY <>" + this.autoParentItem2 + " ))) or");
            }
            sql.append(" Item.FNumber = '" + elimData.endItemNumber + "' ");
            if (!elimData.endItemNumber.equals(elimData.startItemNumber)) {
                sql.append(" )");
            }
            sql.append(" and ElimEntry.FDataElement = ?           \n");
            params.add(new Integer(elimData.intValue_dataElement));
            sql.append(" and Elim.FPeriodType = ?                 \n");
            params.add(new Integer(elimData.intValue_rptPeriodType));
            sql.append(" and Elim.FYear = ?                       \n");
            params.add(new Integer(elimData.year));
            sql.append(" and Elim.FPeriod >= ?                    \n");
            params.add(new Integer(elimData.startPeriod));
            sql.append("and Elim.FPeriod <= ?                     \n");
            params.add(new Integer(elimData.endPeriod));
            if (!elimData.isIncldUnAudit) {
                sql.append(" and Elim.FCheckedStatus = ?          \n");
                params.add(new Integer(2));
            }
            if (elimData.intValue_ElimType == 1 || elimData.intValue_ElimType == 2) {
                sql.append(" and Elim.FInvestNewType = ?");
                params.add(new Integer(elimData.intValue_ElimType));
            } else if (elimData.intValue_ElimType == 4) {
                sql.append(" and ( Elim.FInvestNewType = 0 or Elim.FInvestNewType is null )");
            }
            sql.append(" and Elim.FValueType= ?                \n");
            params.add(new Integer(elimData.intValue_valueType));
            sql.append(" and Elim.FDataCollectNumber= ?   \n");
            params.add(elimData.dataCollectNumber);
            sql.append(" and Company.FNumber = ?               \n");
            if (!elimData.isCompany_Otherwise_OrgUnitGroup && !StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber)) {
                params.add(elimData.orgUnitOnlyGroupNumber);
            } else {
                params.add(elimData.orgUnitNumber);
                if (isCompany_Otherwise_OrgUnitGroup && !StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber)) {
                    sql.append(" and GroupUnit.FNumber = ?     \n");
                    params.add(elimData.orgUnitOnlyGroupNumber);
                }
                if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
                    sql.append(" and TCompany.FNumber = ?");
                    params.add(elimData.orgTarCompanyNumber);
                }
            }
            sql.append(" and Currency.FNumber = ?        \n");
            params.add(elimData.currencyNumber);
            sql.append(" and SourceCurrency.FNumber = ?  \n");
            params.add(elimData.sourceCurrencyNumber);
            sql.append(" and OrgTree.FNumber = ? )       \n");
            params.add(elimData.orgBoundNumber);
        }
        sql.append("group by                             \n");
        sql.append(" Item.FNumber,Company.FNumber,Elim.FPeriodType,ElimEntry.FDataElement, \n");
        sql.append(" SourceCurrency.FNumber,Currency.FNumber,Elim.FYear,Elim.FPeriod,      \n");
        sql.append("Elim.FCheckedStatus,Elim.FValueType,Elim.FDataCollectNumber,OrgTree.FNumber");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" , GroupUnit.FNumber ");
        }
        if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
            sql.append(" , TCompany.FNumber ");
        }
        SQLStringWrapper result = new SQLStringWrapper(sql.toString(), params);
        return result;
    }

    private boolean hasTarCompanyNumber(List formulist) {
        if (formulist == null || formulist.isEmpty()) {
            return false;
        }
        return ((ElimData)formulist.get((int)0)).orgTarCompanyNumber != null && this.isElimOrAdjust(((ElimData)formulist.get((int)0)).intValue_ElimType);
    }

    private boolean isElimOrAdjust(int val) {
        return 1 == val || 2 == val;
    }

    private void calculate_ElimDatas(List sourceFormulas, boolean isCompany_Otherwise_OrgUnitGroup) throws BOSException, EASBizException {
        if (this.isUserTmpTable) {
            this.calculate(sourceFormulas, isCompany_Otherwise_OrgUnitGroup, sourceFormulas);
        } else {
            List allFormulas = sourceFormulas;
            int i = 0;
            while (i < allFormulas.size()) {
                LinkedList forfulas = new LinkedList();
                for (int j = 0; i < allFormulas.size() && j < this.batchSize; ++j) {
                    forfulas.add(allFormulas.get(i++));
                }
                this.calculate(sourceFormulas, isCompany_Otherwise_OrgUnitGroup, forfulas);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculate(List sourceFormulas, boolean isCompany_Otherwise_OrgUnitGroup, List forfulas) throws BOSException, EASBizException {
        SQLStringWrapper sql2;
        String sql;
        IRowSet rs;
        String tmpTable;
        block17: {
            block16: {
                tmpTable = null;
                rs = null;
                sql = null;
                sql2 = null;
                if (!this.isUserTmpTable) break block16;
                tmpTable = this.createFilterTable(isCompany_Otherwise_OrgUnitGroup, forfulas);
                this.insertDataToTmpTable(isCompany_Otherwise_OrgUnitGroup, tmpTable, forfulas);
                sql = this.createCalculateSQLByTmpTable(isCompany_Otherwise_OrgUnitGroup, forfulas, tmpTable);
                if (sql != null) break block17;
                this.handleAllException();
                if (tmpTable == null || DebugLogger.isDebug) return;
                TempTablePool.getInstance((Context)this.serverContext).releaseTable(tmpTable);
                return;
            }
            sql2 = this.createCalculateSQL(isCompany_Otherwise_OrgUnitGroup, forfulas);
            if (sql2 != null) break block17;
            this.handleAllException();
            if (tmpTable == null || DebugLogger.isDebug) return;
            TempTablePool.getInstance((Context)this.serverContext).releaseTable(tmpTable);
            return;
        }
        try {
            HashSet<String> allowedNullFields = new HashSet<String>();
            if (isCompany_Otherwise_OrgUnitGroup) {
                allowedNullFields.add("GroupCompanyNumber");
            }
            CalculatorCombiner combiner = new CalculatorCombiner(allowedNullFields);
            this.preparePropertyMap(forfulas, combiner);
            CombineState state = new CombineState();
            combiner.setPrepareState(state);
            long startTime = System.currentTimeMillis();
            if (this.isUserTmpTable) {
                if (DebugLogger.isDebug) {
                    this.logService.addLogItem("batch execute ElimData:", "=======================");
                    this.logService.addLogItem("batch execute kql", sql);
                }
                rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql);
            } else {
                this.showDebugLogInfo(sql2.getSQLString(), sql2.getParams());
                rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql2.getSQLString(), (Object[])sql2.getArrayParams());
            }
            long executeTime = System.currentTimeMillis() - startTime;
            this.logService.addLogItem("execute kql time", "" + new Long(executeTime));
            this.logService.logIt();
            this.logService.reset();
            PropertyContainer property = new PropertyContainer(10);
            try {
                while (rs.next()) {
                    BigDecimal debit;
                    BigDecimal credit;
                    property.put("DataElement", (Object)new Integer(rs.getInt("DataElement")));
                    property.put("PeriodType", (Object)new Integer(rs.getInt("PeriodType")));
                    property.put("EntryYear", (Object)new Integer(rs.getInt("fYear")));
                    property.put("ValueType", (Object)new Integer(rs.getInt("ValueType")));
                    property.put("DataCollectNumber", (Object)rs.getString("DataCollectNumber"));
                    property.put("CompanyNumber", (Object)rs.getString("CompanyNumber"));
                    property.put("GroupCompanyNumber", isCompany_Otherwise_OrgUnitGroup ? rs.getString("GroupCompanyNumber") : null);
                    property.put("SourceCurrencyNumber", (Object)rs.getString("SourceCurrencyNumber"));
                    property.put("CurrencyNumber", (Object)rs.getString("CurrencyNumber"));
                    property.put("OrgTreeNumber", (Object)rs.getString("OrgTreeNumber"));
                    if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(sourceFormulas)) {
                        property.put("targetCompanyNumber", (Object)rs.getString("targetCompanyNumber"));
                    }
                    if ((credit = rs.getBigDecimal("Credit")) == null) {
                        credit = CslConstant.BGZERO;
                    }
                    if ((debit = rs.getBigDecimal("Debit")) == null) {
                        debit = CslConstant.BGZERO;
                    }
                    state.setCheckStatus(rs.getInt("CheckedStatus"));
                    state.setCredit(credit);
                    state.setDebit(debit);
                    state.setItemNumber(rs.getString("ItemNumber"));
                    state.setOrgBoundNumber(rs.getString("OrgTreeNumber"));
                    state.setPeriod(rs.getInt("fPeriod"));
                    combiner.combineValue(property);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (tmpTable == null || DebugLogger.isDebug) return;
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"calculate error.", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                if (tmpTable == null || DebugLogger.isDebug) throw throwable;
                TempTablePool.getInstance((Context)this.serverContext).releaseTable(tmpTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)this.serverContext).releaseTable(tmpTable);
        return;
    }

    private boolean insertDataToTmpTable(boolean isCompany_Otherwise_OrgUnitGroup, String tmpTable, List calList) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tmpTable).append("(FStartItemNumber,FEndItemNumber,FDataElement,FPeriodType,FYear,");
        sql.append("FStartPeriod,FEndPeriod,FCheckedStatus,FInvestNewType,FValueType,FDataCollectNumber,");
        sql.append("FCompanyNumber,FCurrencyNumber,");
        sql.append("FSrcCurrencyNumber,FOrgTreeNumber");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(",FGroupUnitNumber");
            if (this.hasTarCompanyNumber(calList)) {
                sql.append(",FTCompanyNumber");
            }
        }
        sql.append(") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        int paramSize = 15;
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(",?");
            ++paramSize;
            if (this.hasTarCompanyNumber(calList)) {
                sql.append(",?");
                ++paramSize;
            }
        }
        sql.append(")");
        try {
            HashSet<String> keys = new HashSet<String>();
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            ElimData elimData = null;
            Object[] param = null;
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < calList.size(); ++i) {
                elimData = (ElimData)calList.get(i);
                if (elimData.isException()) continue;
                param = new Object[paramSize];
                param[0] = elimData.startItemNumber;
                param[1] = elimData.endItemNumber;
                param[2] = new Integer(elimData.intValue_dataElement);
                param[3] = new Integer(elimData.intValue_rptPeriodType);
                param[4] = new Integer(elimData.year);
                param[5] = new Integer(elimData.startPeriod);
                param[6] = new Integer(elimData.endPeriod);
                param[7] = !elimData.isIncldUnAudit ? new Integer(2) : Integer.valueOf(-1);
                if (elimData.intValue_ElimType == 1 || elimData.intValue_ElimType == 2) {
                    param[8] = new Integer(elimData.intValue_ElimType);
                } else if (elimData.intValue_ElimType == 4) {
                    param[8] = 0;
                }
                param[9] = new Integer(elimData.intValue_valueType);
                param[10] = elimData.dataCollectNumber;
                param[11] = !elimData.isCompany_Otherwise_OrgUnitGroup && !StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber) ? elimData.orgUnitOnlyGroupNumber : elimData.orgUnitNumber;
                param[12] = elimData.currencyNumber;
                param[13] = elimData.sourceCurrencyNumber;
                param[14] = elimData.orgBoundNumber;
                if (elimData.isCompany_Otherwise_OrgUnitGroup || StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber)) {
                    if (isCompany_Otherwise_OrgUnitGroup && !StringUtils.isEmpty((String)elimData.orgUnitOnlyGroupNumber) && paramSize >= 16) {
                        param[15] = elimData.orgUnitOnlyGroupNumber;
                    }
                    if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList) && paramSize >= 17) {
                        param[16] = elimData.orgTarCompanyNumber;
                    }
                }
                key.setLength(0);
                for (Object curObj : param) {
                    if (curObj == null) continue;
                    key.append(curObj);
                }
                if (keys.contains(key.toString())) continue;
                params.add(param);
                keys.add(key.toString());
            }
            keys.clear();
            if (params.size() > 0) {
                DbUtil.executeBatch((Context)this.serverContext, (String)sql.toString(), params);
            }
            TempTablePool pool = TempTablePool.getInstance((Context)this.serverContext);
            pool.createIndex(tmpTable, "FStartItemNumber,FEndItemNumber,FDataElement,FPeriodType,FYear,FStartPeriod,FEndPeriod,FCurrencyNumber,FSrcCurrencyNumber,FOrgTreeNumber,FDataCollectNumber,FCompanyNumber", false, false);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new SQLDataException(e);
        }
        return true;
    }

    private String createCalculateSQLByTmpTable(boolean isCompany_Otherwise_OrgUnitGroup, List calList, String tmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("select isnull(sum(mainQuery.Credit),0) as Credit, isnull(sum(mainQuery.Debit),0) as Debit, \n");
        sql.append(" mainQuery.ItemNumber as ItemNumber, \n");
        sql.append(" mainQuery.CompanyNumber as CompanyNumber, \n");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" mainQuery.GroupCompanyNumber as GroupCompanyNumber, \n");
        }
        if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
            sql.append(" mainQuery.targetCompanyNumber as targetCompanyNumber, \n");
        }
        sql.append(" mainQuery.PeriodType as PeriodType, \n");
        sql.append(" mainQuery.DataElement as DataElement, \n");
        sql.append(" mainQuery.SourceCurrencyNumber as SourceCurrencyNumber, \n");
        sql.append(" mainQuery.CurrencyNumber as CurrencyNumber, \n");
        sql.append(" mainQuery.DataCollectNumber as DataCollectNumber, \n");
        sql.append(" mainQuery.fYear as fYear, \n");
        sql.append(" mainQuery.fPeriod as fPeriod, \n");
        sql.append(" mainQuery.CheckedStatus as CheckedStatus, \n");
        sql.append(" mainQuery.ValueType as ValueType, \n");
        sql.append(" mainQuery.OrgTreeNumber as OrgTreeNumber \n");
        sql.append(" from ( \n");
        sql.append(" select distinct ElimEntry.FID as elimId,ElimEntry.FCredit as Credit, ElimEntry.FDebit as Debit, \n");
        sql.append(" Item.FNumber as ItemNumber, \t\t\t\t\t\t\t\n");
        sql.append(" Company.FNumber as CompanyNumber, \t\t\t\t\t\t\n");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" GroupUnit.FNumber as GroupCompanyNumber, \t\t\t\n");
        }
        if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
            sql.append(" TCompany.FNumber as targetCompanyNumber,           \n");
        }
        sql.append(" Elim.FPeriodType as PeriodType, \t\t\t\t\t\t\n");
        sql.append(" ElimEntry.FDataElement as DataElement, \t\t\t\t\n");
        sql.append(" SourceCurrency.FNumber as SourceCurrencyNumber, \t\t\n");
        sql.append(" Currency.FNumber as CurrencyNumber, \t\t\t\t\t\n");
        sql.append(" Elim.FDataCollectNumber as DataCollectNumber,                                 \n");
        sql.append(" Elim.FYear as fYear, \t\t\t\t\t\t\t\t\t\n");
        sql.append(" Elim.FPeriod as fPeriod, \t\t\t\t\t\t\t\t\n");
        sql.append(" Elim.FCheckedStatus as CheckedStatus, \t\t\t\t\t\n");
        sql.append(" Elim.FValueType as ValueType, \t\t\t\t\t\t\t\n");
        sql.append(" OrgTree.FNumber as OrgTreeNumber \t\t\t\t\t\t\n");
        sql.append("from T_CSL_ElIMINATIONENTRY ElimEntry \t\t\t\t\t\n");
        sql.append(" inner join T_CSL_ELIMINATION Elim on ElimEntry.FEliminationID = Elim.FID     \n");
        sql.append(" inner join T_CSL_RPTITEM Item on ElimEntry.FItemID = Item.FID                \n");
        sql.append(" inner join T_BD_CURRENCY SourceCurrency on Elim.FSourceCurrencyID = SourceCurrency.FID \n");
        sql.append(" inner join T_BD_CURRENCY Currency on Elim.FCurrencyID = Currency.FID         \n");
        sql.append(" inner join T_ORG_TREE OrgTree on Elim.FOrgBoundID = OrgTree.FID              \n");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" inner join T_ORG_BASEUNIT GroupUnit on Elim.FOrgUnit = GroupUnit.FID     \n");
            if (this.hasTarCompanyNumber(calList)) {
                sql.append(" inner join T_ORG_BASEUNIT Company on ElimEntry.FInvCompanyID = Company.FID  \n");
                sql.append(" inner join T_ORG_BASEUNIT TCompany on ElimEntry.FtargetCompanyId = TCompany.FID \n");
            } else {
                sql.append(" inner join T_ORG_BASEUNIT Company on ElimEntry.FCompanyID = Company.FID  \n");
            }
        } else {
            sql.append(" inner join T_ORG_BASEUNIT Company on Elim.FOrgUnit = Company.FID         \n");
        }
        sql.append(" inner join ").append(tmpTable).append(" filter on (");
        sql.append("((Item.FNumber >= filter.FStartItemNumber and Item.FNumber <= filter.FEndItemNumber and  ( ElimEntry.FSUMMARY is null or (ElimEntry.FSUMMARY <>" + this.autoParentItem + " and ElimEntry.FSUMMARY <>" + this.autoParentItem2 + " )))");
        sql.append(" or Item.FNumber = filter.FEndItemNumber ) and ElimEntry.FDataElement=filter.FDataElement  ");
        sql.append(" and Elim.FPeriodType=filter.FPeriodType and Elim.FYear = filter.FYear and Elim.FPeriod >= filter.FStartPeriod ");
        sql.append(" and Elim.FPeriod <=filter.FEndPeriod and (filter.FCheckedStatus=-1 or (filter.FCheckedStatus<>-1 and Elim.FCheckedStatus=filter.FCheckedStatus))");
        sql.append(" and (filter.FInvestNewType=0 and ( Elim.FInvestNewType = 0 or Elim.FInvestNewType is null ) or (filter.FInvestNewType<>0 and Elim.FInvestNewType =filter.FInvestNewType) or filter.FInvestNewType is null) ");
        sql.append(" and Elim.FValueType =filter.FValueType and Elim.FDataCollectNumber=filter.FDataCollectNumber");
        sql.append(" and Company.FNumber =filter.FCompanyNumber ");
        sql.append(" and Currency.FNumber=filter.FCurrencyNumber ");
        sql.append(" and SourceCurrency.FNumber=filter.FSrcCurrencyNumber and OrgTree.FNumber=filter.FOrgTreeNumber ");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" and (filter.FGroupUnitNumber is null or filter.FGroupUnitNumber=GroupUnit.FNumber )");
            if (this.hasTarCompanyNumber(calList)) {
                sql.append(" and (filter.FTCompanyNumber is null or filter.FTCompanyNumber=TCompany.FNumber)");
            }
        }
        sql.append(")) as mainQuery \n");
        sql.append("group by                             \n");
        sql.append(" mainQuery.ItemNumber,mainQuery.CompanyNumber,mainQuery.PeriodType,mainQuery.DataElement, \n");
        sql.append(" mainQuery.SourceCurrencyNumber,mainQuery.CurrencyNumber,mainQuery.fYear,mainQuery.fPeriod,      \n");
        sql.append(" mainQuery.CheckedStatus,mainQuery.ValueType,mainQuery.DataCollectNumber,mainQuery.OrgTreeNumber");
        if (isCompany_Otherwise_OrgUnitGroup) {
            sql.append(" , mainQuery.GroupCompanyNumber ");
        }
        if (isCompany_Otherwise_OrgUnitGroup && this.hasTarCompanyNumber(calList)) {
            sql.append(" , mainQuery.targetCompanyNumber ");
        }
        return sql.toString();
    }

    private String createFilterTable(boolean isCompany_Otherwise_OrgUnitGroup, List forfulas) throws Exception {
        String tableName;
        StringBuffer create = new StringBuffer();
        create.append("create table Tmp_TempFilterTable");
        create.append("(FStartItemNumber nvarchar(80),FEndItemNumber nvarchar(80),FDataElement int,FPeriodType int,FYear int,");
        create.append("FStartPeriod int,FEndPeriod int,FCheckedStatus int,FInvestNewType int,FValueType int,FDataCollectNumber nvarchar(30),");
        create.append("FCompanyNumber nvarchar(80),FCurrencyNumber nvarchar(80),");
        create.append("FSrcCurrencyNumber nvarchar(80),FOrgTreeNumber nvarchar(80)");
        if (isCompany_Otherwise_OrgUnitGroup) {
            create.append(",FGroupUnitNumber nvarchar(80)");
            if (this.hasTarCompanyNumber(forfulas)) {
                create.append(",FTCompanyNumber nvarchar(80)");
            }
        }
        create.append(")");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)this.serverContext);
            tableName = pool.createTempTable(create.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void showDebugLogInfo(String sql, List params) {
        if (DebugLogger.isDebug) {
            this.logService.addLogItem("batch execute ElimData:", "=======================");
            String ksql = this.backFillSQL(sql, params);
            this.logService.addLogItem("params size", Integer.toString(params.size()));
            this.logService.addLogItem("batch execute kql", ksql);
            this.logService.addLogItem("params", params.toArray());
        }
    }

    private String backFillSQL(String sql, List params) {
        String kql;
        try {
            String dbType = ContextUtil.getDbType((Context)this.serverContext);
            kql = PsSql.getSqlWithParams(sql, params.toArray(), DbType.getValue((String)dbType), false);
        }
        catch (SQLException e) {
            kql = sql.toString() + "\n";
            Iterator it1 = params.iterator();
            while (it1.hasNext()) {
                kql = kql + "[" + it1.next() + "]";
            }
        }
        return kql;
    }

    @Override
    protected void clear() {
        if (this.sortMap != null) {
            this.sortMap.clear();
        }
        if (this.sortMap_OrgUnitGroup != null) {
            this.sortMap_OrgUnitGroup.clear();
        }
    }

    private class CombineState
    implements IFormulaCombinationPreparedState {
        private BigDecimal debit;
        private BigDecimal credit;
        private String itemNumber;
        private int period;
        private int checkStatus;
        private String orgBoundNumber;
        private String targetCompanyNumber;

        private CombineState() {
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            ElimData elimData = (ElimData)formula;
            if (elimData.startItemNumber == null) {
                return false;
            }
            if (elimData.startItemNumber.compareTo(this.itemNumber) > 0) {
                return false;
            }
            if (elimData.endItemNumber == null) {
                return false;
            }
            if (elimData.endItemNumber.compareTo(this.itemNumber) < 0) {
                return false;
            }
            if (elimData.startPeriod > this.period) {
                return false;
            }
            if (elimData.endPeriod < this.period) {
                return false;
            }
            return elimData.isIncldUnAudit || this.checkStatus == 2;
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            ElimData elimDataData = (ElimData)formula;
            if (elimDataData.intValue_dc == 1) {
                return this.debit;
            }
            if (elimDataData.intValue_dc == 0) {
                return this.credit;
            }
            return this.debit.subtract(this.credit);
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            return true;
        }

        public void setItemNumber(String itemNumber) {
            this.itemNumber = itemNumber;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public void setCheckStatus(int checkStatus) {
            this.checkStatus = checkStatus;
        }

        public void setOrgBoundNumber(String orgBoundNumber) {
            this.orgBoundNumber = orgBoundNumber;
        }

        public String getOrgBoundNumber() {
            return this.orgBoundNumber;
        }

        public void setDebit(BigDecimal debit) {
            this.debit = debit;
        }

        public void setCredit(BigDecimal credit) {
            this.credit = credit;
        }

        public String getTargetCompanyNumber() {
            return this.targetCompanyNumber;
        }

        public void setTargetCompanyNumber(String targetCompanyNumber) {
            this.targetCompanyNumber = targetCompanyNumber;
        }
    }

    private class ElimData
    extends AbstractFormulaCalculatorParameter {
        String orgBoundNumber;
        String orgUnitOnlyGroupNumber;
        String orgUnitNumber;
        String orgTarCompanyNumber;
        String sourceCurrencyNumber;
        String currencyNumber;
        String startItemNumber;
        String endItemNumber;
        String rptPeriodType;
        int yearOffset;
        int startPeriodOffset;
        int endPeriodOffset;
        String dataElement;
        String valueType;
        String dc;
        boolean isIncldUnAudit;
        String dataCollectNumber;
        String ElimType;
        int intValue_rptPeriodType;
        int year;
        int startPeriod;
        int endPeriod;
        int intValue_dataElement;
        int intValue_valueType;
        int intValue_dc;
        int intValue_ElimType;
        boolean isCompany_Otherwise_OrgUnitGroup;

        public ElimData(Parameter param) {
            super(param);
        }

        @Override
        protected void verifyArgs() throws ReportException, BOSException, EASBizException {
            int tptSrcTypeEnum = ElimDataCalculator.this.batchHelper.getReport_SourceType();
            if (tptSrcTypeEnum == 2 || tptSrcTypeEnum == 14 || tptSrcTypeEnum == 15 || tptSrcTypeEnum == 3 || tptSrcTypeEnum == 4 || tptSrcTypeEnum == 8 || tptSrcTypeEnum == 11 || tptSrcTypeEnum == 12 || tptSrcTypeEnum == 31 || tptSrcTypeEnum == 33 || tptSrcTypeEnum == 34 || tptSrcTypeEnum == 32 || tptSrcTypeEnum == 35) {
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.isCompany_Otherwise_OrgUnitGroup = false;
                    this.orgUnitNumber = ElimDataCalculator.this.batchHelper.getOrgUnit_Number();
                } else {
                    this.isCompany_Otherwise_OrgUnitGroup = true;
                    if (StringUtils.isEmpty((String)this.orgUnitOnlyGroupNumber)) {
                        this.orgUnitOnlyGroupNumber = ElimDataCalculator.this.batchHelper.getOrgUnit_Number();
                    }
                }
            } else if (tptSrcTypeEnum == -1) {
                boolean isUnit = this.orgUnitOnlyGroupNumber.equals(this.orgUnitNumber);
                this.isCompany_Otherwise_OrgUnitGroup = !isUnit;
            } else if (tptSrcTypeEnum == 68 || tptSrcTypeEnum == 69 || tptSrcTypeEnum == 67) {
                boolean isUnit = this.orgUnitOnlyGroupNumber.equals(this.orgUnitNumber);
                if (isUnit) {
                    this.isCompany_Otherwise_OrgUnitGroup = false;
                } else {
                    this.isCompany_Otherwise_OrgUnitGroup = true;
                    if (StringUtils.isEmpty((String)this.orgUnitOnlyGroupNumber)) {
                        OrgUnitInfo unitInfo = (OrgUnitInfo)ElimDataCalculator.this.batchHelper.getServerContext().get((Object)OrgType.UnionDebt);
                        this.orgUnitOnlyGroupNumber = unitInfo == null ? "" : unitInfo.getNumber();
                    }
                }
            } else {
                this.isCompany_Otherwise_OrgUnitGroup = true;
                if (StringUtils.isEmpty((String)this.orgUnitNumber)) {
                    this.orgUnitNumber = ElimDataCalculator.this.batchHelper.getCompany_Number();
                }
                if (StringUtils.isEmpty((String)this.orgUnitOnlyGroupNumber)) {
                    OrgUnitInfo unitInfo = (OrgUnitInfo)ElimDataCalculator.this.batchHelper.getServerContext().get((Object)OrgType.UnionDebt);
                    this.orgUnitOnlyGroupNumber = unitInfo == null ? "" : unitInfo.getNumber();
                }
            }
            ElimDataCalculator.this.batchHelper.checkUnitCompPermision(this.orgUnitNumber);
            if (StringUtils.isEmpty((String)this.dataCollectNumber)) {
                this.dataCollectNumber = ElimDataCalculator.this.batchHelper.getDataCollectNumber();
            }
            if (ElimDataCalculator.this.isSupportOtherDS) {
                CSLPermissionUtil.checkDataCollectPermissionForFormula((Context)ElimDataCalculator.this.serverContext, (String)ElimDataCalculator.this.serverContext.getCaller().toString(), (String)this.dataCollectNumber);
            }
            if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
                this.orgBoundNumber = ElimDataCalculator.this.batchHelper.getOrgTreeNumber();
                if (StringUtils.isEmpty((String)this.orgBoundNumber)) {
                    throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
                }
            }
            ElimDataCalculator.this.batchHelper.checkOrgTreePremision(this.orgBoundNumber);
            if (StringUtils.isEmpty((String)this.currencyNumber)) {
                this.currencyNumber = ElimDataCalculator.this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
            }
            if (StringUtils.isEmpty((String)this.sourceCurrencyNumber)) {
                this.sourceCurrencyNumber = this.currencyNumber;
            }
            this.intValue_rptPeriodType = StringUtils.isEmpty((String)this.rptPeriodType) ? ElimDataCalculator.this.batchHelper.getReport_PeriodType() : FormulaAdapter.getRptPeriodType((String)this.rptPeriodType);
            if (this.intValue_rptPeriodType < 0) {
                throw new EASBizException(new NumericExceptionSubItem("01423", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"49_AdjustDataCalculator", (Locale)ElimDataCalculator.this.serverContext.getLocale())));
            }
            int rptYear = ElimDataCalculator.this.batchHelper.getReport_Year();
            int rptPeriod = ElimDataCalculator.this.batchHelper.getReport_Period();
            this.intValue_dataElement = -1;
            if (ElimDataCalculator.this.serverContext == null && !StringUtils.isEmpty((String)this.dataElement)) {
                this.intValue_dataElement = DataElementProvider.getDataElementInnerValue((String)this.dataElement);
            } else if (!StringUtils.isEmpty((String)this.dataElement)) {
                this.intValue_dataElement = DataElementProvider.getDataElementInnerValue((Context)ElimDataCalculator.this.serverContext, (String)this.dataElement);
            }
            this.intValue_valueType = FormulaAdapter.getValueType((String)this.valueType);
            if (this.intValue_valueType < 0) {
                throw new EASBizException(new NumericExceptionSubItem("345533", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"51_AdjustDataCalculator", (Locale)ElimDataCalculator.this.serverContext.getLocale())));
            }
            this.intValue_ElimType = this.getElimValueType(this.ElimType);
            if (this.intValue_ElimType < 0) {
                throw new EASBizException(new NumericExceptionSubItem("345511", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"63_ElimDataCalculator", (Locale)ElimDataCalculator.this.serverContext.getLocale())));
            }
            if (ElimDataCalculator.this.isElimOrAdjust(this.intValue_ElimType) && ((Object[])this.getParameter().getArgs()[0]).length > 16) {
                if (this.orgTarCompanyNumber == null) {
                    throw new EASBizException(new NumericExceptionSubItem("01998", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"64_ElimDataCalculator", (Locale)ElimDataCalculator.this.serverContext.getLocale())));
                }
            } else {
                this.orgTarCompanyNumber = null;
            }
            this.intValue_dc = FormulaAdapter.getDebitOrCredit((String)this.dc);
            if (this.intValue_dc < 0) {
                throw new EASBizException(new NumericExceptionSubItem("01457", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"52_AdjustDataCalculator", (Locale)ElimDataCalculator.this.serverContext.getLocale())));
            }
            int[] start = null;
            int[] end = null;
            if (ElimDataCalculator.this.isSupport13Period) {
                start = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.intValue_rptPeriodType, (int)this.yearOffset, (int)this.startPeriodOffset, (boolean)ElimDataCalculator.this.isSupport13Period);
                end = RPTDate13Util.getRptYearAndPeriod((int)rptYear, (int)rptPeriod, (int)this.intValue_rptPeriodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)ElimDataCalculator.this.isSupport13Period);
            } else {
                start = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)ElimDataCalculator.this.fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.intValue_rptPeriodType, (int)this.yearOffset, (int)this.startPeriodOffset, (boolean)ElimDataCalculator.this.isMergeByFiscalPeriod);
                end = FiscalPeriodHelper.getRptFormualYearAndPeriod((PeriodCollection)ElimDataCalculator.this.fiscalPeriods, (int)rptYear, (int)rptPeriod, (int)this.intValue_rptPeriodType, (int)this.yearOffset, (int)this.endPeriodOffset, (boolean)ElimDataCalculator.this.isMergeByFiscalPeriod);
            }
            if (start != null) {
                this.year = start[0];
            } else if (end != null) {
                this.year = end[0];
            }
            this.startPeriod = start == null ? rptPeriod : start[1];
            this.endPeriod = end == null ? rptPeriod : end[1];
        }

        @Override
        protected void initArgs() throws BOSException, EASBizException {
            Object[] objs = (Object[])this.getParameter().getArgs()[0];
            int i = 0;
            String string = this.orgBoundNumber = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.orgUnitOnlyGroupNumber = objs.length <= 14 ? "" : (((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString());
            String string2 = this.orgUnitNumber = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.sourceCurrencyNumber = objs.length == 13 ? "" : (((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString());
            this.currencyNumber = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.startItemNumber = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.endItemNumber = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.rptPeriodType = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.yearOffset = ((Variant)objs[i++]).getValue() == null ? -1 : Integer.parseInt(((Variant)objs[i - 1]).getValue().toString());
            this.startPeriodOffset = ((Variant)objs[i++]).getValue() == null ? -1 : Integer.parseInt(((Variant)objs[i - 1]).getValue().toString());
            this.endPeriodOffset = ((Variant)objs[i++]).getValue() == null ? -1 : Integer.parseInt(((Variant)objs[i - 1]).getValue().toString());
            this.dataElement = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            String string3 = this.valueType = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.ElimType = objs.length < 16 || objs.length == 16 && this.isDataCollectParam(((Variant)objs[15]).getValue().toString()) ? ElimDataInvTypeEnum.ALL.getName() : (((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString());
            this.dc = ((Variant)objs[i++]).getValue() == null ? null : ((Variant)objs[i - 1]).getValue().toString();
            this.isIncldUnAudit = ((Variant)objs[i]).getValue() != null && !((Variant)objs[i]).getValue().toString().equals("false");
            if (objs.length < 17) {
                this.orgTarCompanyNumber = null;
            } else {
                Object obgTcompanyNumber;
                String string4 = this.orgTarCompanyNumber = (obgTcompanyNumber = ((Variant)objs[++i]).getValue()) == null || obgTcompanyNumber.toString().trim().equals("") ? null : obgTcompanyNumber.toString().trim();
            }
            this.dataCollectNumber = objs.length == 18 ? (((Variant)objs[++i]).getValue() == null ? null : ((Variant)objs[i]).getValue().toString()) : (objs.length == 16 && this.isDataCollectParam(((Variant)objs[15]).getValue().toString()) ? (((Variant)objs[15]).getValue() == null ? null : ((Variant)objs[15]).getValue().toString()) : "");
        }

        private boolean isDataCollectParam(String paramitem) {
            return paramitem.equalsIgnoreCase("ACTUALDATA") || paramitem.equalsIgnoreCase("BUDGETDATA") || StringUtils.isEmpty((String)paramitem);
        }

        private int getElimValueType(String name) {
            if (ElimDataInvTypeEnum.getEnum(name) != null) {
                return ElimDataInvTypeEnum.getEnum(name).getValue();
            }
            return -1;
        }
    }
}

