/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.CalculatorCombiner;
import com.kingdee.eas.fi.rpt.batch.ElimRpt;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElimRptCalculator
extends AbstractCalculator {
    boolean isMergeByFiscalPeriod = false;
    boolean isSupport13Period = false;
    PeriodCollection fiscalPeriods = null;
    private boolean isUseTempTable = false;
    private boolean isUseTempTableDebug = false;
    private int sqlVarSize = 500;
    private static final String T_CSL_EXCHITEMDATA = "T_CSL_ExchItemData";
    private static final String T_CSL_INVESTITEMDATA = "T_CSL_InvestItemData";
    private static final String T_CSL_INTERITEMDATA = "T_CSL_InterItemData";
    private static final String[] TABLES = new String[]{"T_CSL_ExchItemData", "T_CSL_InvestItemData", "T_CSL_InterItemData"};

    public ElimRptCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        String dbType;
        Object[] cslValues = CSLParamUtil.batchGetCslParam((Context)serverCtx, (String[])new String[]{"KEY_CSLPARAM_ELIMRPT_BATCHSIZE", "ELIMRPT_USE_TEMP_TABLE_SCHEME", "ELIMRPT_USE_TEMP_TABLE_SCHEME_DEBUG"});
        if (cslValues != null && cslValues[0] != null) {
            this.sqlVarSize = Integer.valueOf(cslValues[1].toString().trim());
        }
        if (cslValues != null && cslValues[1] != null) {
            this.isUseTempTable = Boolean.valueOf(cslValues[1].toString().trim());
        }
        if (cslValues != null && cslValues[2] != null) {
            this.isUseTempTableDebug = Boolean.valueOf(cslValues[2].toString().trim());
        }
        if (serverCtx != null && serverCtx.get((Object)"dbType") != null && cslValues[0] == null && !this.isUseTempTable && 3 == DbType.getValue((String)(dbType = (String)serverCtx.get((Object)"dbType")))) {
            this.sqlVarSize = 200;
        }
    }

    @Override
    protected void calculate() throws BOSException {
        CalculatorCombiner combiner = new CalculatorCombiner(new HashMap());
        combiner.setPrepareState(new ElimRptCombinestate());
        int length = TABLES.length;
        for (int i = 0; i < length; ++i) {
            this.calculateAll(combiner, TABLES[i]);
        }
    }

    @Override
    protected void clear() {
        this.formulaCalculatorList.clear();
        this.errorList.clear();
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initElimRpt(params);
        this.initOrgBoundId();
    }

    private void initElimRpt(SortedParameterArray params) throws BOSException, EASBizException {
        boolean[] values = CSLParamUtil.batchGetParam((Context)this.getServerContext(), (String[])new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        this.isMergeByFiscalPeriod = values[0];
        this.isSupport13Period = values[1];
        if (this.isMergeByFiscalPeriod) {
            this.fiscalPeriods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.getServerContext(), (ICalculateContextProvider)this.getCalCulateContext());
        }
        ElimRpt.setMergeByFiscalPeriod(this.isMergeByFiscalPeriod);
        ElimRpt.setFiscalPeriods(this.fiscalPeriods);
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            ElimRpt elim = new ElimRpt(params.getParameter(i), this.batchHelper);
            if (elim.isException()) {
                this.addToErrorList(elim, elim.getException());
                continue;
            }
            if (elim.isMuliFormula()) {
                this.formulaCalculatorList.addAll(this.separateFormula(elim));
                continue;
            }
            this.formulaCalculatorList.add(elim);
        }
    }

    private List separateFormula(ElimRpt elim) {
        Parameter param = elim.getParameter();
        ArrayList<ElimRpt> formuaList = new ArrayList<ElimRpt>();
        int startYear = elim.getYear();
        int endYear = elim.getEndYear();
        int startPeriod = elim.getPeriod();
        int endPeriod = elim.getEndPeriod();
        ElimRpt elimBegin = new ElimRpt(param, this.batchHelper);
        elimBegin.setYear(startYear);
        elimBegin.setPeriod(startPeriod);
        elimBegin.setEndPeriod(RPTDateUtil.getPeriod((int)startYear, (int)12, (int)31, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((String)elimBegin.getPeriodType())));
        formuaList.add(elimBegin);
        ElimRpt elimOver = new ElimRpt(param, this.batchHelper);
        elimOver.setYear(endYear);
        elimOver.setPeriod(RPTDateUtil.getPeriod((int)endYear, (int)1, (int)1, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((String)elimOver.getPeriodType())));
        elimOver.setEndPeriod(endPeriod);
        formuaList.add(elimOver);
        int yearDiff = endYear - startYear;
        for (int i = 1; i < yearDiff; ++i) {
            ElimRpt elimMid = new ElimRpt(param, this.batchHelper);
            elimMid.setYear(startYear + i);
            elimMid.setPeriod(RPTDateUtil.getPeriod((int)(startYear + i), (int)1, (int)1, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((String)elimMid.getPeriodType())));
            elimMid.setEndPeriod(RPTDateUtil.getPeriod((int)(startYear + i), (int)12, (int)31, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((String)elimMid.getPeriodType())));
            formuaList.add(elimMid);
        }
        return formuaList;
    }

    private StringBuffer getQuery(String tableName, boolean isInterItemData, String adjustStatus) {
        StringBuffer adjustSql = null;
        if (adjustStatus.equals("0") || adjustStatus.equals("1")) {
            adjustSql = new StringBuffer();
            adjustSql.append(" select itemData.fid as fid ,sum(adjustDetails.FItemdcvalue) as adjustData \r\n");
            adjustSql.append(" from T_CSL_AdjustEntryDetails adjustDetails \t\r\n");
            adjustSql.append(" inner join ").append(tableName).append(" itemData \t\r\n");
            adjustSql.append("     on itemData.FTargetCompanyID=adjustDetails.FCompanyID  \r\n");
            adjustSql.append(" and adjustDetails.FDataElement=itemData.FDataElement \r\n");
            adjustSql.append(" inner join t_csl_adjustentry adjustentry \t\t\t\r\n");
            adjustSql.append(" \ton adjustDetails.FAdjustEntryID=adjustentry.fid \r\n");
            adjustSql.append(" inner join t_csl_adjust adjust \t\t\t\t\t\r\n");
            adjustSql.append("    on adjustentry.fadjustid=adjust.fid and adjust.FOrgUnit=itemData.FCompanyID \r\n");
            adjustSql.append("    and adjust.fyear=itemData.fyear and adjust.fperiod=itemData.fperiod \t  \r\n");
            adjustSql.append("    and adjust.FPeriodType=itemData.FPeriodType \t\t\t\t\t\t\t\t  \r\n");
            adjustSql.append("    and adjust.fcheckedStatus=2 \t\t\t\t\t\t\t\t\t  \r\n");
            adjustSql.append(" inner join T_CSL_RptReceived AS rptreceived \t\t\t\t\t\t  \r\n");
            if (!tableName.equalsIgnoreCase(T_CSL_INVESTITEMDATA)) {
                adjustSql.append("    on itemData.FReport = rptreceived.FReportID \t\t\t\t  \r\n");
            } else {
                adjustSql.append("    on itemData.FReportId = rptreceived.FReportID \t\t\t\t  \r\n");
            }
            adjustSql.append("    and  rptreceived.FOrgTreeID=adjust.FOrgBoundID \t\t\t\t\t  \r\n");
            adjustSql.append(" inner join t_csl_rptitem item  \t\t\t\t\t\t\t\t\t  \r\n");
            adjustSql.append("    on item.fid=adjustentry.fitemid and item.fnumber=itemData.fitemnumber \r\n");
            adjustSql.append("  group by itemData.fid ");
        }
        StringBuffer query = new StringBuffer();
        if (adjustStatus.equals("0")) {
            query.append(" SELECT isnull(SUM(adjust.adjustdata),0) AS money ");
        } else if (adjustStatus.equals("1")) {
            query.append(" SELECT ISNULL(SUM(t.FMoney),0)+isnull(SUM(adjust.adjustdata),0) AS money ");
        } else {
            query.append(" SELECT ISNULL(SUM(t.FMoney),0) AS money ");
        }
        query.append("  , t.FItemNumber AS item ");
        query.append("\t, org1.FNumber AS company, org2.FNumber AS companyInverse           \r\n");
        query.append("\t, cy2.FNumber AS currencyConveted, cy1.FNumber AS currency          \r\n");
        query.append("\t, re.FOrgTreeID AS orgTree                                          \r\n");
        if (isInterItemData) {
            query.append(" , 4 AS dataElement                                \r\n");
        } else {
            query.append(" , t.FDataElement AS dataElement                   \r\n");
        }
        query.append(" , t.FPeriodType AS periodType, t.FPeriod AS period, t.FYear AS year   \r\n").append("FROM " + tableName + " t \n");
        if (adjustStatus.equals("0") || adjustStatus.equals("1")) {
            query.append(" left join (");
            query.append(adjustSql.toString());
            query.append("\t) adjust on adjust.fid=t.fid ");
        }
        if (!tableName.equalsIgnoreCase(T_CSL_INVESTITEMDATA)) {
            query.append("\tINNER JOIN T_CSL_rptreceived re on  re.FReportID = t.FReport    \r\n");
        } else {
            query.append("\tINNER JOIN T_CSL_rptreceived re on  re.FReportID = t.FReportID  \r\n");
        }
        query.append("   INNER JOIN T_CSL_RptItem it on it.FNumber = t.FItemNumber           \r\n").append("\tINNER JOIN T_BD_Currency cy1 on cy1.FID = t.FCurrencyID             \r\n").append("\tINNER JOIN T_BD_Currency cy2 on cy2.FID = t.FTargetCurrencyID       \r\n").append("\tINNER JOIN T_ORG_BaseUnit org1 on org1.FID = t.FCompanyID           \r\n").append("\tINNER JOIN T_ORG_BaseUnit org2 on org2.FID = t.FTargetCompanyID     \r\n").append("\tINNER JOIN T_ORG_TREE tree on tree.fid = re.ForgtreeID");
        if (!this.isUseTempTable) {
            query.append("\t\tWHERE (t.FMoney <> 0 AND t.FCommitStatus = 3) AND (             \r\n");
        }
        return query;
    }

    private void calculateAll(CalculatorCombiner combiner, String tableName) throws BOSException {
        ArrayList userdList = new ArrayList(this.formulaCalculatorList.size());
        ArrayList<ElimRpt> beforAdjustList = new ArrayList<ElimRpt>();
        ArrayList<ElimRpt> adjustList = new ArrayList<ElimRpt>();
        ArrayList<ElimRpt> afterAdjustList = new ArrayList<ElimRpt>(this.formulaCalculatorList.size());
        for (ElimRpt elim : this.formulaCalculatorList) {
            if (elim.getAdjustStatus().equals("-1")) {
                beforAdjustList.add(elim);
                continue;
            }
            if (elim.getAdjustStatus().equals("0")) {
                adjustList.add(elim);
                continue;
            }
            if (!elim.getAdjustStatus().equals("1")) continue;
            afterAdjustList.add(elim);
        }
        Map property2ElimRpt = combiner.getPropertyToCalculatorMap();
        ElimRptCombinestate prepareState = (ElimRptCombinestate)combiner.getPrepareState();
        this.calculateByElimRptList(combiner, tableName, beforAdjustList, property2ElimRpt, prepareState, userdList);
        this.calculateByElimRptList(combiner, tableName, adjustList, property2ElimRpt, prepareState, userdList);
        this.calculateByElimRptList(combiner, tableName, afterAdjustList, property2ElimRpt, prepareState, userdList);
        property2ElimRpt.clear();
        userdList.clear();
    }

    private void calculateByElimRptList(CalculatorCombiner combiner, String tableName, List elimRptList, Map property2ElimRpt, ElimRptCombinestate prepareState, List userdList) throws BOSException {
        StringBuffer sqlGroupBy;
        StringBuffer sqlQuery;
        String adjustStatus;
        ArrayList<Object> params;
        StringBuffer property;
        boolean isInterItemData;
        block24: {
            TempTableJdbcTemplate tempTableJdbcTemplate;
            block23: {
                if (elimRptList == null || elimRptList.isEmpty()) {
                    return;
                }
                isInterItemData = tableName.equalsIgnoreCase(T_CSL_INTERITEMDATA);
                property = new StringBuffer();
                params = new ArrayList<Object>();
                adjustStatus = ((ElimRpt)elimRptList.get(0)).getAdjustStatus();
                sqlQuery = this.getQuery(tableName, isInterItemData, adjustStatus);
                sqlGroupBy = new StringBuffer();
                sqlGroupBy.append(" GROUP BY \n").append(" t.FItemNumber, org1.FNumber, org2.FNumber, cy2.FNumber, cy1.FNumber").append(", re.FOrgTreeID ");
                if (!isInterItemData) {
                    sqlGroupBy.append(", t.FDataElement");
                }
                sqlGroupBy.append(", t.FPeriodType, t.FPeriod, t.FYear");
                if (!this.isUseTempTable) break block24;
                tempTableJdbcTemplate = null;
                String tempName = null;
                try {
                    tempTableJdbcTemplate = new TempTableJdbcTemplate(this.serverContext);
                    tempTableJdbcTemplate.initConnection();
                    tempName = this.createFilterTable(isInterItemData, tempTableJdbcTemplate);
                    this.insertDataToTempTable(tempName, elimRptList, isInterItemData, userdList);
                    sqlQuery.append(" INNER JOIN ").append(tempName).append(" temptbl ON temptbl.FItemNumber = t.FItemNumber");
                    sqlQuery.append(" AND temptbl.FCompany = org1.FNumber AND temptbl.FCompanyInverse = org2.FNumber");
                    sqlQuery.append(" AND temptbl.FSourceCurrency = cy1.FNumber AND temptbl.FCurrency = cy2.FNumber");
                    sqlQuery.append(" AND temptbl.FOrgTreeId = re.FOrgTreeID AND temptbl.FPeriodType = t.FPeriodType");
                    sqlQuery.append(" AND temptbl.FYear = t.FYear AND t.FPeriod >= temptbl.FStartPeriod AND t.FPeriod <= temptbl.FEndPeriod");
                    if (!isInterItemData) {
                        sqlQuery.append(" AND temptbl.FDataElement = t.FDataElement \n");
                    } else {
                        sqlQuery.append(" \n");
                    }
                    sqlQuery.append("\t\tWHERE t.FMoney <> 0 AND t.FCommitStatus = 3             \r\n");
                    sqlQuery.append(sqlGroupBy);
                    IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sqlQuery.toString());
                    this.preparePropertyMapForElimRpt(userdList, property2ElimRpt, isInterItemData);
                    while (rs.next()) {
                        int period = rs.getInt("period");
                        int year = rs.getInt("year");
                        this.batchHelper.buildFormulaCalculatorKey(rs.getString("item"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getString("company"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getString("companyInverse"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getString("currencyConveted"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getString("currency"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getInt("periodType"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getInt("period"), property);
                        this.batchHelper.buildFormulaCalculatorKey(rs.getInt("year"), property);
                        this.batchHelper.buildFormulaCalculatorKey(isInterItemData ? 4 : rs.getInt("dataElement"), property);
                        this.batchHelper.buildFormulaCalculatorKey(adjustStatus, property);
                        prepareState.setValue(period, rs.getString("orgTree"), year);
                        combiner.combineValue(property.toString(), (Object)rs.getBigDecimal("money"), true);
                        property.setLength(0);
                    }
                    if (tempName == null || this.isUseTempTableDebug) break block23;
                }
                catch (SQLException e) {
                    try {
                        throw new SQLDataException(e);
                    }
                    catch (Throwable throwable) {
                        if (tempName != null && !this.isUseTempTableDebug) {
                            tempTableJdbcTemplate.releaseDBSystemTempTable(tempName);
                        }
                        if (tempTableJdbcTemplate != null) {
                            tempTableJdbcTemplate.cleanupConnection();
                        }
                        throw throwable;
                    }
                }
                tempTableJdbcTemplate.releaseDBSystemTempTable(tempName);
            }
            if (tempTableJdbcTemplate != null) {
                tempTableJdbcTemplate.cleanupConnection();
            }
            return;
        }
        String strSqlQuery = sqlQuery.toString();
        int formulaCount = elimRptList.size();
        int index = 0;
        while (index < formulaCount) {
            StringBuffer sql = new StringBuffer(strSqlQuery);
            boolean isAddOr = false;
            int varCount = 0;
            while (varCount < this.sqlVarSize && index < formulaCount) {
                ElimRpt elim = (ElimRpt)elimRptList.get(index);
                if (!(elim.isException() || isInterItemData && !elim.isEndBalance())) {
                    if (isAddOr) {
                        sql.append("\t\tOR \n");
                    } else {
                        isAddOr = true;
                    }
                    sql.append(" ( t.FItemNumber = ? ");
                    params.add(elim.getReportItem());
                    ++varCount;
                    sql.append(" AND org2.FNumber = ? ");
                    params.add(elim.getCompanyInverse());
                    ++varCount;
                    sql.append(" AND cy2.FNumber = ? ");
                    params.add(elim.getCurrencyConveted());
                    ++varCount;
                    sql.append(" AND cy1.FNumber = ? ");
                    params.add(elim.getCurrency());
                    ++varCount;
                    sql.append(" AND org1.FNumber = ? ");
                    params.add(elim.getCompany());
                    ++varCount;
                    Set orgBoundIdsSet = elim.getOrgBoundIdSet();
                    if (!orgBoundIdsSet.isEmpty()) {
                        sql.append(" AND (");
                        sql.append(this.getOrgBoundIds(orgBoundIdsSet));
                        sql.append(")");
                        varCount += orgBoundIdsSet.size();
                    }
                    if (!isInterItemData) {
                        sql.append(" AND t.FDataElement = ? ");
                        params.add(new Integer(elim.getRptDataElement()));
                        ++varCount;
                    } else {
                        sql.append(" AND t.FDataElement = ? ");
                        params.add(4);
                        ++varCount;
                    }
                    sql.append(" AND t.FPeriodType = ? ");
                    params.add(new Integer(elim.getRptPeriodType()));
                    ++varCount;
                    sql.append(" AND t.FYear = ? ");
                    params.add(new Integer(elim.getYear()));
                    ++varCount;
                    sql.append(" AND t.FPeriod >= ? AND t.FPeriod <= ? )");
                    params.add(new Integer(elim.getPeriod()));
                    params.add(new Integer(elim.getEndPeriod()));
                    varCount += 2;
                    userdList.add(elim);
                }
                ++index;
            }
            if (params.isEmpty()) continue;
            sql.append(") \n").append(sqlGroupBy);
            IRowSet rs = DbUtil.executeQuery((Context)this.serverContext, (String)sql.toString(), (Object[])params.toArray());
            this.preparePropertyMapForElimRpt(userdList, property2ElimRpt, isInterItemData);
            try {
                while (rs.next()) {
                    int period = rs.getInt("period");
                    int year = rs.getInt("year");
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("item"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("company"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("companyInverse"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("currencyConveted"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getString("currency"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getInt("periodType"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getInt("period"), property);
                    this.batchHelper.buildFormulaCalculatorKey(rs.getInt("year"), property);
                    this.batchHelper.buildFormulaCalculatorKey(isInterItemData ? 4 : rs.getInt("dataElement"), property);
                    this.batchHelper.buildFormulaCalculatorKey(adjustStatus, property);
                    prepareState.setValue(period, rs.getString("orgTree"), year);
                    combiner.combineValue(property.toString(), (Object)rs.getBigDecimal("money"), true);
                    property.setLength(0);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            params.clear();
        }
    }

    private String getOrgBoundIds(Set orgBoundIdsSet) {
        StringBuffer strOrgBound = new StringBuffer();
        boolean isFrist = true;
        for (String orgBound : orgBoundIdsSet) {
            if (!isFrist) {
                strOrgBound.append(" OR ");
            }
            strOrgBound.append("re.FOrgTreeID = '").append(orgBound).append("'");
            isFrist = false;
        }
        return strOrgBound.toString();
    }

    private void preparePropertyMapForElimRpt(List userd, Map result, boolean isInterItemData) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < userd.size(); ++i) {
            ElimRpt elim = (ElimRpt)userd.get(i);
            this.batchHelper.buildFormulaCalculatorKey(elim.getReportItem(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getCompany(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getCompanyInverse(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getCurrencyConveted(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getCurrency(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getRptPeriodType(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getPeriod(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getYear(), sb);
            this.batchHelper.buildFormulaCalculatorKey(isInterItemData ? 4 : elim.getRptDataElement(), sb);
            this.batchHelper.buildFormulaCalculatorKey(elim.getAdjustStatus(), sb);
            this.batchHelper.fillKey2FormulaCalculatorMap(result, sb.toString(), elim);
            sb.setLength(0);
        }
    }

    private void initOrgBoundId() throws EASBizException, BOSException {
        if (this.formulaCalculatorList == null || this.formulaCalculatorList.isEmpty()) {
            return;
        }
        int size = this.formulaCalculatorList.size();
        for (int i = 0; i < size; ++i) {
            ElimRpt elim = (ElimRpt)this.formulaCalculatorList.get(i);
            String orgBoundNumber = elim.getOrgBoundNumber();
            if (StringUtils.isEmpty((String)orgBoundNumber)) continue;
            Map orgTreeMap = FiscalPeriodHelper.getOrgTreeByPeriods((Context)this.serverContext, (PeriodCollection)this.fiscalPeriods, (String)orgBoundNumber, (int)elim.getYear(), (int)elim.getYear(), (int)elim.getPeriod(), (int)elim.getEndPeriod(), (int)elim.getRptPeriodType(), (boolean)this.isMergeByFiscalPeriod, (boolean)this.isSupport13Period);
            elim.getOrgBoundIdSet().addAll(orgTreeMap.keySet());
            if (!elim.getOrgBoundIdSet().isEmpty()) continue;
            elim.setException((Exception)((Object)new ReportException(ReportException.ORGBOUND_IS_NULL_IN_SELECT_PERIOD)));
        }
    }

    private String createFilterTable(boolean isInterItemData, TempTableJdbcTemplate tempTableJdbcTemplate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table Tmp_ElimRptFilterTable");
        sql.append("(FItemNumber nvarchar(80), FCompany nvarchar(80), FCompanyInverse nvarchar(80), FSourceCurrency nvarchar(80),");
        sql.append(" FCurrency nvarchar(80), FOrgTreeId varchar(44), FPeriodType int, FYear int, FStartPeriod int, FEndPeriod int");
        if (!isInterItemData) {
            sql.append(" ,FDataElement int) ");
        } else {
            sql.append(" ) ");
        }
        String tableName = this.isUseTempTableDebug ? tempTableJdbcTemplate.createTempTable(sql.toString()) : tempTableJdbcTemplate.createDBSystemTempTable(sql.toString());
        return tableName;
    }

    private void insertDataToTempTable(String tmpTable, List<ElimRpt> elimRptList, boolean isInterItemData, List<ElimRpt> userdList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tmpTable).append("(FItemNumber, FCompany, FCompanyInverse, FSourceCurrency, ");
        sql.append("FCurrency, FOrgTreeId, FPeriodType, FYear, FStartPeriod, FEndPeriod");
        int paramsSize = 10;
        if (!isInterItemData) {
            sql.append(", FDataElement) values(?,?,?,?,?,?,?,?,?,?,?)");
            paramsSize = 11;
        } else {
            sql.append(") values(?,?,?,?,?,?,?,?,?,?) ");
        }
        ElimRpt elim = null;
        Object[] param = null;
        StringBuffer key = new StringBuffer();
        HashSet<String> keys = new HashSet<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < elimRptList.size(); ++i) {
            elim = elimRptList.get(i);
            if (elim.isException() || isInterItemData && !elim.isEndBalance()) continue;
            Set orgBoundIdsSet = elim.getOrgBoundIdSet();
            for (String orgTreeId : orgBoundIdsSet) {
                param = new Object[paramsSize];
                param[0] = elim.getReportItem();
                param[1] = elim.getCompany();
                param[2] = elim.getCompanyInverse();
                param[3] = elim.getCurrency();
                param[4] = elim.getCurrencyConveted();
                param[5] = orgTreeId;
                param[6] = new Integer(elim.getRptPeriodType());
                param[7] = new Integer(elim.getYear());
                param[8] = new Integer(elim.getPeriod());
                param[9] = new Integer(elim.getEndPeriod());
                if (!isInterItemData) {
                    param[10] = new Integer(elim.getRptDataElement());
                }
                key.setLength(0);
                for (Object curObj : param) {
                    if (curObj == null) continue;
                    key.append(curObj);
                }
                if (keys.contains(key.toString())) continue;
                params.add(param);
                keys.add(key.toString());
            }
            userdList.add(elim);
        }
        keys.clear();
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)this.serverContext, (String)sql.toString(), params);
        }
    }

    private class ElimRptCombinestate
    implements IFormulaCombinationPreparedState {
        private int period;
        private int year;
        private String orgBoundId;

        private ElimRptCombinestate() {
        }

        @Override
        public Object getFormulaResultValue(IFormulaCalculator formula) {
            return null;
        }

        @Override
        public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
            return true;
        }

        @Override
        public boolean isPrepared(IFormulaCalculator formula) {
            boolean result;
            ElimRpt elim = (ElimRpt)formula;
            Set orgBoundIdSet = elim.getOrgBoundIdSet();
            boolean bl = result = elim.getPeriod() <= this.period && elim.getEndPeriod() >= this.period && elim.getYear() == this.year;
            if (orgBoundIdSet.isEmpty()) {
                return result;
            }
            return result && orgBoundIdSet.contains(this.orgBoundId);
        }

        public void setValue(int period, String orgBoundId, int year) {
            this.period = period;
            this.orgBoundId = orgBoundId;
            this.year = year;
        }
    }
}

