/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AssistantGroupComparator;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAcctSortState
implements IAcctSortState {
    private static final String GENERAL_ASST_ACT_TYPE = "T_BD_GeneralAsstActType";
    private Map context;
    private List formulaList = new LinkedList();
    private static Comparator itemComparator = new AsstActTypeComarator();
    private static Comparator groupComparator = new AssistantGroupComparator();
    private StringBuffer temp = new StringBuffer();
    private Set companyNumberSet;
    private boolean isMultiUnPosted;
    private String companyID;
    private String accountTableID;
    private String currencyID;
    private String currencyNumber;
    private String periodID;
    private int startYear = 0;
    private int startPeriod = 0;
    private int endYear = 0;
    private int endPeriod = 0;
    private boolean isIncludingUnPosted;
    private boolean isNotLeafAsstAccount;
    private String balType;
    private String balPairType;
    private String[] accounts;
    private List asstActTypeList;
    private List synedDetailAsstActTypeList;
    private boolean isBizCompany;
    private PeriodInfo currentPeriod;
    private String delegetedCompanyId = null;
    private List singleAsstActItems;
    private List asstActItems;
    private Map groupMap;
    protected boolean isIncludeSubAccount;
    protected boolean isIncludeSubAsstItem;
    protected boolean isIncludeLeafAccount;
    protected boolean isIncludeLeafAsstItem;
    OrgType rptOrgType;
    protected boolean isCalcByPriorityAccount;

    @Override
    public void addFormula(IFormulaCalculator formula) {
        this.formulaList.add(formula);
    }

    @Override
    public String generateKey() {
        this.temp.setLength(0);
        this.temp.append("[").append(this.companyID == null ? "" : this.companyID).append("]");
        this.temp.append("[").append(this.rptOrgType == null ? "" : this.rptOrgType.getValue() + "").append("]");
        this.temp.append("[").append(this.accountTableID).append("]");
        this.temp.append("[").append(this.currencyID).append("]");
        this.temp.append("[").append(this.periodID == null ? "" : this.periodID).append("]");
        this.temp.append("[").append(this.startYear).append("]");
        this.temp.append("[").append(this.startPeriod).append("]");
        this.temp.append("[").append(this.endYear).append("]");
        this.temp.append("[").append(this.endPeriod).append("]");
        this.temp.append("[").append(this.isIncludingUnPosted ? 1 : 0).append("]");
        this.temp.append("[").append(this.isMultiUnPosted ? 1 : 0).append("]");
        this.temp.append("[").append(this.isNotLeafAsstAccount ? 1 : 0).append("]");
        this.temp.append("[").append(this.balPairType).append("]");
        this.temp.append("[").append(this.isBizCompany ? 1 : 0).append("]");
        this.temp.append("[").append(this.isIncludeSubAccount ? "1" : "0").append("]");
        this.temp.append("[").append(this.isIncludeSubAsstItem ? "1" : "0").append("]");
        this.temp.append("[").append(this.isIncludeLeafAccount ? "1" : "0").append("]");
        this.temp.append("[").append(this.isIncludeLeafAsstItem ? "1" : "0").append("]");
        if (this.accounts == null) {
            this.temp.append("[]");
        } else {
            this.temp.append("[").append(this.accounts[0]).append(":").append(this.accounts[1]).append(":").append(this.accounts[2]).append("]");
        }
        if (this.synedDetailAsstActTypeList != null) {
            this.temp.append("[syn]");
            for (AsstActType itemType : this.synedDetailAsstActTypeList) {
                this.temp.append("[").append(itemType.number).append("]");
            }
            this.temp.append("[syn]");
        }
        if (this.asstActTypeList != null) {
            for (AsstActType itemType : this.asstActTypeList) {
                AssistantGroup[] groups;
                if (this.groupMap != null && (groups = (AssistantGroup[])this.groupMap.get(itemType.number)) != null) {
                    this.temp.append("[").append(itemType.number).append(":");
                    for (int i = 0; i < groups.length; ++i) {
                        AssistantGroup eachGroup = groups[i];
                        this.temp.append(eachGroup.getStandardID()).append("|").append(eachGroup.getStandardNumber() == null ? "" : eachGroup.getStartLongNumber()).append(":").append(eachGroup.getEndLongNumber() == null ? "" : eachGroup.getEndLongNumber());
                    }
                    this.temp.append("]");
                    continue;
                }
                this.temp.append("[").append(itemType.number).append("]");
            }
            if (this.singleAsstActItems != null) {
                for (String[] asstItems : this.singleAsstActItems) {
                    this.temp.append("[").append(asstItems[0]).append("|").append(asstItems[1]).append("|").append(asstItems[2]).append("]");
                }
            }
            if (this.asstActItems != null) {
                for (String[] asstItems : this.asstActItems) {
                    this.temp.append("[").append(asstItems[1]).append(":").append(asstItems[2]).append("|").append(asstItems[3]).append("]");
                }
            }
        }
        return this.temp.toString();
    }

    @Override
    public List getFormulaList() {
        return this.formulaList;
    }

    @Override
    public void reset() {
        this.companyID = null;
        this.accountTableID = null;
        this.currencyID = null;
        this.currencyNumber = null;
        this.periodID = null;
        this.startYear = 0;
        this.startPeriod = 0;
        this.endYear = 0;
        this.endPeriod = 0;
        this.isIncludingUnPosted = false;
        this.isNotLeafAsstAccount = false;
        this.balType = null;
        this.balPairType = null;
        this.accounts = null;
        this.asstActTypeList = null;
        this.singleAsstActItems = null;
        this.asstActItems = null;
        this.groupMap = null;
        this.isBizCompany = false;
        this.isIncludeSubAccount = false;
        this.isIncludeSubAsstItem = false;
        this.isIncludeLeafAccount = false;
        this.isIncludeLeafAsstItem = false;
        this.synedDetailAsstActTypeList = null;
        this.currentPeriod = null;
        this.delegetedCompanyId = null;
    }

    @Override
    public void setContext(Map context) {
        this.context = context;
        this.companyNumberSet = (Set)context.get("COMPANYIDSET");
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        this.setCurrencyID(acct.getCurrency().getId().toString());
        this.setCurrencyNumber(acct.getCurrency().getNumber());
        this.setPeriodID(acct.getStrPeriodID());
        this.setIncludingUnPosted(acct.isIsincludingUnPosted());
        this.setCalcByPriorityAccount(acct.getStruct().isCalcByPriorityAccount());
        this.setNotLeafNeedAsstAccount(acct.getAccountItem().hasItem() && !acct.getAccountItem().isDetailAccount());
        this.setBizCompany(!acct.getCompany().isIsOnlyUnion());
        this.setBalType(acct.getBalanceType().getName());
        this.setBalPairType(AcctUtils.getPairType(acct.getBalanceType().getName()));
        this.rptOrgType = acct.getStruct().getOrgType();
        if (acct.getCompany().isIsProfitOrgUnit()) {
            this.delegetedCompanyId = (String)acct.getCompany().get("DELEGATED_COMPANY_ID");
        }
        if (!acct.getAccountItem().isSingleAccount()) {
            this.setAccounts(new String[]{acct.getAccountItem().startAccount.getAccountNumber(), acct.getAccountItem().endAccount.getAccountNumber(), "" + acct.getAccountItem().startAccount.account.level});
        }
        if (acct.getAccountItem().getSynedDetailAsstActTypes() != null) {
            ArrayList list = new ArrayList(acct.getAccountItem().getSynedDetailAsstActTypes());
            Collections.sort(list, itemComparator);
            this.setSynedDetailAsstActTypeList(list);
        }
        if (acct.getAccountItem().hasItem()) {
            ArrayList<AsstActType> items = new ArrayList<AsstActType>();
            for (AssistantItem asst : acct.getAccountItem().getItemTypes().values()) {
                items.add(asst.itemType);
            }
            Collections.sort(items, itemComparator);
            this.setAsstActTypeList(items);
            ArrayList<String[]> singleNumberList = null;
            ArrayList<String[]> doubleNumberList = null;
            HashMap<String, AssistantGroup[]> groupMap = null;
            for (AsstActType itemType : items) {
                AssistantItem assistantItem = acct.getAccountItem().getItem(itemType.number);
                if (assistantItem != null && assistantItem.startItem != null && assistantItem.endItem != null && !StringUtils.isEmpty((String)assistantItem.startItem.number) && !StringUtils.isEmpty((String)assistantItem.endItem.number)) {
                    String numberField;
                    boolean isUseLongNumber = RptUtil.isUseLongNumber(itemType.useLongNumber, itemType.realtionDataObject);
                    if (assistantItem.startItem.isHasWildcar && !GENERAL_ASST_ACT_TYPE.equalsIgnoreCase(itemType.realtionDataObject)) {
                        isUseLongNumber = false;
                    }
                    boolean isLongNumberNotEmpty = !StringUtils.isEmpty((String)assistantItem.startItem.longNumber) && !StringUtils.isEmpty((String)assistantItem.endItem.longNumber);
                    String startNumber = isUseLongNumber && isLongNumberNotEmpty ? assistantItem.startItem.longNumber : assistantItem.startItem.number;
                    String endNumber = isUseLongNumber && isLongNumberNotEmpty ? assistantItem.endItem.longNumber : assistantItem.endItem.number;
                    String string = numberField = isUseLongNumber && isLongNumberNotEmpty ? "FLongNumber" : "FNumber";
                    if (startNumber.equals(endNumber)) {
                        if (singleNumberList == null) {
                            singleNumberList = new ArrayList<String[]>();
                        }
                        singleNumberList.add(new String[]{itemType.number, numberField, Boolean.toString(assistantItem.startItem.isHasWildcar)});
                        continue;
                    }
                    if (doubleNumberList == null) {
                        doubleNumberList = new ArrayList<String[]>();
                    }
                    doubleNumberList.add(new String[]{itemType.number, startNumber, endNumber, numberField, String.valueOf(isUseLongNumber)});
                    continue;
                }
                if (assistantItem.getGroups() == null || assistantItem.getGroups().length <= 0) continue;
                if (groupMap == null) {
                    groupMap = new HashMap<String, AssistantGroup[]>();
                }
                AssistantGroup[] groups = assistantItem.getGroups();
                Arrays.sort(groups, groupComparator);
                groupMap.put(itemType.number, groups);
            }
            this.setSingleAsstActItems(singleNumberList);
            this.setAsstActItems(doubleNumberList);
            this.setGroupMap(groupMap);
        }
        String id = acct.getCompany().isIsOnlyUnion() ? acct.getCompany().getLongNumber() : acct.getCompany().getId().toString();
        this.setCompanyID(id);
        this.setAccountTableID(acct.getAccountTable().getId().toString());
        this.setCurrentPeriod(acct.getCurrentPeriod());
        if (!this.isMultiUnPosted()) {
            this.setStartYear(acct.getIStartYear());
            this.setEndYear(acct.getIEndYear());
            this.setStartPeriod(acct.getIStartPeriod());
            this.setEndPeriod(acct.getIEndPeriod());
        } else if (this.isMultiUnPosted()) {
            this.setStartYear(acct.getNextCurrentPeriodYear());
            this.setEndYear(acct.getIEndYear());
            this.setStartPeriod(acct.getNextCurrentPeriodNumber());
            this.setEndPeriod(acct.getIEndPeriod());
        }
    }

    @Override
    public Object clone() {
        AbstractAcctSortState newOne = (AbstractAcctSortState)this.getNewInstance();
        newOne.companyID = this.companyID;
        newOne.accountTableID = this.accountTableID;
        newOne.currencyID = this.currencyID;
        newOne.currencyNumber = this.currencyNumber;
        newOne.periodID = this.periodID;
        newOne.startYear = this.startYear;
        newOne.startPeriod = this.startPeriod;
        newOne.endYear = this.endYear;
        newOne.endPeriod = this.endPeriod;
        newOne.isIncludingUnPosted = this.isIncludingUnPosted;
        newOne.isNotLeafAsstAccount = this.isNotLeafAsstAccount;
        newOne.balType = this.balType;
        newOne.balPairType = this.balPairType;
        newOne.accounts = this.accounts;
        newOne.asstActTypeList = this.asstActTypeList;
        newOne.singleAsstActItems = this.singleAsstActItems;
        newOne.asstActItems = this.asstActItems;
        newOne.groupMap = this.groupMap;
        newOne.isBizCompany = this.isBizCompany;
        newOne.isIncludeLeafAccount = this.isIncludeLeafAccount;
        newOne.isIncludeLeafAsstItem = this.isIncludeLeafAsstItem;
        newOne.isIncludeSubAccount = this.isIncludeSubAccount;
        newOne.isIncludeSubAsstItem = this.isIncludeSubAsstItem;
        newOne.synedDetailAsstActTypeList = this.synedDetailAsstActTypeList;
        newOne.isMultiUnPosted = this.isMultiUnPosted;
        newOne.currentPeriod = this.currentPeriod;
        newOne.rptOrgType = this.rptOrgType;
        newOne.delegetedCompanyId = this.delegetedCompanyId;
        newOne.isCalcByPriorityAccount = this.isCalcByPriorityAccount;
        return newOne;
    }

    @Override
    public String getBalTableName() {
        boolean isHasItem;
        boolean bl = isHasItem = this.getAsstActTypeList() != null && this.getAsstActTypeList().size() > 0 || (this.isIncludeLeafAsstItem() || this.isIncludeSubAsstItem()) && this.getSynedDetailAsstActTypeList() != null;
        if (isHasItem) {
            if (OrgType.ProfitCenter.equals((Object)this.rptOrgType)) {
                if (!this.isIncludingUnPosted()) {
                    if ("GLC".equals(this.getCurrencyNumber())) {
                        if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                            return "T_PCA_PcAssistBalance_5R";
                        }
                        return "T_PCA_PcAssistBalance_5L";
                    }
                    if ("GRC".equals(this.getCurrencyNumber())) {
                        if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                            return "T_PCA_PcAssistBalance_5L";
                        }
                        return "T_PCA_PcAssistBalance_5R";
                    }
                    return "T_PCA_PcAssistBalance_5F";
                }
                if ("GLC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                        return "T_PCA_PcAssistBalance_1R";
                    }
                    return "T_PCA_PcAssistBalance_1L";
                }
                if ("GRC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                        return "T_PCA_PcAssistBalance_1L";
                    }
                    return "T_PCA_PcAssistBalance_1R";
                }
                return "T_PCA_PcAssistBalance_1F";
            }
            if (!this.isIncludingUnPosted()) {
                if ("GLC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                        return "T_GL_AssistBalance_5R";
                    }
                    return "T_GL_AssistBalance_5L";
                }
                if ("GRC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                        return "T_GL_AssistBalance_5L";
                    }
                    return "T_GL_AssistBalance_5R";
                }
                return "T_GL_AssistBalance_5F";
            }
            if ("GLC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AssistBalance_1R";
                }
                return "T_GL_AssistBalance_1L";
            }
            if ("GRC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AssistBalance_1L";
                }
                return "T_GL_AssistBalance_1R";
            }
            return "T_GL_AssistBalance_1F";
        }
        if (OrgType.ProfitCenter.equals((Object)this.rptOrgType)) {
            if (!this.isIncludingUnPosted()) {
                if ("GLC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                        return "T_PCA_PcAccountBalance_5R";
                    }
                    return "T_PCA_PcAccountBalance_5L";
                }
                if ("GRC".equals(this.getCurrencyNumber())) {
                    if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                        return "T_PCA_PcAccountBalance_5L";
                    }
                    return "T_PCA_PcAccountBalance_5R";
                }
                return "T_PCA_PcAccountBalance_5F";
            }
            if ("GLC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_PCA_PcAccountBalance_1R";
                }
                return "T_PCA_PcAccountBalance_1L";
            }
            if ("GRC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_PCA_PcAccountBalance_1L";
                }
                return "T_PCA_PcAccountBalance_1R";
            }
            return "T_PCA_PcAccountBalance_1F";
        }
        if (!this.isIncludingUnPosted()) {
            if ("GLC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AccountBalance_5R";
                }
                return "T_GL_AccountBalance_5L";
            }
            if ("GRC".equals(this.getCurrencyNumber())) {
                if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AccountBalance_5L";
                }
                return "T_GL_AccountBalance_5R";
            }
            return "T_GL_AccountBalance_5F";
        }
        if ("GLC".equals(this.getCurrencyNumber())) {
            if (RptUtil.findString(this.getBalType(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                return "T_GL_AccountBalance_1R";
            }
            return "T_GL_AccountBalance_1L";
        }
        if ("GRC".equals(this.getCurrencyNumber())) {
            if (RptUtil.findString(this.getBalType(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                return "T_GL_AccountBalance_1L";
            }
            return "T_GL_AccountBalance_1R";
        }
        return "T_GL_AccountBalance_1F";
    }

    public boolean isNeedAccountViewForDC() {
        return !this.isNotLeafAsstAccount() && this.getAccounts() == null && RptUtil.findString(this.getBalType(), ",B,TB,RB,C,Y,TC,TY,RC,RY,QC,QY,");
    }

    public boolean isAccountsForDC() {
        return !this.isNotLeafAsstAccount() && this.getAccounts() != null && RptUtil.findString(this.getBalType(), ",B,TB,RB,C,Y,TC,TY,RC,RY,QC,QY,");
    }

    public boolean isNeedAccountViewForDCByQB() {
        return !this.isNotLeafAsstAccount() && RptUtil.findString(this.getBalType(), ",QB,");
    }

    public boolean isAccountsForDCByisNotLeafAsstAccount() {
        return (this.isNotLeafAsstAccount() || this.isNeedSubAccount()) && RptUtil.findString(this.getBalType(), ",B,TB,RB,C,Y,TC,TY,RC,RY,QC,QY,");
    }

    @Override
    public boolean isUseTempTableScheme() {
        return this.getBalTableName().equals("T_GL_AssistBalance_1F") || this.getBalTableName().equals("T_GL_AssistBalance_1L") || this.getBalTableName().equals("T_GL_AssistBalance_1R") || this.getBalTableName().equals("T_GL_AssistBalance_5F") || this.getBalTableName().equals("T_GL_AssistBalance_5L") || this.getBalTableName().equals("T_GL_AssistBalance_5R") || this.getBalTableName().equals("T_PCA_PcAssistBalance_1F") || this.getBalTableName().equals("T_PCA_PcAssistBalance_1L") || this.getBalTableName().equals("T_PCA_PcAssistBalance_1R") || this.getBalTableName().equals("T_PCA_PcAssistBalance_5F") || this.getBalTableName().equals("T_PCA_PcAssistBalance_5L") || this.getBalTableName().equals("T_PCA_PcAssistBalance_5R");
    }

    public boolean isNeedAccountTable() {
        return !this.isBizCompany() || this.getAccounts() != null || this.isNeedSubAccount() || this.isNotLeafAsstAccount();
    }

    public String getCompanyID() {
        return this.companyID;
    }

    public void setCompanyID(String companyID) {
        this.companyID = companyID;
    }

    public String getCurrencyID() {
        return this.currencyID;
    }

    public void setCurrencyID(String currencyID) {
        this.currencyID = currencyID;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getPeriodID() {
        return this.periodID;
    }

    public void setPeriodID(String periodID) {
        this.periodID = periodID;
    }

    public boolean isIncludingUnPosted() {
        return this.isIncludingUnPosted;
    }

    public void setIncludingUnPosted(boolean isIncludingUnPosted) {
        this.isIncludingUnPosted = isIncludingUnPosted;
    }

    public List getAsstActTypeList() {
        return this.asstActTypeList;
    }

    public void setAsstActTypeList(List asstActTypeList) {
        this.asstActTypeList = asstActTypeList;
    }

    public List getSingleAsstActItems() {
        return this.singleAsstActItems;
    }

    public void setSingleAsstActItems(List singleAsstActItems) {
        this.singleAsstActItems = singleAsstActItems;
    }

    public List getAsstActItems() {
        return this.asstActItems;
    }

    public void setAsstActItems(List asstActItems) {
        this.asstActItems = asstActItems;
    }

    public String getBalType() {
        return this.balType;
    }

    public void setBalType(String balType) {
        this.balType = balType;
    }

    public String getBalTypePair() {
        return this.balPairType;
    }

    public void setBalPairType(String balTypePair) {
        this.balPairType = balTypePair;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(int startPeriod) {
        this.startPeriod = startPeriod;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public boolean isSameYear() {
        return this.startYear == this.endYear;
    }

    public boolean isSamePeriod() {
        return this.startYear == this.endYear && this.startPeriod == this.endPeriod;
    }

    public String getBalPairType() {
        return this.balPairType;
    }

    public String[] getAccounts() {
        return this.accounts;
    }

    public void setAccounts(String[] accounts) {
        this.accounts = accounts;
    }

    public Map getGroupMap() {
        return this.groupMap;
    }

    public void setGroupMap(Map groupMap) {
        this.groupMap = groupMap;
    }

    public Map getContext() {
        return this.context;
    }

    public String getAccountTableID() {
        return this.accountTableID;
    }

    public void setAccountTableID(String accountTableID) {
        this.accountTableID = accountTableID;
    }

    public boolean isNotLeafAsstAccount() {
        return this.isNotLeafAsstAccount;
    }

    public void setNotLeafNeedAsstAccount(boolean isOnlyNeedLeafAccount) {
        this.isNotLeafAsstAccount = isOnlyNeedLeafAccount;
    }

    public boolean isBizCompany() {
        return this.isBizCompany;
    }

    public void setBizCompany(boolean isBizCompany) {
        this.isBizCompany = isBizCompany;
    }

    public boolean isIncludeSubAccount() {
        return this.isIncludeSubAccount;
    }

    public void setIncludeSubAccount(boolean isIncludeSubAccount) {
        this.isIncludeSubAccount = isIncludeSubAccount;
    }

    public boolean isIncludeSubAsstItem() {
        return this.isIncludeSubAsstItem;
    }

    public void setIncludeSubAsstItem(boolean isIncludeSubAsstItem) {
        this.isIncludeSubAsstItem = isIncludeSubAsstItem;
    }

    public boolean isIncludeLeafAccount() {
        return this.isIncludeLeafAccount;
    }

    public void setIncludeLeafAccount(boolean isIncludeLeafAccount) {
        this.isIncludeLeafAccount = isIncludeLeafAccount;
    }

    public boolean isIncludeLeafAsstItem() {
        return this.isIncludeLeafAsstItem;
    }

    public void setIncludeLeafAsstItem(boolean isIncludeLeafAsstItem) {
        this.isIncludeLeafAsstItem = isIncludeLeafAsstItem;
    }

    public boolean hasItem() {
        return this.getAsstActTypeList() != null && this.getAsstActTypeList().size() > 0;
    }

    public boolean isNeedSubAccountBySheetParam() {
        return this.isIncludeLeafAccount() || this.isIncludeLeafAsstItem() || this.isIncludeSubAccount() || this.isIncludeSubAsstItem();
    }

    public List getSynedDetailAsstActTypeList() {
        return this.synedDetailAsstActTypeList;
    }

    public void setSynedDetailAsstActTypeList(List synedDetailAsstActTypeList) {
        this.synedDetailAsstActTypeList = synedDetailAsstActTypeList;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(PeriodInfo currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    @Override
    public boolean isMultiUnPosted() {
        return this.isMultiUnPosted;
    }

    @Override
    public void setMultiUnPosted(boolean isMultiUnPosted) {
        this.isMultiUnPosted = isMultiUnPosted;
    }

    public boolean isGroupByAccount() {
        Boolean isGroupByAccount = (Boolean)this.context.get("isGroupByAccount");
        return isGroupByAccount != null && isGroupByAccount != false;
    }

    public int getAcctSortType() {
        return 0;
    }

    public String getOrgUnitDBField() {
        if (OrgType.ProfitCenter.equals((Object)this.rptOrgType)) {
            return "FProfitCenterID";
        }
        return "FOrgUnitID";
    }

    @Override
    public void setRptOrgType(OrgType rptOrgType) {
        this.rptOrgType = rptOrgType;
    }

    @Override
    public OrgType getRptOrgType() {
        return this.rptOrgType;
    }

    public String getPeriodStr() {
        return null;
    }

    public String getOrgUnitDBTable() {
        if (OrgType.ProfitCenter.equals((Object)this.rptOrgType)) {
            return "T_ORG_ProfitCenter";
        }
        return "T_ORG_Company";
    }

    public String getDelegetedCompanyId() {
        return this.delegetedCompanyId;
    }

    public boolean isNeedAccountViewForMeasureUnit() {
        return !this.isNotLeafAsstAccount() && this.getAccounts() == null && RptUtil.findString(this.getBalType(), ",QJF,QDF,QJL,QDL,QSY,QSL,QC,QY,QB,");
    }

    public boolean isForMeasureUnit() {
        return RptUtil.findString(this.getBalType(), ",QJF,QDF,QJL,QDL,QSY,QSL,QC,QY,QB,");
    }

    public boolean isCalcByPriorityAccount() {
        return this.isCalcByPriorityAccount;
    }

    public void setCalcByPriorityAccount(boolean isCalcByPriorityAccount) {
        this.isCalcByPriorityAccount = isCalcByPriorityAccount;
    }
}

