/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acct.AbstractAcctSortState;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.batch.acct.IAcctSortState;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

public class AcctAccrualState
extends AbstractAcctSortState
implements Cloneable {
    private static Set qtyTypeSet = new HashSet();
    private boolean isQty;
    private int qtyType;
    private static final int QTY_NODETAIL = 0;
    private static final int QTY_DETAIL_DEBIT = 1;
    private static final int QTY_DETAIL_CREDIT = -1;
    private StringBuffer temp = new StringBuffer();

    @Override
    public String generateKey() {
        String key = super.generateKey();
        this.temp.setLength(0);
        this.temp.append(key);
        this.temp.append("[").append(this.isQty ? "1" : "0").append("]");
        this.temp.append("[").append(this.qtyType).append("]");
        return this.temp.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.isQty = false;
        this.qtyType = 0;
    }

    @Override
    public void setState(IFormulaCalculator formula) {
        super.setState(formula);
        AcctCalculaterExt acct = (AcctCalculaterExt)formula;
        if (qtyTypeSet.contains(acct.getBalanceType().getName())) {
            this.setQty(true);
            if (this.isNotLeafAsstAccount()) {
                this.setQtyType(0);
            } else {
                this.setQtyType(acct.getAccountItem().startAccount.account.dc);
            }
        } else {
            this.setQty(false);
            this.setQtyType(0);
        }
    }

    @Override
    public Object clone() {
        AcctAccrualState newOne = (AcctAccrualState)super.clone();
        newOne.isQty = this.isQty;
        newOne.qtyType = this.qtyType;
        return newOne;
    }

    @Override
    public IAcctSortState getNewInstance() {
        return new AcctAccrualState();
    }

    @Override
    public String getSumPart(String currencyNumber) {
        if (!this.isQty()) {
            if ("GLC".equals(currencyNumber)) {
                return AcctUtils.getAccrualSelectPartForGLC(this.getBalPairType());
            }
            if ("GRC".equals(currencyNumber)) {
                return AcctUtils.getAccrualSelectPartForGRC(this.getBalPairType());
            }
            return AcctUtils.getAccrualSelectPart(this.getBalPairType());
        }
        switch (this.getQtyType()) {
            case 0: {
                if ("GLC".equals(currencyNumber)) {
                    return AcctUtils.getQtyNotDetalSelectPartForGLC(this.getBalPairType());
                }
                if ("GRC".equals(currencyNumber)) {
                    return AcctUtils.getQtyNotDetalSelectPartForGRC(this.getBalPairType());
                }
                return AcctUtils.getQtyNotDetalSelectPart(this.getBalPairType());
            }
            case 1: {
                if ("GLC".equals(currencyNumber)) {
                    return AcctUtils.getQtyDetailDebitSelectPartForGLC(this.getBalPairType());
                }
                if ("GRC".equals(currencyNumber)) {
                    return AcctUtils.getQtyDetailDebitSelectPartForGRC(this.getBalPairType());
                }
                return AcctUtils.getQtyDetailDebitSelectPart(this.getBalPairType());
            }
            case -1: {
                if ("GLC".equals(currencyNumber)) {
                    return AcctUtils.getQtyDetailCreditSelectTypeForGLC(this.getBalPairType());
                }
                if ("GRC".equals(currencyNumber)) {
                    return AcctUtils.getQtyDetailCreditSelectTypeForGRC(this.getBalPairType());
                }
                return AcctUtils.getQtyDetailCreditSelectType(this.getBalPairType());
            }
        }
        return null;
    }

    @Override
    public boolean isNeedSubAccount() {
        return false;
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object) {
        return object;
    }

    public boolean isQty() {
        return this.isQty;
    }

    public void setQty(boolean isQty) {
        this.isQty = isQty;
    }

    public int getQtyType() {
        return this.qtyType;
    }

    public void setQtyType(int qtyType) {
        this.qtyType = qtyType;
    }

    @Override
    public String getGroupByPart() {
        return null;
    }

    @Override
    public String getFromPart() {
        return null;
    }

    @Override
    public String getUnPostedAccrualSelectPart(String currencyNumber) {
        return null;
    }

    @Override
    public String getUnPostedBalanceSelectPart(String currencyNumber) {
        return null;
    }

    @Override
    public int getAcctSortType() {
        return 3;
    }

    @Override
    public Object processReturnValue(IFormulaCalculator formula, Object object, BigDecimal dc) {
        return object;
    }

    static {
        qtyTypeSet.add("QJF");
        qtyTypeSet.add("QDF");
    }
}

