/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acct;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableUtil;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueInsertUtil;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCallback;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AcctTempTableValueInsertProcessor
implements ITempTableValueInsertProcessor {
    private static final String A_ACCT_LEAF_FID = "A_AcctLeaf.FID";
    private static final String A_ACCT_FID = "A_Acct.FID";
    private String accountTableId;
    private String companyId;

    public AcctTempTableValueInsertProcessor() {
        this(null, null);
    }

    public AcctTempTableValueInsertProcessor(String accountTableId, String companyId) {
        this.accountTableId = accountTableId;
        this.companyId = companyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTempTableValueInsert(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, String tempTableName, List valuesList) throws BOSException {
        TempTableFieldItem accountFieldItem = (TempTableFieldItem)this.getAccountTempTableFieldItem(tempTableField);
        if (accountFieldItem == null) {
            TempTableValueInsertUtil.insertValueIntoTempTable(tempTableJdbcTemplate, tempTableField, tempTableName, valuesList);
            return;
        }
        String accountTempTableFieldName = accountFieldItem.getTempTableField();
        String tempTable = null;
        try {
            tempTable = TempTableUtil.createDBSystemTempTable(tempTableJdbcTemplate, tempTableField, "T_RPT_AccountTempTable", false);
            TempTableValueInsertUtil.insertValueIntoTempTable(tempTableJdbcTemplate, tempTableField, tempTable, valuesList);
            tempTableJdbcTemplate.analyzeTable(tempTable);
            StringBuffer ksqlBuffer = new StringBuffer();
            ksqlBuffer.append(" insert into ").append(tempTableName).append(" ");
            ksqlBuffer.append(" select ");
            List tempTableFieldItems = tempTableField.getTempTableFieldItems();
            Iterator it = tempTableFieldItems.iterator();
            while (it.hasNext()) {
                TempTableFieldItem fieldItem1 = (TempTableFieldItem)it.next();
                String tempTableFieldName1 = fieldItem1.getTempTableField();
                if (A_ACCT_LEAF_FID.equalsIgnoreCase(fieldItem1.getField())) {
                    ksqlBuffer.append(A_ACCT_LEAF_FID);
                } else {
                    ksqlBuffer.append(this.getTempTableFieldName(tempTableFieldName1));
                }
                if (!it.hasNext()) continue;
                ksqlBuffer.append(",");
            }
            String tempTableAlias = this.getTempTableAlias();
            ksqlBuffer.append(" from T_BD_AccountView A_Acct inner join T_BD_AccountView A_AcctLeaf on (A_Acct.FCompanyID = A_AcctLeaf.FCompanyID ");
            ksqlBuffer.append(" and A_Acct.FAccountTableID = A_AcctLeaf.FAccountTableID and A_AcctLeaf.fnumber like concat(A_Acct.fnumber,'%'))");
            ksqlBuffer.append(" inner join ").append(tempTable).append(" ").append(this.getTempTableAlias()).append(" on ").append(tempTableAlias).append(".").append(accountTempTableFieldName).append(" = A_Acct.FID");
            ksqlBuffer.append(" where A_Acct.FCompanyID = ? and A_Acct.FAccountTableID = ?");
            ksqlBuffer.append(" and A_Acct.FID in (select distinct ").append(accountTempTableFieldName).append(" from ").append(tempTable).append(")");
            tempTableJdbcTemplate.execute(ksqlBuffer.toString(), new PreparedStatementCallback(){

                @Override
                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                    ps.setString(1, AcctTempTableValueInsertProcessor.this.companyId);
                    ps.setString(2, AcctTempTableValueInsertProcessor.this.accountTableId);
                    ps.executeUpdate();
                    return null;
                }
            });
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, tempTable);
            }
        }
    }

    private ITempTableFieldItem getAccountTempTableFieldItem(ITempTableField tempTableField) {
        if (tempTableField.getTempTableFieldItem(A_ACCT_FID) != null) {
            return tempTableField.getTempTableFieldItem(A_ACCT_FID);
        }
        return null;
    }

    private String getTempTableFieldName(String tempTableField) {
        return this.getTempTableAlias() + "." + tempTableField;
    }

    private String getTempTableAlias() {
        return "tempTable";
    }

    public String getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(String accountTableId) {
        this.accountTableId = accountTableId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
}

