/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLFlagCollection;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLFlagInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantBasicStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantItemStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupStandardQuery;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.TreeNodeBatchQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AsstActTypeComarator;
import com.kingdee.eas.fi.rpt.batch.BatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashBatchProccessor;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashCombineHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashInitProccessor;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashInitRegister;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashProfitsProcessor;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashProfitsSortState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashSortRegister;
import com.kingdee.eas.fi.rpt.batch.acctcash.CashFlowItem;
import com.kingdee.eas.fi.rpt.batch.acctcash.IBaseAcctCashHandler;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AcctCashBatchCalculator
extends AbstractCalculator {
    private static Logger logger = Logger.getLogger(AcctCashBatchCalculator.class);
    private AsstActTypeComarator asstItemComarator = new AsstActTypeComarator();
    private IBatchSQLSorterRegister sortRegister = new AcctCashSortRegister();
    private List profitsList = new LinkedList();
    private List initProfitsList;
    private IBatchSQLSorterRegister initSortRegister = new AcctCashInitRegister();
    private boolean isForIncashFlow;
    private Map AsstActTypeNumberMap;
    private static final int COMPANY_CHANGES_MARK = 1;
    private static final int CURRENCY_CHANGES_MARK = 1;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\|");
    private IBaseAcctCashHandler acctCashHandler;
    private Connection conn;
    private AssistantBasicStandardQuerySolution basicStandardProcesser;
    private AssistantItemStandardQuerySolution standardProcesser;
    private MaterialGroupStandardQuery materialGroupStandardQuery;
    private Map asstItemProcesser;
    private MaterialGroupQuerySolution materialGroupQuery;
    private AssistantGroupQuerySolution groupProcesser;
    private static final String ACCTCASH_USE_TEMP_TABLE_SCHEME = "ACCTCASH_USE_TEMP_TABLE_SCHEME";
    private static final String ACCTCASH_USE_TEMP_TABLE_SCHEME_DEBUG = "ACCTCASH_USE_TEMP_TABLE_SCHEME_DEBUG";
    private static final String ACCTCASHPARAMSSIZE = "AcctCashParamsSize";
    private Context ctx;
    private boolean isUseTempTableScheme;
    private boolean isTempTableSchemeDebug;
    private static final String PERIOD_SQL = "select Max(FPeriodNumber) maxNumber ,FPeriodYear,FTypeID from T_BD_Period group by FPeriodYear,FTypeID";

    public AcctCashBatchCalculator(ICalculateContextProvider context, Context serverCtx, IBaseAcctCashHandler acctCashHandler) {
        super(context, serverCtx);
        this.initProfitsList = new LinkedList();
        if (acctCashHandler == null) {
            acctCashHandler = new AcctCashHandler();
        }
        this.acctCashHandler = acctCashHandler;
        this.ctx = serverCtx;
    }

    public AcctCashBatchCalculator(ICalculateContextProvider context, Context serverCtx, boolean isForIncashFlow) {
        this(context, serverCtx, new AcctCashHandler());
        ((AcctCashSortRegister)this.sortRegister).setForIncashFlow(isForIncashFlow);
        ((AcctCashInitRegister)this.initSortRegister).setForIncashFlow(isForIncashFlow);
        this.setForIncashFlow(isForIncashFlow);
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.getBatchHelper().setBatchSize(400);
        Map paramsMap = RptUtil.getCslParams(this.ctx, new String[]{ACCTCASHPARAMSSIZE, ACCTCASH_USE_TEMP_TABLE_SCHEME, ACCTCASH_USE_TEMP_TABLE_SCHEME_DEBUG});
        if (paramsMap.get(ACCTCASHPARAMSSIZE) != null) {
            int acctCashParamsSize = Integer.valueOf((String)paramsMap.get(ACCTCASHPARAMSSIZE));
            this.getBatchHelper().setBatchSize(acctCashParamsSize);
        }
        this.isUseTempTableScheme = RptUtil.isTrue(paramsMap.get(ACCTCASH_USE_TEMP_TABLE_SCHEME));
        this.isTempTableSchemeDebug = RptUtil.isTrue(paramsMap.get(ACCTCASH_USE_TEMP_TABLE_SCHEME_DEBUG));
        ((AcctCashSortRegister)this.sortRegister).setUseTempTableScheme(this.isUseTempTableScheme);
        this.batchHelper.setTempTableSchemeDebug(this.isTempTableSchemeDebug);
        int count = params.size();
        HashSet innerCompanyNumberSet = null;
        if (this.isForIncashFlow()) {
            innerCompanyNumberSet = new HashSet();
            this.covertParams(params, count, innerCompanyNumberSet);
        }
        HashSet asstActTypeNumberSet = new HashSet();
        HashSet cashFlowItemNumber = new HashSet();
        HashSet currencyNumber = new HashSet();
        HashSet companyNumberSet = new HashSet();
        this.constructAcctCash(params, count, companyNumberSet, asstActTypeNumberSet, cashFlowItemNumber, currencyNumber);
        this.expendAcctCashByCompany(companyNumberSet);
        ((AcctCashSortRegister)this.sortRegister).setCompanyChanges(companyNumberSet.size() > 1);
        ((AcctCashSortRegister)this.sortRegister).setCurrencyChanges(currencyNumber.size() > 1);
        ((AcctCashInitRegister)this.initSortRegister).setCompanyChanges(companyNumberSet.size() > 1);
        ((AcctCashInitRegister)this.initSortRegister).setCurrencyChanges(currencyNumber.size() > 1);
        if (innerCompanyNumberSet != null) {
            companyNumberSet.addAll(innerCompanyNumberSet);
        }
        this.fillAcctCash(companyNumberSet, asstActTypeNumberSet, cashFlowItemNumber);
        try {
            this.conn = EJBFactory.getConnection((Context)this.getServerContext());
            this.submitAssistantStandardQuery();
            this.submitAssistantItemQuery();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        this.submitFormula();
    }

    private void covertParams(SortedParameterArray params, int count, Set companySet) throws BOSException, EASBizException {
        for (int i = 0; i < count; ++i) {
            Parameter parameter = params.getParameter(i);
            String oppCompany = ((Variant)parameter.getArgs()[1]).getValue() == null ? null : ((Variant)parameter.getArgs()[1]).getValue().toString();
            parameter.getArgs()[1] = parameter.getArgs()[2];
            parameter.getArgs()[2] = parameter.getArgs()[3];
            parameter.getArgs()[3] = parameter.getArgs()[4];
            parameter.getArgs()[4] = parameter.getArgs()[5];
            parameter.getArgs()[5] = parameter.getArgs()[6];
            parameter.getArgs()[6] = this.convertCashFlowItem((Variant)parameter.getArgs()[7], oppCompany);
            parameter.getArgs()[7] = Variant.nullVariant;
            if (StringUtils.isEmpty((String)oppCompany)) {
                companySet.add(oppCompany);
            }
            DebugLogger.info(logger, "InCashFlow Param Convert", parameter.getArgs());
        }
    }

    private Variant convertCashFlowItem(Variant inCashFlowParam, String oppCompany) throws BOSException {
        String[] split;
        String item;
        String string = item = inCashFlowParam.getValue() == null ? null : inCashFlowParam.getValue().toString();
        if (!StringUtils.isEmpty((String)item) && (split = SPLIT_PATTERN.split(item)).length == 2) {
            if (this.AsstActTypeNumberMap == null) {
                this.queryAsstActTypeNumber();
            }
            String incashItem = null;
            if ("C".equals(split[1])) {
                incashItem = split[0] + "|" + this.AsstActTypeNumberMap.get("C") + "|" + oppCompany;
            } else if ("I".equals(split[1])) {
                incashItem = split[0] + "|" + this.AsstActTypeNumberMap.get("I") + "|" + oppCompany;
            } else if ("S".equals(split[1])) {
                incashItem = split[0] + "|" + this.AsstActTypeNumberMap.get("S") + "|" + oppCompany;
            }
            if (incashItem != null) {
                return new Variant(incashItem);
            }
        }
        return Variant.nullVariant;
    }

    private Map queryAsstActTypeNumber() throws BOSException {
        this.AsstActTypeNumberMap = new HashMap();
        StringBuffer kql = new StringBuffer();
        kql.append(" SELECT FNUMBER,FASSTHGATTRIBUTE FROM T_BD_AsstActType WHERE FASSTHGATTRIBUTE IN (? ,? ,?)");
        ArrayList<String> params = new ArrayList<String>();
        params.add("companyOrg");
        params.add("provider");
        params.add("customer");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)kql.toString(), (Object[])params.toArray());
            while (rowSet.next()) {
                if ("customer".equals(rowSet.getString("FASSTHGATTRIBUTE"))) {
                    this.AsstActTypeNumberMap.put("C", rowSet.getString("FNUMBER"));
                }
                if ("companyOrg".equals(rowSet.getString("FASSTHGATTRIBUTE"))) {
                    this.AsstActTypeNumberMap.put("I", rowSet.getString("FNUMBER"));
                }
                if (!"provider".equals(rowSet.getString("FASSTHGATTRIBUTE"))) continue;
                this.AsstActTypeNumberMap.put("S", rowSet.getString("FNUMBER"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return this.AsstActTypeNumberMap;
    }

    protected void fillAcctCash(Set companyNumberSet, Set asstActTypeNumberSet, Set cashFlowItemNumber) throws BOSException, EASBizException {
        Map companyMap = this.queryCompany(companyNumberSet);
        Map oppAsstActTypeMap = this.queryAsstActType(asstActTypeNumberSet);
        Map maxPeriodMap = this.getEachYearMaxPeriodNumberByType();
        Map cashFlowMap = this.queryCashItem(cashFlowItemNumber);
        Map company2SubMap = this.getSubOrgMap(companyNumberSet);
        Map companyNumber2StartPeriodMap = this.initNeedInitValue(companyNumberSet, companyMap);
        ArrayList<String> companyIds = new ArrayList<String>();
        for (String orgNumber : companyNumberSet) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyMap.get(orgNumber);
            if (company == null) continue;
            company2SubMap.put(orgNumber, company.getId().toString());
            companyIds.add(company.getId().toString());
        }
        Map PeriodCollections = FiscalPeriodHelper.getPeriodCollectionsByCompanyIds((Context)this.getServerContext(), companyIds);
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)this.getServerContext());
        Map cashItem2SubMap = this.getSubCashItemMap(cashFlowItemNumber);
        for (String itemNumber : cashFlowItemNumber) {
            CashFlowItemInfo cashItem = (CashFlowItemInfo)cashFlowMap.get(itemNumber);
            if (cashItem == null || !cashItem.isIsLeaf()) continue;
            cashItem2SubMap.put(itemNumber, cashItem.getId().toString());
        }
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            int i;
            AcctCash acctCash = (AcctCash)iterator.next();
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                iterator.remove();
                continue;
            }
            acctCash.company = (CompanyOrgUnitInfo)companyMap.get(acctCash.fiOrgUnit);
            if (acctCash.company == null) {
                this.addToErrorList(acctCash, (Exception)((Object)new ReportException(ReportException.FIND_COMPANY_ERROR)));
                iterator.remove();
                continue;
            }
            acctCash.cashFlowItemInfo = (CashFlowItemInfo)cashFlowMap.get(acctCash.cashFlowItem.number);
            if (acctCash.cashFlowItemInfo == null) {
                this.addToErrorList(acctCash, (Exception)((Object)new RptAndTempException(RptAndTempException.ITEMISNULL)));
                iterator.remove();
                continue;
            }
            acctCash.companyList = (List)company2SubMap.get(acctCash.fiOrgUnit);
            if (acctCash.companyList == null) {
                company2SubMap.put(acctCash.fiOrgUnit, acctCash.company.getId().toString());
                acctCash.companyList = (List)company2SubMap.get(acctCash.fiOrgUnit);
            }
            acctCash.cashFlowItemList = (List)cashItem2SubMap.get(acctCash.cashFlowItem.number);
            if (acctCash.cashFlowItemList == null && acctCash.cashFlowItemInfo.isIsLeaf()) {
                cashItem2SubMap.put(acctCash.cashFlowItem.number, acctCash.cashFlowItemInfo.getId().toString());
                acctCash.cashFlowItemList = (List)cashItem2SubMap.get(acctCash.cashFlowItem.number);
            }
            if (acctCash.cashFlowItemList == null || acctCash.cashFlowItemList.size() == 0) {
                this.addToErrorList(acctCash, (Exception)((Object)new RptAndTempException(RptAndTempException.ITEMISNULL)));
                iterator.remove();
                continue;
            }
            if (acctCash.cashFlowItem.hasItem()) {
                acctCash.sorttedCashFlowAsstActTypeList = new ArrayList();
                List assistantItemExtList = acctCash.assistantItemExtList;
                if (assistantItemExtList != null) {
                    int size = assistantItemExtList.size();
                    for (i = 0; i < size; ++i) {
                        AssistantItemExt assistItem = (AssistantItemExt)assistantItemExtList.get(i);
                        if (assistItem.itemType == null) {
                            this.addToErrorList(acctCash, (Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noitemtype", this.getServerContext().getLocale())})));
                            iterator.remove();
                            continue;
                        }
                        acctCash.sorttedCashFlowAsstActTypeList.add(assistItem.itemType);
                    }
                }
            }
            if (acctCash.oppAccountItem != null && acctCash.oppAccountItem.getAccountAsstItem() != null) {
                AcctountAsstItemParser.AccountAsstItem acctItem = acctCash.oppAccountItem.getAccountAsstItem();
                if (acctItem.asstItems != null) {
                    acctCash.sorttedOppAsstActTypeList = new ArrayList();
                    for (i = 0; i < acctItem.asstItems.length; ++i) {
                        AssistantItemExt assistItem = new AssistantItemExt(acctItem.asstItems[i].asstTypeNumber);
                        assistItem.itemType = (AsstActType)oppAsstActTypeMap.get(acctItem.asstItems[i].asstTypeNumber);
                        if (assistItem.itemType == null) {
                            this.addToErrorList(acctCash, (Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noitemtype", this.getServerContext().getLocale()) + " \"" + acctItem.asstItems[i].asstTypeNumber + "\""})));
                            iterator.remove();
                            continue;
                        }
                        acctCash.sorttedOppAsstActTypeList.add(assistItem.itemType);
                        assistItem.startItem = new GroupTreeNode();
                        assistItem.endItem = new GroupTreeNode();
                        assistItem.startItem.number = acctItem.asstItems[i].startNumber;
                        assistItem.endItem.number = acctItem.asstItems[i].endNumber;
                        if (acctItem.asstItems[i].group != null) {
                            assistItem.groups = new AssistantGroup[acctItem.asstItems[i].group.length];
                            for (int j = 0; acctItem.asstItems[i].group != null && j < acctItem.asstItems[i].group.length; ++j) {
                                AcctountAsstItemParser.Group groupParser = acctItem.asstItems[i].group[j];
                                AssistantGroup group = new AssistantGroup();
                                if (groupParser.startNumber.equals(groupParser.endNumber)) {
                                    if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                        group.startGroup = group.endGroup = new GroupTreeNode();
                                        group.startGroup.number = groupParser.startNumber;
                                    }
                                } else {
                                    if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                        group.startGroup = new GroupTreeNode();
                                        group.startGroup.number = groupParser.startNumber;
                                    }
                                    if (!StringUtils.isEmpty((String)groupParser.endNumber)) {
                                        group.endGroup = new GroupTreeNode();
                                        group.endGroup.number = groupParser.endNumber;
                                    }
                                }
                                group.standardNumber = groupParser.standardNumber;
                                assistItem.groups[j] = group;
                            }
                            assistItem.setGroups(assistItem.groups);
                        }
                        acctCash.oppAccountItem.getItemTypes().put(assistItem.itemType.number, assistItem);
                    }
                    Collections.sort(acctCash.sorttedOppAsstActTypeList, this.asstItemComarator);
                }
            }
            try {
                acctCash.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
                acctCash.periods = (PeriodCollection)PeriodCollections.get(acctCash.company.getId().toString());
                boolean success = this.acctCashHandler.dealTimeConditionForFillAcctCash(acctCash, maxPeriodMap, this.getCalCulateContext());
                if (!success) {
                    iterator.remove();
                    continue;
                }
                this.acctCashHandler.checkIsNeedInitValue(this.getServerContext(), companyNumber2StartPeriodMap, acctCash);
            }
            catch (ReportException e) {
                this.addToErrorList(acctCash, (Exception)((Object)e));
                iterator.remove();
            }
        }
    }

    public void execAssistantStandardQuery() throws Exception {
        if (this.standardProcesser != null) {
            this.standardProcesser.exec();
        }
        if (this.basicStandardProcesser != null) {
            this.basicStandardProcesser.exec();
        }
        if (this.materialGroupStandardQuery != null) {
            this.materialGroupStandardQuery.exec();
        }
    }

    public void execAssistantItemQuery() throws Exception {
        if (this.groupProcesser != null) {
            this.groupProcesser.exec();
        }
        if (this.asstItemProcesser != null) {
            Iterator it = this.asstItemProcesser.entrySet().iterator();
            while (it.hasNext()) {
                ((TreeNodeBatchQuerySolution)it.next().getValue()).exec();
            }
        }
        if (this.materialGroupQuery != null) {
            this.materialGroupQuery.exec();
        }
    }

    private void submitAssistantItemQuery() throws Exception {
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            AcctCash acctCash = (AcctCash)iterator.next();
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                iterator.remove();
                continue;
            }
            List assistantItemExtList = acctCash.assistantItemExtList;
            if (assistantItemExtList != null) {
                int size = assistantItemExtList.size();
                for (int i = 0; i < size; ++i) {
                    AssistantItemExt assistItem = (AssistantItemExt)assistantItemExtList.get(i);
                    if (assistItem == null) continue;
                    this.processAssistantItem(acctCash, assistItem);
                    this.execAssistantItemQuery();
                }
            }
            if (acctCash.oppAccountItem == null) continue;
            for (AssistantItemExt assistItemOpp : acctCash.oppAccountItem.getItemTypes().values()) {
                this.processAssistantItem(acctCash, assistItemOpp);
            }
        }
    }

    private void processAssistantItem(AcctCash acctCash, AssistantItemExt assistItem) {
        AssistantGroup[] groups = assistItem.getGroups();
        for (int i = 0; groups != null && i < groups.length; ++i) {
            AssistantGroup group = groups[i];
            int type = -1;
            if ("T_BD_CUSTOMER".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) {
                type = 1;
            } else if ("T_BD_SUPPLIER".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) {
                type = 2;
            }
            if (type > 0) {
                if (StringUtils.isEmpty((String)group.standardID)) {
                    acctCash.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"GroupStandardNoExists", (Locale)this.getBatchHelper().getServerContext().getLocale()) + "\"" + group.standardNumber + "\""})));
                }
                this.submitGroupQuery(group.startGroup, type, group.standardID);
                if (group.startGroup == group.endGroup) continue;
                this.submitGroupQuery(group.endGroup, type, group.standardID);
                continue;
            }
            if (StringUtils.isEmpty((String)group.standardID)) continue;
            this.submitMaterialGroupQuery(group.startGroup, group.standardID);
            if (group.startGroup == group.endGroup) continue;
            this.submitMaterialGroupQuery(group.endGroup, group.standardID);
        }
        if (assistItem.itemType != null && (assistItem.itemType.useLongNumber || "T_BD_GeneralAsstActType".equalsIgnoreCase(assistItem.itemType.realtionDataObject))) {
            if (assistItem.startItem != null && assistItem.startItem.number != null) {
                assistItem.startItem.longNumber = assistItem.startItem.number = assistItem.startItem.number.replaceAll("\\.", "\\!");
            }
            if (assistItem.endItem != null && assistItem.endItem.number != null) {
                assistItem.endItem.longNumber = assistItem.endItem.number = assistItem.endItem.number.replaceAll("\\.", "\\!");
            }
        } else if (assistItem.itemType != null && ("T_ORG_Admin".equalsIgnoreCase(assistItem.itemType.realtionDataObject) || "T_BD_CashFlowItem".equalsIgnoreCase(assistItem.itemType.realtionDataObject) || "T_ORG_CostCenter".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) && assistItem.startItem != null && assistItem.startItem.number != null) {
            this.submitAsstItemQuery(assistItem.itemType.realtionDataObject, assistItem.startItem);
            if (assistItem.startItem != assistItem.endItem && assistItem.endItem != null && assistItem.endItem.number != null) {
                this.submitAsstItemQuery(assistItem.itemType.realtionDataObject, assistItem.endItem);
            }
        }
    }

    public void submitAsstItemQuery(String tableName, GroupTreeNode node) {
        if (this.asstItemProcesser == null) {
            this.asstItemProcesser = new HashMap(1);
        }
        TreeNodeBatchQuerySolution query = null;
        if (this.asstItemProcesser.containsKey(tableName)) {
            query = (TreeNodeBatchQuerySolution)this.asstItemProcesser.get(tableName);
        } else {
            query = new TreeNodeBatchQuerySolution(this.conn, tableName);
            this.asstItemProcesser.put(tableName, query);
        }
        try {
            query.add(node);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitMaterialGroupQuery(GroupTreeNode group, String standard) {
        this.materialGroupQuery = new MaterialGroupQuerySolution(this.conn);
        this.materialGroupQuery.add(group, standard);
    }

    private void submitGroupQuery(GroupTreeNode node, int type, String stdid) {
        this.groupProcesser = new AssistantGroupQuerySolution(this.conn);
        try {
            this.groupProcesser.add(node, type, stdid);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitAssistantStandardQuery() throws Exception {
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            AcctCash acctCash = (AcctCash)iterator.next();
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                iterator.remove();
                continue;
            }
            List assistantItemExtList = acctCash.assistantItemExtList;
            if (assistantItemExtList != null) {
                int size = assistantItemExtList.size();
                for (int i = 0; i < size; ++i) {
                    AssistantItemExt assistItem = (AssistantItemExt)assistantItemExtList.get(i);
                    if (assistItem == null) continue;
                    this.processGroupStandard(assistItem);
                    this.execAssistantStandardQuery();
                }
            }
            if (acctCash.oppAccountItem == null) continue;
            AcctountAsstItemParser.AccountAsstItem accountAsstItem = acctCash.oppAccountItem.getAccountAsstItem();
            for (int i = 0; accountAsstItem != null && accountAsstItem.asstItems != null && i < accountAsstItem.asstItems.length; ++i) {
                AssistantItemExt assistItemOpp;
                if (acctCash.oppAccountItem.getItemTypes() == null || (assistItemOpp = (AssistantItemExt)acctCash.oppAccountItem.getItemTypes().get(accountAsstItem.asstItems[i].asstTypeNumber)) == null) continue;
                this.processGroupStandard(assistItemOpp);
                this.execAssistantStandardQuery();
            }
        }
    }

    private void processGroupStandard(AssistantItemExt assistItem) {
        AssistantGroup[] groups = assistItem.getGroups();
        for (int i = 0; groups != null && i < groups.length; ++i) {
            AssistantGroup group = groups[i];
            int type = -1;
            type = "T_BD_CUSTOMER".equalsIgnoreCase(assistItem.itemType.realtionDataObject) ? 1 : ("T_BD_SUPPLIER".equalsIgnoreCase(assistItem.itemType.realtionDataObject) ? 2 : 3);
            group.standardType = type;
            if (type == 1 || type == 2) {
                if (!(!StringUtils.isEmpty((String)group.getStandardNumber()) || StringUtils.isEmpty((String)group.getStartGroup().getNumber()) && StringUtils.isEmpty((String)group.getEndGroup().getNumber()))) {
                    this.submitBasicStandardQuery(assistItem, group);
                    continue;
                }
                this.submitStandardQuery(group);
                continue;
            }
            if (type != 3) continue;
            if (!(!StringUtils.isEmpty((String)group.getStandardNumber()) || StringUtils.isEmpty((String)group.getStartGroup().getNumber()) && StringUtils.isEmpty((String)group.getEndGroup().getNumber()))) {
                group.standardType = 1;
                this.submitMaterialStandardQuery(group);
                continue;
            }
            group.standardType = 0;
            this.submitMaterialStandardQuery(group);
        }
    }

    private void submitBasicStandardQuery(AssistantItemExt item, AssistantGroup group) {
        this.basicStandardProcesser = new AssistantBasicStandardQuerySolution(this.conn);
        try {
            this.basicStandardProcesser.add(item, group);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitStandardQuery(AssistantGroup group) {
        this.standardProcesser = new AssistantItemStandardQuerySolution(this.conn);
        try {
            this.standardProcesser.add(group);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitMaterialStandardQuery(AssistantGroup g) {
        this.materialGroupStandardQuery = new MaterialGroupStandardQuery(this.conn);
        this.materialGroupStandardQuery.setContext(this.getServerContext());
        this.materialGroupStandardQuery.add(g);
    }

    protected Map initNeedInitValue(Set companySet, Map companyMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("value"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowInit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        GLFlagCollection col = GLFlagFactory.getLocalInstance((Context)this.getServerContext()).getCollection(view);
        HashMap<String, String> id2OmpanyNumberMap = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            id2OmpanyNumberMap.put(col.get(i).getOrgUnit().getId().toString(), col.get(i).getOrgUnit().getNumber());
        }
        HashSet<CompanyOrgUnitInfo> virtualCompanys = new HashSet<CompanyOrgUnitInfo>();
        for (String company : companySet) {
            Object companyInfo = companyMap.get(company);
            if (!(companyInfo instanceof CompanyOrgUnitInfo) || ((CompanyOrgUnitInfo)companyInfo).isIsBizUnit()) continue;
            virtualCompanys.add((CompanyOrgUnitInfo)companyInfo);
        }
        Map virtualUnitPeriods = this.getStartPeriodForVirtual(virtualCompanys);
        Map bizUnitPeriods = this.getStartPeriod(id2OmpanyNumberMap);
        bizUnitPeriods.putAll(virtualUnitPeriods);
        return bizUnitPeriods;
    }

    private Map getStartPeriodForVirtual(Set virtualCompanys) throws BOSException {
        StringBuffer longNumberField = new StringBuffer();
        StringBuffer longNumberWhere = new StringBuffer();
        longNumberField.append("    \t\tcase ");
        HashMap<String, String> longNumber2Number = new HashMap<String, String>();
        HashMap result = new HashMap();
        if (virtualCompanys.isEmpty()) {
            return result;
        }
        for (CompanyOrgUnitInfo company : virtualCompanys) {
            longNumberWhere.append(" or ");
            longNumberWhere.append(" org.fLongNumber like '" + company.getLongNumber() + "!%' ");
            longNumberField.append("    \t\t\twhen  org.fLongNumber like '" + company.getLongNumber() + "!%' then '" + company.getLongNumber() + "'    ");
            longNumber2Number.put(company.getLongNumber(), company.getNumber());
        }
        longNumberWhere.delete(0, " or ".length() - 1);
        longNumberField.append("    \t\t\telse 'NONE'     ");
        longNumberField.append("    \t\tend ");
        StringBuffer sql = new StringBuffer();
        sql.append("    select \tmin(CONVERT(VARCHAR,period.FPeriodYear) || case when len(CONVERT(VARCHAR,period.FPeriodNumber))=1 then '0' else '' end || CONVERT(VARCHAR,period.FPeriodNumber) ) PERIOD,    ");
        sql.append("    ");
        sql.append(longNumberField);
        sql.append("    LONGNUMBER \t");
        sql.append("    from T_BD_SystemStatusCtrol sysStaCtr    ");
        sql.append("    inner join T_BD_SystemStatus sysSta    ");
        sql.append("    on  sysStaCtr.FSystemStatusID=sysSta.FID     ");
        sql.append("    inner join T_BD_Period period      ");
        sql.append("    on sysStaCtr.FStartPeriodID = period.FID     ");
        sql.append("    inner join t_org_company org    ");
        sql.append("    on org.fid = sysStaCtr.FCompanyId    ");
        sql.append("    where sysSta.FName = 6     ");
        sql.append("    and ( ");
        sql.append(longNumberWhere);
        sql.append("    ) ");
        sql.append("    and org.fIsBizUnit = 1    ");
        sql.append("    group by ");
        sql.append(longNumberField);
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                while (iRowSet.next()) {
                    String period = iRowSet.getString("PERIOD");
                    String longNumber = iRowSet.getString("LONGNUMBER");
                    if (period == null || !period.matches("[0-9]{6}")) continue;
                    PeriodInfo periodInfo = new PeriodInfo();
                    periodInfo.setPeriodNumber(Integer.parseInt(period.substring(4)));
                    periodInfo.setPeriodYear(Integer.parseInt(period.substring(0, 4)));
                    result.put(longNumber2Number.get(longNumber), periodInfo);
                }
                return result;
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return result;
    }

    protected Map getStartPeriod(Map id2OmpanyNumberMap) throws BOSException, EASBizException {
        if (id2OmpanyNumberMap.size() == 0) {
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Integer> params = new ArrayList<Integer>();
        sql.append(" select period.FPeriodYear periodYear,period.FPeriodNumber periodNumber,sysStaCtr.FCompanyID companyID ");
        sql.append(" from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta,T_BD_Period period ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FStartPeriodID = period.FID ");
        sql.append(" and sysStaCtr.FCompanyID in ");
        sql.append(this.getBatchHelper().createInSql(id2OmpanyNumberMap.keySet().iterator(), params));
        sql.append(" and sysSta.FName = ? ");
        params.add(new Integer(6));
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
        HashMap result = new HashMap();
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                while (iRowSet.next()) {
                    PeriodInfo periodInfo = new PeriodInfo();
                    periodInfo.setPeriodNumber(iRowSet.getInt("periodNumber"));
                    periodInfo.setPeriodYear(iRowSet.getInt("periodYear"));
                    result.put(id2OmpanyNumberMap.get(iRowSet.getString("companyID")), periodInfo);
                }
                return result;
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        return result;
    }

    protected void submitFormula() {
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            AcctCash acctCash = (AcctCash)iterator.next();
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                iterator.remove();
                continue;
            }
            if (acctCash.cashFlowItemInfo.isIsProfit()) {
                if (acctCash.needCombineInitValue) {
                    this.initProfitsList.add(acctCash);
                }
                this.profitsList.add(acctCash);
                HashSet<String> nullSet = new HashSet<String>();
                acctCash.setNullFields(nullSet);
                if (acctCash.isIncludingUnPosted) {
                    nullSet.add("isIncludingUnPosted");
                }
                if (CashTypeEnum.AS.equals((Object)acctCash.cashTypeEnum) || CashTypeEnum.AZ.equals((Object)acctCash.cashTypeEnum)) {
                    nullSet.add("CurrencyNumber");
                }
                ITimeCondition timeCondition = acctCash.getTimeCondition();
                int sameType = timeCondition.whatSame();
                switch (sameType) {
                    case 1: {
                        nullSet.add("sameyear");
                        break;
                    }
                    case 2: {
                        nullSet.add("sameperiod");
                        break;
                    }
                    case 3: {
                        nullSet.add("sametime");
                        break;
                    }
                }
                continue;
            }
            if (acctCash.needCombineInitValue) {
                acctCash.initCompanyList = new ArrayList();
                CompanyOrgUnitInfo company = acctCash.company;
                if (!company.isIsOnlyUnion()) {
                    acctCash.initCompanyList = acctCash.companyList;
                    this.initSortRegister.register(acctCash);
                } else {
                    this.removeCompanyWhichIsNotInited(acctCash);
                    if (acctCash.initCompanyList.size() > 0) {
                        this.initSortRegister.register(acctCash);
                    }
                }
            }
            this.sortRegister.register(acctCash);
        }
    }

    private void removeCompanyWhichIsNotInited(AcctCash acctCash) {
        List companyids = acctCash.companyList;
        HashSet companySet = new HashSet(companyids);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)"cashflowInit", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)"true", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", companySet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            GLFlagCollection col = GLFlagFactory.getLocalInstance((Context)this.getServerContext()).getCollection(view);
            if (col != null && col.size() > 0) {
                for (GLFlagInfo info : col) {
                    acctCash.initCompanyList.add(info.getOrgUnit().getId().toString());
                }
            }
        }
        catch (BOSException e) {
            acctCash.setException((Exception)((Object)e));
        }
    }

    protected Map getSubCashItemMap(Set cashFlowItemNumber) throws BOSException {
        OneToManyMap result = new OneToManyMap();
        if (cashFlowItemNumber.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append(" select sub.FID SubID,super.FNumber SuperNumber ");
        sql.append(" from T_BD_CashFLowItem sub   ");
        sql.append(" inner join T_BD_CashFLowItem super on charindex(concat(super.FLongnumber,'!'),sub.FLongnumber) = 1   ");
        sql.append(" where  sub.FIsleaf = 1 and super.FNumber in ");
        sql.append(this.batchHelper.createInSql(cashFlowItemNumber.iterator(), params));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                String companyNumber = rowSet.getString("SuperNumber");
                result.put(companyNumber, rowSet.getString("SubID"));
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected Map getSubOrgMap(Set companyNumberSet) throws BOSException {
        OneToManyMap result = new OneToManyMap();
        if (companyNumberSet.size() == 0) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append(" select sub.FID SubID,super.FNumber SuperNumber ");
        sql.append(" from T_ORG_company sub   ");
        sql.append(" inner join T_ORG_Company super on charindex(concat(super.FLongnumber,'!'),sub.FLongnumber) = 1   ");
        sql.append(" where sub.fiscompanyorgunit = 1 and sub.FIssealup = 0 and super.FNumber in ");
        sql.append(this.batchHelper.createInSql(companyNumberSet.iterator(), params));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                String companyNumber = rowSet.getString("SuperNumber");
                result.put(companyNumber, rowSet.getString("SubID"));
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected Map queryCashItem(Set cashFlowItemNumber) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("type"));
        ev.getSelector().add(new SelectorItemInfo("isLeaf"));
        ev.getSelector().add(new SelectorItemInfo("direction"));
        ev.getSelector().add(new SelectorItemInfo("isProfit"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("isEnable"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)cashFlowItemNumber, CompareType.INCLUDE));
        CashFlowItemCollection cashFlowItemCollection = CashFlowItemFactory.getLocalInstance((Context)this.getServerContext()).getCashFlowItemCollection(ev);
        HashMap<String, CashFlowItemInfo> result = new HashMap<String, CashFlowItemInfo>();
        if (cashFlowItemCollection != null) {
            int count = cashFlowItemCollection.size();
            for (int i = 0; i < count; ++i) {
                result.put(cashFlowItemCollection.get(i).getNumber(), cashFlowItemCollection.get(i));
            }
        }
        return result;
    }

    private void constructAcctCash(SortedParameterArray params, int count, Set companyNumberSet, Set asstActTypeNumberSet, Set cashFlowItemNumberSet, Set currencyNumber) {
        for (int i = 0; i < count; ++i) {
            ITimeCondition timeCondition = this.acctCashHandler.getTimeConditionInstance();
            AcctCash acctCash = new AcctCash(params.getParameter(i), this.batchHelper, timeCondition);
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                continue;
            }
            try {
                acctCash.cashFlowItem = new CashFlowItem(this.batchHelper.getServerContext(), acctCash.cashFlowItemString, acctCash);
            }
            catch (ParseException e1) {
                acctCash.setException(e1);
                this.addToErrorList(acctCash);
                logger.error((Object)"cashFlowItem", (Throwable)e1);
                continue;
            }
            catch (ReportException e) {
                acctCash.setException((Exception)((Object)e));
                this.addToErrorList(acctCash);
                logger.error((Object)"cashFlowItem", (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                acctCash.setException((Exception)((Object)e));
                this.addToErrorList(acctCash);
                logger.error((Object)"cashFlowItem", (Throwable)e);
                continue;
            }
            companyNumberSet.add(acctCash.fiOrgUnit);
            currencyNumber.add(acctCash.currencyNumber);
            cashFlowItemNumberSet.add(acctCash.cashFlowItem.number);
            if (acctCash.oppAccountItem != null && acctCash.oppAccountItem.getAccountAsstItem().asstItems != null) {
                for (int j = 0; j < acctCash.oppAccountItem.getAccountAsstItem().asstItems.length; ++j) {
                    asstActTypeNumberSet.add(acctCash.oppAccountItem.getAccountAsstItem().asstItems[j].asstTypeNumber);
                }
            }
            this.getFormulaCalculatorParameterList().add(acctCash);
        }
    }

    protected Map getEachYearMaxPeriodNumberByType() throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)PERIOD_SQL);
        try {
            StringBuffer sb = new StringBuffer();
            while (rowSet.next()) {
                sb.append(rowSet.getInt("FPeriodYear")).append(rowSet.getString("FTypeID"));
                result.put(sb.toString(), new Integer(rowSet.getInt("maxNumber")));
                sb.setLength(0);
            }
            return result;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected Map queryAsstActType(Set asstActTypeNumberSet) throws BOSException {
        HashMap<String, AsstActType> asstActTypeMap = new HashMap<String, AsstActType>();
        if (asstActTypeNumberSet.size() == 0) {
            return asstActTypeMap;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        sql.append(" Select FNumber, FrealtionDataObject FtableName, FmappingFieldName FfieldName , FGlAsstActTypeGrpID groupID, FGroupTableName , FGroupMappingFieldName, FUseLongNumber  from T_BD_AsstActType where  FNumber in  \n");
        sql.append(this.getBatchHelper().createInSql(asstActTypeNumberSet.iterator(), params));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                AsstActType type = new AsstActType();
                type.realtionDataObject = rowSet.getString("FtableName").toUpperCase();
                type.mappingFieldName = rowSet.getString("FfieldName").toUpperCase();
                type.number = rowSet.getString("FNumber");
                type.glAsstActTypeGrpID = rowSet.getString("groupID");
                type.groupTableName = rowSet.getString("FGroupTableName");
                type.groupMappingFieldName = rowSet.getString("FGroupMappingFieldName");
                int isUseLongNumberInt = rowSet.getInt("FUseLongNumber");
                type.useLongNumber = isUseLongNumberInt == 1 ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
                asstActTypeMap.put(type.number, type);
            }
            return asstActTypeMap;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected Map queryCompany(Set companyNumberSet) throws BOSException {
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        if (companyNumberSet.size() == 0) {
            return companyMap;
        }
        EntityViewInfo view = new EntityViewInfo();
        this.getCompanySelector(view);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)this.getServerContext()).getCompanyOrgUnitCollection(view);
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            companyMap.put(companyOrgUnitInfo.getNumber(), companyOrgUnitInfo);
        }
        return companyMap;
    }

    private void getCompanySelector(EntityViewInfo view) {
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isOnlyUnion"));
        view.getSelector().add(new SelectorItemInfo("accountTable.id"));
        view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        view.getSelector().add(new SelectorItemInfo("accountPeriodType.id"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("isBizUnit"));
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        if (this.initProfitsList.size() > 0) {
            this.calculateInitProfits(this.initProfitsList);
        }
        if (this.profitsList.size() > 0) {
            AcctCashProfitsProcessor builder = new AcctCashProfitsProcessor(this.batchHelper.getBatchSize());
            BatchSQLSorterRegister register = new BatchSQLSorterRegister(new HashMap());
            register.setSortState(new AcctCashProfitsSortState());
            for (AcctCash acctCash : this.profitsList) {
                register.register(acctCash);
            }
            this.batchHelper.batchCalculateBigDecimalBySorter(builder, register);
        }
        AcctCashInitProccessor initProcessor = new AcctCashInitProccessor(this.batchHelper.getBatchSize());
        this.batchHelper.batchCalculateBigDecimalBySorter(initProcessor, this.initSortRegister);
        AcctCashBatchProccessor processor = new AcctCashBatchProccessor(this.batchHelper.getBatchSize());
        this.batchHelper.batchCalculateBigDecimalBySorter(processor, this.sortRegister, new AcctCashCombineHandler());
    }

    private void calculateInitProfits(List initProfitsList) throws BOSException {
        if (initProfitsList == null || initProfitsList.size() == 0) {
            return;
        }
        OneToManyMap typeMap = new OneToManyMap();
        for (AcctCash acctCash : initProfitsList) {
            if (acctCash.isNeedCurrency()) {
                typeMap.put(acctCash.currencyNumber + acctCash.company.getId(), acctCash);
                continue;
            }
            typeMap.put(acctCash.company.getId(), acctCash);
        }
        String sqlNeedCurrency = this.getInitProfitsSQL(true);
        String sqlNoNeedCurrency = this.getInitProfitsSQL(false);
        for (Map.Entry entry : typeMap.entrySet()) {
            Object[] objectArray;
            String sql;
            List formulas = (List)entry.getValue();
            AcctCash exam = (AcctCash)formulas.get(0);
            String string = sql = exam.isNeedCurrency() ? sqlNeedCurrency : sqlNoNeedCurrency;
            if (exam.isNeedCurrency()) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = exam.company.getId().toString();
                objectArray = objectArray2;
                objectArray2[1] = exam.currencyNumber;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = exam.company.getId().toString();
            }
            Object[] params = objectArray;
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql, (Object[])params);
            try {
                while (rowSet.next()) {
                    BigDecimal local = rowSet.getBigDecimal("LocalAmount");
                    BigDecimal report = rowSet.getBigDecimal("ReportingAmount");
                    BigDecimal original = rowSet.getBigDecimal("OriginalAmount");
                    for (AcctCash acctCash : formulas) {
                        BigDecimal value = null;
                        value = acctCash.cashTypeEnum == null ? original : (CashTypeEnum.Z.equals((Object)acctCash.cashTypeEnum) || CashTypeEnum.AZ.equals((Object)acctCash.cashTypeEnum) ? local : (CashTypeEnum.S.equals((Object)acctCash.cashTypeEnum) || CashTypeEnum.AS.equals((Object)acctCash.cashTypeEnum) ? report : original));
                        acctCash.combineNumberValue(value);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private String getInitProfitsSQL(boolean needCurrency) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select sum((-1)*FDC*FYearPnLLocal) LocalAmount ");
        sql.append(" ,sum((-1)*FDC*FYearPnLRpt) ReportingAmount ");
        sql.append(" ,sum((-1)*FDC*FYearPnLFor) OriginalAmount ");
        sql.append(" from T_GL_InitAccountBalance balance ");
        sql.append(" inner join T_BD_AccountView account on balance.FAccountID = account.FID ");
        sql.append(" inner join T_BD_Currency currency on balance.FCurrencyID = currency.FID ");
        sql.append(" where account.FIsLeaf = 1 and account.FPLType>0  ");
        sql.append(" and balance.FOrgUnitId = ? ");
        if (needCurrency) {
            sql.append(" and currency.FNumber = ? ");
        }
        return sql.toString();
    }

    @Override
    protected void clear() {
    }

    public boolean isForIncashFlow() {
        return this.isForIncashFlow;
    }

    public void setForIncashFlow(boolean isForIncashFlow) {
        this.isForIncashFlow = isForIncashFlow;
    }

    private void expendAcctCashByCompany(Set companyNumberSet) {
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        ArrayList<AcctCash> acctCashs = new ArrayList<AcctCash>();
        ArrayList<AcctCash> removes = new ArrayList<AcctCash>();
        while (iterator.hasNext()) {
            AcctCash acctCash = (AcctCash)iterator.next();
            if (acctCash.isException()) {
                this.addToErrorList(acctCash);
                iterator.remove();
                continue;
            }
            StringTokenizer stoken = new StringTokenizer(acctCash.fiOrgUnit, "\\||\\,|\\;");
            ArrayList<String> companyList = new ArrayList<String>();
            while (stoken.hasMoreElements()) {
                String trim = stoken.nextElement().toString().trim();
                companyList.add(trim);
            }
            if (companyList.size() > 1) {
                int size = companyList.size();
                for (int i = 0; i < size; ++i) {
                    String companyNumber;
                    AcctCash acctCashNew = acctCash.copy();
                    acctCashNew.fiOrgUnit = companyNumber = (String)companyList.get(i);
                    try {
                        this.batchHelper.checkCompanyPermisionNotSplit(OrgType.Company, acctCashNew.fiOrgUnit);
                    }
                    catch (Exception e) {
                        acctCashNew.setException(e);
                    }
                    companyNumberSet.add(companyNumber);
                    acctCashs.add(acctCashNew);
                }
                if (acctCashs.size() <= 0) continue;
                removes.add(acctCash);
                companyNumberSet.remove(acctCash.fiOrgUnit);
                continue;
            }
            try {
                this.batchHelper.checkCompanyPermisionNotSplit(OrgType.Company, acctCash.fiOrgUnit);
            }
            catch (Exception e) {
                acctCash.setException(e);
            }
        }
        if (removes.size() > 0) {
            this.getFormulaCalculatorParameterList().removeAll(removes);
            this.getFormulaCalculatorParameterList().addAll(acctCashs);
        }
    }
}

