/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class AcctCashCombineState
implements IFormulaCombinationPreparedState {
    private BigDecimal reporting;
    private BigDecimal local;
    private BigDecimal original;
    private Map notLeafAsstNumberMap = new HashMap();

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        if (acctCash.cashTypeEnum == CashTypeEnum.Y || acctCash.cashTypeEnum == null && timeCondition.getType() == 2) {
            return this.original;
        }
        if (acctCash.cashTypeEnum == CashTypeEnum.Z || acctCash.cashTypeEnum == CashTypeEnum.AZ) {
            return this.local;
        }
        if (acctCash.cashTypeEnum == CashTypeEnum.S || acctCash.cashTypeEnum == CashTypeEnum.AS) {
            return this.reporting;
        }
        return CslConstant.BGZERO;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        if (this.notLeafAsstNumberMap.size() > 0) {
            for (Map.Entry entry : this.notLeafAsstNumberMap.entrySet()) {
                String asstActType = (String)entry.getKey();
                String formulaItem = acctCash.cashFlowItem.getItem((String)asstActType).startItem.longNumber;
                String resultItem = (String)entry.getValue();
                if (resultItem.equals(formulaItem) || resultItem.startsWith(formulaItem + "!")) continue;
                return false;
            }
        }
        return true;
    }

    public BigDecimal getReporting() {
        return this.reporting;
    }

    public void setReporting(BigDecimal reporting) {
        this.reporting = reporting;
    }

    public BigDecimal getLocal() {
        return this.local;
    }

    public void setLocal(BigDecimal local) {
        this.local = local;
    }

    public BigDecimal getOriginal() {
        return this.original;
    }

    public void setOriginal(BigDecimal original) {
        this.original = original;
    }

    public void putAsstNumber(String asstTypenumber, String asstNumber) {
        this.notLeafAsstNumberMap.put(asstTypenumber, asstNumber);
    }

    public void refresh() {
        this.notLeafAsstNumberMap.clear();
    }
}

