/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashExtTimeCondition;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashTimeCondition;
import com.kingdee.eas.fi.rpt.batch.acctcash.ITimeCondition;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AcctCashProfitCombineState
implements IFormulaCombinationPreparedState {
    private static final int MIN_PERIOD_YEAR = 0;
    private static final int MIN_PERIOD_NUMBER = 0;
    private static final int MAX_PERIOD_YEAR = Integer.MAX_VALUE;
    private static final int MAX_PERIOD_NUMBER = Integer.MAX_VALUE;
    private Logger logger = Logger.getLogger(AcctCashProfitCombineState.class);
    private BigDecimal reporting;
    private BigDecimal local;
    private BigDecimal original;
    private int periodYear;
    private int periodNumber;
    private Map currentPeriods = new HashMap();
    private String cashFlowAsstActItemLongNumber;

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        if (acctCash.cashTypeEnum == CashTypeEnum.Y || acctCash.cashTypeEnum == null && timeCondition.getType() == 2) {
            return this.original;
        }
        if (acctCash.cashTypeEnum == CashTypeEnum.Z || acctCash.cashTypeEnum == CashTypeEnum.AZ) {
            return this.local;
        }
        if (acctCash.cashTypeEnum == CashTypeEnum.S || acctCash.cashTypeEnum == CashTypeEnum.AS) {
            return this.reporting;
        }
        return CslConstant.BGZERO;
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        ITimeCondition timeCondition = acctCash.getTimeCondition();
        int startYear = 0;
        int startPeriod = 0;
        int endYear = 0;
        int endPeriod = 0;
        if (timeCondition instanceof AcctCashTimeCondition) {
            AcctCashTimeCondition acctCashTC = (AcctCashTimeCondition)timeCondition;
            startYear = acctCashTC.getStartYear();
            startPeriod = acctCashTC.getStartPeriod();
            endYear = acctCashTC.getEndYear();
            endPeriod = acctCashTC.getEndPeriod();
        } else if (timeCondition instanceof AcctCashExtTimeCondition) {
            AcctCashExtTimeCondition acctCashTC = (AcctCashExtTimeCondition)timeCondition;
            Date startTime = acctCashTC.getStartTime();
            Date endTime = acctCashTC.getEndTime();
            try {
                int[] yearPeriodRange = this.getYearPeriodRangeByDate(startTime, endTime, acctCash);
                if (yearPeriodRange == null) {
                    return false;
                }
                startYear = yearPeriodRange[0];
                startPeriod = yearPeriodRange[1];
                endYear = yearPeriodRange[2];
                endPeriod = yearPeriodRange[3];
            }
            catch (BOSException e) {
                this.logger.error((Object)"", (Throwable)e);
                return false;
            }
            catch (EASBizException e) {
                this.logger.error((Object)"", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                this.logger.error((Object)"", (Throwable)e);
                acctCash.setException(e);
                return false;
            }
        } else {
            return false;
        }
        if (startYear == endYear && startPeriod == endPeriod) {
            return this.periodYear == startYear && this.periodNumber == startPeriod;
        }
        if (startYear == endYear) {
            return this.periodYear == startYear && this.periodNumber >= startPeriod && this.periodNumber <= endPeriod;
        }
        return this.periodYear == startYear && this.periodNumber >= startPeriod || this.periodYear > startYear && this.periodYear < endYear || this.periodYear == endYear && this.periodNumber <= endPeriod;
    }

    private int[] getYearPeriodRangeByDate(Date startTime, Date endTime, AcctCash acctCash) throws EASBizException, BOSException {
        Context serverContext = acctCash.batchHelper.getServerContext();
        PeriodTypeInfo compPeriodTypeInfo = acctCash.company.getAccountPeriodType();
        PeriodInfo startPeriod = this.getPeriodByDate(serverContext, startTime, compPeriodTypeInfo.getId().toString());
        PeriodInfo endPeriod = this.getPeriodByDate(serverContext, endTime, compPeriodTypeInfo.getId().toString());
        PeriodInfo currentPeriod = null;
        if ((startPeriod == null || endPeriod == null) && (currentPeriod = this.getCompCurrPeriod(serverContext, acctCash.company)) == null) {
            return null;
        }
        int startPeriodYear = 0;
        int startPeriodNumber = 0;
        int endPeriodYear = 0;
        int endPeriodNumber = 0;
        if (startPeriod == null) {
            if (currentPeriod != null && startTime.before(currentPeriod.getBeginDate())) {
                startPeriodYear = 0;
                startPeriodNumber = 0;
            } else {
                startPeriodYear = Integer.MAX_VALUE;
                startPeriodNumber = Integer.MAX_VALUE;
            }
        } else {
            startPeriodYear = startPeriod.getPeriodYear();
            startPeriodNumber = startPeriod.getPeriodNumber();
        }
        if (endPeriod == null) {
            if (currentPeriod != null && endTime.before(currentPeriod.getBeginDate())) {
                endPeriodYear = 0;
                endPeriodNumber = 0;
            } else {
                endPeriodYear = Integer.MAX_VALUE;
                endPeriodNumber = Integer.MAX_VALUE;
            }
        } else {
            endPeriodYear = endPeriod.getPeriodYear();
            endPeriodNumber = endPeriod.getPeriodNumber();
        }
        return new int[]{startPeriodYear, startPeriodNumber, endPeriodYear, endPeriodNumber};
    }

    private PeriodInfo getCompCurrPeriod(Context serverContext, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = (PeriodInfo)this.currentPeriods.get(company.getId().toString());
        if (currentPeriod == null) {
            currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)serverContext, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            if (currentPeriod == null) {
                return null;
            }
            this.currentPeriods.put(company.getId().toString(), currentPeriod);
        }
        return currentPeriod;
    }

    private PeriodInfo getPeriodByDate(Context ctx, Date tsDate, String compPeriodTypeInfoId) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("beginDate", (Object)tsDate, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("endDate", (Object)tsDate, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("periodType.id", (Object)compPeriodTypeInfoId));
        view.setFilter(filter);
        PeriodCollection periodCollection = iPeriod.getPeriodCollection(view);
        PeriodInfo periodInfo = periodCollection == null || periodCollection.size() == 0 ? null : periodCollection.get(0);
        return periodInfo;
    }

    public BigDecimal getReporting() {
        return this.reporting;
    }

    public void setReporting(BigDecimal reporting) {
        this.reporting = reporting;
    }

    public BigDecimal getLocal() {
        return this.local;
    }

    public void setLocal(BigDecimal local) {
        this.local = local;
    }

    public BigDecimal getOriginal() {
        return this.original;
    }

    public void setOriginal(BigDecimal original) {
        this.original = original;
    }

    public void setPeriodYear(int periodYear) {
        this.periodYear = periodYear;
    }

    public void setPeriodNumber(int periodNumber) {
        this.periodNumber = periodNumber;
    }

    public void setCashFlowAsstActItemLongNumber(String cashFlowAsstActItemLongNumber) {
        this.cashFlowAsstActItemLongNumber = cashFlowAsstActItemLongNumber;
    }
}

