/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableField;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.ITempTableValueInsertProcessor;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableFieldItem;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableJdbcTemplate;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableUtil;
import com.kingdee.eas.fi.rpt.batch.temptablescheme.TempTableValueInsertUtil;
import com.kingdee.eas.fi.rpt.jdbc.PreparedStatementCallback;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AcctCashTempTableValueInsertProcessor
implements ITempTableValueInsertProcessor {
    private static final String CASHITEMFID = "CashItem.FID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTempTableValueInsert(TempTableJdbcTemplate tempTableJdbcTemplate, ITempTableField tempTableField, String tempTableName, List valuesList) throws BOSException {
        String tempTable = null;
        TempTableFieldItem accountFieldItem = (TempTableFieldItem)this.getAccountTempTableFieldItem(tempTableField);
        if (accountFieldItem == null) {
            TempTableValueInsertUtil.insertValueIntoTempTable(tempTableJdbcTemplate, tempTableField, tempTableName, valuesList);
            return;
        }
        String accountTempTableFieldName = accountFieldItem.getTempTableField();
        try {
            tempTable = TempTableUtil.createDBSystemTempTable(tempTableJdbcTemplate, tempTableField, "T_RPT_CashItemTempTable", false);
            TempTableValueInsertUtil.insertValueIntoTempTable(tempTableJdbcTemplate, tempTableField, tempTable, valuesList);
            tempTableJdbcTemplate.analyzeTable(tempTable);
            StringBuffer ksqlBuffer = new StringBuffer();
            ksqlBuffer.append(" insert into ").append(tempTableName).append(" ");
            ksqlBuffer.append(" select distinct ");
            List tempTableFieldItems = tempTableField.getTempTableFieldItems();
            Iterator it = tempTableFieldItems.iterator();
            while (it.hasNext()) {
                TempTableFieldItem fieldItem1 = (TempTableFieldItem)it.next();
                String tempTableFieldName1 = fieldItem1.getTempTableField();
                if (CASHITEMFID.equalsIgnoreCase(fieldItem1.getField())) {
                    ksqlBuffer.append(CASHITEMFID);
                } else {
                    ksqlBuffer.append(this.getTempTableFieldName(tempTableFieldName1));
                }
                if (!it.hasNext()) continue;
                ksqlBuffer.append(",");
            }
            String tempTableAlias = this.getTempTableAlias();
            ksqlBuffer.append(" from T_BD_CashFLowItem CashItem   ");
            ksqlBuffer.append(" inner join T_BD_CashFLowItem super on charindex(concat(super.FLongnumber,'!'),CashItem.FLongnumber) = 1   ");
            ksqlBuffer.append(" inner join ").append(tempTable).append(" ").append(tempTableAlias).append(" on ").append(tempTableAlias).append(".").append(accountTempTableFieldName).append(" = super.FID");
            ksqlBuffer.append(" where  CashItem.FIsleaf = 1 and super.Fid in ( select ").append(accountTempTableFieldName).append(" from ").append(tempTable).append(")");
            tempTableJdbcTemplate.execute(ksqlBuffer.toString(), new PreparedStatementCallback(){

                @Override
                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                    ps.executeUpdate();
                    return null;
                }
            });
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                TempTableUtil.releaseDBSystemTempTable(tempTableJdbcTemplate, tempTable);
            }
        }
    }

    private ITempTableFieldItem getAccountTempTableFieldItem(ITempTableField tempTableField) {
        if (tempTableField.getTempTableFieldItem(CASHITEMFID) != null) {
            return tempTableField.getTempTableFieldItem(CASHITEMFID);
        }
        return null;
    }

    private String getTempTableFieldName(String tempTableField) {
        return this.getTempTableAlias() + "." + tempTableField;
    }

    private String getTempTableAlias() {
        return "tempTable";
    }
}

